/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class IntSizeBitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5094608065640873994L;
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final int WORD_MASK = -1;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bits", int[].class)};
    private int[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private void checkInvariants() {
        assert (this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0);
        assert (this.wordsInUse >= 0 && this.wordsInUse <= this.words.length);
        assert (this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0);
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0 && this.words[i] == 0; --i) {
        }
        this.wordsInUse = i + 1;
    }

    public IntSizeBitSet() {
        this.initWords(32);
        this.sizeIsSticky = false;
    }

    public IntSizeBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
        this.sizeIsSticky = true;
    }

    private void initWords(int nbits) {
        this.words = new int[IntSizeBitSet.wordIndex(nbits - 1) + 1];
    }

    private IntSizeBitSet(int[] words) {
        this.words = words;
        this.wordsInUse = words.length;
        this.checkInvariants();
    }

    public static IntSizeBitSet valueOf(int[] ints) {
        int n;
        for (n = ints.length; n > 0 && ints[n - 1] == 0; --n) {
        }
        return new IntSizeBitSet(Arrays.copyOf(ints, n));
    }

    public static IntSizeBitSet valueOf(Integer[] ints) {
        if (ints == null || ints.length <= 0) {
            return new IntSizeBitSet();
        }
        int[] result = new int[ints.length];
        int cnt = 0;
        for (Integer i : ints) {
            if (i == null) continue;
            result[cnt++] = i;
        }
        return IntSizeBitSet.valueOf(Arrays.copyOfRange(result, 0, cnt));
    }

    public static IntSizeBitSet valueOf(IntBuffer lb) {
        int n;
        lb = lb.slice();
        for (n = lb.remaining(); n > 0 && lb.get(n - 1) == 0; --n) {
        }
        int[] words = new int[n];
        lb.get(words);
        return new IntSizeBitSet(words);
    }

    public static IntSizeBitSet valueOf(byte[] bytes) {
        return IntSizeBitSet.valueOf(ByteBuffer.wrap(bytes));
    }

    public static IntSizeBitSet valueOf(ByteBuffer bb) {
        int n;
        bb = bb.slice().order(ByteOrder.LITTLE_ENDIAN);
        for (n = bb.remaining(); n > 0 && bb.get(n - 1) == 0; --n) {
        }
        int[] words = new int[(n + 7) / 8];
        bb.limit(n);
        int i = 0;
        while (bb.remaining() >= 8) {
            words[i++] = bb.getInt();
        }
        int remaining = bb.remaining();
        for (int j = 0; j < remaining; ++j) {
            int n2 = i;
            words[n2] = (int)((long)words[n2] | ((long)bb.get() & 0xFFL) << 8 * j);
        }
        return new IntSizeBitSet(words);
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse;
        if (n == 0) {
            return new byte[0];
        }
        int len = 4 * (n - 1);
        for (int x = this.words[n - 1]; x != 0; x >>>= 8) {
            ++len;
        }
        byte[] bytes = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n - 1; ++i) {
            bb.putInt(this.words[i]);
        }
        for (int x = this.words[n - 1]; x != 0; x >>>= 8) {
            bb.put((byte)(x & 0xFF));
        }
        return bytes;
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            this.words = Arrays.copyOf(this.words, request);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = IntSizeBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] ^ 1 << bitIndex;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void flip(int fromIndex, int toIndex) {
        IntSizeBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = IntSizeBitSet.wordIndex(fromIndex);
        int endWordIndex = IntSizeBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                int n2 = i++;
                this.words[n2] = ~this.words[n2];
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] ^ lastWordMask;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = IntSizeBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1 << bitIndex;
        this.checkInvariants();
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        IntSizeBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = IntSizeBitSet.wordIndex(fromIndex);
        int endWordIndex = IntSizeBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = -1;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
        this.checkInvariants();
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = IntSizeBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & ~(1 << bitIndex);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear(int fromIndex, int toIndex) {
        IntSizeBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = IntSizeBitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = IntSizeBitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse - 1;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & ~(firstWordMask & lastWordMask);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & ~firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = 0;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & ~lastWordMask;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = IntSizeBitSet.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1 << bitIndex) != 0;
    }

    public IntSizeBitSet get(int fromIndex, int toIndex) {
        IntSizeBitSet.checkRange(fromIndex, toIndex);
        this.checkInvariants();
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new IntSizeBitSet(0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        IntSizeBitSet result = new IntSizeBitSet(toIndex - fromIndex);
        int targetWords = IntSizeBitSet.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = IntSizeBitSet.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x1F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words[i] = wordAligned ? this.words[sourceIndex] : this.words[sourceIndex] >>> fromIndex | this.words[sourceIndex + 1] << -fromIndex;
            ++i;
            ++sourceIndex;
        }
        int lastWordMask = -1 >>> -toIndex;
        result.words[targetWords - 1] = (toIndex - 1 & 0x1F) < (fromIndex & 0x1F) ? this.words[sourceIndex] >>> fromIndex | (this.words[sourceIndex + 1] & lastWordMask) << -fromIndex : (this.words[sourceIndex] & lastWordMask) >>> fromIndex;
        result.wordsInUse = targetWords;
        result.recalculateWordsInUse();
        result.checkInvariants();
        return result;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = IntSizeBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        int word = this.words[u] & -1 << fromIndex;
        while (word == 0) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 32 + Integer.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = IntSizeBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        int word = ~this.words[u] & -1 << fromIndex;
        while (word == 0) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 32;
            }
            word = ~this.words[u];
        }
        return u * 32 + Integer.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = IntSizeBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return this.length() - 1;
        }
        int word = this.words[u] & -1 >>> -(fromIndex + 1);
        while (word == 0) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u];
        }
        return (u + 1) * 32 - 1 - Integer.numberOfLeadingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = IntSizeBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        int word = ~this.words[u] & -1 >>> -(fromIndex + 1);
        while (word == 0) {
            if (u-- == 0) {
                return -1;
            }
            word = ~this.words[u];
        }
        return (u + 1) * 32 - 1 - Integer.numberOfLeadingZeros(word);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 32 * (this.wordsInUse - 1) + (32 - Integer.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(IntSizeBitSet set) {
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & set.words[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            sum += Integer.bitCount(this.words[i]);
        }
        return sum;
    }

    public void and(IntSizeBitSet set) {
        if (this == set) {
            return;
        }
        while (this.wordsInUse > set.wordsInUse) {
            this.words[--this.wordsInUse] = 0;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & set.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void or(IntSizeBitSet set) {
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            int n = i;
            this.words[n] = this.words[n] | set.words[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
        this.checkInvariants();
    }

    public void xor(IntSizeBitSet set) {
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            int n = i;
            this.words[n] = this.words[n] ^ set.words[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse - wordsInCommon);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void andNot(IntSizeBitSet set) {
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & ~set.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        int h = 1234;
        int i = this.wordsInUse;
        while (--i >= 0) {
            h ^= this.words[i] * (i + 1);
        }
        return h;
    }

    public int size() {
        return this.words.length * 32;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntSizeBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        IntSizeBitSet set = (IntSizeBitSet)obj;
        this.checkInvariants();
        set.checkInvariants();
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        try {
            IntSizeBitSet result = (IntSizeBitSet)super.clone();
            result.words = (int[])this.words.clone();
            result.checkInvariants();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.checkInvariants();
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("bits", this.words);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.words = (int[])fields.get("bits", null);
        this.wordsInUse = this.words.length;
        this.recalculateWordsInUse();
        this.sizeIsSticky = this.words.length > 0 && this.words[this.words.length - 1] == 0;
        this.checkInvariants();
    }

    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse > 64 ? this.cardinality() : this.wordsInUse * 32;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    public IntStream stream() {
        return StreamSupport.intStream(() -> {
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    this.next = IntSizeBitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    return this.next != -1;
                }

                @Override
                public int nextInt() {
                    if (this.next != -1) {
                        int ret = this.next;
                        this.next = IntSizeBitSet.this.nextSetBit(this.next + 1);
                        return ret;
                    }
                    throw new NoSuchElementException();
                }
            }
            return Spliterators.spliterator(new BitSetIterator(), (long)this.cardinality(), 21);
        }, 16469, false);
    }
}

