/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.qing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.ParentChildDimension;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.IColumnValueConverter;
import kd.data.disf.algo.IDataSetRowDataPageReaderBuilder;
import kd.data.disf.utils.IDataQingHelper;
import kd.data.disf.utils.IDataStringUtil;
import kd.data.disf.utils.QFilterBuilder;
import kd.data.disf.utils.QingAPITableBuilder;
import org.apache.commons.lang3.ArrayUtils;

public class IDataQingDataProviderCacheParam
implements Serializable {
    private static final long serialVersionUID = 1889572980645874937L;
    public static final String KEY_SCHEME_ID = "schemeId";
    public static final String KEY_MODULE_ID = "moduleId";
    public static final String KEY_COL_TO_ROW = "colToRow";
    public static final String KEY_FACT_ENTITY = "factEntityName";
    public static final String KEY_MEASURE_TYPE = "measureTypeColName";
    public static final String KEY_HIERARACHY_DIMS = "hierarchyDims";
    public static final String KEY_MERGE_DATE = "mergedate";
    public static final String KEY_SYNC_PARAM_ID = "syncParamId";
    public static final String KEY_ORGANIZATION_VIEW_ID = "organizationViewId";
    public static final String KEY_DIMNUMBERMAPMEMBERID_MAP = "dimNumberMapMemberIdMap";
    private boolean needColumnToRowTransformation;
    private boolean needDimHierarchy;
    private Long schemeId;
    private Long syncParamId;
    private String factEntityName;
    private String factEntityDisplayName;
    private QingAPITableBuilder qingAPITableBuilder;
    private Map<Object, Integer> transKeyMap;
    private IColumnValueConverter<?, Object[][]> dimGroupConverter;
    private Map<Integer, Map<String, Field>> usedFileds = new LinkedHashMap<Integer, Map<String, Field>>(10);
    private Map<String, DimensionFieldInfo> dimFiledInfos;
    private QFilterBuilder[] qFilterBuilder = new QFilterBuilder[2];
    private boolean mergedate;
    private boolean superLongData;
    private Map<String, String> originalDimNumberMap;
    private boolean necessaryIndispensable;
    private Map<String, String> rigidConditionDimMemMap = new LinkedHashMap<String, String>(10);
    protected Set<String> displayNumberDimSet = new HashSet<String>(10);
    protected Set<Integer> displayNumberIndexSet = new HashSet<Integer>(10);
    private static final FieldTypeEnum[] SelectFields = new FieldTypeEnum[]{FieldTypeEnum.MeasureType, FieldTypeEnum.DateDim, FieldTypeEnum.HierarchyType, FieldTypeEnum.RowKeyDim, FieldTypeEnum.QueryMeasure, FieldTypeEnum.Version};

    public IDataQingDataProviderCacheParam() {
    }

    public IDataQingDataProviderCacheParam(Long schemeId, String factEntityName, String factEntityDisplayName, QingAPITableBuilder qingAPITableBuilder) {
        this();
        this.schemeId = schemeId;
        this.factEntityName = factEntityName;
        this.factEntityDisplayName = factEntityDisplayName;
        this.qingAPITableBuilder = qingAPITableBuilder;
        this.addField(FieldTypeEnum.Version, "version", "version", QingFieldType.Int, factEntityDisplayName, false);
    }

    public String toString() {
        return "IDataQingDataProviderCacheParam{needColumnToRowTransformation=" + this.needColumnToRowTransformation + ", needDimHierarchy=" + this.needDimHierarchy + ", schemeId=" + this.schemeId + ", factEntityName='" + this.factEntityName + '\'' + ", factEntityDisplayName='" + this.factEntityDisplayName + '\'' + ", qingAPITableBuilder=" + this.qingAPITableBuilder + ", transKeyMap=" + this.transKeyMap + ", dimGroupConverter=" + this.dimGroupConverter + ", usedFileds=" + this.usedFileds + ", dimFiledInfos=" + this.dimFiledInfos + ", qFilterBuilder=" + Arrays.toString(this.qFilterBuilder) + ", mergedate=" + this.mergedate + '}';
    }

    public Field addField(FieldTypeEnum fieldType, String fieldKey, String fieldName, QingFieldType fieldDataType) {
        return this.addField(fieldType, fieldKey, fieldName, fieldDataType, null, false);
    }

    public final Field addField(FieldTypeEnum fieldType, String fieldKey, String fieldName, QingFieldType fieldDataType, String entityName, boolean hide) {
        Field resultField = IDataQingHelper.createFieldObj(fieldKey, fieldName, fieldDataType, entityName, hide);
        this.addFields(fieldType, resultField);
        return resultField;
    }

    public int addFields(FieldTypeEnum fieldType, Field ... fields) {
        boolean isDimField;
        if (fieldType == null) {
            throw new KDBizException("Field Type is null!");
        }
        Map<String, Field> fieldBufMap = this.usedFileds.get(fieldType.getCode());
        if (fieldBufMap == null) {
            fieldBufMap = new LinkedHashMap<String, Field>(fields.length);
            this.usedFileds.put(fieldType.getCode(), fieldBufMap);
        }
        boolean bl = isDimField = fieldType.getCode() == FieldTypeEnum.RowKeyDim.getCode() || fieldType.getCode() == FieldTypeEnum.HierarchyType.getCode();
        if (isDimField && this.dimFiledInfos == null) {
            this.dimFiledInfos = new LinkedHashMap<String, DimensionFieldInfo>(5);
        }
        for (Field f : fields) {
            if (f == null) continue;
            String fieldKey = f.getKey();
            fieldBufMap.put(fieldKey, f);
            if (!isDimField) continue;
            this.dimFiledInfos.put(fieldKey, new DimensionFieldInfo(fieldBufMap.size(), fieldKey, fieldType));
        }
        return fields.length;
    }

    public Map<String, Field> addFields(FieldTypeEnum fieldType, String entityName, IDataEntityProperty ... fieldProps) {
        if (fieldProps == null || fieldProps.length <= 0) {
            return Collections.emptyMap();
        }
        if (fieldType == null) {
            throw new KDBizException("Field Type is null!");
        }
        boolean hideField = false;
        LinkedHashMap<String, Field> addResult = new LinkedHashMap<String, Field>(fieldProps.length);
        for (IDataEntityProperty prop : fieldProps) {
            String fieldKey;
            if (prop == null) continue;
            if (FieldTypeEnum.DateDim == fieldType) {
                fieldKey = "accountperiod";
                addResult.put(fieldKey, IDataQingHelper.createFieldObj(fieldKey, "\u4f1a\u8ba1\u671f\u95f4", QingFieldType.Date, entityName, false));
                continue;
            }
            fieldKey = FieldTypeEnum.MeasureType == fieldType || FieldTypeEnum.HierarchyType == fieldType ? prop.getName() : this.getIDataEntityPropertySelectName(prop);
            if (this.mergedate && prop.getName() != null && (prop.getName().equals("year") || prop.getName().equals("period"))) {
                hideField = true;
            }
            addResult.put(fieldKey, IDataQingHelper.createFieldObj(fieldKey, prop.getDisplayName() == null ? fieldKey : prop.getDisplayName().toString(), FieldTypeEnum.QueryMeasure == fieldType ? QingFieldType.Number : IDataQingHelper.getQingFieldType(prop), entityName, prop.getDisplayName() == null || hideField));
        }
        this.addFields(fieldType, addResult.values().toArray(new Field[0]));
        return addResult;
    }

    public Map<String, Field> addFields(FieldTypeEnum fieldType, IDataEntityProperty ... fieldProps) {
        return this.addFields(fieldType, (String)null, fieldProps);
    }

    public Map<String, Field> addFieldsFromEntityType(boolean needColumnToRowTransformation, MainEntityType entityType, Set<String> excludeFieldList, Collection<String> measureTypeColumnNames, Map<String, FieldTypeEnum> dimFieldTypeMap, Map<String, String> dimNumberOutputMap, List<String> measureColumnList) {
        Map<String, Field> addBufMap;
        HashSet measureTypeColNames = measureTypeColumnNames == null ? new HashSet(0) : new HashSet<String>(measureTypeColumnNames);
        LinkedHashMap<String, Field> resultMap = new LinkedHashMap<String, Field>(entityType.getProperties().size());
        for (String dimNumber : dimNumberOutputMap.keySet()) {
            Class fieldClassType;
            DynamicProperty prop = entityType.getProperty(dimNumber);
            if (prop == null) continue;
            if (excludeFieldList.contains(dimNumber)) {
                try {
                    prop = (DynamicProperty)prop.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u514b\u9686\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"IDataQingDataProviderCacheParam_0", (String)"data-fsa-disfcore", (Object[])new Object[0]) + e.getMessage());
                }
                prop.setDisplayName(null);
            }
            addBufMap = measureColumnList == null && (BigDecimal.class.isAssignableFrom(fieldClassType = prop.getPropertyType()) || Double.class.isAssignableFrom(fieldClassType)) || measureColumnList != null && measureColumnList.contains(prop.getName().toLowerCase()) ? this.addFields(FieldTypeEnum.QueryMeasure, new IDataEntityProperty[]{prop}) : (needColumnToRowTransformation && measureTypeColNames.contains(prop.getName()) ? this.addFields(FieldTypeEnum.MeasureType, new IDataEntityProperty[]{prop}) : (dimFieldTypeMap != null && dimFieldTypeMap.size() > 0 ? this.addFields(dimFieldTypeMap.getOrDefault(prop.getName(), FieldTypeEnum.RowKeyDim), new IDataEntityProperty[]{prop}) : this.addFields(FieldTypeEnum.RowKeyDim, new IDataEntityProperty[]{prop})));
            resultMap.putAll(addBufMap);
        }
        if (this.mergedate) {
            addBufMap = this.addFields(FieldTypeEnum.DateDim, new IDataEntityProperty[]{new DateProp()});
            resultMap.putAll(addBufMap);
        }
        return resultMap;
    }

    public Map<String, Field> removeFields(FieldTypeEnum fieldType, String ... fieldNames) {
        if (fieldNames == null || fieldNames.length <= 0) {
            return Collections.emptyMap();
        }
        if (fieldType == null) {
            throw new KDBizException("Field Type is null!");
        }
        LinkedHashMap<String, Field> delResult = new LinkedHashMap<String, Field>(fieldNames.length);
        Map<String, Field> fieldBufMap = this.usedFileds.get(fieldType.getCode());
        if (fieldBufMap != null) {
            for (String key : fieldNames) {
                delResult.put(key, fieldBufMap.remove(key));
            }
        }
        return delResult;
    }

    public Map<String, Field> getFieldsMap(FieldTypeEnum ... fieldTypes) {
        if (fieldTypes != null && fieldTypes.length > 0) {
            LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>(10);
            for (FieldTypeEnum t : fieldTypes) {
                if (t == null) continue;
                result.putAll(this.usedFileds.getOrDefault(t.getCode(), Collections.emptyMap()));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public List<Field> getFields(FieldTypeEnum ... fieldTypes) {
        return new ArrayList<Field>(this.getFieldsMap(fieldTypes).values());
    }

    public List<String> getFieldNames(FieldTypeEnum ... fieldTypes) {
        return new ArrayList<String>(this.getFieldsMap(fieldTypes).keySet());
    }

    protected List<String> getFieldNames(Collection<Field> fields) {
        ArrayList<String> resultList = new ArrayList<String>(fields.size());
        for (Field f : fields) {
            resultList.add(f.getKey());
        }
        return resultList;
    }

    public int getFieldValueCnt(FieldTypeEnum ... fieldTypes) {
        int cnt = 0;
        if (fieldTypes != null && fieldTypes.length > 0) {
            for (FieldTypeEnum t : fieldTypes) {
                if (t == null) continue;
                cnt += this.usedFileds.getOrDefault(t.getCode(), Collections.emptyMap()).size();
            }
        }
        return cnt;
    }

    public String getFactTableSelectFields() {
        return IDataStringUtil.collectionToString(this.getFieldNames(this.getSelectFields()), ",");
    }

    public String[] getFactTableOrderFields() {
        return (String[])ArrayUtils.addAll((Object[])this.getFieldNames(FieldTypeEnum.HierarchyType).toArray(new String[0]), (Object[])this.getFieldNames(FieldTypeEnum.RowKeyDim).toArray(new String[0]));
    }

    public List<Field> getSelectFields() {
        IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType type = IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType.parse(this.needColumnToRowTransformation, this.needDimHierarchy);
        switch (type) {
            case Original: {
                return this.getFields(FieldTypeEnum.RowKeyDim, FieldTypeEnum.QueryMeasure);
            }
            case ColToRow: {
                return this.getFields(FieldTypeEnum.MeasureType, FieldTypeEnum.RowKeyDim, FieldTypeEnum.QueryMeasure);
            }
            case Original_With_Hierarchy: {
                return this.getFields(FieldTypeEnum.HierarchyType, FieldTypeEnum.RowKeyDim, FieldTypeEnum.QueryMeasure);
            }
            case ColToRow_With_Hierarchy: {
                return this.getFields(FieldTypeEnum.MeasureType, FieldTypeEnum.HierarchyType, FieldTypeEnum.RowKeyDim, FieldTypeEnum.QueryMeasure);
            }
        }
        throw new KDBizException("Unkonw Type: " + type);
    }

    public List<Field> getTableOrderFields() {
        return this.getFields(FieldTypeEnum.RowKeyDim);
    }

    public boolean validateCacheParam() {
        if (this.schemeId == null) {
            throw new KDBizException("\u65b9\u6848ID\u4e3aNull");
        }
        if (StringUtils.isEmpty((String)this.factEntityName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u8868\u7684\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a", (String)"IDataQingDataProviderCacheParamException_0", (String)"data-fsa-disfcore", (Object[])new Object[0]));
        }
        if (this.needColumnToRowTransformation && this.getFieldValueCnt(FieldTypeEnum.MeasureType) == 0) {
            throw new KDBizException(String.format("\u5b9e\u4f53\u5bf9\u8c61\u4e2d[%s]\u4e2d\u672a\u627e\u5230\u5ea6\u91cf\u7c7b\u578b\u5217\u7684\u5b57\u6bb5\u4fe1\u606f", this.factEntityName));
        }
        this.getQingAPITableBuilder().validate();
        return true;
    }

    public QingAPITableBuilder buildQingAPITableBuilder() {
        QingAPITableBuilder qingBuilder = new QingAPITableBuilder();
        DimensionFieldInfo emptyDimInfo = new DimensionFieldInfo(-1, null, FieldTypeEnum.RowKeyDim);
        for (Field f : this.getFieldsMap(FieldTypeEnum.HierarchyType, FieldTypeEnum.DateDim, FieldTypeEnum.RowKeyDim).values()) {
            if (this.needDimHierarchy && this.dimFiledInfos != null && this.dimFiledInfos.getOrDefault(f.getKey(), emptyDimInfo).isHierarchyDim()) {
                qingBuilder.addQingHierarchyField(f, this.necessaryIndispensable ? ParentChildDimension.Necessary.Indispensable : ParentChildDimension.Necessary.RootRepresented);
                continue;
            }
            qingBuilder.addTableField(f, Boolean.FALSE);
        }
        for (Field f : this.getFieldsMap(this.needColumnToRowTransformation ? FieldTypeEnum.OutputMeasure : FieldTypeEnum.QueryMeasure).values()) {
            qingBuilder.addTableField(f, Boolean.TRUE);
        }
        return qingBuilder;
    }

    public DimensionFieldInfo getPrimaryHierarchyDimensionField() {
        for (DimensionFieldInfo dim : this.dimFiledInfos.values()) {
            if (!dim.isPrimaryhierarchyDim()) continue;
            return dim;
        }
        return null;
    }

    public Map<String, Integer[]> getBaseFieldReadWriteIndexs() {
        IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType type = IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType.parse(this.needColumnToRowTransformation, this.needDimHierarchy);
        LinkedHashMap<String, Integer[]> indexMap = new LinkedHashMap<String, Integer[]>(10);
        int readIndex = 0;
        int writeIndex = 0;
        List<String> fieldNameBufList = null;
        switch (type) {
            case ColToRow: {
                fieldNameBufList = this.getFieldNames(FieldTypeEnum.QueryMeasure);
                readIndex = this.getFieldValueCnt(FieldTypeEnum.MeasureType, FieldTypeEnum.RowKeyDim);
                writeIndex = this.getFieldValueCnt(FieldTypeEnum.RowKeyDim, FieldTypeEnum.DateDim);
                break;
            }
            case Original: {
                readIndex = this.getFieldValueCnt(FieldTypeEnum.RowKeyDim);
                writeIndex = this.getFieldValueCnt(FieldTypeEnum.RowKeyDim);
                fieldNameBufList = this.getFieldNames(FieldTypeEnum.QueryMeasure);
                break;
            }
            case Original_With_Hierarchy: 
            case ColToRow_With_Hierarchy: {
                readIndex = this.getFieldValueCnt(FieldTypeEnum.MeasureType, FieldTypeEnum.HierarchyType, FieldTypeEnum.RowKeyDim);
                writeIndex += this.getFieldValueCnt(FieldTypeEnum.RowKeyDim);
                writeIndex += this.getFieldValueCnt(FieldTypeEnum.HierarchyType) * 3;
                if (this.mergedate) {
                    ++writeIndex;
                }
                fieldNameBufList = this.getFieldNames(FieldTypeEnum.QueryMeasure);
                break;
            }
        }
        if (fieldNameBufList != null) {
            this.buildFieldWriteIndexMap(readIndex, writeIndex, indexMap, fieldNameBufList);
        }
        return indexMap;
    }

    protected String getIDataEntityPropertySelectName(IDataEntityProperty prop) {
        if (DynamicObject.class.isAssignableFrom(prop.getPropertyType())) {
            if ("period".equalsIgnoreCase(prop.getName())) {
                return prop.getName() + ".number";
            }
            return prop.getName() + ".name";
        }
        return prop.getName();
    }

    public void buildFieldWriteIndexMap(int readIndex, int writeIndex, Map<String, Integer[]> outputMap, List<String> fieldNameBufList) {
        if (this.mergedate) {
            for (String field : fieldNameBufList) {
                Integer[] index;
                if (field.equals("accountperiod")) {
                    index = new Integer[3];
                    index[2] = writeIndex++;
                    outputMap.put(field, index);
                    continue;
                }
                index = new Integer[]{readIndex++, writeIndex++};
                if (field.equals("year")) {
                    outputMap.get((Object)"accountperiod")[0] = index[0];
                }
                if (field.equals("period")) {
                    outputMap.get((Object)"accountperiod")[1] = index[0];
                }
                outputMap.put(field, index);
            }
        } else {
            for (String field : fieldNameBufList) {
                Integer[] index = new Integer[]{readIndex++, writeIndex++};
                outputMap.put(field, index);
            }
        }
    }

    public Map<String, Integer[]> getRowKeyDimReadWriteIndexs() {
        IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType type = IDataSetRowDataPageReaderBuilder.IDataSetRowDataPageReaderType.parse(this.needColumnToRowTransformation, this.needDimHierarchy);
        LinkedHashMap<String, Integer[]> indexMap = new LinkedHashMap<String, Integer[]>(10);
        int readIndex = 0;
        int writeIndex = 0;
        switch (type) {
            case ColToRow: {
                readIndex = this.getFieldValueCnt(FieldTypeEnum.MeasureType);
                this.buildFieldWriteIndexMap(readIndex, writeIndex, indexMap, this.getFieldNames(FieldTypeEnum.DateDim, FieldTypeEnum.RowKeyDim));
                break;
            }
            case Original: {
                boolean dimIndex = false;
                for (String field : this.getFieldNames(FieldTypeEnum.RowKeyDim)) {
                    Integer[] index;
                    if (field.equals("accountperiod")) {
                        index = new Integer[3];
                        index[2] = writeIndex++;
                        indexMap.put(field, index);
                        continue;
                    }
                    index = new Integer[]{readIndex++, writeIndex};
                    indexMap.put(field, index);
                    if (field.equals("year") && indexMap.get("accountperiod") != null) {
                        ((Integer[])indexMap.get((Object)"accountperiod"))[0] = index[0];
                    }
                    if (field.equals("period") && indexMap.get("accountperiod") != null) {
                        ((Integer[])indexMap.get((Object)"accountperiod"))[1] = index[0];
                    }
                    ++writeIndex;
                }
                break;
            }
            case ColToRow_With_Hierarchy: {
                readIndex = this.getFieldValueCnt(FieldTypeEnum.MeasureType);
            }
            case Original_With_Hierarchy: {
                boolean dimIndex = false;
                List<String> hierarchyField = this.getFieldNames(FieldTypeEnum.HierarchyType);
                for (String field : this.getFieldNames(FieldTypeEnum.HierarchyType, FieldTypeEnum.DateDim, FieldTypeEnum.RowKeyDim)) {
                    Integer[] index;
                    if (field.equals("accountperiod")) {
                        index = new Integer[3];
                        index[2] = writeIndex++;
                        indexMap.put(field, index);
                        continue;
                    }
                    index = new Integer[]{readIndex++, writeIndex};
                    indexMap.put(field, index);
                    if (field.equals("year") && indexMap.get("accountperiod") != null) {
                        ((Integer[])indexMap.get((Object)"accountperiod"))[0] = index[0];
                    }
                    if (field.equals("period") && indexMap.get("accountperiod") != null) {
                        ((Integer[])indexMap.get((Object)"accountperiod"))[1] = index[0];
                    }
                    if (hierarchyField.contains(field)) {
                        writeIndex += 3;
                        continue;
                    }
                    ++writeIndex;
                }
                break;
            }
        }
        return indexMap;
    }

    public List<Integer> getHierarchyDimColIndexs() {
        if (!this.needDimHierarchy) {
            return Collections.emptyList();
        }
        Map<String, Integer[]> dimReadWriteIndex = this.getRowKeyDimReadWriteIndexs();
        if (dimReadWriteIndex.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Integer> resultIndexList = new LinkedList<Integer>();
        for (DimensionFieldInfo f : this.dimFiledInfos.values()) {
            if (!f.isHierarchyDim()) continue;
            resultIndexList.add(dimReadWriteIndex.get(f.getDimFieldKey())[1]);
            if (!this.displayNumberDimSet.contains(f.getDimFieldKey())) continue;
            this.displayNumberIndexSet.add(dimReadWriteIndex.get(f.getDimFieldKey())[1]);
        }
        return resultIndexList;
    }

    public QFilterBuilder buildQueryMeasureFilter(int filterType) {
        if (filterType < 0 || filterType >= this.qFilterBuilder.length) {
            return null;
        }
        return this.qFilterBuilder[filterType];
    }

    public void setQFilterBuilder(int filterType, QFilterBuilder filterBuilder) {
        if (filterType < 0 || filterType >= this.qFilterBuilder.length) {
            return;
        }
        this.qFilterBuilder[filterType] = filterBuilder;
    }

    public void setQFilterBuilder(int filterType, boolean andMode, QFilter filter) {
        if (filterType < 0 || filterType >= this.qFilterBuilder.length) {
            return;
        }
        if (this.qFilterBuilder[filterType] == null) {
            this.qFilterBuilder[filterType] = new QFilterBuilder();
        }
        if (andMode) {
            this.qFilterBuilder[filterType].and(filter);
        } else {
            this.qFilterBuilder[filterType].or(filter);
        }
    }

    public QingAPITableBuilder getQingAPITableBuilder() {
        if (this.qingAPITableBuilder == null) {
            this.qingAPITableBuilder = this.buildQingAPITableBuilder();
        }
        return this.qingAPITableBuilder;
    }

    public void setQingAPITableBuilder(QingAPITableBuilder qingAPITableBuilder) {
        this.qingAPITableBuilder = qingAPITableBuilder;
    }

    public String getFactEntityDisplayName() {
        return this.factEntityDisplayName;
    }

    public void setFactEntityDisplayName(String factEntityDisplayName) {
        this.factEntityDisplayName = factEntityDisplayName;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getFactEntityName() {
        return this.factEntityName;
    }

    public void setFactEntityName(String factEntityName) {
        this.factEntityName = factEntityName;
    }

    public boolean isNeedColumnToRowTransformation() {
        return this.needColumnToRowTransformation;
    }

    public void setNeedColumnToRowTransformation(boolean needColumnToRowTransformation) {
        this.needColumnToRowTransformation = needColumnToRowTransformation;
    }

    public Map<Object, Integer> getTransKeyMap() {
        return this.transKeyMap;
    }

    public void setTransKeyMap(Map<Object, Integer> transKeyMap) {
        this.transKeyMap = transKeyMap;
    }

    public boolean isNeedDimHierarchy() {
        return this.needDimHierarchy;
    }

    public void setNeedDimHierarchy(boolean needDimHierarchy) {
        this.needDimHierarchy = needDimHierarchy;
    }

    public IColumnValueConverter<?, Object[][]> getDimGroupConverter() {
        return this.dimGroupConverter;
    }

    public void setDimGroupConverter(IColumnValueConverter<?, Object[][]> dimGroupConverter) {
        this.dimGroupConverter = dimGroupConverter;
    }

    public Map<Integer, Map<String, Field>> getUsedFileds() {
        return this.usedFileds;
    }

    public boolean isMergedate() {
        return this.mergedate;
    }

    public void setMergedate(boolean mergedate) {
        this.mergedate = mergedate;
    }

    public Long getSyncParamId() {
        return this.syncParamId;
    }

    public void setSyncParamId(Long syncParamId) {
        this.syncParamId = syncParamId;
    }

    public boolean isSuperLongData() {
        return this.superLongData;
    }

    public void setSuperLongData(boolean superLongData) {
        this.superLongData = superLongData;
    }

    public Map<String, String> getOriginalDimNumberMap() {
        return this.originalDimNumberMap;
    }

    public boolean addOriginalDimNumberMap(String originalNumber, String entityNumber) {
        if (StringUtils.isEmpty((String)originalNumber) || StringUtils.isEmpty((String)entityNumber)) {
            return false;
        }
        if (this.originalDimNumberMap == null) {
            this.originalDimNumberMap = new HashMap<String, String>(10);
        }
        this.originalDimNumberMap.putIfAbsent(originalNumber, entityNumber);
        return true;
    }

    public void setNecessaryIndispensable(boolean necessaryIndispensable) {
        this.necessaryIndispensable = necessaryIndispensable;
    }

    public Map<String, String> getRigidConditionDimMemMap() {
        return this.rigidConditionDimMemMap;
    }

    public boolean addRigidConditionDimMemMap(String dimensionNumber, String memberNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber) || StringUtils.isEmpty((String)memberNumber)) {
            return false;
        }
        if (this.rigidConditionDimMemMap == null) {
            this.rigidConditionDimMemMap = new LinkedHashMap<String, String>(10);
        }
        this.rigidConditionDimMemMap.putIfAbsent(dimensionNumber, memberNumber);
        return true;
    }

    public void setRigidConditionDimMemMap(Map<String, String> rigidConditionDimMemMap) {
        this.rigidConditionDimMemMap = rigidConditionDimMemMap;
    }

    public Set<String> getDisplayNumberDimSet() {
        return this.displayNumberDimSet;
    }

    public Set<Integer> getDisplayNumberIndexSet() {
        return this.displayNumberIndexSet;
    }

    public void addDisplayNumberDimSet(String dimNumber) {
        if (this.displayNumberDimSet == null) {
            this.displayNumberDimSet = new HashSet<String>(10);
        }
        this.displayNumberDimSet.add(dimNumber);
    }

    public static enum FieldTypeEnum implements Serializable
    {
        MeasureType(0),
        HierarchyType(1),
        RowKeyDim(2),
        PlanHierarchyDim(2),
        PrimaryHierarchyDim(2),
        QueryMeasure(3),
        OutputMeasure(4),
        DateDim(5),
        Version(6);

        int code;

        private FieldTypeEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static FieldTypeEnum getEnum(Integer code) {
            if (code == null) {
                return null;
            }
            for (FieldTypeEnum en : FieldTypeEnum.values()) {
                if (en.getCode() != code.intValue()) continue;
                return en;
            }
            return null;
        }

        public static FieldTypeEnum getEnum(String code) {
            if (code == null) {
                return null;
            }
            return FieldTypeEnum.getEnum(Integer.valueOf(code));
        }
    }

    public static class DimensionFieldInfo
    implements Serializable {
        private static final long serialVersionUID = -8656056149505738379L;
        protected String dimFieldKey;
        protected boolean hierarchyDim;
        protected boolean primaryhierarchyDim;
        protected int readSeq;

        protected DimensionFieldInfo(int readSeq, String dimFieldKey, FieldTypeEnum fieldType) {
            this.readSeq = readSeq;
            this.dimFieldKey = dimFieldKey;
            switch (fieldType) {
                case PrimaryHierarchyDim: {
                    this.primaryhierarchyDim = true;
                }
                case HierarchyType: {
                    this.hierarchyDim = true;
                    break;
                }
            }
        }

        protected DimensionFieldInfo(String dimFieldKey, boolean hierarchyDim, boolean primaryhierarchyDim, int readSeq) {
            this.dimFieldKey = dimFieldKey;
            this.hierarchyDim = hierarchyDim;
            this.primaryhierarchyDim = primaryhierarchyDim;
            this.readSeq = readSeq;
        }

        public String toString() {
            return "DimensionFieldInfo{dimFieldKey='" + this.dimFieldKey + '\'' + ", hierarchyDim=" + this.hierarchyDim + ", primaryhierarchyDim=" + this.primaryhierarchyDim + ", readSeq=" + this.readSeq + '}';
        }

        public String getDimFieldKey() {
            return this.dimFieldKey;
        }

        public boolean isHierarchyDim() {
            return this.hierarchyDim;
        }

        public boolean isPrimaryhierarchyDim() {
            return this.primaryhierarchyDim;
        }

        public int getReadSeq() {
            return this.readSeq;
        }
    }
}

