/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.stream.consumer;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import kd.data.disf.file.BaseMultipleVolumeFileInfo;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.listener.IVolumeChangeListener;
import kd.data.disf.stream.datablock.IAsyncStreamDataBlock;

public abstract class AbstractMultiVolumeStreamConsumer<F extends BaseMultipleVolumeFileInfo, E>
implements Consumer<IAsyncStreamDataBlock<E>> {
    protected F fileVolumeInfo;
    protected IExceptionListener exceptionListener;
    protected IVolumeChangeListener volumeChangeListener;

    public AbstractMultiVolumeStreamConsumer(F fileVolumeInfo) throws IOException {
        this.fileVolumeInfo = fileVolumeInfo;
        this.finalStartNewPage();
    }

    @Override
    public void accept(IAsyncStreamDataBlock<E> dataBlock) {
        block10: {
            if (dataBlock.isEmpty()) {
                return;
            }
            boolean fileOpen = true;
            try {
                int newPageflag = dataBlock.requiredNewPage();
                int flushFlag = dataBlock.requiredFlush();
                if (newPageflag == -1 || newPageflag == 2) {
                    fileOpen = this.startNewPage();
                } else if (flushFlag == -1 || flushFlag == 2) {
                    this.flushPage(false);
                }
                if (fileOpen) {
                    if (((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).increaseCurrentVolumnSize(this.processData(dataBlock)) || newPageflag == 2) {
                        this.startNewPage();
                    } else if (flushFlag == 2) {
                        this.flushPage(false);
                    }
                }
            }
            catch (Exception ex) {
                if (this.exceptionListener == null) break block10;
                this.exceptionListener.onError(ex);
            }
        }
    }

    protected abstract long processData(IAsyncStreamDataBlock<E> var1) throws IOException;

    protected abstract void flushPage(boolean var1) throws IOException;

    protected boolean startNewPage() throws IOException {
        this.flushPage(true);
        long currentVolumeSize = ((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).getCurrentVolumnSize();
        File oldName = ((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).getCurFileName();
        File newName = ((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).switchToNewVolume();
        if (this.volumeChangeListener != null) {
            return this.volumeChangeListener.onVolumeChange(oldName, newName, ((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).getVolumeCnt(), currentVolumeSize, ((BaseMultipleVolumeFileInfo)this.fileVolumeInfo).getTotalVolumnSize());
        }
        return true;
    }

    protected final void finalStartNewPage() throws IOException {
        this.startNewPage();
    }

    public BaseMultipleVolumeFileInfo getFileVolumeInfo() {
        return this.fileVolumeInfo;
    }

    public void setFileVolumeInfo(F fileVolumeInfo) throws IOException {
        this.fileVolumeInfo = fileVolumeInfo;
        this.startNewPage();
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public IVolumeChangeListener getVolumeChangeListener() {
        return this.volumeChangeListener;
    }

    public void setVolumeChangeListener(IVolumeChangeListener volumeChangeListener) {
        this.volumeChangeListener = volumeChangeListener;
    }
}

