/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.stream.consumer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.data.disf.file.MultipleVolumeZipFileInfo;
import kd.data.disf.stream.consumer.AbstractMultiVolumeStreamConsumer;
import kd.data.disf.stream.datablock.IAsyncStreamDataBlock;

public class MultiVolumeZipFileStreamConsumer<E>
extends AbstractMultiVolumeStreamConsumer<MultipleVolumeZipFileInfo, E> {
    protected ZipOutputStream currentOutpuStream;
    protected ZipEntry currentZipEntry;

    public MultiVolumeZipFileStreamConsumer(MultipleVolumeZipFileInfo fileVolumeInfo) throws IOException {
        super(fileVolumeInfo);
    }

    @Override
    protected boolean startNewPage() throws IOException {
        boolean result = super.startNewPage();
        if (result) {
            File fileName = ((MultipleVolumeZipFileInfo)this.fileVolumeInfo).getCurFileName();
            if (fileName == null) {
                fileName = ((MultipleVolumeZipFileInfo)this.fileVolumeInfo).switchToNewVolume();
            }
            this.currentOutpuStream = new ZipOutputStream(new FileOutputStream(fileName));
            this.currentOutpuStream.setLevel(((MultipleVolumeZipFileInfo)this.fileVolumeInfo).getCompressLevel());
            this.currentOutpuStream.setMethod(((MultipleVolumeZipFileInfo)this.fileVolumeInfo).getStoreMode());
            this.currentZipEntry = new ZipEntry(((MultipleVolumeZipFileInfo)this.fileVolumeInfo).getEntryName());
            this.currentOutpuStream.putNextEntry(this.currentZipEntry);
        }
        return result;
    }

    @Override
    protected void flushPage(boolean close) throws IOException {
        if (this.currentOutpuStream != null) {
            this.currentOutpuStream.flush();
            if (close) {
                this.currentOutpuStream.closeEntry();
                this.currentOutpuStream.close();
            }
        }
    }

    @Override
    protected long processData(IAsyncStreamDataBlock<E> dataBlock) throws IOException {
        byte[] data = dataBlock.getDataBytes();
        if (data != null) {
            this.currentOutpuStream.write(data);
            return data.length;
        }
        return 0L;
    }
}

