/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.stream.pipe;

import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.function.BiConsumer;

public class PipeStreamInfo<P> {
    protected PipedInputStream pipeConsumer;
    protected PipedOutputStream pipeProducer;
    protected boolean newPage;
    public static int DEFAULT_PIPE_SIZE = 4096;

    public PipeStreamInfo() throws IOException {
        this(DEFAULT_PIPE_SIZE);
    }

    public PipeStreamInfo(int pipeBufferSize) throws IOException {
        this.pipeConsumer = new PipedInputStream(pipeBufferSize);
        this.pipeProducer = new PipedOutputStream(this.pipeConsumer);
    }

    public PipeStreamInfo(int pipeBufferSize, BiConsumer<PipeStreamInfo<P>, Object> consumer, Object ... params) throws IOException {
        this(pipeBufferSize);
        if (consumer != null) {
            this.attach(consumer, params);
        }
    }

    public final void attach(BiConsumer<PipeStreamInfo<P>, Object> consumer, Object ... param) {
        new Thread(() -> consumer.accept(this, param)).start();
    }

    private static void closeClosable(Closeable src) {
        if (src != null) {
            try {
                src.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        PipeStreamInfo.closeClosable(this.pipeProducer);
        PipeStreamInfo.closeClosable(this.pipeConsumer);
    }

    public int available() throws IOException {
        return this.pipeConsumer.available();
    }

    public long skip(long skipBytes) throws IOException {
        return this.pipeConsumer.skip(skipBytes);
    }

    public void connect(PipedOutputStream targetPipedOutputStream) throws IOException {
        this.pipeConsumer.connect(targetPipedOutputStream);
    }

    public void flush() throws IOException {
        this.pipeProducer.flush();
    }

    public void writeToPipe(int src) throws IOException {
        this.pipeProducer.write(src);
    }

    public void writeToPipe(byte[] src) throws IOException {
        this.pipeProducer.write(src);
    }

    public void writeToPipe(byte[] src, int off, int len) throws IOException {
        this.pipeProducer.write(src, off, len);
    }

    public int readFromPipe() throws IOException {
        return this.pipeConsumer.read();
    }

    public int readFromPipe(byte[] src) throws IOException {
        return this.pipeConsumer.read(src);
    }

    public int readFromPipe(byte[] src, int off, int len) throws IOException {
        return this.pipeConsumer.read(src, off, len);
    }
}

