/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.task;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;

public class FSAWorkTaskManager
extends IDataWorkTaskManager {
    @Override
    public <T> Future<T> submit(IDataWorkTask<T> workTask) {
        return this.submit(workTask, null);
    }

    @Override
    public <T> Future<T> submit(Callable<T> workTask, boolean asHelperThread) {
        return this.submit(workTask, null, asHelperThread);
    }

    @Override
    public <T> Future<T> submit(IDataWorkTask<T> workTask, boolean asHelperThread) {
        if (asHelperThread) {
            RequestContext requestContext = RequestContextCreator.createForThreadPool();
            workTask.setRequestContext(requestContext);
            return ThreadService.submit(workTask, (TaskType)TaskType.FSA_HELPER_TASK, (RequestContext)requestContext);
        }
        return this.submit(workTask, null);
    }

    @Override
    public <T> Future<T> submit(IDataWorkTask<T> workTask, RequestContext requestContext) {
        if (requestContext == null) {
            requestContext = RequestContextCreator.createForThreadPool();
        }
        workTask.setRequestContext(requestContext);
        return ThreadService.submit(workTask, (TaskType)TaskType.FSA_WORK_TASK, (RequestContext)requestContext);
    }

    @Override
    public <T> Future<T> submit(Callable<T> workTask, RequestContext requestContext, boolean asHelperThread) {
        if (requestContext == null) {
            requestContext = RequestContextCreator.createForThreadPool();
        }
        if (asHelperThread) {
            return ThreadService.submit((Callable)new IDataWorkTaskManager.RunnableWorkTaskWrapper(workTask, null), (TaskType)TaskType.FSA_HELPER_TASK, (RequestContext)requestContext);
        }
        return ThreadService.submit((Callable)new IDataWorkTaskManager.RunnableWorkTaskWrapper(workTask, null), (TaskType)TaskType.FSA_WORK_TASK, (RequestContext)requestContext);
    }

    @Override
    public void execute(Runnable workTask) {
        this.execute(workTask, null);
    }

    @Override
    public void execute(IDataWorkTask<?> workTask) {
        this.execute(workTask, false);
    }

    @Override
    public void execute(IDataWorkTask<?> workTask, boolean asHelperThread) {
        this.execute(workTask, null, asHelperThread);
    }

    @Override
    public void execute(Runnable workTask, RequestContext requestContext) {
        this.execute(new IDataWorkTaskManager.RunnableWorkTaskWrapper(workTask, null), requestContext, false);
    }

    @Override
    public void execute(IDataWorkTask<?> workTask, RequestContext requestContext, boolean asHelperThread) {
        if (requestContext == null) {
            requestContext = RequestContextCreator.createForThreadPool();
        }
        workTask.setRequestContext(requestContext);
        if (asHelperThread) {
            ThreadService.execute(workTask, (TaskType)TaskType.FSA_HELPER_TASK, (RequestContext)requestContext);
        } else {
            ThreadService.execute(workTask, (TaskType)TaskType.FSA_WORK_TASK, (RequestContext)requestContext);
        }
    }
}

