/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.task;

import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.enums.WorkTaskExecutionStatusEnum;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IWorkTaskSetpResult;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.TaskGroupCondition;

public abstract class IDataAbstractStriveWorkTask<ID, T>
extends IDataAbstractWorkTask<T> {
    private static final Log logger = LogFactory.getLog(IDataAbstractStriveWorkTask.class);
    protected int fetchLogBatchSize = 1000;
    protected long dlockTimeOutValue;
    protected int dlockRetryCnt;
    protected IWorkTaskTransLog<ID> currentWorkTaskTransLog;
    protected boolean enableStriveTask;

    public IDataAbstractStriveWorkTask(Object taskKey) {
        super(taskKey);
        this.enableStriveTask = true;
    }

    public IDataAbstractStriveWorkTask(Object taskKey, IWorkTaskTransLog<ID> currentWorkTaskTransLog) {
        super(taskKey);
        this.currentWorkTaskTransLog = currentWorkTaskTransLog;
        this.enableStriveTask = true;
    }

    public IDataAbstractStriveWorkTask(Object taskKey, IWorkTaskTransLog<ID> currentWorkTaskTransLog, boolean enableStriveTask) {
        super(taskKey);
        this.currentWorkTaskTransLog = currentWorkTaskTransLog;
        this.enableStriveTask = enableStriveTask;
    }

    protected IDataAbstractStriveWorkTask(Object taskKey, IExceptionListener exceptionListener) {
        super(taskKey, exceptionListener, new TaskGroupCondition());
        this.enableStriveTask = true;
    }

    protected IDataAbstractStriveWorkTask(Object taskKey, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        super(taskKey, exceptionListener, taskGroupCondition);
        this.enableStriveTask = true;
    }

    @Override
    public String toString() {
        return "IDataAbstractStriveWorkTask [enableStriveTask =" + this.enableStriveTask + ", fetchLogBatchSize=" + this.fetchLogBatchSize + ", dlockTimeOutValue=" + this.dlockTimeOutValue + ", dlockRetryCnt=" + this.dlockRetryCnt + ", currentWorkTaskTransLog=" + this.currentWorkTaskTransLog + ", taskKey=" + this.taskKey + ", taskTypeCode=" + this.taskTypeCode + ", requestContext=" + this.requestContext + ", taskResult=" + this.taskResult + ", exceptionListener=" + this.exceptionListener + ", taskGroupCondition=" + this.taskGroupCondition + ", taskStageCode=" + this.taskStageCode + "]";
    }

    protected abstract List<Object> queryWaitingJobLogRecords(IWorkTaskTransLog<ID> var1, int var2);

    protected abstract IWorkTaskTransLog<ID> convertToWorkTaskTransLog(Object var1);

    protected abstract IWorkTaskSetpResult processTaskStep(IWorkTaskTransLog<ID> var1);

    protected abstract void processTaskStepResult(IWorkTaskTransLog<ID> var1, IWorkTaskSetpResult var2, Throwable var3);

    protected void processTaskStepResult(IWorkTaskTransLog<ID> taskTransLog, IWorkTaskSetpResult taskStepResult) {
        this.processTaskStepResult(taskTransLog, taskStepResult, null);
    }

    protected abstract IWorkTaskTransLog<ID> updateTaskTransLogStatus(IWorkTaskTransLog<ID> var1, WorkTaskExecutionStatusEnum var2, String var3, Throwable var4);

    protected abstract String getDLockKeyPrefix();

    protected String buildDLockKey(Object ... params) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDLockKeyPrefix());
        for (Object v : params) {
            buf.append('/').append(v);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doTaskJob() {
        if (this.currentWorkTaskTransLog == null) {
            this.currentWorkTaskTransLog = this.getNextWaitingJob(null, true);
        }
        if (this.currentWorkTaskTransLog == null) {
            return (T)this.taskResult;
        }
        do {
            DLock curLoopLock = this.currentWorkTaskTransLog.getDlock();
            try {
                do {
                    Exception executeException = null;
                    try {
                        IWorkTaskSetpResult taskStepResult = this.processTaskStep(this.currentWorkTaskTransLog);
                        if (taskStepResult != null) {
                            this.processTaskStepResult(this.currentWorkTaskTransLog, taskStepResult);
                        }
                    }
                    catch (Exception ex) {
                        executeException = ex;
                        this.onException(ex);
                    }
                    this.updateTaskTransLogStatus(this.currentWorkTaskTransLog, executeException == null ? WorkTaskExecutionStatusEnum.SUCCESS : WorkTaskExecutionStatusEnum.FAILURE, executeException != null ? executeException.getMessage() : null, executeException);
                } while (this.enableStriveTask && (this.currentWorkTaskTransLog = this.getNextWaitingJob(this.currentWorkTaskTransLog, false)) != null);
            }
            finally {
                try {
                    if (curLoopLock != null) {
                        curLoopLock.close();
                    }
                }
                catch (Exception ex) {
                    this.onException(ex);
                }
            }
        } while (this.enableStriveTask && (this.currentWorkTaskTransLog = this.getNextWaitingJob(null, true)) != null);
        return (T)this.taskResult;
    }

    protected IWorkTaskTransLog<ID> getNextWaitingJob(IWorkTaskTransLog<ID> previouseLog, boolean needRequestDLock) {
        List<Object> waitingTaskJobs = this.queryWaitingJobLogRecords(previouseLog, this.fetchLogBatchSize);
        if (logger.isInfoEnabled()) {
            logger.info("queryWaitingJobLogRecords result cnt = " + (waitingTaskJobs != null ? waitingTaskJobs.size() : 0));
        }
        if (waitingTaskJobs != null && !waitingTaskJobs.isEmpty()) {
            boolean lockSuccess = !needRequestDLock;
            for (Object stepJob : waitingTaskJobs) {
                IWorkTaskTransLog<ID> waitingTaskTransLog = this.convertToWorkTaskTransLog(stepJob);
                if (needRequestDLock) {
                    lockSuccess = this.requestTransLogLock(waitingTaskTransLog);
                }
                if (!lockSuccess || this.updateTaskTransLogStatus(waitingTaskTransLog, WorkTaskExecutionStatusEnum.PROCESSING, null, null) == null) continue;
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("queryWaitingJobLogRecords Success return IWorkTaskTransLog=%s", waitingTaskTransLog));
                }
                return waitingTaskTransLog;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requestTransLogLock(IWorkTaskTransLog<ID> transLog) {
        DLock dlock;
        boolean lockSuccess;
        block10: {
            String dlockKeyBuf = this.buildDLockKey(transLog);
            lockSuccess = false;
            dlock = null;
            try {
                dlock = DLock.createReentrant((String)dlockKeyBuf);
                lockSuccess = dlock.tryLock();
                if (!lockSuccess) break block10;
                transLog.setDlock(dlock);
            }
            catch (Exception ex) {
                try {
                    this.onException(ex);
                    this.updateTaskTransLogStatus(transLog, WorkTaskExecutionStatusEnum.FAILURE, ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("queryWaitingJobLogRecords Get Lock Result=%s, LockInfo=%s, IWorkTaskTransLog=%s", lockSuccess, dlock, transLog));
                    }
                    if (dlock != null && !lockSuccess) {
                        dlock.close();
                    }
                    throw throwable;
                }
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("queryWaitingJobLogRecords Get Lock Result=%s, LockInfo=%s, IWorkTaskTransLog=%s", lockSuccess, dlock, transLog));
                }
                if (dlock != null && !lockSuccess) {
                    dlock.close();
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("queryWaitingJobLogRecords Get Lock Result=%s, LockInfo=%s, IWorkTaskTransLog=%s", lockSuccess, dlock, transLog));
        }
        if (dlock != null && !lockSuccess) {
            dlock.close();
        }
        return lockSuccess;
    }

    protected int retryDLockCnt() {
        return this.dlockRetryCnt;
    }

    public long getDlockTimeOutValue() {
        return this.dlockTimeOutValue;
    }

    public void setDlockTimeOutValue(long dlockTimeOutValue) {
        this.dlockTimeOutValue = dlockTimeOutValue;
    }

    public int getDlockRetryCnt() {
        return this.dlockRetryCnt;
    }

    public void setDlockRetryCnt(int dlockRetryCnt) {
        this.dlockRetryCnt = dlockRetryCnt;
    }

    public int getFetchLogBatchSize() {
        return this.fetchLogBatchSize;
    }

    public void setFetchLogBatchSize(int fetchLogBatchSize) {
        this.fetchLogBatchSize = fetchLogBatchSize;
    }

    public boolean isEnableStriveTask() {
        return this.enableStriveTask;
    }

    public void setEnableStriveTask(boolean enableStriveTask) {
        this.enableStriveTask = enableStriveTask;
    }
}

