/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.task;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.event.IDataNotifyEventConsumer;
import kd.data.disf.event.IDataNotifyEventSender;
import kd.data.disf.event.IWorkTaskStatusChangeListener;
import kd.data.disf.event.NotifyEvent;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.disf.task.status.IDataWorkTaskStatusMgr;

public abstract class IDataAbstractWorkTask<T>
implements IDataWorkTask<T>,
IDataNotifyEventSender,
IDataNotifyEventConsumer {
    private static final Log logger = LogFactory.getLog(IDataAbstractWorkTask.class);
    protected Serializable taskKey;
    protected String taskUUId;
    protected String taskTypeCode;
    protected RequestContext requestContext;
    protected T taskResult;
    protected IDataWorkTaskStatusMgr workTaskStatusMgr;
    protected IExceptionListener exceptionListener;
    protected TaskGroupCondition taskGroupCondition;
    protected IWorkTaskStatusChangeListener taskStatusChangeListener;
    protected Map<String, List<IDataNotifyEventConsumer>> notifyEventConsumers;
    protected Map<String, List<IDataNotifyEventConsumer>> errorEventConsumers;
    protected static final EmptyNotifyEventConsumer defaultNotifyEventConsumer = new EmptyNotifyEventConsumer();
    protected int totalStatisticsPoints;
    protected boolean throwException = true;
    protected Throwable exception;
    protected boolean updateReference;
    protected AtomicInteger taskStageCode;

    protected IDataAbstractWorkTask(Object taskKey) {
        this(taskKey, null, new TaskGroupCondition());
    }

    protected IDataAbstractWorkTask(Object taskKey, IExceptionListener exceptionListener) {
        this(taskKey, exceptionListener, new TaskGroupCondition());
    }

    protected IDataAbstractWorkTask(Object taskKey, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        this.setTaskKey(taskKey);
        this.taskGroupCondition = taskGroupCondition;
        this.exceptionListener = exceptionListener;
        this.updateReference = true;
        this.taskStageCode = new AtomicInteger(0);
        this.taskUUId = UUID.randomUUID().toString();
    }

    public String toString() {
        return "IDataAbstractWorkTask [taskKey=" + this.taskKey + ", taskTypeCode=" + this.taskTypeCode + ", requestContext=" + this.requestContext + ", taskResult=" + this.taskResult + "]";
    }

    @Override
    public String getTaskUUId() {
        return this.taskUUId;
    }

    @Override
    public void notifiyEvent(NotifyEvent event) {
    }

    @Override
    public void run() {
        try {
            this.taskResult = this.call();
        }
        catch (Exception ex) {
            this.onException(ex);
        }
    }

    protected abstract T doTaskJob();

    @Override
    public int getTaskStageCode() {
        return this.taskStageCode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTaskStageCode(int newStageCode) {
        this.taskStageCode.set(newStageCode);
        if (this.taskGroupCondition != null) {
            TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
            synchronized (taskGroupCondition) {
                switch (newStageCode) {
                    case 2: {
                        ++this.taskGroupCondition.startedSubTaskCnt;
                        break;
                    }
                    case 9: {
                        ++this.taskGroupCondition.completedSubTaskCnt;
                        break;
                    }
                    case -9: {
                        ++this.taskGroupCondition.errorTerminiatedSubTaskCnt;
                        break;
                    }
                    case -1: {
                        this.taskGroupCondition.withError = true;
                        break;
                    }
                    case 10: {
                        ++this.taskGroupCondition.cancelledSubTaskCnt;
                        break;
                    }
                }
            }
        }
    }

    protected int calcTaskTotalStatisticsPoints() {
        return this.totalStatisticsPoints;
    }

    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return null;
    }

    protected boolean onException(Throwable exception) {
        logger.error(String.format("%s doTaskJob Error\uff1aTaskClass=%s", this.getClass().getName(), this));
        logger.error(exception.getMessage(), exception);
        return this.exceptionListener != null ? this.exceptionListener.onError(exception) : true;
    }

    @Override
    public T call() {
        block12: {
            if (logger.isInfoEnabled()) {
                logger.info("Starting WorkTask: " + this);
            }
            if (this.taskStatusChangeListener != null) {
                this.taskStatusChangeListener.beforeTaskStart(this.taskUUId, this);
            }
            this.updateTaskStageCode(1);
            if (this.getTenantRequestContext() != null) {
                this.restoreRequestContext(this.getTenantRequestContext());
            }
            try {
                this.updateTaskStageCode(2);
                if (!this.isCancelled()) {
                    this.taskResult = this.doTaskJob();
                    if (logger.isInfoEnabled()) {
                        logger.info("WorkTask Completed: " + this.getTaskKey());
                    }
                    this.updateTaskStageCode(9);
                } else {
                    this.updateTaskStageCode(10);
                }
            }
            catch (Exception ex) {
                this.updateTaskStageCode(-1);
                this.onException(ex);
                this.updateTaskStageCode(-9);
                if (this.taskStatusChangeListener != null) {
                    this.taskStatusChangeListener.onTaskError(this.taskUUId, this, ex);
                }
                if (!this.throwException) break block12;
                throw ex;
            }
        }
        try {
            this.doTaskFinallyCleanUp(this.isCancelled(), this.taskGroupCondition.withError);
        }
        catch (Exception ex) {
            this.onException(ex);
        }
        if (this.taskStatusChangeListener != null) {
            this.taskStatusChangeListener.afterTaskCompleted(this.taskUUId, this, this.taskResult);
        }
        return this.taskResult;
    }

    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
        synchronized (taskGroupCondition) {
            this.taskGroupCondition.active = false;
            this.taskGroupCondition.cancelMode = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
        synchronized (taskGroupCondition) {
            return this.taskGroupCondition.cancelMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isError() {
        TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
        synchronized (taskGroupCondition) {
            return this.taskGroupCondition.withError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateOnError() {
        TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
        synchronized (taskGroupCondition) {
            this.taskGroupCondition.active = false;
            this.taskGroupCondition.withError = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
        synchronized (taskGroupCondition) {
            if (!this.taskGroupCondition.active) {
                switch (this.taskStageCode.get()) {
                    case -9: 
                    case -1: 
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    protected void restoreRequestContext(RequestContext tenantRequestContext) {
        RequestContext.copyAndSet((RequestContext)tenantRequestContext);
    }

    @Override
    public void setTaskGroupCondition(TaskGroupCondition taskGroupCondition) {
        this.taskGroupCondition = taskGroupCondition;
        if (this.taskGroupCondition == null) {
            throw new KDBizException("TaskGroupCondition Cannot be Null!");
        }
    }

    @Override
    public Serializable getId() {
        return this.getTaskKey();
    }

    @Override
    public void acceptErrorEvent(NotifyEvent notifyEvent, Throwable exception) {
    }

    @Override
    public void acceptNotifyEvent(NotifyEvent notifyEvent) {
    }

    @Override
    public void sendNotifyEvent(NotifyEvent notifyEvent) {
        this.sendEvent(false, notifyEvent, null);
    }

    @Override
    public void sendErrorEvent(NotifyEvent notifyEvent, Throwable exception) {
        this.sendEvent(true, notifyEvent, exception);
    }

    @Override
    public boolean registerNotifyEventConsumer(String eventTypeCode, IDataNotifyEventConsumer consumer) {
        return this.registerEventConsumer(false, eventTypeCode, consumer);
    }

    @Override
    public boolean registerErrorEventConsumer(String eventTypeCode, IDataNotifyEventConsumer consumer) {
        return this.registerEventConsumer(true, eventTypeCode, consumer);
    }

    protected Map<String, List<IDataNotifyEventConsumer>> getEventConsumerMap(boolean errorCategory, boolean autoCreate) {
        Map<String, List<IDataNotifyEventConsumer>> eventConsumersMap;
        if (errorCategory) {
            if (this.errorEventConsumers == null && autoCreate) {
                this.errorEventConsumers = new LinkedHashMap<String, List<IDataNotifyEventConsumer>>(2);
            }
            eventConsumersMap = this.errorEventConsumers;
        } else {
            if (this.notifyEventConsumers == null && autoCreate) {
                this.notifyEventConsumers = new LinkedHashMap<String, List<IDataNotifyEventConsumer>>(2);
            }
            eventConsumersMap = this.notifyEventConsumers;
        }
        return eventConsumersMap;
    }

    protected boolean registerEventConsumer(boolean isErrorCategory, String eventTypeCode, IDataNotifyEventConsumer consumer) {
        Map<String, List<IDataNotifyEventConsumer>> map = this.getEventConsumerMap(isErrorCategory, true);
        if (map != null) {
            List<IDataNotifyEventConsumer> consumerList = map.get(eventTypeCode);
            if (consumerList == null || consumerList.isEmpty()) {
                consumerList = new LinkedList<IDataNotifyEventConsumer>();
            }
            consumerList.add(consumer);
            if (isErrorCategory) {
                this.errorEventConsumers.put(eventTypeCode, consumerList);
            } else {
                this.notifyEventConsumers.put(eventTypeCode, consumerList);
            }
            return true;
        }
        return false;
    }

    protected void sendEvent(boolean errorCategory, NotifyEvent notifyEvent, Throwable exception) {
        Map<String, List<IDataNotifyEventConsumer>> eventConsumersMap = this.getEventConsumerMap(errorCategory, false);
        if (eventConsumersMap == null) {
            return;
        }
        List consumerList = eventConsumersMap.getOrDefault(notifyEvent.getActionName(), Collections.emptyList());
        for (IDataNotifyEventConsumer consumer : consumerList) {
            if (errorCategory) {
                consumer.acceptErrorEvent(notifyEvent, exception);
                continue;
            }
            consumer.acceptNotifyEvent(notifyEvent);
        }
    }

    @Override
    public RequestContext getTenantRequestContext() {
        return this.requestContext;
    }

    @Override
    public Serializable getTaskKey() {
        return this.taskKey;
    }

    public final void setTaskKey(Object taskKey) {
        this.taskKey = taskKey != null ? String.valueOf(taskKey) : null;
    }

    @Override
    public T getResult() {
        return this.taskResult;
    }

    public String getTaskTypeCode() {
        return this.taskTypeCode;
    }

    public void setTaskTypeCode(String taskTypeCode) {
        this.taskTypeCode = taskTypeCode;
    }

    @Override
    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public T getTaskResult() {
        return this.taskResult;
    }

    public TaskGroupCondition getTaskGroupCondition() {
        return this.taskGroupCondition;
    }

    public IWorkTaskStatusChangeListener getTaskStatusChangeListener() {
        return this.taskStatusChangeListener;
    }

    @Override
    public void setTaskStatusChangeListener(IWorkTaskStatusChangeListener taskStatusChangeListener) {
        this.taskStatusChangeListener = taskStatusChangeListener;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void setUpdateReference(boolean updateReference) {
        this.updateReference = updateReference;
    }

    @Override
    public boolean getUpdateReference() {
        return this.updateReference;
    }

    protected static class EmptyNotifyEventConsumer
    implements IDataNotifyEventConsumer {
        protected EmptyNotifyEventConsumer() {
        }

        public String getId() {
            return "EmptyNotifyEventConsumer";
        }

        @Override
        public void acceptErrorEvent(NotifyEvent notifyEvent, Throwable exception) {
        }

        @Override
        public void acceptNotifyEvent(NotifyEvent notifyEvent) {
        }
    }
}

