/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.task;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.model.impl.ThreeValueTuple;
import kd.data.disf.task.IDataAbstractWorkGroupMainTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IWorkTaskResultProcessor;

public class IDataSequenceWorkTaskGroup<TASK_RESULT, TASK_STEP extends Callable, TASK_STATUS extends IWorkTaskStatusEvent>
extends IDataAbstractWorkGroupMainTask<TASK_RESULT, TASK_STEP, TASK_STATUS> {
    private static final Log logger = LogFactory.getLog(IDataSequenceWorkTaskGroup.class);
    protected ConcurrentLinkedDeque<TASK_STEP> waitingTaskQueue = new ConcurrentLinkedDeque();
    protected IWorkTaskResultProcessor<TASK_STEP> processTaskResultFunc;
    protected ThreeValueTuple<TASK_STEP, Boolean, Boolean> currentWorkTaskInfo = new ThreeValueTuple<Object, Boolean, Boolean>(null, Boolean.TRUE, Boolean.FALSE);

    public IDataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<TASK_STEP> processTaskResultFunc, IExceptionListener exceptionListener) {
        super(taskKey, version, exceptionListener);
        this.processTaskResultFunc = processTaskResultFunc;
    }

    public IDataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<TASK_STEP> processTaskResultFunc) {
        this(taskKey, version, processTaskResultFunc, null);
    }

    public void addSubTask(TASK_STEP subWorkTask) {
        this.addSubTask(subWorkTask, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubTask(TASK_STEP subWorkTask, boolean updateReference) {
        if (subWorkTask != null) {
            if (updateReference && subWorkTask instanceof IDataWorkTask) {
                this.updateSubTaskReference((IDataWorkTask)subWorkTask);
            }
            this.waitingTaskQueue.add(subWorkTask);
            ConcurrentLinkedDeque<TASK_STEP> concurrentLinkedDeque = this.waitingTaskQueue;
            synchronized (concurrentLinkedDeque) {
                this.waitingTaskQueue.notifyAll();
            }
        }
    }

    @Override
    protected TASK_RESULT processTaskResult(int taskIndex, TASK_STEP task, Object currentTaskResult) {
        if (this.processTaskResultFunc != null) {
            this.processTaskResultFunc.processWorkTaskResult(taskIndex, task, currentTaskResult);
        }
        return (TASK_RESULT)this.taskResult;
    }

    @Override
    public ThreeValueTuple<TASK_STEP, Boolean, Boolean> getNextSubTask() {
        Callable taskStep = (Callable)this.waitingTaskQueue.poll();
        if (taskStep != null) {
            this.currentWorkTaskInfo.setKey(taskStep);
            return this.currentWorkTaskInfo;
        }
        return null;
    }

    @Override
    public boolean hasSubTask() {
        return !this.waitingTaskQueue.isEmpty();
    }

    @Override
    protected Future processSubTask(TASK_STEP subWorkTask) {
        try {
            subWorkTask.call();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return null;
    }
}

