/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.task.status;

import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.util.function.Consumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.stream.datablock.IAsyncStreamDataBlock;
import kd.data.disf.stream.pipe.AsyncStreamPipe;
import kd.data.disf.task.status.IDataWorkTaskStatusMgr;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonUtil;
import kd.data.disf.utils.IDataValueUtil;

public abstract class AbstractIDataWorkTaskStatusConsumer
implements Consumer<IAsyncStreamDataBlock<IWorkTaskStatusEvent>>,
IDataWorkTaskStatusMgr {
    private static final Log logger = LogFactory.getLog(AbstractIDataWorkTaskStatusConsumer.class);
    private static final int cacheTimeOut = 600;
    protected AsyncStreamPipe<IWorkTaskStatusEvent> processPipe = new AsyncStreamPipe();
    protected DistributeCache cache;

    protected abstract IDataCacheModule getCacheModel();

    protected int getCacheTimeOut() {
        return 600;
    }

    public DistributeCache getDistributeCache() {
        if (this.cache == null) {
            this.cache = DistributeCache.getCache(this.getCacheModel());
        }
        return this.cache;
    }

    protected AbstractIDataWorkTaskStatusConsumer() {
        this.processPipe.attach(this);
        logger.info(String.format("IDataWorkTaskStatusConsumer Started! [%s]", this.getClass().getName()));
    }

    @Override
    public void updateTaskStatus(IWorkTaskStatusEvent taskStatus) throws InterruptedException {
        this.processPipe.putToQueue(taskStatus);
    }

    @Override
    public boolean checkTaskCancelStatus(Object taskId, boolean removeFromCache) {
        String cacheKey = this.getTaskCacheKey(taskId, true);
        boolean result = IDataValueUtil.getBoolean(this.getDistributeCache().get(cacheKey));
        if (removeFromCache) {
            this.getDistributeCache().remove(cacheKey);
        }
        return result;
    }

    @Override
    public void markTaskCancel(Object taskId) {
        this.getDistributeCache().put(this.getTaskCacheKey(taskId, true), "y", this.getCacheTimeOut());
    }

    protected void putCacheValue(Object taskId, Object value) {
        this.getDistributeCache().put(this.getTaskCacheKey(taskId, false), IDataJsonUtil.toJSONString(value), this.getCacheTimeOut());
    }

    @Override
    public IWorkTaskStatusEvent getCachedWorkTaskStatusEvent(Object taskId) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray(this.getDistributeCache().get(this.getTaskCacheKey(taskId, false)));
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IWorkTaskStatusEvent)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName(String.valueOf(jsonArray.get(0))), jsonArray);
    }

    protected String getTaskCacheKey(Object taskId, boolean controlMode) {
        if (controlMode) {
            return (Object)((Object)this.getCacheModel()) + "||" + taskId;
        }
        return (Object)((Object)this.getCacheModel()) + "|" + taskId;
    }

    @Override
    public void accept(IAsyncStreamDataBlock<IWorkTaskStatusEvent> dataBlock) {
        IWorkTaskStatusEvent taskStatus;
        if (dataBlock != null && (taskStatus = dataBlock.getData()) != null) {
            Serializable taskId = taskStatus.getTaskId();
            if (taskStatus.needMergeStatus()) {
                IWorkTaskStatusEvent oldStatus = this.getCachedWorkTaskStatusEvent(taskId);
                taskStatus.mergeTaskStatus(oldStatus);
            }
            this.putCacheValue(taskId, taskStatus);
        }
    }
}

