/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.CustomizedFormBuilderInfo;

public class CustomizedDynamicFormBuilderUtil {
    private static final Log logger = LogFactory.getLog(CustomizedDynamicFormBuilderUtil.class);

    public static CustomizedFormBuilderInfo initializedNewCustomizedFormMeta(CustomizedFormBuilderInfo formBuilderInfo) {
        EntityMetadata entityMeta;
        FormMetadata formMeta;
        if (formBuilderInfo == null) {
            throw new IllegalArgumentException("CustomizedFormBuilderInfo Cannot be Null!");
        }
        if (formBuilderInfo.formNumber == null || formBuilderInfo.bizAppId == null) {
            throw new IllegalArgumentException("Form Number or BizAppID is Null!");
        }
        IFormTemplate formTemplate = formBuilderInfo.formTemplate = FormTemplateFactory.createTemplate((String)formBuilderInfo.formModelType);
        boolean needCreateNewForm = false;
        needCreateNewForm = MetadataDao.checkNumber((String)formBuilderInfo.formNumber) ? !CustomizedDynamicFormBuilderUtil.loadFormModelMeta(formBuilderInfo) : true;
        if (needCreateNewForm) {
            LocaleString formDisplayName = new LocaleString(formBuilderInfo.formName);
            formMeta = formBuilderInfo.formMeta = formTemplate.getFormMetadata();
            formMeta.setBizappId(formBuilderInfo.bizAppId);
            formMeta.setKey(formBuilderInfo.formNumber);
            formMeta.setName(formDisplayName);
            formMeta.setIsv(ISVService.getISVInfo().getId());
            formMeta.setDevType("0");
            entityMeta = formBuilderInfo.entityMeta = formTemplate.getEntityMetadata();
            entityMeta.setBizappId(formBuilderInfo.bizAppId);
            entityMeta.setEnabled(true);
            entityMeta.setId(formMeta.getId());
            entityMeta.setKey(formBuilderInfo.formNumber);
            entityMeta.setName(formDisplayName);
            MainEntity mainEntity = entityMeta.getRootEntity();
            mainEntity.setId(entityMeta.getId());
            mainEntity.setKey(formBuilderInfo.formNumber);
            mainEntity.setTableName("t_" + formBuilderInfo.formNumber);
            mainEntity.setName(formDisplayName);
            if (StringUtils.isNotEmpty((String)formBuilderInfo.bizAppId)) {
                DynamicObject bizapp = BusinessDataServiceHelper.loadSingle((Object)formBuilderInfo.bizAppId, (String)"bos_devportal_bizapp");
                formBuilderInfo.dbRoute = bizapp.getString("dbroute");
                mainEntity.setdbRoute(formBuilderInfo.dbRoute);
            }
            formMeta.createIndex();
            entityMeta.createIndex();
            formMeta.setEntityId(formMeta.getId());
        } else {
            formBuilderInfo.dbRoute = formBuilderInfo.mainEntity.getdbRoute();
            formMeta = formBuilderInfo.formMeta;
            entityMeta = formBuilderInfo.entityMeta;
        }
        formMeta.bindEntityMetadata(entityMeta);
        return formBuilderInfo;
    }

    public static CustomizedFormBuilderInfo createCustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId, String formModelType) {
        return CustomizedDynamicFormBuilderUtil.initializedNewCustomizedFormMeta(new CustomizedFormBuilderInfo(formNumber, formName, bizAppId, formModelType));
    }

    public static boolean loadFormModelMeta(CustomizedFormBuilderInfo formBuilderInfo) {
        boolean result = true;
        try {
            String metaid = MetadataDao.getIdByNumber((String)formBuilderInfo.formNumber, (MetaCategory)MetaCategory.Entity);
            formBuilderInfo.entityMeta = (EntityMetadata)MetadataDao.readMeta((String)metaid, (MetaCategory)MetaCategory.Entity);
            formBuilderInfo.formMeta = (FormMetadata)MetadataDao.readMeta((String)metaid, (MetaCategory)MetaCategory.Form);
            formBuilderInfo.mainEntity = formBuilderInfo.entityMeta.getRootEntity();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    protected static String arrayToString(Object[] srcArray, boolean skipEmpty, char delimeter) {
        StringBuilder buf = new StringBuilder();
        for (Object obj : srcArray) {
            String strBuf;
            if (obj == null) {
                if (skipEmpty) continue;
                strBuf = "";
            } else {
                strBuf = obj.toString().trim();
            }
            buf.append(delimeter).append(strBuf);
        }
        return buf.toString().substring(1);
    }

    protected static String arrayToString(Object[] srcArray) {
        return CustomizedDynamicFormBuilderUtil.arrayToString(srcArray, true, ',');
    }

    public static int createTableIndex(String dbRouterKey, String indexName, String tableName, String ... fields) {
        if (dbRouterKey == null || indexName == null || tableName == null || fields == null || fields.length < 1) {
            return -1;
        }
        DBRoute dbrouter = DBRoute.of((String)dbRouterKey);
        if (!DB.exitsIndex((DBRoute)dbrouter, (String)tableName, (String)("index " + indexName))) {
            DB.execute((DBRoute)dbrouter, (String)String.format("create index %s on %s (%s);", indexName, tableName, CustomizedDynamicFormBuilderUtil.arrayToString(fields)));
            return 1;
        }
        return 0;
    }

    public static Map<String, Object> saveEntityMetaDataAndCreateTable(CustomizedFormBuilderInfo formBuilderInfo) {
        ErrorInfo indexError;
        Map saveResult = new DesignerData().save(formBuilderInfo.buildFormDesignerDataMap());
        if (saveResult != null && saveResult.getOrDefault("success", Boolean.FALSE).booleanValue() && (indexError = CustomizedDynamicFormBuilderUtil.createTableIndexs(formBuilderInfo)) != null) {
            ((List)saveResult.computeIfAbsent("errors", n -> new LinkedList())).add(indexError);
        }
        return saveResult;
    }

    public static ErrorInfo createTableIndexs(CustomizedFormBuilderInfo formBuilderInfo) {
        if (formBuilderInfo.getTableIndexMap() != null && !formBuilderInfo.getTableIndexMap().isEmpty()) {
            try {
                String tableName = "t_" + formBuilderInfo.getFormNumber();
                for (Map.Entry<String, String> en : formBuilderInfo.getTableIndexMap().entrySet()) {
                    if (StringUtils.isEmpty((String)en.getValue())) continue;
                    CustomizedDynamicFormBuilderUtil.createTableIndex(formBuilderInfo.dbRoute, en.getKey(), tableName, en.getValue());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ErrorInfo("\u521b\u5efa\u7d22\u5f15\u5931\u8d25: " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean checkDesignerDataSaveResult(Map<String, Object> saveResult, boolean throwException) {
        List errInfos;
        boolean saveStatus = (Boolean)saveResult.getOrDefault("success", Boolean.FALSE);
        if (!saveStatus && (errInfos = (List)saveResult.get("errors")) != null && !errInfos.isEmpty() && throwException) {
            StringBuilder errBuffer = new StringBuilder();
            ErrorInfo lastError = null;
            for (ErrorInfo errInfo : errInfos) {
                lastError = errInfo;
                if (lastError == null) continue;
                errBuffer.append(String.format("Save Error! Type=%s, Level=%s, ItemId=%s, PropertyName=%s, ErrorMsg=%s", errInfo.getType(), errInfo.getLevel(), errInfo.getItemId(), errInfo.getPropertyName(), errInfo.getError())).append('\n');
            }
            if (lastError != null) {
                throw new KDException(new ErrorCode(lastError.getType(), errBuffer.toString()), new Object[]{errInfos});
            }
        }
        return saveStatus;
    }

    public static boolean checkDesignerDataSaveResult(Map<String, Object> saveResult) {
        return CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult(saveResult, false);
    }

    public static FieldsetPanelAp creatFieldsetPanelAp(String parentId, String key, String title) {
        FieldsetPanelAp panel = new FieldsetPanelAp();
        panel.setId(Uuid8.generateShortUuid());
        panel.setKey(key);
        panel.setName(new LocaleString(title));
        panel.setParentId(parentId);
        panel.setWidth(new LocaleString("100%"));
        panel.setCollapsible(false);
        return panel;
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid, int index) {
        CustomizedDynamicFormBuilderUtil.setFieldAp(fieldAp, field, panelid);
        fieldAp.setIndex(index);
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid, String lockConfigString) {
        fieldAp.setId(field.getId());
        fieldAp.setFieldId(field.getId());
        fieldAp.setKey(field.getKey());
        fieldAp.setName(field.getName());
        fieldAp.setField((Field)field);
        fieldAp.setParentId(panelid);
        fieldAp.setLock(lockConfigString);
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid) {
        CustomizedDynamicFormBuilderUtil.setFieldAp(fieldAp, field, panelid, "submit,audit,edit");
    }

    public static FieldAp createBasePropFields(Class<? extends Field> fieldTypeClass, String fieldNumber, String fieldName, String basePropEntityName, String parentId, EntityMetadata entityMeta, String basePanelId, int fieldIndex) {
        Field field;
        try {
            field = fieldTypeClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        field.setEnableNull(fieldTypeClass.isAssignableFrom(DecimalField.class));
        field.setId(Uuid8.generateShortUuid());
        field.setKey(fieldNumber);
        field.setFieldName("f" + fieldNumber);
        field.setName(new LocaleString(fieldName));
        field.setParentId(parentId);
        field.setEntityMetadata(entityMeta);
        field.setMustInput(true);
        if (StringUtils.isNotEmpty((String)basePropEntityName)) {
            ((BasedataField)field).setDisplayProp("name");
            ((BasedataField)field).setBaseEntityId(MetadataDao.getIdByNumber((String)basePropEntityName, (MetaCategory)MetaCategory.Entity));
        }
        field.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(field);
        FieldAp filedAp = new FieldAp();
        CustomizedDynamicFormBuilderUtil.setFieldAp(filedAp, (AbstractElement)field, basePanelId, fieldIndex);
        return filedAp;
    }

    public static Set<String> getEntityProperties(String entityNumber, Set<String> includePropNames, boolean lowcase, Class ... includePropDataTypes) {
        LinkedHashSet<String> resultList = new LinkedHashSet<String>();
        HashSet<Class> dataTypeFilter = new HashSet<Class>();
        if (includePropDataTypes != null) {
            dataTypeFilter.addAll(Arrays.asList(includePropDataTypes));
        }
        boolean needPropNameFilter = includePropNames != null && !includePropNames.isEmpty();
        boolean needPropDataTypeFilter = !dataTypeFilter.isEmpty();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String propNumber = prop.getName();
            boolean needAdd = false;
            if (!needPropNameFilter && !needPropDataTypeFilter) {
                needAdd = true;
            } else {
                needAdd = !needPropDataTypeFilter || dataTypeFilter.contains(prop.getPropertyType());
                if (needAdd) {
                    boolean bl = needAdd = !needPropNameFilter || includePropNames.contains(propNumber);
                }
            }
            if (!needAdd) continue;
            resultList.add(lowcase ? propNumber.toLowerCase() : propNumber);
        }
        return resultList;
    }

    public static Set<String> getEntityProperties(String entityNumber, Set<String> includePropNames, Class ... includePropDataTypes) {
        return CustomizedDynamicFormBuilderUtil.getEntityProperties(entityNumber, includePropNames, true, includePropDataTypes);
    }

    public static void deleteForm(String targetEntityNumber, boolean dropR3) {
        List formPKs;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        String sql = "SELECT FID FROM T_META_FORMDESIGN WHERE FNUMBER = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)targetEntityNumber)};
        try {
            formPKs = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                ArrayList<String> list = new ArrayList<String>(1);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            logger.error(msg + "\n" + e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (entityType != null) {
            try {
                boolean dropResult;
                if (dropR3) {
                    try {
                        dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("select 1 from %s_r3;", entityType.getAlias()));
                    }
                    catch (Exception e) {
                        dropResult = false;
                    }
                    if (dropResult) {
                        dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("drop table %s_r3;", entityType.getAlias()));
                        logger.info(String.format("drop table %s_r3; Result = %s", entityType.getAlias(), dropResult));
                    }
                }
                dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("drop table %s;", entityType.getAlias()));
                logger.info(String.format("drop table %s; Result = %s", entityType.getAlias(), dropResult));
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (formPKs != null && !formPKs.isEmpty()) {
            CustomizedDynamicFormBuilderUtil.deleteForm((String)formPKs.get(0));
        }
    }

    private static void deleteForm(String formId) {
        try (TXHandle tx = TX.required((String)"fsa/data/deleteForm");){
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)"masterid,type");
            MetadataDao.delFormMetadata((String)formId);
            try {
                ArrayList<String> formIdList = new ArrayList<String>();
                String devType = pageObject.getString("type");
                if ("2".equals(devType)) {
                    formId = pageObject.getString("masterid");
                    formIdList.add(formId);
                    MetadataDao.clearSubRuntimeMeta(formIdList);
                    MetadataDao.rebuildRuntimeMetaById((String)formId);
                }
            }
            catch (Exception e) {
                logger.error("deleteForm\uff1a" + e.getMessage());
                throw e;
            }
        }
    }
}

