/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.isv.ISVService;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.FSADataTypeEnum;
import kd.data.disf.utils.CustomizedDynamicFormBuilderUtil;

public class CustomizedFormBuilderInfo
implements Serializable {
    private static final long serialVersionUID = 3353447205684514804L;
    protected IFormTemplate formTemplate;
    protected String formNumber;
    protected String formName;
    protected FormMetadata formMeta;
    protected EntityMetadata entityMeta;
    protected MainEntity mainEntity;
    protected String entityMetaId;
    protected String formModelType;
    protected String dbRoute;
    protected boolean isDeveloper;
    protected String bizAppId;
    protected String bizUnitId;
    protected Map<String, String> tableIndexMap;

    public CustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId) {
        this(formNumber, formName, bizAppId, "BillFormModel");
    }

    public CustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId, String formModelType) {
        this.formNumber = formNumber;
        this.formName = formName;
        this.formModelType = formModelType;
        this.bizAppId = bizAppId;
    }

    public String toString() {
        return "CustomizedFormBuilderInfo [formTemplate=" + this.formTemplate + ", formNumber=" + this.formNumber + ", formName=" + this.formName + ", formMeta=" + this.formMeta + ", entityMeta=" + this.entityMeta + ", mainEntity=" + this.mainEntity + ", entityMetaId=" + this.entityMetaId + ", formModelType=" + this.formModelType + ", dbRoute=" + this.dbRoute + ", isDeveloper=" + this.isDeveloper + ", bizAppId=" + this.bizAppId + "]";
    }

    public Map<String, Object> buildFormDesignerDataMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", this.formNumber);
        resultMap.put("caption", this.formName);
        resultMap.put("entitymeta", this.formTemplate.serializeToMap((Object)this.entityMeta));
        resultMap.put("formmeta", this.formTemplate.serializeToMap((Object)this.formMeta));
        resultMap.put("modelType", this.formModelType);
        resultMap.put("bizunitid", this.bizUnitId);
        resultMap.put("BizappId", this.bizAppId);
        resultMap.put("subSystem", 1);
        resultMap.put("isPC", Boolean.TRUE);
        resultMap.put("MasterId", "");
        resultMap.put("isDeveloper", this.isDeveloper);
        resultMap.put("devType", 0);
        resultMap.put("isv", ISVService.getISVInfo().getId());
        this.formMeta.setIsv(ISVService.getISVInfo().getId());
        this.formMeta.setDevType("0");
        this.formMeta.setModelType(this.formModelType);
        this.formMeta.setEnabled(true);
        return resultMap;
    }

    public void addFormPlugin(String pluginName, boolean enable) {
        if (this.formMeta == null || this.formMeta.getRootAp() == null) {
            throw new IllegalArgumentException("FormMeta is Null and FormMeta Root Ap is Null!");
        }
        Plugin plugin = new Plugin();
        plugin.setClassName(pluginName);
        plugin.setEnabled(enable);
        this.formMeta.getRootAp().getPlugins().add(plugin);
    }

    public List<Operation> getOperationList() {
        return ((BillEntity)this.entityMeta.getRootEntity()).getOperations();
    }

    public Operation addOperation(String operationType, String operationKey, String operationName) {
        Operation op = new Operation();
        op.setOperationType(operationType);
        op.setKey(operationKey);
        op.setName(new LocaleString(operationName));
        op.setId(Uuid8.generateShortUuid());
        op.setLogEnable(false);
        this.entityMeta.getRootEntity().getOperations().add(op);
        return op;
    }

    public FormAp getFormRootAp() {
        return this.formMeta != null ? this.formMeta.getRootAp() : null;
    }

    public FieldAp addBasicField(FSADataTypeEnum fieldType, String fieldNumber, String fieldName, String defaultValue) {
        switch (fieldType) {
            case DATE_TYPE: {
                return this.addDateField(fieldNumber, fieldName, defaultValue);
            }
            case BASICDATA_TYPE: {
                return this.addBigIntField(fieldNumber, fieldName, defaultValue);
            }
            case FLOAT_TYPE: {
                return this.addDecimalField(fieldNumber, fieldName, defaultValue);
            }
        }
        return this.addIntegerField(fieldNumber, fieldName, defaultValue);
    }

    public FieldAp addDateField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(DateField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((DateField)ap.getField()).setDefValue(defaultValue);
        }
        return ap;
    }

    public FieldAp addDecimalField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(DecimalField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((DecimalField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addTextField(String fieldNumber, String fieldName, int maxLength, String defaultValue) {
        FieldAp ap = this.addField(TextField.class, fieldNumber, fieldName, null);
        TextField textField = (TextField)ap.getField();
        textField.setMaxLength(maxLength);
        textField.setMinLength(0);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            textField.setDefValue(defaultValue);
        }
        return ap;
    }

    public FieldAp addBigIntField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(BigIntField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((BigIntField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addIntegerField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(IntegerField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((IntegerField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addField(Class<? extends Field> fieldTypeClass, String fieldNumber, String fieldName, String basePropEntityName) {
        int fieldIndex = this.formMeta != null && this.formMeta.getItems() != null ? this.formMeta.getItems().size() : 0;
        return CustomizedDynamicFormBuilderUtil.createBasePropFields(fieldTypeClass, fieldNumber, fieldName, basePropEntityName, this.getFormRootAp().getId(), this.entityMeta, this.getFormRootAp().getId(), fieldIndex);
    }

    public IFormTemplate getFormTemplate() {
        return this.formTemplate;
    }

    public void setFormTemplate(IFormTemplate formTemplate) {
        this.formTemplate = formTemplate;
    }

    public String getFormNumber() {
        return this.formNumber;
    }

    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public FormMetadata getFormMeta() {
        return this.formMeta;
    }

    public void setFormMeta(FormMetadata formMeta) {
        this.formMeta = formMeta;
    }

    public EntityMetadata getEntityMeta() {
        return this.entityMeta;
    }

    public void setEntityMeta(EntityMetadata entityMeta) {
        this.entityMeta = entityMeta;
    }

    public MainEntity getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(MainEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public String getEntityMetaId() {
        return this.entityMetaId;
    }

    public void setEntityMetaId(String entityMetaId) {
        this.entityMetaId = entityMetaId;
    }

    public String getFormModelType() {
        return this.formModelType;
    }

    public void setFormModelType(String formModelType) {
        this.formModelType = formModelType;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public boolean isDeveloper() {
        return this.isDeveloper;
    }

    public void setDeveloper(boolean isDeveloper) {
        this.isDeveloper = isDeveloper;
    }

    public String getBizAppId() {
        return this.bizAppId;
    }

    public void setBizAppId(String bizAppId) {
        this.bizAppId = bizAppId;
    }

    public String getBizUnitId() {
        return this.bizUnitId;
    }

    public void setBizUnitId(String bizUnitId) {
        this.bizUnitId = bizUnitId;
    }

    public Map<String, String> getTableIndexMap() {
        return this.tableIndexMap;
    }

    public void setTableIndexMap(Map<String, String> tableIndexMap) {
        this.tableIndexMap = tableIndexMap;
    }
}

