/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.data.disf.utils.IDataValueUtil;

public class IDataCommonUtil {
    public static <K, V> Map<K, V> singleValueMap(K key, V value) {
        HashMap<K, V> resultMap = new HashMap<K, V>();
        resultMap.put(key, value);
        return resultMap;
    }

    public static <K, V> Map<K, V> twoValueMap(K key, V value, K key2, V value2) {
        HashMap<K, V> resultMap = new HashMap<K, V>();
        resultMap.put(key, value);
        resultMap.put(key2, value2);
        return resultMap;
    }

    public static <K, V> Map<K, V> tripleValueMap(K key, V value, K key2, V value2, K key3, V value3) {
        HashMap<K, V> resultMap = new HashMap<K, V>();
        resultMap.put(key, value);
        resultMap.put(key2, value2);
        resultMap.put(key3, value3);
        return resultMap;
    }

    public static <T> T[] singleValueToArray(Object value) {
        if (value == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(value.getClass(), 1);
        result[0] = value;
        return result;
    }

    public static <T> List<T> multipleValueListToSingleValueList(List<T[]> multipleValueList, int valueIndex, T defaultValueForNull) {
        if (multipleValueList == null || multipleValueList.isEmpty() || valueIndex < 0) {
            return new ArrayList(0);
        }
        ArrayList<T> resultList = new ArrayList<T>(multipleValueList.size());
        for (T[] v : multipleValueList) {
            resultList.add(v == null || v.length <= valueIndex ? defaultValueForNull : v[valueIndex]);
        }
        return resultList;
    }

    public static <T> List<T> multipleValueListToSingleValueList(List<T[]> multipleValueList) {
        return IDataCommonUtil.multipleValueListToSingleValueList(multipleValueList, 0, null);
    }

    public static <T> List<T> multipleValueListToSingleValueList(List<T[]> multipleValueList, T defaultValueForNull) {
        return IDataCommonUtil.multipleValueListToSingleValueList(multipleValueList, 0, defaultValueForNull);
    }

    public static <T> T[] convertCollectionToArray(List sourceCollection, Class<T> targetClassType) {
        if (sourceCollection == null || sourceCollection.isEmpty()) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(targetClassType, sourceCollection.size());
        int i = 0;
        for (Object obj : sourceCollection) {
            if (obj == null) {
                result[i++] = null;
                continue;
            }
            result[i++] = targetClassType.cast(obj);
        }
        return result;
    }

    public static <T> T[] convertCollectionToArrayEx(Collection sourceCollection, Class<T> targetClassType) {
        if (sourceCollection == null || sourceCollection.isEmpty()) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(targetClassType, sourceCollection.size());
        int i = 0;
        switch (targetClassType.getName()) {
            case "java.lang.Long": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getLong(obj);
                }
                break;
            }
            case "java.lang.Integer": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getInteger(obj);
                }
                break;
            }
            case "java.lang.Byte": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getByte(obj);
                }
                break;
            }
            case "java.lang.Short": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getShort(obj);
                }
                break;
            }
            case "java.sql.Date": 
            case "java.util.Date": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getDate(obj);
                }
                break;
            }
            case "java.lang.Boolean": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getBoolean(obj);
                }
                break;
            }
            case "java.lang.Float": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getFloat(obj);
                }
                break;
            }
            case "java.lang.Double": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getDouble(obj);
                }
                break;
            }
            case "java.math.BigDecimal": {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = IDataValueUtil.getBigDecimal(obj);
                }
                break;
            }
            default: {
                for (Object obj : sourceCollection) {
                    if (obj == null) {
                        result[i++] = null;
                        continue;
                    }
                    result[i++] = targetClassType.cast(obj);
                }
            }
        }
        return result;
    }

    public static <T> T[] convertArrayElementType(Object[] sourceArray, Class<T> targetClassType) {
        if (sourceArray == null || sourceArray.length <= 0) {
            return (Object[])Array.newInstance(targetClassType, 0);
        }
        return IDataCommonUtil.convertCollectionToArray(Arrays.asList(sourceArray), targetClassType);
    }
}

