/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import com.alibaba.fastjson.parser.Feature;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.data.disf.date.CalendarDatePeriod;
import kd.data.disf.enums.TimePeriodTypeEnum;
import kd.data.disf.utils.IDataJsonUtil;

public class IDataFilterUtil {
    public static QFilter addQFilters(QFilter rootFilter, boolean andMode, QFilter ... newFilters) {
        int i;
        if (rootFilter == null && (newFilters == null || newFilters.length <= 0)) {
            return null;
        }
        if (rootFilter == null) {
            for (i = 0; i < newFilters.length; ++i) {
                if (newFilters[i] != null) continue;
                rootFilter = newFilters[i];
            }
        }
        if (rootFilter != null && i < newFilters.length) {
            while (i < newFilters.length) {
                if (andMode) {
                    rootFilter.and(newFilters[i]);
                } else {
                    rootFilter.or(newFilters[i]);
                }
                ++i;
            }
        }
        return rootFilter;
    }

    public static QFilter addAndQFilters(QFilter rootFilter, QFilter ... newFilters) {
        return IDataFilterUtil.addQFilters(rootFilter, true, newFilters);
    }

    public static QFilter addOrQFilters(QFilter rootFilter, QFilter ... newFilters) {
        return IDataFilterUtil.addQFilters(rootFilter, false, newFilters);
    }

    public static QFilter getFilterFromFilterCondition(MainEntityType entityType, Object filterConditionValue, IDataJsonUtil jsonUtil) {
        if (filterConditionValue == null) {
            return null;
        }
        FilterCondition filterCondition = null;
        if (filterConditionValue instanceof String) {
            String strBuf = (String)filterConditionValue;
            if (IDataJsonUtil.isJSonFormat(strBuf, "filterRow")) {
                filterCondition = jsonUtil.parseObject(strBuf, FilterCondition.class, new Feature[0]);
            }
        } else if (filterConditionValue instanceof FilterCondition) {
            filterCondition = (FilterCondition)filterConditionValue;
        }
        QFilter resultFilter = null;
        if (filterCondition != null) {
            FilterBuilder builder = new FilterBuilder(entityType, filterCondition);
            builder.buildFilter();
            resultFilter = builder.getQFilter();
        }
        return resultFilter;
    }

    public static QFilter getFilterFromFilterCondition(String entityTypeName, Object filterConditionValue, IDataJsonUtil jsonUtil) {
        return IDataFilterUtil.getFilterFromFilterCondition(EntityMetadataCache.getDataEntityType((String)entityTypeName), filterConditionValue, jsonUtil);
    }

    public static Set<String> parseFilterFileds(QFilter filter) {
        if (filter == null) {
            return new HashSet<String>(0);
        }
        List nestFilters = filter.getNests(true);
        if (nestFilters == null || nestFilters.isEmpty()) {
            return new HashSet<String>(0);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(nestFilters.size() + 1);
        for (QFilter.QFilterNest nest : nestFilters) {
            if (nest == null) continue;
            result.add(nest.getFilter().getProperty());
        }
        return result;
    }

    public static Set<String> parseFilterFileds(MainEntityType entityType, String filterConditionValue, IDataJsonUtil jsonUtil) {
        if (entityType == null || StringUtils.isEmpty((CharSequence)filterConditionValue)) {
            return new HashSet<String>(0);
        }
        return IDataFilterUtil.parseFilterFileds(IDataFilterUtil.getFilterFromFilterCondition(entityType, (Object)filterConditionValue, jsonUtil));
    }

    public static QFilter buildTimePeriodFilter(String timeFieldName, Date currentDate, TimePeriodTypeEnum periodType, int periodLength, Integer offset) {
        if (offset == null) {
            offset = 0;
        }
        CalendarDatePeriod datePeriod = CalendarDatePeriod.updateCalendarDatePeriod(periodType, periodLength, offset, currentDate, null);
        return new QFilter(timeFieldName, "<=", (Object)datePeriod.getEndDate()).and(new QFilter(timeFieldName, ">=", (Object)datePeriod.getStartDate()));
    }
}

