/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class IDataMathUtil {
    public static String rounding(String sourceString, int scale, RoundingMode roundingMode) {
        return String.valueOf(new BigDecimal("0." + sourceString).setScale(scale, roundingMode)).substring(2);
    }

    public static String rounding(String sourceString, int scale) {
        return IDataMathUtil.rounding(sourceString, scale, RoundingMode.HALF_UP);
    }

    public static String rounding(String sourceString) {
        return IDataMathUtil.rounding(sourceString, sourceString.length() - 1, RoundingMode.HALF_UP);
    }

    public static BigDecimal nRoot(BigDecimal source, int n) {
        switch (n) {
            case 0: {
                return BigDecimal.ONE;
            }
            case 1: {
                return source;
            }
            case 2: {
                return BigDecimal.valueOf(Math.sqrt(source.doubleValue()));
            }
        }
        return BigDecimal.valueOf(Math.pow(source.doubleValue(), 1.0 / (double)n));
    }

    public static double nRoot(double source, int n) {
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return source;
            }
            case 2: {
                return Math.sqrt(source);
            }
        }
        return Math.pow(source, 1.0 / (double)n);
    }

    public static BigDecimal sqrt(BigDecimal source) {
        return BigDecimal.valueOf(Math.sqrt(source.doubleValue()));
    }
}

