/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IDataQingHelper {
    private static Log logger = LogFactory.getLog(IDataQingHelper.class);
    private static Map<String, QingFieldType> dataEntityTypeToQingFieldTypeMap = new HashMap<String, QingFieldType>();
    private static Map<String, String> dataEntityTypeToReportColumnTypeMap;
    private static Map<String, DataType> reportColumnTypeToDataTypeMap;

    public static DataType reportColumnTypeToAlgoDataType(String reportColumnDataType) {
        return reportColumnTypeToDataTypeMap.get(reportColumnDataType);
    }

    public static String dataEntityTypeToReportColumnType(Class<?> dataEntityType) {
        return dataEntityTypeToReportColumnTypeMap.get(dataEntityType.getName());
    }

    public static QingFieldType dataEntityTypeToQingFieldType(Class<?> dataEntityType) {
        return dataEntityTypeToQingFieldTypeMap.get(dataEntityType.getName());
    }

    public static QingFieldType getQingFieldType(Class<?> propType) {
        if (propType == null) {
            return null;
        }
        if (!DynamicObject.class.isAssignableFrom(propType)) {
            if (Integer.class.isAssignableFrom(propType) || Long.class.isAssignableFrom(propType) || Short.class.isAssignableFrom(propType)) {
                return QingFieldType.Int;
            }
            if (Double.class.isAssignableFrom(propType) || Float.class.isAssignableFrom(propType) || BigDecimal.class.isAssignableFrom(propType)) {
                return QingFieldType.Number;
            }
            if (Date.class.isAssignableFrom(propType)) {
                return QingFieldType.Date;
            }
            if (java.util.Date.class.isAssignableFrom(propType)) {
                return QingFieldType.DateTime;
            }
            if (Boolean.class.isAssignableFrom(propType)) {
                return QingFieldType.Boolean;
            }
        }
        return QingFieldType.String;
    }

    public static QingFieldType getQingFieldType(IDataEntityProperty entityProp) {
        return entityProp != null ? IDataQingHelper.getQingFieldType(entityProp.getPropertyType()) : QingFieldType.String;
    }

    public static QingFieldType convertEntityTypeToQingFieldType(IDataEntityProperty property) {
        String key = null;
        if (property != null && property.getPropertyType() != null && !dataEntityTypeToQingFieldTypeMap.containsKey(key = property.getPropertyType().getName()) && property instanceof BasedataProp) {
            key = String.class.getName();
        }
        return key == null ? null : dataEntityTypeToQingFieldTypeMap.get(key);
    }

    public static String convertEntityTypeToReportColumnType(IDataEntityProperty property) {
        String key = null;
        if (property != null && property.getPropertyType() != null) {
            key = property.getPropertyType().getName();
            String typeValue = dataEntityTypeToReportColumnTypeMap.get(key);
            if (typeValue != null) {
                return typeValue;
            }
            if (property instanceof CurrencyProp) {
                return "currency";
            }
            if (property instanceof UnitProp) {
                return "unit";
            }
            if (property instanceof BasedataProp) {
                return "basedata";
            }
        }
        return "text";
    }

    public static Field createFieldObj(String key, String name, int fieldType) {
        return IDataQingHelper.createFieldObj(key, name, fieldType, null, false);
    }

    public static Field createFieldObj(String key, String name, QingFieldType fieldType, String entity) {
        return IDataQingHelper.createFieldObj(key, name, fieldType.toNumber(), entity, false);
    }

    public static Field createFieldObj(String key, String name, QingFieldType fieldType, String entity, boolean hide) {
        return IDataQingHelper.createFieldObj(key, name, fieldType.toNumber(), entity, hide);
    }

    public static Field createFieldObj(String key, String name, int fieldType, String entity) {
        return IDataQingHelper.createFieldObj(key, name, fieldType, entity, false);
    }

    public static Field createFieldObj(String key, String name, int fieldType, String entity, boolean hide) {
        Field field = new Field();
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        field.setHide(hide);
        if (entity != null) {
            field.setEntity(entity);
        }
        return field;
    }

    public static Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        if (qingMeta == null) {
            throw new KDBizException("\u8f7b\u5206\u6790\u7684Meta\u4fe1\u606f\u65e0\u6548 ");
        }
        if (qingMeta.getColumns() == null || qingMeta.getColumns().isEmpty()) {
            return new HashMap<String, Integer>(0);
        }
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (Field col : qingMeta.getColumns()) {
            qingDataIndexMap.put(col.getKey(), columnSeqNo);
            ++columnSeqNo;
        }
        return qingDataIndexMap;
    }

    public static Set<String> parserQueryFieldsFromQingMeta(QingMeta qingMeta, MainEntityType analysisSchemeMeta, boolean basedataPropUseName) {
        if (qingMeta == null) {
            throw new KDBizException("\u8f7b\u5206\u6790\u7684Meta\u4fe1\u606f\u65e0\u6548 ");
        }
        if (analysisSchemeMeta == null) {
            throw new KDBizException("\u5206\u6790\u65b9\u6848\u65e0\u6548 ");
        }
        if (qingMeta.getColumns() == null || qingMeta.getColumns().isEmpty()) {
            return new HashSet<String>(0);
        }
        LinkedHashSet<String> queryNameList = new LinkedHashSet<String>(qingMeta.getColumns().size());
        DataEntityPropertyCollection fieldProperties = analysisSchemeMeta.getProperties();
        for (Field col : qingMeta.getColumns()) {
            String colName = col.getKey().toLowerCase();
            if (!fieldProperties.containsKey((Object)colName) || !basedataPropUseName || !(fieldProperties.get((Object)colName) instanceof BasedataProp)) continue;
            queryNameList.add(colName + ".name");
        }
        return queryNameList;
    }

    static {
        dataEntityTypeToQingFieldTypeMap.put(String.class.getName(), QingFieldType.String);
        dataEntityTypeToQingFieldTypeMap.put(BigDecimal.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Long.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Integer.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Double.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Float.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Short.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(Byte.class.getName(), QingFieldType.Number);
        dataEntityTypeToQingFieldTypeMap.put(java.util.Date.class.getName(), QingFieldType.Date);
        dataEntityTypeToQingFieldTypeMap.put(Date.class.getName(), QingFieldType.Date);
        dataEntityTypeToReportColumnTypeMap = new HashMap<String, String>();
        dataEntityTypeToReportColumnTypeMap.put(String.class.getName(), "text");
        dataEntityTypeToReportColumnTypeMap.put(Integer.class.getName(), "integer");
        dataEntityTypeToReportColumnTypeMap.put(BigDecimal.class.getName(), "amount");
        dataEntityTypeToReportColumnTypeMap.put(Float.class.getName(), "amount");
        dataEntityTypeToReportColumnTypeMap.put(Double.class.getName(), "amount");
        dataEntityTypeToReportColumnTypeMap.put(Long.class.getName(), "integer");
        dataEntityTypeToReportColumnTypeMap.put(Short.class.getName(), "integer");
        dataEntityTypeToReportColumnTypeMap.put(Byte.class.getName(), "integer");
        dataEntityTypeToReportColumnTypeMap.put(Boolean.class.getName(), "boolean");
        dataEntityTypeToReportColumnTypeMap.put(java.util.Date.class.getName(), "date");
        dataEntityTypeToReportColumnTypeMap.put(Date.class.getName(), "date");
        reportColumnTypeToDataTypeMap = new HashMap<String, DataType>();
        reportColumnTypeToDataTypeMap.put("text", (DataType)DataType.StringType);
        reportColumnTypeToDataTypeMap.put("integer", (DataType)DataType.BigDecimalType);
        reportColumnTypeToDataTypeMap.put("amount", (DataType)DataType.BigDecimalType);
        reportColumnTypeToDataTypeMap.put("date", (DataType)DataType.DateType);
        reportColumnTypeToDataTypeMap.put("boolean", (DataType)DataType.BooleanType);
        reportColumnTypeToDataTypeMap.put("unit", (DataType)DataType.LongType);
        reportColumnTypeToDataTypeMap.put("decimal", (DataType)DataType.BigDecimalType);
        reportColumnTypeToDataTypeMap.put("basedata", (DataType)DataType.LongType);
        reportColumnTypeToDataTypeMap.put("currency", (DataType)DataType.LongType);
        reportColumnTypeToDataTypeMap.put("user", (DataType)DataType.LongType);
        reportColumnTypeToDataTypeMap.put("qty", (DataType)DataType.BigDecimalType);
    }
}

