/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.util.ArrayList;
import java.util.Set;
import kd.data.disf.model.IDimensionKeys;
import kd.data.disf.model.impl.IDataBaseMutableArrayMap;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.model.impl.IDataMutableArray;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.disf.utils.storage.impl.IDataBaseInnerDimensionKeys;

public class IDataStorageDimKeyMgr<T>
implements IDataJsonArraySerialization {
    private static final long serialVersionUID = -682077280173901371L;
    protected static final IDataBaseInnerDimensionKeys _emptyInnerDimKeys = new IDataBaseInnerDimensionKeys();
    protected static final Integer[] EmptyIntegerArray = new Integer[0];
    protected IDataMutableArray<IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>>> dimKeyToIndexMaps;

    public IDataStorageDimKeyMgr() {
        this.initialization(null);
    }

    public IDataStorageDimKeyMgr(int initialDimCnt) {
        this.initialization(initialDimCnt);
    }

    public String toString() {
        return "IDataStorageDimKeyMgr [dimKeyToIndexMaps=" + this.dimKeyToIndexMaps + "]";
    }

    protected final void initialization(Integer initialDimCnt) {
        this.dimKeyToIndexMaps = initialDimCnt != null ? new IDataMutableArray<IDataBaseMutableArrayMap>(initialDimCnt, IDataBaseMutableArrayMap.class) : new IDataMutableArray<IDataBaseMutableArrayMap>(IDataBaseMutableArrayMap.class);
    }

    protected IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>> createDimMemMap(Class<T> keyClassType) {
        if (keyClassType == null) {
            throw new IllegalArgumentException("Key Class Type Cannot be null!");
        }
        IDataBaseMutableArrayMap<T, IDataMapEntry> result = new IDataBaseMutableArrayMap<T, IDataMapEntry>(IDataMapEntry.class, keyClassType);
        result.setNeedSerializeIndexMap(true);
        result.setNeedSerializKeyFetcher(true);
        return result;
    }

    public Integer[] registerDimKey(int dimIndex, Class<T> keyClassType, T[] dimMemKeys) {
        if (dimMemKeys == null) {
            return EmptyIntegerArray;
        }
        IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>> dimMap = (IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>>)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        if (dimMap == null) {
            if (keyClassType == null) {
                for (T memKey : dimMemKeys) {
                    if (memKey == null) continue;
                    keyClassType = memKey.getClass();
                    break;
                }
            }
            dimMap = this.createDimMemMap(keyClassType);
            this.dimKeyToIndexMaps.setElementValue(dimIndex, dimMap);
        }
        ArrayList<Integer> result = new ArrayList<Integer>(dimMemKeys.length);
        int startCnt = dimMap.getNextStorageValuePosition(false);
        for (T key : dimMemKeys) {
            if (key == null) continue;
            dimMap.addValue(key, new IDataMapEntry<T, Integer>(key, startCnt));
            result.add(startCnt++);
        }
        return result.toArray(new Integer[0]);
    }

    public Integer[] registerDimKey(int dimIndex, T[] dimMemKeys) {
        return this.registerDimKey(dimIndex, null, dimMemKeys);
    }

    public IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>> registerDimKey(int dimIndex, Class<T> keyClassType) {
        IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>> dimMap = (IDataBaseMutableArrayMap<T, IDataMapEntry<T, Integer>>)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        if (dimMap == null) {
            dimMap = this.createDimMemMap(keyClassType);
            this.dimKeyToIndexMaps.setElementValue(dimIndex, dimMap);
        }
        return dimMap;
    }

    public Integer getDimKeyInnerIndex(int dimIndex, T dimMemKey, boolean autoAdd) {
        IDataBaseMutableArrayMap<?, IDataMapEntry<?, Integer>> dimMap = (IDataBaseMutableArrayMap<?, IDataMapEntry<?, Integer>>)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        IDataMapEntry<T, Integer> result = null;
        if (dimMap == null && autoAdd) {
            dimMap = this.createDimMemMap(dimMemKey.getClass());
            this.dimKeyToIndexMaps.add(dimMap);
        }
        if (dimMap != null && (result = (IDataMapEntry)dimMap.get(dimMemKey)) == null && autoAdd) {
            result = new IDataMapEntry<T, Integer>(dimMemKey, dimMap.getNextStorageValuePosition(false));
            dimMap.addValue(dimMemKey, result);
        }
        return result == null ? null : (Integer)result.getValue();
    }

    public Integer getDimKeyInnerIndex(int dimIndex, T dimMemKey) {
        return this.getDimKeyInnerIndex(dimIndex, dimMemKey, false);
    }

    public Set<T> getDimMembers(int dimIndex) {
        IDataBaseMutableArrayMap dimMap = (IDataBaseMutableArrayMap)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        return dimMap != null ? dimMap.getIndexMap().keySet() : null;
    }

    public int getDimMemberCnt(int dimIndex) {
        IDataBaseMutableArrayMap dimMap = (IDataBaseMutableArrayMap)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        return dimMap == null ? 0 : dimMap.size();
    }

    public boolean isDimensionEmpty(int dimIndex) {
        IDataBaseMutableArrayMap dimMap = (IDataBaseMutableArrayMap)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        return dimMap == null ? true : dimMap.isEmpty();
    }

    public IDimensionKeys<Integer, Integer> buildInnerDimensionKeys(IDimensionKeys srcDimKeys, int[] dimGroupIndexs) {
        if (srcDimKeys == null || srcDimKeys.isEmpty()) {
            return _emptyInnerDimKeys;
        }
        int dimCnt = dimGroupIndexs != null ? dimGroupIndexs.length : srcDimKeys.size();
        IDataBaseInnerDimensionKeys resultDimKeys = new IDataBaseInnerDimensionKeys(dimCnt);
        if (dimGroupIndexs == null) {
            for (int i = 0; i < dimCnt; ++i) {
                resultDimKeys.setDimValue(i, this.getDimKeyInnerIndex(i, srcDimKeys.getDimensionKeyByIndex(i), true));
            }
        } else {
            for (int i = 0; i < dimCnt; ++i) {
                int dimPos = dimGroupIndexs[i];
                resultDimKeys.setDimValue(i, this.getDimKeyInnerIndex(dimPos, srcDimKeys.getDimensionKeyByIndex(dimPos), true));
            }
        }
        return resultDimKeys;
    }

    public T getDimMemberByIndex(int dimIndex, int innerIndex) {
        IDataBaseMutableArrayMap dimMap = (IDataBaseMutableArrayMap)this.dimKeyToIndexMaps.getByIndex(dimIndex);
        IDataMapEntry valueEntry = (IDataMapEntry)dimMap.getByIndex(innerIndex);
        return valueEntry == null ? null : (T)valueEntry.getKey();
    }

    @Override
    public Object[] getV() {
        return new Object[]{this.dimKeyToIndexMaps};
    }

    @Override
    public void setV(Object[] v) {
        this.dimKeyToIndexMaps.clear();
        IDataValueUtil.parseFromJSONArray(IDataValueUtil.getJSONArray(v, 0), this.dimKeyToIndexMaps);
    }
}

