/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.data.disf.iterators.impl.ArrayIterator;

public class IDataStringUtil {
    public static final String Default_Delimiter = ",";

    public static String printStackTraceToString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        return sw.getBuffer().toString();
    }

    public static <T> T[] iteratorToArray(Iterator<T> sourceIterator, boolean skipNull) {
        if (sourceIterator == null || !sourceIterator.hasNext()) {
            return null;
        }
        ArrayList<T> resultList = new ArrayList<T>();
        Class<?> clazzBuf = null;
        while (sourceIterator.hasNext()) {
            T buf = sourceIterator.next();
            if (buf == null && skipNull) continue;
            resultList.add(buf);
            if (clazzBuf != null || buf == null) continue;
            clazzBuf = buf.getClass();
        }
        if (clazzBuf != null) {
            return resultList.toArray((Object[])Array.newInstance(clazzBuf, 0));
        }
        return null;
    }

    public static Object[] iteratorToObjecctArray(Iterator<?> sourceIterator, boolean skipNull) {
        if (sourceIterator == null || !sourceIterator.hasNext()) {
            return new Object[0];
        }
        ArrayList resultList = new ArrayList();
        while (sourceIterator.hasNext()) {
            Object buf = sourceIterator.next();
            if (buf == null && skipNull) continue;
            resultList.add(buf);
        }
        return resultList.toArray();
    }

    public static String iteratorToString(Iterator<?> sourceIterator, String delimiter, String defaultValue, boolean skipNullValue) {
        if (sourceIterator == null) {
            return defaultValue;
        }
        StringBuilder builder = new StringBuilder();
        boolean defaultSameAsDelimiter = delimiter.equals(defaultValue);
        boolean lastValueIsDelimiter = false;
        while (sourceIterator.hasNext()) {
            Object val = sourceIterator.next();
            if (val != null) {
                if (builder.length() > 0 && !lastValueIsDelimiter) {
                    builder.append(delimiter);
                }
                builder.append(val);
                lastValueIsDelimiter = false;
                continue;
            }
            if (skipNullValue) continue;
            if (builder.length() > 0 && !defaultSameAsDelimiter) {
                builder.append(delimiter);
            }
            builder.append(defaultValue);
            lastValueIsDelimiter = defaultSameAsDelimiter;
        }
        return builder.toString();
    }

    public static String iteratorToString(Iterator<?> sourceIterator, String delimiter) {
        return IDataStringUtil.iteratorToString(sourceIterator, delimiter, null, true);
    }

    public static String iteratorToString(Iterator<?> sourceIterator) {
        return IDataStringUtil.iteratorToString(sourceIterator, Default_Delimiter, null, true);
    }

    public static String collectionToString(Collection source, String delimiter, String defaultValue, boolean skipNullValue) {
        return source == null ? defaultValue : IDataStringUtil.iteratorToString(source.iterator(), delimiter, defaultValue, skipNullValue);
    }

    public static String collectionToString(Collection source, String delimiter, String defaultValue) {
        return source == null ? defaultValue : IDataStringUtil.iteratorToString(source.iterator(), delimiter, defaultValue, true);
    }

    public static String collectionToString(Collection source, String delimiter) {
        return source == null ? null : IDataStringUtil.iteratorToString(source.iterator(), delimiter, null, true);
    }

    public static String collectionToString(Collection source) {
        return source == null ? null : IDataStringUtil.iteratorToString(source.iterator(), Default_Delimiter, null, true);
    }

    public static String arrayToString(Object[] srcArray, String delimiter, String defaultValue, boolean skipNullValue) {
        return srcArray == null || srcArray.length <= 0 ? defaultValue : IDataStringUtil.iteratorToString(Arrays.asList(srcArray).iterator(), delimiter, defaultValue, skipNullValue);
    }

    public static String arrayToString(Object[] srcArray, String delimiter) {
        return srcArray == null || srcArray.length <= 0 ? null : IDataStringUtil.iteratorToString(Arrays.asList(srcArray).iterator(), delimiter, null, true);
    }

    public static List<String> stringToList(String source) {
        return IDataStringUtil.stringToList(source, true, Default_Delimiter);
    }

    public static String[] stringToArray(String source, boolean skipEmpty, String delimter) {
        return StringUtils.split((String)source, (boolean)skipEmpty, (char[])delimter.toCharArray());
    }

    public static List<String> stringToList(String source, boolean skipEmpty, String delimter) {
        return Arrays.asList(StringUtils.split((String)source, (boolean)skipEmpty, (char[])delimter.toCharArray()));
    }

    public static String buildSQLParamHolders(int cnt) {
        if (cnt <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < cnt; ++i) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append('?');
        }
        return result.toString();
    }

    public static String[] buildSequenceArray(int start, int length, Integer ... skipSeqNos) {
        String[] result = new String[length];
        if (skipSeqNos != null && skipSeqNos.length > 0) {
            Arrays.sort((Object[])skipSeqNos);
            ArrayIterator<Integer> skipSeqNoIterator = new ArrayIterator<Integer>(skipSeqNos);
            Integer currentSkipValue = skipSeqNoIterator.next();
            int i = 0;
            int pos = start;
            while (i < length) {
                if (currentSkipValue != null && pos == currentSkipValue) {
                    currentSkipValue = skipSeqNoIterator.hasNext() ? skipSeqNoIterator.next() : null;
                } else {
                    result[i] = Integer.toString(pos);
                }
                ++i;
                ++pos;
            }
            ArrayList<String> bufList = new ArrayList<String>();
            for (String r : result) {
                if (!StringUtils.isNotEmpty((String)r)) continue;
                bufList.add(r);
            }
            result = bufList.toArray(new String[0]);
        } else {
            int i = 0;
            int pos = start;
            while (i < length) {
                result[i] = Integer.toString(pos);
                ++i;
                ++pos;
            }
        }
        return result;
    }

    public static String getFullSpace(int level) {
        StringBuilder spaceBuilder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            spaceBuilder.append("\u3000\u3000");
        }
        return spaceBuilder.toString();
    }
}

