/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.DataValueTypeEnum;
import kd.data.disf.enums.IByteCodeEnum;
import kd.data.disf.model.IBasePropObject;
import kd.data.disf.model.IJSONArrayToMultableArray;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataAnyValue;
import kd.data.disf.model.impl.IDataBaseModel;
import kd.data.disf.model.impl.IntSizeBitSet;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataJsonUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.IllegalClassException;

public class IDataValueUtil {
    static final SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy.MM.dd"), new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("MM.dd.yyyy"), new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("dd.MM.yyyy")};

    public static int[] convertIntListToArray(Collection<Integer> srcList, int defaultValue) {
        if (srcList == null || srcList.isEmpty()) {
            return new int[0];
        }
        int[] result = new int[srcList.size()];
        int i = 0;
        for (Integer v : srcList) {
            result[i++] = v != null ? v : defaultValue;
        }
        return result;
    }

    public static long[] convertLongListToArray(Collection<Long> srcList, long defaultValue) {
        if (srcList == null || srcList.isEmpty()) {
            return new long[0];
        }
        long[] result = new long[srcList.size()];
        int i = 0;
        for (Long v : srcList) {
            result[i++] = v != null ? v : defaultValue;
        }
        return result;
    }

    public static IDataEntityProperty getDataEntityProperty(DynamicObject sourceDyn, String propertyName) {
        return (IDataEntityProperty)sourceDyn.getDataEntityType().getProperties().get((Object)propertyName);
    }

    public static <T> T getDynPropValue(DynamicObject sourceDyn, String propertyName, Class<T> clazzType) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        if (prop == null) {
            return null;
        }
        return (T)ObjectConverter.convert((Object)prop.getValueFast((Object)sourceDyn), clazzType, (boolean)false);
    }

    public static Object getDynPropValue(DynamicObject sourceDyn, String propertyName) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        return prop == null ? null : prop.getValueFast((Object)sourceDyn);
    }

    public static BasePropModel getBasePropModel(DynamicObject sourceDynamicObject, String propertyName) {
        if (sourceDynamicObject == null) {
            return null;
        }
        DynamicObject dynBuf = IDataValueUtil.getDynPropValue(sourceDynamicObject, propertyName, DynamicObject.class);
        if (dynBuf != null) {
            BasePropModel basePropModel = IDataValueUtil.getClassNewInstance(BasePropModel.class);
            basePropModel.loadFromDynamicObject(dynBuf, true);
            return basePropModel;
        }
        return null;
    }

    public static <T extends IDataBaseModel> T getBasePropObject(DynamicObject sourceDynamicObject, String propertyName, Class<T> targetClass) {
        if (sourceDynamicObject == null) {
            return null;
        }
        DynamicObject dynBuf = IDataValueUtil.getDynPropValue(sourceDynamicObject, propertyName, DynamicObject.class);
        if (dynBuf != null) {
            try {
                IDataBaseModel t = (IDataBaseModel)IDataBeanUtil.getConstructor(targetClass, new Class[0]).newInstance(new Object[0]);
                t.loadFromDynamicObject(sourceDynamicObject);
                return (T)t;
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode(null, ex.getMessage()), new Object[0]);
            }
        }
        return null;
    }

    public static final <T> T getClassNewInstance(Class<T> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode(null, e.getMessage()), new Object[0]);
        }
    }

    public static <T extends IDataBaseModel> List<T> getEntityObjectList(DynamicObject sourceDynamicObject, String entityName, Class<T> targetClass) {
        ArrayList<IDataBaseModel> resultList;
        block9: {
            DynamicObjectCollection dynCollection;
            block8: {
                resultList = new ArrayList<IDataBaseModel>();
                if (sourceDynamicObject == null) {
                    return resultList;
                }
                dynCollection = IDataValueUtil.getDynPropValue(sourceDynamicObject, entityName, DynamicObjectCollection.class);
                if (dynCollection == null && (sourceDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceDynamicObject.getPkValue(), (DynamicObjectType)sourceDynamicObject.getDynamicObjectType())) != null) {
                    dynCollection = IDataValueUtil.getDynPropValue(sourceDynamicObject, entityName, DynamicObjectCollection.class);
                }
                if (dynCollection == null) {
                    return resultList;
                }
                DynamicObjectType subEntryObjType = dynCollection.getDynamicObjectType();
                String[] names = ((IDataBaseModel)IDataValueUtil.getClassNewInstance(targetClass)).getRequiredChildEntryNames();
                boolean needToReload = false;
                if (names != null) {
                    DataEntityPropertyCollection propCol = subEntryObjType.getProperties();
                    for (String string : names) {
                        if (propCol.get((Object)string) != null) continue;
                        needToReload = true;
                        break;
                    }
                }
                if (!needToReload) break block8;
                IDataBaseModel objBuf = (IDataBaseModel)IDataValueUtil.getClassNewInstance(targetClass);
                ArrayList<Object> idList = new ArrayList<Object>(dynCollection.size());
                for (DynamicObject dyn : dynCollection) {
                    idList.add(dyn.getPkValue());
                }
                Map subEntryMaps = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)objBuf.getEntityTypeName());
                if (subEntryMaps.isEmpty()) break block9;
                for (Object e : idList) {
                    DynamicObject dynBuf = (DynamicObject)subEntryMaps.get(e);
                    if (dynBuf == null) continue;
                    objBuf = (IDataBaseModel)IDataValueUtil.getClassNewInstance(targetClass);
                    objBuf.loadFromDynamicObject(dynBuf, false);
                    resultList.add(objBuf);
                }
                break block9;
            }
            for (DynamicObject dynBuf : dynCollection) {
                IDataBaseModel objBuf = (IDataBaseModel)IDataValueUtil.getClassNewInstance(targetClass);
                objBuf.loadFromDynamicObject(dynBuf, false);
                resultList.add(objBuf);
            }
        }
        return resultList;
    }

    public static <T extends IDataBaseModel> T[] getEntityObjectArray(DynamicObject sourceDynamicObject, String entityName, Class<T> targetClass) {
        List<IDataBaseModel> resultList = IDataValueUtil.getEntityObjectList(sourceDynamicObject, entityName, targetClass);
        return resultList.toArray((IDataBaseModel[])Array.newInstance(targetClass, 0));
    }

    public static <T> Class getEntityPropValueDataType(IDataEntityProperty entityProp) {
        Class dataTypeClass = entityProp.getPropertyType();
        return dataTypeClass;
    }

    public static void setEntityPropValue(IDataEntityProperty entityProp, DynamicObject dataEntity, Object newValue) {
        Class dataTypeClass = entityProp.getPropertyType();
        if (Date.class.isAssignableFrom(dataTypeClass)) {
            newValue = IDataValueUtil.getDate(newValue);
        } else if (Boolean.class.isAssignableFrom(dataTypeClass) || Boolean.TYPE.isAssignableFrom(dataTypeClass)) {
            newValue = IDataValueUtil.getBoolean(newValue);
        }
        entityProp.setValueFast((Object)dataEntity, newValue);
    }

    public static Long dumpDateValue(Date srcDate) {
        return srcDate != null ? Long.valueOf(srcDate.getTime()) : null;
    }

    public static Byte getByteCodeEnumCode(IByteCodeEnum<?> val) {
        return val == null ? null : Byte.valueOf(val.getCode());
    }

    public static String getByteCodeEnumCodeString(IByteCodeEnum<?> val) {
        return val == null ? null : val.getCodeString();
    }

    public static JSONObject toJSONObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof JSONObject) {
            return (JSONObject)source;
        }
        throw new IllegalClassException(String.format("Expect JSONObject, but accutal=%s", source.getClass().getName()));
    }

    public static JSONArray toJSONArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            String jsonStr = source.toString();
            if (IDataJsonUtil.isJSonFormat(jsonStr, new String[0])) {
                return IDataValueUtil.toJSONArray(IDataJsonUtil.parseObject(jsonStr, new Feature[0]));
            }
        } else {
            if (source instanceof JSONArray) {
                return (JSONArray)source;
            }
            if (source instanceof JSONObject) {
                return ((JSONObject)source).getJSONArray("v");
            }
        }
        throw new IllegalClassException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
    }

    public static <T> T toBasePropObject(Object source, Class<T> targetClassType) {
        if (source == null) {
            return null;
        }
        if (targetClassType.isAssignableFrom(source.getClass())) {
            return targetClassType.cast(source);
        }
        if (source instanceof JSONArray) {
            return IDataValueUtil.jsonArrayToObject((JSONArray)source, targetClassType);
        }
        if (source instanceof JSONObject) {
            return IDataValueUtil.jsonArrayToObject(((JSONObject)source).getJSONArray("v"), targetClassType);
        }
        throw new IllegalClassException(String.format("Expect JSONObject or JSONArray, but accutal=%s", source.getClass().getName()));
    }

    public static <T> T jsonArrayToObject(JSONArray sourceValue, Class<T> targetClassType) {
        if (sourceValue == null) {
            return null;
        }
        try {
            return IDataBeanUtil.getConstructor(targetClassType, JSONArray.class).newInstance(sourceValue);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode(null, ex.getMessage()), new Object[0]);
        }
    }

    public static <E> void parseArrayMapFromJSONArray(JSONArray jsonArray, IJSONArrayToMultableArray<E> target) {
        if (target != null && jsonArray != null && !jsonArray.isEmpty()) {
            Class<E> elementClassType = target.getElementClassType();
            if (elementClassType == null) {
                throw new IllegalArgumentException(String.format("Missing Element Class Type [%s]!", jsonArray));
            }
            if (IBasePropObject.class.isAssignableFrom(elementClassType)) {
                Constructor<E> constrcutor;
                try {
                    constrcutor = IDataBeanUtil.getConstructor(elementClassType, JSONArray.class);
                }
                catch (IllegalArgumentException e) {
                    throw new KDException((Throwable)e, new ErrorCode(null, String.format("Element Class[%s] not support JSONArray Constructor!", elementClassType)), new Object[0]);
                }
                JSONArray valueBuf = null;
                try {
                    Iterator it = jsonArray.iterator();
                    while (it.hasNext()) {
                        valueBuf = IDataValueUtil.toJSONArray(it.next());
                        if (valueBuf == null) continue;
                        target.cache(constrcutor.newInstance(valueBuf));
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(String.format("Element Class[%s] Parse Object Error! [Source Object=%s]", elementClassType, valueBuf), ex);
                }
            }
            Constructor<E> constrcutor = IDataBeanUtil.getConstructor(elementClassType, String.class);
            if (constrcutor != null) {
                throw new IllegalArgumentException(String.format("Element Class[%s] not support JSONArray Constructor!", elementClassType));
            }
            target.flushCacheToArray();
        }
    }

    public static boolean parseFromJSONArray(JSONArray jsonArray, IDataJsonArraySerialization target) {
        if (target != null && jsonArray != null && !jsonArray.isEmpty()) {
            target.setV(jsonArray.toArray());
            return true;
        }
        return false;
    }

    public static Map<String, IDataAnyValue> parseJsonAnyValueMap(String sourceString) {
        JSONObject jsonObj;
        Object obj;
        HashMap<String, IDataAnyValue> resultMap = new HashMap<String, IDataAnyValue>();
        if (!StringUtils.isEmpty((String)sourceString) && (obj = JSON.parse((String)sourceString)) != null && !(jsonObj = (JSONObject)obj).isEmpty()) {
            for (Map.Entry en : jsonObj.entrySet()) {
                resultMap.put((String)en.getKey(), IDataValueUtil.toBasePropObject(en.getValue(), IDataAnyValue.class));
            }
        }
        return resultMap;
    }

    public static IntSizeBitSet parseIntSizeBitSet(JSONArray jsonArray) {
        return jsonArray == null ? null : IntSizeBitSet.valueOf((Integer[])jsonArray.toArray((Object[])new Integer[0]));
    }

    public static Object getObject(Object[] v, int index) {
        return v == null || index < 0 || index >= v.length ? null : v[index];
    }

    public static BasePropModel getBasePropModel(Object[] objectArray, int index) {
        return IDataValueUtil.getBasePropObject(objectArray, index, BasePropModel.class);
    }

    public static JSONArray getJSONArray(Object[] objectArray, int index) {
        return IDataValueUtil.toJSONArray(objectArray[index]);
    }

    public static JSONObject getJSONObject(Object[] objectArray, int index) {
        return IDataValueUtil.toJSONObject(objectArray[index]);
    }

    public static <T> T getBasePropObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.toBasePropObject(objectArray[index], targetClassType);
    }

    public static <T> T[] getArrayObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.parseArrayObject(objectArray[index], targetClassType);
    }

    public static <T> T[] parseArrayObject(Object sourceObject, Class<T> targetClassType) {
        JSONArray targetJsonArray = IDataValueUtil.toJSONArray(sourceObject);
        return targetJsonArray == null ? null : targetJsonArray.toArray((Object[])Array.newInstance(targetClassType, 0));
    }

    public static <T> T[][] getArraysObject(Object[] objectArray, int index, Class<T> targetClassType) {
        return IDataValueUtil.parseArraysObject(objectArray[index], targetClassType);
    }

    public static <T> T[][] parseArraysObject(Object sourceObject, Class<T> targetClassType) {
        JSONArray targetJsonArray = IDataValueUtil.toJSONArray(sourceObject);
        if (targetJsonArray == null) {
            return null;
        }
        int size = targetJsonArray.size();
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(size);
        Object[] templateClass = (Object[])Array.newInstance(targetClassType, 0);
        for (int i = 0; i < size; ++i) {
            JSONArray subArrayBuf = targetJsonArray.getJSONArray(i);
            if (subArrayBuf == null) continue;
            resultList.add(subArrayBuf.toArray(templateClass));
        }
        return (Object[][])resultList.toArray((T[])((Object[][])Array.newInstance(templateClass.getClass(), 0)));
    }

    public static Map<String, Object> parseMap(JSONObject sourceObject) {
        return sourceObject == null ? new LinkedHashMap<String, Object>(0) : new LinkedHashMap(sourceObject);
    }

    public static Map<String, Object> parseMap(Object[] objectArray, int index) {
        return IDataValueUtil.parseMap(IDataValueUtil.getJSONObject(objectArray, index));
    }

    public static int[] getIntArray(Object[] objectArray, int index) {
        return IDataValueUtil.getIntArray(objectArray[index]);
    }

    public static int[] getIntArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        int[] result = new int[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].intValue();
            }
        }
        return result;
    }

    public static long[] getLongArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        long[] result = new long[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].longValue();
            }
        }
        return result;
    }

    public static Long[] getLongArrayEx(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        Long[] result = new Long[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].longValue();
            }
        }
        return result;
    }

    public static Long[] getLongArrayEx(Object[] v, int index) {
        return IDataValueUtil.getLongArrayEx(v[index]);
    }

    public static long[] getLongArray(Object[] v, int index) {
        return IDataValueUtil.getLongArray(v[index]);
    }

    public static Boolean getBoolean(Object[] v, int index) {
        return IDataValueUtil.getBoolean(IDataValueUtil.getObject(v, index));
    }

    public static Byte getByte(Object[] v, int index) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return Byte.valueOf(value.toString());
    }

    public static String getString(Object[] v, int index, boolean trim) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static String getString(Object[] v, int index) {
        return IDataValueUtil.getString(v, index, false);
    }

    public static String getString(Object value) {
        return IDataValueUtil.getString(value, false);
    }

    public static String getString(Object value, boolean trim) {
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static Date getDate(Object[] v, int index) {
        return IDataValueUtil.getDate(IDataValueUtil.getObject(v, index));
    }

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Date) {
            return (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
        }
        if (value instanceof String) {
            String srcBuf = (String)value;
            if (srcBuf.contains("/") || srcBuf.contains("-") || srcBuf.contains(".")) {
                for (SimpleDateFormat formatter : dateFormats) {
                    try {
                        return formatter.parse(srcBuf);
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                try {
                    return new Date(Long.parseLong((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Integer getInteger(Object[] v, int index) {
        return IDataValueUtil.getInteger(IDataValueUtil.getObject(v, index));
    }

    public static Short getShort(Object[] v, int index) {
        return IDataValueUtil.getShort(IDataValueUtil.getObject(v, index));
    }

    public static Long getLong(Object[] v, int index) {
        return IDataValueUtil.getLong(IDataValueUtil.getObject(v, index));
    }

    public static Double getDouble(Object[] v, int index) {
        return IDataValueUtil.getDouble(IDataValueUtil.getObject(v, index));
    }

    public static Float getFloat(Object[] v, int index) {
        return IDataValueUtil.getFloat(IDataValueUtil.getObject(v, index));
    }

    public static <T> T convertValue(DataValueTypeEnum dataValueType, Object source) {
        DataValueTypeEnum v1 = dataValueType;
        Object v2 = null;
        switch (v1) {
            case Date: {
                v2 = IDataValueUtil.getDate(source);
                break;
            }
            case BaseProp: {
                BasePropModel baseProp = null;
                if (IDataJsonUtil.isJSonFormat(String.valueOf(source), "v") && (baseProp = IDataValueUtil.toBasePropObject(source, BasePropModel.class)) != null) {
                    v2 = baseProp;
                }
                if (baseProp != null) break;
                v2 = Long.valueOf(String.valueOf(source));
                break;
            }
            case Double: {
                v2 = Double.valueOf(String.valueOf(source));
                break;
            }
            case Int: {
                v2 = Integer.valueOf(String.valueOf(source));
                break;
            }
            case String: {
                v2 = String.valueOf(source);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Not Support DataValueType:%s, Object=%s", v1, source.toString()));
            }
        }
        return (T)v2;
    }

    public static Long getLong(Object value) {
        return value == null ? null : (Long)ObjectConverter.convert((Object)value, Long.class, (boolean)false);
    }

    public static Long[] parseObjectArray(Object[] value, Class targetClassType) {
        return value == null ? null : (Long[])ConvertUtils.convert((Object)value, Long[].class);
    }

    public static Double getDouble(Object value) {
        return value == null ? null : (Double)ObjectConverter.convert((Object)value, Double.class, (boolean)false);
    }

    public static Boolean getBoolean(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static BigDecimal getBigDecimal(Object value) {
        return value == null ? null : (BigDecimal)ObjectConverter.convert((Object)value, BigDecimal.class, (boolean)false);
    }

    public static Byte getByte(Object value) {
        return value == null ? null : (Byte)ObjectConverter.convert((Object)value, Byte.class, (boolean)false);
    }

    public static LocaleString getLocaleString(Object value) {
        return value == null ? null : (LocaleString)ObjectConverter.convert((Object)value, LocaleString.class, (boolean)false);
    }

    public static Float getFloat(Object value) {
        return value == null ? null : (Float)ObjectConverter.convert((Object)value, Float.class, (boolean)false);
    }

    public static Short getShort(Object value) {
        return value == null ? null : (Short)ObjectConverter.convert((Object)value, Short.class, (boolean)false);
    }

    public static Integer getInteger(Object value) {
        return value == null ? null : (Integer)ObjectConverter.convert((Object)value, Integer.class, (boolean)false);
    }

    private static Class getIntegerNumberType(String srcValue) {
        BigInteger temp;
        if (srcValue.toUpperCase().contains("E")) {
            return BigDecimal.class;
        }
        if (srcValue.contains(".")) {
            return srcValue.length() > 9 ? BigDecimal.class : Double.class;
        }
        int len = srcValue.length();
        if (len > 19 || (temp = new BigInteger(srcValue)).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || temp.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            return BigInteger.class;
        }
        if (len > 10 || Long.parseLong(srcValue) > Integer.MAX_VALUE || Long.parseLong(srcValue) < Integer.MIN_VALUE) {
            return Long.class;
        }
        if (srcValue.equals(Integer.valueOf(srcValue).toString())) {
            return Integer.class;
        }
        return BigDecimal.class;
    }

    public static Boolean isBooleanValue(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": 
                case "n": 
                case "no": 
                case "f": 
                case "false": 
                case "0": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static Class parseObjectDataType(Object srcObject) {
        if (srcObject == null) {
            return String.class;
        }
        if (srcObject instanceof String) {
            String srcBuf = ((String)srcObject).trim();
            if (srcBuf.length() <= 0) {
                return String.class;
            }
            try {
                srcBuf = srcBuf.replaceAll(",", "");
                if (srcBuf.length() <= 0) {
                    return String.class;
                }
                IDataValueUtil.getBigDecimal(srcBuf);
                String[] vals = srcBuf.split("\\.");
                switch (vals.length) {
                    case 1: {
                        return IDataValueUtil.getIntegerNumberType(vals[0]);
                    }
                    case 2: {
                        Class high = IDataValueUtil.getIntegerNumberType(vals[0]);
                        Class low = IDataValueUtil.getIntegerNumberType("0." + vals[1]);
                        if (BigInteger.class.isAssignableFrom(high) || BigInteger.class.isAssignableFrom(low) || BigDecimal.class.isAssignableFrom(high) || BigDecimal.class.isAssignableFrom(low)) {
                            return BigDecimal.class;
                        }
                        return Double.class;
                    }
                }
                return String.class;
            }
            catch (Exception ex) {
                if (srcBuf.contains("/") || srcBuf.contains("-") || srcBuf.contains(".")) {
                    for (SimpleDateFormat formatter : dateFormats) {
                        try {
                            formatter.parse(srcBuf);
                            return Date.class;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (IDataValueUtil.isBooleanValue(srcBuf).booleanValue()) {
                    return Boolean.class;
                }
                return String.class;
            }
        }
        return srcObject.getClass();
    }

    public static Date getDate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        for (SimpleDateFormat formatter : dateFormats) {
            try {
                return formatter.parse(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static boolean isInRange(Integer srcValue, Integer smallValue, Integer bigValue) {
        return srcValue >= smallValue && srcValue <= bigValue;
    }

    public static DataValueTypeEnum getDataType(IDataEntityProperty fieldProp) {
        if (fieldProp != null) {
            Class propType = fieldProp.getPropertyType();
            if (Number.class.isAssignableFrom(propType)) {
                if (Integer.class.isAssignableFrom(propType) || Long.class.isAssignableFrom(propType) || Short.class.isAssignableFrom(propType) || Byte.class.isAssignableFrom(propType)) {
                    return DataValueTypeEnum.Int;
                }
                return DataValueTypeEnum.Double;
            }
            if (Date.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Date;
            }
            if (Boolean.class.isAssignableFrom(propType) || Boolean.TYPE.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Bool;
            }
            if (DynamicObject.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.BaseProp;
            }
            if (String.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.String;
            }
        }
        return DataValueTypeEnum.String;
    }
}

