/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.orm.query.QFilter;

public class QFilterBuilder
implements Serializable {
    private static final long serialVersionUID = 2607013596458482545L;
    private LinkedList<QFilter> filters = new LinkedList();

    public QFilterBuilder() {
    }

    public QFilterBuilder(String field, String qc, Object val) {
        this.add(new QFilter(field, qc, val));
    }

    public QFilterBuilder add(String field, String qc, Object val) {
        this.add(new QFilter(field, qc, val));
        return this;
    }

    public QFilterBuilder add(List<QFilter> ls) {
        for (QFilter filter : ls) {
            this.add(filter);
        }
        return this;
    }

    public final QFilterBuilder add(QFilter f) {
        if (f != null) {
            this.filters.add(f);
        }
        return this;
    }

    public QFilterBuilder and(QFilter f) {
        if (this.filters.isEmpty()) {
            this.add(f);
        } else if (f != null) {
            this.filters.getLast().and(f);
        }
        return this;
    }

    public QFilterBuilder and(String field, String qc, Object val) {
        return this.and(new QFilter(field, qc, val));
    }

    public QFilterBuilder and(QFilterBuilder qfBuilder) {
        if (this.filters.isEmpty()) {
            this.filters.addAll(qfBuilder.filters);
        } else {
            for (QFilter qFilter : qfBuilder.filters) {
                this.filters.getLast().and(qFilter);
            }
        }
        return this;
    }

    public QFilterBuilder or(QFilter f) {
        if (this.filters.isEmpty()) {
            this.add(f);
        } else if (f != null) {
            this.filters.getLast().or(f);
        }
        return this;
    }

    public QFilterBuilder or(String field, String qc, Object val) {
        return this.or(new QFilter(field, qc, val));
    }

    public QFilterBuilder or(QFilterBuilder qfBuilder) {
        if (this.filters.isEmpty()) {
            this.filters.addAll(qfBuilder.filters);
        } else {
            QFilter lastFilter = this.filters.getLast();
            for (QFilter qFilter : qfBuilder.filters) {
                lastFilter.or(qFilter);
            }
        }
        return this;
    }

    public int size() {
        return this.filters.size();
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public void clear() {
        this.filters.clear();
    }

    public QFilter[] toArray() {
        return this.filters.isEmpty() ? null : this.filters.toArray(new QFilter[0]);
    }

    public LinkedList<QFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(LinkedList<QFilter> filters) {
        this.filters = filters;
    }

    public QFilter buildSingleFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        Iterator filterIterator = this.filters.iterator();
        QFilter filter = (QFilter)filterIterator.next();
        while (filterIterator.hasNext()) {
            QFilter buf = (QFilter)filterIterator.next();
            if (buf == null) continue;
            filter.and(buf);
        }
        return filter;
    }

    public String toFilterString() {
        QFilter filter = this.buildSingleFilter();
        return filter != null ? filter.toString() : null;
    }
}

