/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.ParentChildDimension;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataQingHelper;

public class QingAPITableBuilder
implements Serializable {
    private static final long serialVersionUID = -1285291761407992416L;
    private static final Log logger = LogFactory.getLog(QingAPITableBuilder.class);
    private static final String[][] HierarchyField_Suffix = new String[][]{{"_id", "_ID"}, {"_parentId", "_\u7236ID"}, {"_displayName", "_\u540d\u79f0"}};
    private Map<String, EntryEntity> entryEntityMap;
    private Map<String, Field> qingFieldMap = new LinkedHashMap<String, Field>();
    private Map<String, ParentChildDimensionEx> parentChildDimensionMap;
    private List<String> entityPKFieldKeys;
    private List<String> dimFieldKeys = new LinkedList<String>();
    private Map<String, Set<String>> groupDimFieldKeys;
    private List<String> measureFieldKeys = new LinkedList<String>();
    private List<String> actualQueryFieldKeys;
    private boolean hideDimGroupChild = false;

    public String toString() {
        return "QingAPITableBuilder{entryEntityMap=" + this.entryEntityMap + ", qingFieldMap=" + this.qingFieldMap + ", parentChildDimensionMap=" + this.parentChildDimensionMap + ", entityPKFieldKeys=" + this.entityPKFieldKeys + ", dimFieldKeys=" + this.dimFieldKeys + ", groupDimFieldKeys=" + this.groupDimFieldKeys + ", measureFieldKeys=" + this.measureFieldKeys + ", actualQueryFieldKeys=" + this.actualQueryFieldKeys + ", hideDimGroupChild=" + this.hideDimGroupChild + '}';
    }

    public QingMeta buildQingMeta() {
        this.validate();
        QingMeta qingMeta = new QingMeta();
        for (Field field : this.getAllFieldsOrderBy()) {
            if (field == null) continue;
            qingMeta.addColumn(field);
        }
        if (this.entryEntityMap != null && !this.entryEntityMap.isEmpty()) {
            for (EntryEntity en : this.entryEntityMap.values()) {
                qingMeta.addEntryEntity(en);
            }
        }
        if (this.parentChildDimensionMap != null && !this.parentChildDimensionMap.isEmpty()) {
            for (ParentChildDimensionEx dimLink : this.parentChildDimensionMap.values()) {
                qingMeta.addParentChildDimension(dimLink.toParentChildDimension());
            }
        }
        return qingMeta;
    }

    public Map<String, Integer> buildIndexMap() {
        List<Field> fieldList = this.getAllFields();
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(fieldList.size());
        int i = 0;
        for (Field f : fieldList) {
            resultMap.put(f.getKey(), i++);
        }
        return resultMap;
    }

    protected Field getQingField(String fieldKey) {
        Field field = this.qingFieldMap.get(fieldKey);
        if (field == null) {
            throw new KDBizException("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7684QingField: Key=" + fieldKey);
        }
        return field;
    }

    protected Field deleteQingField(String fieldKey) {
        return this.qingFieldMap.remove(fieldKey);
    }

    public Field addTableField(Field field) {
        return this.addTableField(field, Boolean.FALSE);
    }

    public Field addTableField(Field field, Boolean asMeasure) {
        if (field == null) {
            return null;
        }
        this.qingFieldMap.put(field.getKey(), field);
        if (asMeasure != null) {
            if (asMeasure.booleanValue()) {
                this.measureFieldKeys.add(field.getKey());
            } else {
                this.dimFieldKeys.add(field.getKey());
            }
        }
        return field;
    }

    public Field addTableField(String key, String displayName, QingFieldType qingFieldType, Boolean asMeasure, String entityName, boolean hideField) {
        return this.addTableField(IDataQingHelper.createFieldObj(key, displayName, qingFieldType, entityName, hideField), asMeasure);
    }

    public Field addTableField(String key, String displayName, QingFieldType qingFieldType, Boolean asMeasure) {
        return this.addTableField(key, displayName, qingFieldType, asMeasure, null, false);
    }

    public Field addTableField(IDataEntityProperty entityProp, Boolean asMeasure) {
        if (entityProp == null || entityProp.getDisplayName() == null) {
            return null;
        }
        return this.addTableField(entityProp.getName(), entityProp.getDisplayName().toString(), IDataQingHelper.getQingFieldType(entityProp), asMeasure);
    }

    public EntryEntity addEntryEntity(String key, String displayName, String pkFieldName) {
        return this.addEntryEntity(key, displayName, pkFieldName, null);
    }

    public EntryEntity addEntryEntity(String key, String displayName, String pkFieldName, String parentKey) {
        EntryEntity entity = new EntryEntity();
        entity.setKey(key);
        entity.setParentKey(parentKey);
        entity.setName(new LocaleString(displayName));
        entity.setPkFieldName(pkFieldName);
        if (this.entryEntityMap == null) {
            this.entryEntityMap = new LinkedHashMap<String, EntryEntity>(2);
        }
        if (this.entityPKFieldKeys == null) {
            this.entityPKFieldKeys = new LinkedList<String>();
        }
        this.entryEntityMap.put(key, entity);
        this.entityPKFieldKeys.add(pkFieldName);
        return entity;
    }

    public EntryEntity getEntryEntity(String key) {
        return this.entryEntityMap.get(key);
    }

    public EntryEntity deleteEntryEntity(String key) {
        return this.entryEntityMap.remove(key);
    }

    public ParentChildDimensionEx addQingHierarchyField(IDataEntityProperty prop, ParentChildDimension.Necessary hierarchyNecessary) {
        String fieldName = prop.getName();
        String displayName = prop.getDisplayName().toString();
        String[] result = new String[HierarchyField_Suffix.length];
        int i = 0;
        for (String[] suffix : HierarchyField_Suffix) {
            result[i] = this.addTableField(fieldName + suffix[0], displayName + suffix[1], i > 1 ? QingFieldType.String : QingFieldType.Int, false).getKey();
            ++i;
        }
        return this.addParentChildDimension(fieldName, displayName, result[0], result[1], result[2], result[2], hierarchyNecessary != null ? hierarchyNecessary : ParentChildDimension.Necessary.RootRepresented);
    }

    public ParentChildDimensionEx addQingHierarchyField(IDataEntityProperty prop) {
        return this.addQingHierarchyField(prop, null);
    }

    public ParentChildDimensionEx addQingHierarchyField(Field qingField, ParentChildDimension.Necessary hierarchyNecessary) {
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("\u5c42\u7ea7\u5b57\u6bb5").append(qingField.getKey()).append("  ---  ").append(qingField.getName());
            logger.info(logMsg.toString());
        }
        String fieldName = qingField.getKey();
        String displayName = qingField.getName().toString();
        String[] result = new String[HierarchyField_Suffix.length];
        int i = 0;
        for (String[] suffix : HierarchyField_Suffix) {
            result[i] = this.addTableField(fieldName + suffix[0], displayName + suffix[1], i > 1 ? QingFieldType.String : QingFieldType.Int, false, qingField.getEntity(), false).getKey();
            ++i;
        }
        return this.addParentChildDimension(fieldName, displayName, result[0], result[1], result[2], result[2], hierarchyNecessary != null ? hierarchyNecessary : ParentChildDimension.Necessary.RootRepresented);
    }

    public ParentChildDimensionEx addQingHierarchyField(Field qingField) {
        return this.addQingHierarchyField(qingField, null);
    }

    public ParentChildDimensionEx addParentChildDimension(String key, String displayName, String idFieldKey, String parentIdFieldKey, String defaultDisplayNameKey, String sortAccordingFieldKey, ParentChildDimension.Necessary necessary) {
        if (this.parentChildDimensionMap == null) {
            this.parentChildDimensionMap = new LinkedHashMap<String, ParentChildDimensionEx>(10);
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new KDBizException((Throwable)new IllegalArgumentException(), new ErrorCode("", "key\u4e3a null"), new Object[0]);
        }
        Field idField = this.getQingField(idFieldKey);
        if (idField == null) {
            throw new KDBizException((Throwable)new IllegalArgumentException(), new ErrorCode("", String.format("%s\u5bf9\u5e94\u7684idField\u4e3a null", key)), new Object[0]);
        }
        Field parentField = this.getQingField(parentIdFieldKey);
        if (parentField == null) {
            throw new KDBizException((Throwable)new IllegalArgumentException(), new ErrorCode("", String.format("%s\u5bf9\u5e94\u7684parentField\u4e3a null", key)), new Object[0]);
        }
        LinkedHashSet<String> dimFieldKeyList = new LinkedHashSet<String>();
        ParentChildDimensionEx dimLink = new ParentChildDimensionEx(key, displayName, idField, parentField);
        dimFieldKeyList.add(idFieldKey);
        dimFieldKeyList.add(parentIdFieldKey);
        if (StringUtils.isNotEmpty((String)defaultDisplayNameKey)) {
            dimLink.setDefaultDisplayName(this.getQingField(defaultDisplayNameKey));
            dimFieldKeyList.add(defaultDisplayNameKey);
        } else {
            dimLink.setDefaultDisplayName(this.getQingField(idFieldKey));
        }
        if (StringUtils.isNotEmpty((String)sortAccordingFieldKey)) {
            dimLink.setSortAccording(this.getQingField(sortAccordingFieldKey));
            dimFieldKeyList.add(sortAccordingFieldKey);
        } else {
            dimLink.setSortAccording(this.getQingField(idFieldKey));
        }
        dimLink.setNecessary(necessary);
        this.parentChildDimensionMap.put(key, dimLink);
        if (this.groupDimFieldKeys == null) {
            this.groupDimFieldKeys = new LinkedHashMap<String, Set<String>>();
        }
        this.groupDimFieldKeys.put(key, dimFieldKeyList);
        return dimLink;
    }

    public ParentChildDimensionEx addParentChildDimension(String key, String displayName, String idFieldKey, String parentIdFieldKey, ParentChildDimension.Necessary necessary) {
        return this.addParentChildDimension(key, displayName, idFieldKey, parentIdFieldKey, null, null, necessary);
    }

    protected List<Field> getAllFields() {
        LinkedList<Field> result = new LinkedList<Field>();
        if (this.entityPKFieldKeys != null) {
            result.addAll(this.getFieldList(this.entityPKFieldKeys));
        }
        result.addAll(this.getDimFields());
        result.addAll(this.getMeasureFields());
        return result;
    }

    protected List<Field> getAllFieldsOrderBy() {
        LinkedList<Field> result = new LinkedList<Field>();
        if (this.entityPKFieldKeys != null) {
            result.addAll(this.getFieldList(this.entityPKFieldKeys));
        }
        result.addAll(this.qingFieldMap.values());
        return result;
    }

    protected List<Field> getFieldList(Collection<String> fieldKeys) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        for (String key : fieldKeys) {
            fieldList.add(this.qingFieldMap.get(key));
        }
        return fieldList;
    }

    public List<Field> getGroupDimFields() {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (this.groupDimFieldKeys == null || this.groupDimFieldKeys.isEmpty()) {
            return fields;
        }
        for (Map.Entry<String, Set<String>> en : this.groupDimFieldKeys.entrySet()) {
            fields.addAll(this.getFieldList((Collection<String>)en.getValue()));
        }
        fields.forEach(f -> f.setHide(this.hideDimGroupChild));
        return fields;
    }

    public List<Field> getDimFields() {
        return this.getFieldList(this.dimFieldKeys);
    }

    public List<Field> getMeasureFields() {
        return this.getFieldList(this.measureFieldKeys);
    }

    protected void validateEntryEntity(EntryEntity entryEntity) {
        if (entryEntity == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)entryEntity.getParentKey()) && !this.entryEntityMap.containsKey(entryEntity.getParentKey())) {
            throw new KDBizException(String.format("\u5b9a\u4e49\u7684EntryEntity\u4e2d\u5f15\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u7236EntryEntity: Key=%s; EntryEntity=[%s, %s]", entryEntity.getParentKey(), entryEntity.getKey(), entryEntity.getName()));
        }
        if (!this.qingFieldMap.containsKey(entryEntity.getPkFieldName())) {
            throw new KDBizException(String.format("\u5b9a\u4e49\u7684EntryEntity\u4e2d\u5f15\u7528\u4e86\u4e0d\u5b58\u5728\u7684PKQingField\u5b57\u6bb5: Key=%s; EntryEntity=[%s, %s]", entryEntity.getPkFieldName(), entryEntity.getKey(), entryEntity.getName()));
        }
    }

    protected void validateQingFieldEntryEntity() {
        if (this.entryEntityMap == null || this.entryEntityMap.isEmpty()) {
            return;
        }
        HashSet<String> checkFieldKeyList = new HashSet<String>();
        if (this.dimFieldKeys != null && !this.dimFieldKeys.isEmpty()) {
            checkFieldKeyList.addAll(this.dimFieldKeys);
        }
        if (this.measureFieldKeys != null && !this.measureFieldKeys.isEmpty()) {
            checkFieldKeyList.addAll(this.measureFieldKeys);
        }
        if (this.parentChildDimensionMap != null && !this.parentChildDimensionMap.isEmpty()) {
            for (ParentChildDimensionEx dimLink : this.parentChildDimensionMap.values()) {
                checkFieldKeyList.add(dimLink.getId().getKey());
                checkFieldKeyList.add(dimLink.getParentId().getKey());
                checkFieldKeyList.add(dimLink.getDefaultDisplayName().getKey());
                checkFieldKeyList.add(dimLink.getSortAccording().getKey());
            }
        }
        int errorCnt = 0;
        StringBuilder errorMsg = new StringBuilder();
        for (String fieldKey : checkFieldKeyList) {
            Field field = this.qingFieldMap.get(fieldKey);
            if (field == null) {
                errorMsg.append(String.format("%s). [Key=%s]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684QingField\u5b9a\u4e49%n", errorCnt + 1, fieldKey));
                ++errorCnt;
                continue;
            }
            String entityKey = field.getEntity();
            if (!StringUtils.isEmpty((String)entityKey) && this.entryEntityMap.containsKey(entityKey)) continue;
            errorMsg.append(String.format("%s). QingField[Key=%s, Name=%s]\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5f52\u5c5e\u7684\u5b9e\u4f53\u5bf9\u8c61[%s] %n", errorCnt + 1, field.getKey(), field.getName(), entityKey));
            ++errorCnt;
        }
        if (errorCnt > 0) {
            throw new KDBizException(String.format("\u9a8c\u8bc1QingField\u4e0eEntryEntity\u7684\u5173\u7cfb\u53d1\u73b0\u5f02\u5e38: %s", errorMsg.toString()));
        }
    }

    protected void validateParentChildDimension(ParentChildDimension dimLink) {
        if (dimLink == null) {
            return;
        }
        if (!(this.qingFieldMap.containsKey(dimLink.getId().getKey()) && this.qingFieldMap.containsKey(dimLink.getParentId().getKey()) && this.qingFieldMap.containsKey(dimLink.getDefaultDisplayName().getKey()) && this.qingFieldMap.containsKey(dimLink.getSortAccording().getKey()))) {
            throw new KDBizException(String.format("\u5b9a\u4e49\u7684ParentChildDimension\u4e2d\u5f15\u7528\u4e86\u4e0d\u5b58\u5728\u7684QingField\u5b57\u6bb5: [Name=%s, Alias=%s, Id=%s, ParentId=%s, DisplayName=%s, Sort=%s]", dimLink.getName(), dimLink.getAlias(), dimLink.getId().getKey(), dimLink.getParentId().getKey(), dimLink.getDefaultDisplayName() != null ? dimLink.getDefaultDisplayName().getKey() : null, dimLink.getSortAccording().getKey()));
        }
    }

    public void validate() {
        if (!this.qingFieldMap.keySet().containsAll(this.dimFieldKeys)) {
            throw new KDBizException(String.format("\u5b9a\u4e49\u7684\u7ef4\u5ea6\u5b57\u6bb5\u4e2d\u5b58\u5728\u4e0d\u5b58\u5728\u7684QingField: \u7ef4\u5ea6\u5b57\u6bb5=%s, QingFields=%s", this.dimFieldKeys, this.qingFieldMap.keySet()));
        }
        if (!this.qingFieldMap.keySet().containsAll(this.measureFieldKeys)) {
            throw new KDBizException(String.format("\u5b9a\u4e49\u7684\u5ea6\u91cf\u5b57\u6bb5\u4e2d\u5b58\u5728\u4e0d\u5b58\u5728\u7684QingField: \u5ea6\u91cf\u5b57\u6bb5=%s, QingFields=%s", this.dimFieldKeys, this.qingFieldMap.keySet()));
        }
        if (this.entryEntityMap != null && !this.entryEntityMap.isEmpty()) {
            for (EntryEntity en : this.entryEntityMap.values()) {
                this.validateEntryEntity(en);
            }
            this.validateQingFieldEntryEntity();
        }
        if (this.parentChildDimensionMap != null && !this.parentChildDimensionMap.isEmpty()) {
            for (ParentChildDimensionEx dimLink : this.parentChildDimensionMap.values()) {
                this.validateParentChildDimension(dimLink.toParentChildDimension());
            }
        }
    }

    protected QingAPITableBuilder addFieldList(List<Field> fieldList, Boolean asMeasure) {
        if (fieldList == null || fieldList.isEmpty()) {
            return this;
        }
        for (Field f : fieldList) {
            if (f == null) continue;
            this.addTableField(f, asMeasure);
        }
        return this;
    }

    public QingAPITableBuilder setDimFields(List<Field> dimFields) {
        return this.addFieldList(dimFields, Boolean.FALSE);
    }

    public QingAPITableBuilder setMeasureFields(List<Field> measureFields) {
        return this.addFieldList(measureFields, Boolean.TRUE);
    }

    public Map<String, EntryEntity> getEntryEntityMap() {
        return this.entryEntityMap;
    }

    public void setEntryEntityMap(Map<String, EntryEntity> entryEntityMap) {
        this.entryEntityMap = entryEntityMap;
    }

    public Map<String, Field> getQingFieldMap() {
        return this.qingFieldMap;
    }

    public void setQingFieldMap(Map<String, Field> qingFieldMap) {
        this.qingFieldMap = qingFieldMap;
    }

    public Map<String, ParentChildDimensionEx> getParentChildDimensionMap() {
        return this.parentChildDimensionMap;
    }

    public void setParentChildDimensionMap(Map<String, ParentChildDimensionEx> parentChildDimensionMap) {
        this.parentChildDimensionMap = parentChildDimensionMap;
    }

    public List<String> getDimFieldKeys() {
        return this.dimFieldKeys;
    }

    public void setDimFieldKeys(List<String> dimFieldKeys) {
        this.dimFieldKeys = dimFieldKeys;
    }

    public List<String> getMeasureFieldKeys() {
        return this.measureFieldKeys;
    }

    public void setMeasureFieldKeys(List<String> measureFieldKeys) {
        this.measureFieldKeys = measureFieldKeys;
    }

    public List<String> getEntityPKFieldKeys() {
        return this.entityPKFieldKeys;
    }

    public void setEntityPKFieldKeys(List<String> entityPKFieldKeys) {
        this.entityPKFieldKeys = entityPKFieldKeys;
    }

    public Map<String, Set<String>> getGroupDimFieldKeys() {
        return this.groupDimFieldKeys;
    }

    public void setGroupDimFieldKeys(Map<String, Set<String>> groupDimFieldKeys) {
        this.groupDimFieldKeys = groupDimFieldKeys;
    }

    public boolean isHideDimGroupChild() {
        return this.hideDimGroupChild;
    }

    public void setHideDimGroupChild(boolean hideDimGroupChild) {
        this.hideDimGroupChild = hideDimGroupChild;
    }

    public List<String> getActualQueryFieldKeys() {
        return this.actualQueryFieldKeys;
    }

    public void setActualQueryFieldKeys(List<String> actualQueryFieldKeys) {
        this.actualQueryFieldKeys = actualQueryFieldKeys;
    }

    public static class ParentChildDimensionEx
    implements Serializable {
        private String name;
        private String alias;
        private Field id;
        private Field parentId;
        private Field defaultDisplayName;
        private Field sortAccording;
        private ParentChildDimension.Necessary necessary;

        public ParentChildDimensionEx() {
        }

        public ParentChildDimensionEx(String name, Field id, Field parentId) {
            if (id == null) {
                throw new KDBizException("Self ID Field is Null!");
            }
            if (parentId == null) {
                throw new KDBizException("Parent ID Field is Null!");
            }
            if (StringUtils.isEmpty((String)name)) {
                throw new KDBizException("ParentChildDimension Name is Empty!");
            }
            this.name = name;
            this.id = id;
            this.parentId = parentId;
        }

        public ParentChildDimensionEx(String name, String alias, Field id, Field parentId) {
            this(name, id, parentId);
            this.alias = alias;
        }

        public ParentChildDimension toParentChildDimension() {
            ParentChildDimension parentChildDimension = new ParentChildDimension(this.name, this.alias, this.id, this.parentId);
            if (this.defaultDisplayName != null) {
                parentChildDimension.setDefaultDisplayName(this.defaultDisplayName);
            }
            if (this.sortAccording != null) {
                parentChildDimension.setSortAccording(this.sortAccording);
            }
            if (this.necessary != null) {
                parentChildDimension.setNecessary(this.necessary);
            }
            return parentChildDimension;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Field getId() {
            return this.id;
        }

        public void setId(Field id) {
            this.id = id;
        }

        public Field getParentId() {
            return this.parentId;
        }

        public void setParentId(Field parentId) {
            this.parentId = parentId;
        }

        public Field getDefaultDisplayName() {
            return this.defaultDisplayName;
        }

        public void setDefaultDisplayName(Field defaultDisplayName) {
            this.defaultDisplayName = defaultDisplayName;
        }

        public Field getSortAccording() {
            return this.sortAccording;
        }

        public void setSortAccording(Field sortAccording) {
            this.sortAccording = sortAccording;
        }

        public ParentChildDimension.Necessary getNecessary() {
            return this.necessary;
        }

        public void setNecessary(ParentChildDimension.Necessary necessary) {
            this.necessary = necessary;
        }
    }
}

