/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipStreamHelper {
    private ZipStreamHelper() {
    }

    private static boolean notEmpty(String source) {
        return source != null && !"".equals(source.trim());
    }

    public static long compressInputStream(InputStream srcInputStream, ZipOutputStream zipOutputStream, String newEntryName, boolean autoCloseEntry, byte[] readBuffer) throws IOException {
        int length;
        if (srcInputStream == null || zipOutputStream == null) {
            return -1L;
        }
        if (ZipStreamHelper.notEmpty(newEntryName)) {
            zipOutputStream.putNextEntry(new ZipEntry(newEntryName));
        }
        if (readBuffer == null) {
            readBuffer = new byte[4096];
        }
        long totalLength = 0L;
        while ((length = srcInputStream.read(readBuffer)) > 0) {
            zipOutputStream.write(readBuffer, 0, length);
            totalLength += (long)length;
        }
        if (autoCloseEntry) {
            zipOutputStream.closeEntry();
        }
        return totalLength;
    }
}

