/*
 * Decompiled with CFR 0.152.
 */
package kd.data.driver.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.data.disf.model.impl.IDataMapEntry;

public interface IDataProcessor<T> {
    public T process(Object ... var1);

    public void setDataOutputProcessor(IDataProcessor var1);

    public Class[] getInputParamTypes();

    public String[] getInputParamNames();

    public Class<T> getOutputDataType();

    default public List<Map.Entry<String, Class>> getInputParams() {
        Class[] classTypes = this.getInputParamTypes();
        String[] names = this.getInputParamNames();
        if (classTypes == null || names == null) {
            return Collections.emptyList();
        }
        if (classTypes.length == names.length) {
            throw new IllegalArgumentException(String.format("Input Parameter Name[%s] and Class Type[%s] Count is not matched!", names.length, classTypes.length));
        }
        LinkedList<Map.Entry<String, Class>> resultList = new LinkedList<Map.Entry<String, Class>>();
        for (int i = 0; i < classTypes.length; ++i) {
            resultList.add(new IDataMapEntry<String, Class>(names[i], classTypes[i]));
        }
        return resultList;
    }

    default public Map<String, Object> getInputParamTemplateMap() {
        String[] names = this.getInputParamNames();
        if (names == null || names.length <= 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(names.length);
        for (String n : names) {
            resultMap.put(n, null);
        }
        return resultMap;
    }

    default public int validateInputParamType(Class ... paramClassTypes) {
        Class[] requiredInputs = this.getInputParamTypes();
        if (paramClassTypes == null || paramClassTypes.length < requiredInputs.length) {
            return paramClassTypes == null ? 0 : paramClassTypes.length + 1;
        }
        for (int i = 0; i < requiredInputs.length; ++i) {
            if (requiredInputs[i].isAssignableFrom(paramClassTypes[i])) continue;
            return i + 1;
        }
        return -1;
    }

    default public int validateInputParams(boolean throwException, Object ... params) {
        Class[] requiredInputs = this.getInputParamTypes();
        if (params == null || params.length < requiredInputs.length) {
            return params == null ? 0 : params.length + 1;
        }
        int errorIdx = -1;
        for (int i = 0; i < params.length; ++i) {
            if ((params[i] != null || !requiredInputs[i].isPrimitive()) && (params[i] == null || requiredInputs[i].isAssignableFrom(params[i].getClass()))) continue;
            errorIdx = i + 1;
            break;
        }
        if (errorIdx >= 0 && throwException) {
            throw new IllegalArgumentException(String.format("Invalid Param Type on param[%s]. Params=%s", errorIdx, Arrays.deepToString(params)));
        }
        return errorIdx;
    }

    default public Object updateProcessor(Object ... params) {
        return Boolean.TRUE;
    }
}

