/*
 * Decompiled with CFR 0.152.
 */
package kd.data.driver.datasource.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.DataValueTypeEnum;
import kd.data.disf.enums.DimensionTypeEnum;
import kd.data.disf.model.impl.BasePropModel;

public class BaseInfoField
extends BasePropModel {
    private static final long serialVersionUID = -1258800493136920389L;
    @JSONField(serialize=false)
    @JsonIgnore
    protected DataValueTypeEnum dataType;
    @JSONField(serialize=false)
    @JsonIgnore
    protected DimensionTypeEnum dimType;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String defaultValue;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String defaultDisplayValue;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String srcNum;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String srcEntry;
    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean customizedField;

    public BaseInfoField() {
    }

    public BaseInfoField(JSONArray jsonObject) {
        super(jsonObject);
    }

    @Override
    public Object[] elementKey() {
        return this.getFieldIndexKeys();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 7;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int idx = super.getArraySize();
        targetArray[idx++] = this.getByteCodeEnumCode(this.dataType);
        targetArray[idx++] = this.getByteCodeEnumCode(this.dimType);
        targetArray[idx++] = this.defaultValue;
        targetArray[idx++] = this.defaultDisplayValue;
        targetArray[idx++] = this.srcNum;
        targetArray[idx++] = this.srcEntry;
        targetArray[idx] = this.customizedField;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int idx = super.getArraySize();
        this.dataType = DataValueTypeEnum.getEnum(this.getByte(v, idx++));
        this.dimType = DimensionTypeEnum.getEnum(this.getByte(v, idx++));
        this.defaultValue = this.getString(v, idx++);
        this.defaultDisplayValue = this.getString(v, idx++);
        this.srcNum = this.getString(v, idx++);
        this.srcEntry = this.getString(v, idx++);
        this.customizedField = this.getBoolean(v, idx);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String[] getFieldIndexKeys() {
        if (StringUtils.isEmpty((String)this.getNumber())) {
            return new String[]{this.getSrcFieldFullName()};
        }
        return new String[]{this.getFieldAliasFullName(), this.getSrcFieldFullName()};
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getFieldFullName() {
        if (this.getNumber() == null) {
            return this.getFieldAliasFullName();
        }
        return this.getSrcFieldFullName();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getFieldAliasFullName() {
        return StringUtils.isNotEmpty((String)this.srcEntry) ? this.srcEntry + "." + this.getNumber() : this.getNumber();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getSrcFieldFullName() {
        return StringUtils.isNotEmpty((String)this.srcEntry) ? this.srcEntry + "." + this.srcNum : this.srcNum;
    }

    public String[] getQueryFieldNames(String[] basePropAppendFieldNames) {
        String[] result;
        String srcFieldFullName = this.getSrcFieldFullName();
        if (basePropAppendFieldNames == null || basePropAppendFieldNames.length <= 0) {
            result = new String[]{srcFieldFullName};
        } else {
            int totalLength = basePropAppendFieldNames.length;
            result = new String[totalLength];
            for (int i = 0; i < totalLength; ++i) {
                result[i] = srcFieldFullName + "." + basePropAppendFieldNames[i];
            }
        }
        return result;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasAliaseNumber() {
        return this.getNumber() != null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean hasAliaseName() {
        return this.getName() != null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getSrcNum() {
        return this.srcNum;
    }

    public void setSrcNum(String srcNum) {
        this.srcNum = srcNum;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getSrcEntry() {
        return this.srcEntry;
    }

    public void setSrcEntry(String srcEntry) {
        this.srcEntry = srcEntry;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public DataValueTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataValueTypeEnum dataType) {
        this.dataType = dataType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isCustomizedField() {
        return this.customizedField;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getDefaultDisplayValue() {
        return this.defaultDisplayValue;
    }

    public void setDefaultDisplayValue(String defaultDisplayValue) {
        this.defaultDisplayValue = defaultDisplayValue;
    }

    public void setCustomizedField(boolean customizedField) {
        this.customizedField = customizedField;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public DimensionTypeEnum getDimType() {
        return this.dimType;
    }

    public void setDimType(DimensionTypeEnum dimType) {
        this.dimType = dimType;
    }
}

