/*
 * Decompiled with CFR 0.152.
 */
package kd.data.driver.datasource.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import kd.data.driver.datasource.common.IColumnValueConverter;
import kd.data.driver.datasource.common.IDataQueryResultSet;
import kd.data.driver.datasource.common.IDimFieldConverterQueryInfo;
import kd.data.driver.datasource.common.IQueryRequesterInfo;

public interface IDataSourceDriver {
    public String getDriverKey();

    public String getDriverVersion();

    public Class getMethodReturnType(String var1, Object ... var2);

    public boolean supportMethod(String var1, Object ... var2);

    public boolean supportFunction(DataSourceDriverCommonFunc var1, Object ... var2);

    public Object getParamValue(String var1, Object ... var2);

    public Collection<Object> getSrcFields(String var1, Object ... var2);

    public Object getFieldValues(Collection<Object> var1, Object ... var2);

    default public Object getFieldValues(Object fieldModel, Object ... queryParamValues) {
        return this.getFieldValues(Collections.singletonList(fieldModel), queryParamValues);
    }

    public <DIM_NUMBER extends Serializable, DIM_MEM_ID extends Serializable> IColumnValueConverter<DIM_NUMBER, Object[][]> getColumnValueConverter(IDimFieldConverterQueryInfo<DIM_NUMBER, DIM_MEM_ID> var1);

    default public <R> R queryDataValues(IQueryRequesterInfo queryParams, BiFunction<IDataQueryResultSet, IQueryRequesterInfo, R> queryDataConsumer) {
        IDataQueryResultSet queryResultSet = this.queryDataValues(queryParams);
        if (queryResultSet != null && queryResultSet.hasNext()) {
            return queryDataConsumer.apply(queryResultSet, queryParams);
        }
        return null;
    }

    public IDataQueryResultSet queryDataValues(IQueryRequesterInfo var1);

    public static enum DataSourceDriverCommonFunc {
        FUN_Preview_Data(0),
        FUN_Custom_Data_Filter(1),
        FUN_SupportHierarchy(3);

        int code;

        private DataSourceDriverCommonFunc(int code) {
            this.code = code;
        }
    }
}

