/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.formplugin.util.FSAMemberF7Util;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;

public class FSABatchCreateParamFormPlugin
extends AbstractFormPlugin {
    private static final String PAGE_CACHE_RETURN_DATA = "pageCacheReturnData";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", "selectmember"});
    }

    public void afterCreateNewData(EventObject e) {
        Map paramMap;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter parameter = view.getFormShowParameter();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String id = (String)parameter.getCustomParam("syncparam_id");
        try {
            Date startTime = sdf.parse((String)parameter.getCustomParam("starttime"));
            String endTimeStr = (String)parameter.getCustomParam("endtime");
            if (StringUtils.isNotEmpty((String)endTimeStr)) {
                Date endTime = sdf.parse(endTimeStr);
                model.setValue("endtime", (Object)endTime);
            }
            model.setValue("starttime", (Object)startTime);
        }
        catch (Exception startTime) {
            // empty catch block
        }
        String repeatMode = (String)parameter.getCustomParam("repeatmode");
        Integer cycleNum = (Integer)parameter.getCustomParam("cyclenum");
        String paramJson = (String)parameter.getCustomParam("batchparamjson_tag");
        if (StringUtils.isNotEmpty((String)paramJson)) {
            paramMap = (Map)JSON.parseObject((String)paramJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            model.setValue("dateoffset", paramMap.get("dateoffset"));
        } else {
            paramMap = new HashMap(0);
            if ("q".equals(repeatMode)) {
                model.setValue("dateoffset", (Object)-1);
            }
        }
        DynamicObject syncParamDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id), (String)"fsa_syncparam");
        DynamicObjectCollection dimEntryCol = syncParamDyo.getDynamicObjectCollection("dimentry");
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        abstractModel.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("dimname", new Object[0]);
        tvs.addField("dimnumber", new Object[0]);
        tvs.addField("srcnumber", new Object[0]);
        tvs.addField("paramtemp", new Object[0]);
        tvs.addField("memberjson_tag", new Object[0]);
        tvs.addField("selectmember", new Object[0]);
        for (DynamicObject dim : dimEntryCol) {
            Object[] objectArray;
            if (!"2".equals(dim.getString("filtermode"))) continue;
            String dimNumber = dim.getString("dimnumber");
            JSONArray jsonArray = (JSONArray)paramMap.get(dimNumber);
            if (jsonArray == null) {
                String[] stringArray = new String[3];
                stringArray[0] = null;
                stringArray[1] = null;
                objectArray = stringArray;
                stringArray[2] = null;
            } else {
                objectArray = jsonArray.toArray();
            }
            Object[] paramArr = objectArray;
            tvs.addRow(new Object[]{dim.getString("dimname"), dimNumber, dim.getString("olddimnumber"), paramArr[0], paramArr[2], paramArr[1]});
        }
        abstractModel.batchCreateNewEntryRow("paramentry", tvs);
        abstractModel.endInit();
        view.updateView("paramentry");
        model.setValue("syncparamnum", (Object)syncParamDyo.getString("number"));
        model.setValue("repeatmode", (Object)repeatMode);
        model.setValue("cyclenum", (Object)cycleNum);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "btnok": {
                Integer dateOffset = (Integer)model.getValue("dateoffset");
                DynamicObjectCollection paramEntry = model.getEntryEntity("paramentry");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(paramEntry.size() + 1);
                paramMap.put("dateoffset", dateOffset);
                for (DynamicObject param : paramEntry) {
                    String paramTemp = param.getString("paramtemp");
                    String selectMember = param.getString("selectmember");
                    if (StringUtils.isEmpty((String)paramTemp) && StringUtils.isEmpty((String)selectMember)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6bcf\u4e00\u884c\u53c2\u6570\u6a21\u677f\u3002", (String)"FSABatchCreateParamFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String selectMemberId = param.getString("memberjson_tag");
                    String[] paramArr = new String[]{paramTemp != null ? paramTemp.replaceAll(" ", "") : null, selectMember, selectMemberId};
                    paramMap.put(param.getString("dimnumber"), paramArr);
                }
                if (StringUtils.isNotEmpty((String)((String)view.getFormShowParameter().getCustomParam("batchparamjson_tag")))) {
                    view.getPageCache().put(PAGE_CACHE_RETURN_DATA, JSON.toJSONString(paramMap));
                    view.showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6709\u5fc5\u586b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\uff0c\u70b9\u51fb\u786e\u8ba4\u5c06\u4f1a\u8986\u76d6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSABatchCreateParamFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackReset", (IFormPlugin)this));
                    return;
                }
                view.returnDataToParent((Object)JSON.toJSONString(paramMap));
                view.close();
                break;
            }
            case "selectmember": {
                FSAMemberF7Util.memberF7(this, model.getEntryCurrentRowIndex("paramentry"), model, Long.parseLong((String)view.getFormShowParameter().getCustomParam("syncparam_id")));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView view = this.getView();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult && "callbackReset".equalsIgnoreCase(actionId)) {
            view.returnDataToParent((Object)view.getPageCache().get(PAGE_CACHE_RETURN_DATA));
            view.close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent arg) {
        super.closedCallBack(arg);
        String key = arg.getActionId();
        IDataModel model = this.getModel();
        Object returnData = arg.getReturnData();
        if ("closeCallbackSelectMember".equalsIgnoreCase(key)) {
            Set resultSet = (Set)returnData;
            if (resultSet == null) {
                return;
            }
            int curIdx = model.getEntryCurrentRowIndex("paramentry");
            LinkedHashSet<String> memberNumberSet = new LinkedHashSet<String>(resultSet.size());
            LinkedHashSet<String> memberIdSet = new LinkedHashSet<String>(resultSet.size());
            for (OlapServerDimMemberMetaInfo info : resultSet) {
                memberNumberSet.add(info.getNumber());
                memberIdSet.add(String.valueOf(info.getId()));
            }
            model.setValue("selectmember", (Object)String.join((CharSequence)",", memberNumberSet), curIdx);
            model.setValue("memberjson_tag", (Object)String.join((CharSequence)",", memberIdSet), curIdx);
        }
    }
}

