/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.fsa.utils.FSADataversionUtils;

public class FSAChooseImportVersionFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter originFsp = view.getFormShowParameter();
        Long syncParamId = (Long)originFsp.getCustomParam("syncparam_id");
        DynamicObjectCollection dataVersionList = FSADataversionUtils.getInfoBySyncParamId((Long)syncParamId);
        if (!CollectionUtils.isEmpty((Collection)dataVersionList)) {
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            IFormView parentView = view.getParentView();
            IDataModel parentModel = parentView.getModel();
            String versionStepConfig = (String)parentModel.getValue("stepconfig", 2);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int rowIndex = 0;
            int selectIndex = -1;
            for (DynamicObject doj : dataVersionList) {
                Long version = doj.getLong("version");
                if (selectIndex < 0 && String.valueOf(version).equals(versionStepConfig)) {
                    selectIndex = rowIndex;
                }
                String createTime = sdf.format(doj.getDate("createtime"));
                String status = doj.getString("status");
                int idx = abstractModel.createNewEntryRow("data_version_entity");
                abstractModel.setValue("version", (Object)version, idx);
                if (FSAStatusEnum.DISABLE.getCodeString().equals(status)) {
                    abstractModel.setValue("status", (Object)"0", idx);
                } else if (FSAStatusEnum.ENABLE.getCodeString().equals(status)) {
                    abstractModel.setValue("status", (Object)"1", idx);
                }
                abstractModel.setValue("createtime", (Object)createTime, idx);
                ++rowIndex;
            }
            abstractModel.endInit();
            view.updateView("data_version_entity");
            if (selectIndex >= 0) {
                model.setValue("create_version", (Object)Boolean.FALSE);
                model.setValue("current_version", (Object)versionStepConfig);
            } else if (StringUtils.isNotEmpty((String)versionStepConfig)) {
                model.setValue("create_version", (Object)Boolean.TRUE);
                model.setValue("current_version", (Object)versionStepConfig);
            }
        } else {
            model.setValue("current_version", (Object)String.valueOf(FSADataversionUtils.getVersionToDateLong()));
            model.setValue("create_version", (Object)Boolean.TRUE);
            view.setEnable(Boolean.FALSE, new String[]{"create_version"});
        }
        QFilter idFilter = new QFilter("id", "=", (Object)syncParamId);
        DynamicObject syncParamDyn = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"tablenumber,number,name", (QFilter[])idFilter.toArray());
        if (syncParamDyn != null && StringUtils.isEmpty((String)syncParamDyn.getString("tablenumber"))) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("fsa_number_name_config");
            fsp.setStatus(OperationStatus.ADDNEW);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("syncparam_id", (Object)syncParamId);
            fsp.setCustomParam("synParamName", (Object)syncParamDyn.getString("name"));
            fsp.setCustomParam("synParamNum", (Object)syncParamDyn.getString("number"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fsa_number_name_config"));
            Long collectionId = (Long)originFsp.getCustomParam("datacollection");
            QFilter colIdFilter = new QFilter("id", "=", (Object)collectionId);
            DynamicObject collectionDyn = QueryServiceHelper.queryOne((String)"fsa_data_collection", (String)"number,name", (QFilter[])colIdFilter.toArray());
            if (collectionDyn != null) {
                fsp.setCustomParam("collectionName", (Object)collectionDyn.getString("name"));
                fsp.setCustomParam("collectionNum", (Object)collectionDyn.getString("number"));
            }
            view.showForm(fsp);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868", (String)"FSAGuideFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        String versionStepConfig = (String)parentModel.getValue("stepconfig", 2);
        int rowCount = model.getEntryRowCount("data_version_entity");
        for (int i = 0; i < rowCount; ++i) {
            String version = (String)model.getValue("version", i);
            if (!version.equals(versionStepConfig)) continue;
            model.setEntryCurrentRowIndex("data_version_entity", i);
            break;
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Boolean createVersion = (Boolean)model.getValue("create_version");
        if (createVersion.booleanValue()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
            entryGrid.clearEntryState();
            return;
        }
        int versionIdx = model.getEntryCurrentRowIndex("data_version_entity");
        String version = (String)model.getValue("version", versionIdx);
        model.setValue("current_version", (Object)version);
        DynamicObject versionField = FSADataversionUtils.getVersionEntryInfo((Long)Long.parseLong(version));
        if (versionField != null) {
            model.deleteEntryData("required_param_entity");
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            DynamicObjectCollection entryEntity = versionField.getDynamicObjectCollection("entryentity");
            TableValueSetter columnEntryTvs = new TableValueSetter(new String[0]);
            columnEntryTvs.addField("dim_name", new Object[0]);
            columnEntryTvs.addField("param_set_value", new Object[0]);
            for (DynamicObject row : entryEntity) {
                StringBuilder paramSetValueSb = new StringBuilder();
                DynamicObjectCollection subEntryEntity = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subRow : subEntryEntity) {
                    paramSetValueSb.append(',').append(subRow.getString("membername"));
                }
                columnEntryTvs.addRow(new Object[]{row.getString("dimname"), paramSetValueSb.substring(1)});
            }
            abstractModel.batchCreateNewEntryRow("required_param_entity", columnEntryTvs);
            abstractModel.endInit();
            view.updateView("required_param_entity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("create_version".equalsIgnoreCase(e.getProperty().getName())) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
                entryGrid.clearEntryState();
                this.getModel().setValue("current_version", (Object)String.valueOf(FSADataversionUtils.getVersionToDateLong()));
            } else {
                this.getModel().setValue("current_version", null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object obj = closedCallBackEvent.getReturnData();
        switch (closedCallBackEvent.getActionId()) {
            case "fsa_number_name_config": {
                this.setTableFromReturnData(obj);
                break;
            }
        }
    }

    private void setTableFromReturnData(Object obj) {
        Map result;
        boolean success;
        if (obj instanceof Map && (success = Boolean.parseBoolean((String)(result = (Map)obj).get("res")))) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%s]\u521b\u5efa\u6210\u529f", (String)"FSASyncParamFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), result.get("tablename")));
        }
    }
}

