/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.fsa.model.file.FSAFileInfoModel;

public class FSAChooseSheetFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save"});
    }

    public void afterCreateNewData(EventObject e) {
        FSAFileInfoModel fileInfoModel;
        IFormView view = this.getView();
        String customDependOn = (String)view.getFormShowParameter().getCustomParam("customDependOn");
        if (StringUtils.isNotEmpty((String)customDependOn) && (fileInfoModel = (FSAFileInfoModel)JSON.parseObject((String)customDependOn, (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0])) != null) {
            this.setComboItems(fileInfoModel.getSheetNameList());
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("save".equalsIgnoreCase(control.getKey())) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String sheetName = (String)model.getValue("choosesheet");
            if (StringUtils.isEmpty((String)sheetName)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8868", (String)"FSAChooseSheetFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            } else {
                view.returnDataToParent((Object)sheetName);
                view.close();
            }
        }
    }

    private void setComboItems(List<String> nameList) {
        LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
        ComboEdit cb = (ComboEdit)this.getControl("choosesheet");
        if (!CollectionUtils.isEmpty(nameList)) {
            for (String name : nameList) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(name));
                item.setValue(name);
                item.setItemVisible(true);
                comboItems.add(item);
            }
            cb.setComboItems(comboItems);
        }
    }
}

