/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.model.gdt.CombFiledModel;
import kd.data.fsa.model.gdt.MemberModel;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;

public class FSACombFieldSettingFormPlugin
extends AbstractFormPlugin {
    public static final String PARAMSRC = "paramsrc_tag";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        JSONArray jsonArray = (JSONArray)view.getFormShowParameter().getCustomParam("F7PARAM");
        if (jsonArray != null && jsonArray.size() > 0) {
            this.showDim(jsonArray, view);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("selectmember".equals(actionId)) {
            this.returnSelectMember(returnData);
        }
    }

    private void returnSelectMember(Object returnData) {
        IDataModel model = this.getModel();
        Set setDuplicate = (Set)returnData;
        Set existence = model.getEntryEntity("subentryentity").stream().map(p -> p.getString("membernumber")).collect(Collectors.toSet());
        HashSet<OlapServerDimMemberMetaInfo> needToWrite = new HashSet<OlapServerDimMemberMetaInfo>(setDuplicate.size());
        for (OlapServerDimMemberMetaInfo next : setDuplicate) {
            if (existence.contains(next.getNumber())) continue;
            needToWrite.add(next);
            existence.add(next.getNumber());
        }
        if (needToWrite.size() == 0) {
            return;
        }
        int[] subentryentities = model.batchCreateNewEntryRow("subentryentity", needToWrite.size());
        Iterator iterator = needToWrite.iterator();
        int sourcefieldrow = model.getEntryCurrentRowIndex("sourcefield");
        String srcdimname = (String)model.getValue("dimname", sourcefieldrow);
        String srcdimnumber = (String)model.getValue("dimnumber", sourcefieldrow);
        for (int subentryentity : subentryentities) {
            OlapServerDimMemberMetaInfo next = (OlapServerDimMemberMetaInfo)iterator.next();
            model.setValue("dimname1", (Object)srcdimname, subentryentity);
            model.setValue("dimnumber1", (Object)srcdimnumber, subentryentity);
            model.setValue("membername", (Object)next.getName(), subentryentity);
            model.setValue("membernumber", (Object)next.getNumber(), subentryentity);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "btn_ok": {
                this.returnData();
                break;
            }
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection sourcefield = model.getEntryEntity("sourcefield");
        ArrayList entryList = new ArrayList(sourcefield.size());
        for (DynamicObject dynamicObject : sourcefield) {
            DynamicObjectCollection subentryentity = dynamicObject.getDynamicObjectCollection("subentryentity");
            if (subentryentity.size() == 0) {
                String string = dynamicObject.getString("dimname");
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0%s\u5b57\u6bb5\u6210\u5458\u3002", (String)"FSACombFieldSettingFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), string));
                return;
            }
            ArrayList<ChangeModel> arrayList = new ArrayList<ChangeModel>(subentryentity.size());
            for (DynamicObject subEntry : subentryentity) {
                String dimName = subEntry.getString("dimname1");
                String dimNumber = subEntry.getString("dimnumber1");
                String memberName = subEntry.getString("membername");
                String memberNumber = subEntry.getString("membernumber");
                arrayList.add(new ChangeModel(dimName, dimNumber, memberName, memberNumber));
            }
            entryList.add(arrayList);
        }
        ArrayList resultList = new ArrayList(32);
        ArrayList<CombFiledModel> returnList = new ArrayList<CombFiledModel>(32);
        this.descartes(entryList, resultList, 0, new ArrayList());
        for (List list : resultList) {
            StringBuilder combFiledName = new StringBuilder();
            StringBuilder combFiledNumber = new StringBuilder();
            ArrayList<MemberModel> memberModels = new ArrayList<MemberModel>(10);
            for (int i1 = 0; i1 < list.size(); ++i1) {
                ChangeModel model1 = (ChangeModel)list.get(i1);
                MemberModel memberModel = new MemberModel(model1.memberName, model1.memberNumber, model1.dimName, model1.dimNumber);
                memberModels.add(memberModel);
                combFiledName.append(model1.memberName);
                combFiledNumber.append(model1.memberNumber);
                if (i1 >= list.size() - 1) continue;
                combFiledName.append('_');
                combFiledNumber.append('_');
            }
            returnList.add(new CombFiledModel(combFiledName.toString(), combFiledNumber.toString(), memberModels));
        }
        this.getView().returnDataToParent(returnList);
        this.getView().close();
    }

    public <T> void descartes(List<List<T>> dimensionValue, List<List<T>> result, int layer, List<T> currentList) {
        block7: {
            block6: {
                if (layer >= dimensionValue.size() - 1) break block6;
                if (dimensionValue.get(layer).size() == 0) {
                    this.descartes(dimensionValue, result, layer + 1, currentList);
                } else {
                    for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                        ArrayList<T> list = new ArrayList<T>(currentList);
                        list.add(dimensionValue.get(layer).get(i));
                        this.descartes(dimensionValue, result, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimensionValue.size() - 1) break block7;
            if (dimensionValue.get(layer).size() == 0) {
                result.add(currentList);
            } else {
                for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                    ArrayList<T> list = new ArrayList<T>(currentList);
                    list.add(dimensionValue.get(layer).get(i));
                    result.add(list);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_add".equals(itemKey)) {
            this.openMultipleMenberF7();
        }
    }

    private Object parserSrcParam(String key) {
        String paramsrc = (String)this.getView().getFormShowParameter().getCustomParam(PARAMSRC);
        JSONObject parser = (JSONObject)JSONObject.parse((String)paramsrc);
        return parser.get((Object)key);
    }

    private void openMultipleMenberF7() {
        IDataModel model = this.getModel();
        int selectrow = model.getEntryCurrentRowIndex("sourcefield");
        DynamicObject entryCurrentRow = model.getEntryRowEntity("sourcefield", selectrow);
        Long moduleid = (Long)this.parserSrcParam("moduleId");
        Long viewid = (Long)this.parserSrcParam("OrgView");
        String dimnumber = entryCurrentRow.getString("dimnumber");
        String dimname = entryCurrentRow.getString("dimname");
        FSAMultipleMemberF7BasePlugin.openF7(this, dimname, moduleid, dimnumber, viewid, "selectmember", Boolean.TRUE, null, null);
    }

    private void showDim(JSONArray jsonArray, IFormView view) {
        IDataModel model = this.getModel();
        Map echoMap = (Map)view.getFormShowParameter().getCustomParam("customEchoMap");
        int[] createRows = model.batchCreateNewEntryRow("sourcefield", jsonArray.size());
        int index = 0;
        for (int i = 0; i < createRows.length; ++i) {
            JSONObject jsonObject;
            String srcDimName;
            srcDimName = (srcDimName = (jsonObject = jsonArray.getJSONObject(index++)).getString("srcdimname")) == null ? jsonObject.getString("srcfieldname") : srcDimName;
            String srcDimNumber = jsonObject.getString("srcdimnumber");
            srcDimNumber = srcDimNumber == null ? jsonObject.getString("srcfieldnumber") : srcDimNumber;
            model.setValue("dimname", (Object)srcDimName, i);
            model.setValue("dimnumber", (Object)srcDimNumber, i);
            if (echoMap == null) continue;
            model.setEntryCurrentRowIndex("sourcefield", i);
            Map stringMapMap = (Map)echoMap.get(srcDimNumber);
            String finalSrcDimNumber = srcDimNumber;
            stringMapMap.forEach((k, v) -> {
                int newRow = model.createNewEntryRow("subentryentity");
                model.setValue("dimname1", v.get(1), newRow);
                model.setValue("dimnumber1", (Object)finalSrcDimNumber, newRow);
                model.setValue("membername", v.get(2), newRow);
                model.setValue("membernumber", k, newRow);
            });
        }
        this.getView().updateView("sourcefield");
    }

    public static class ChangeModel {
        String dimName;
        String dimNumber;
        String memberName;
        String memberNumber;

        public ChangeModel(String dimName, String dimNumber, String memberName, String memberNumber) {
            this.dimName = dimName;
            this.dimNumber = dimNumber;
            this.memberName = memberName;
            this.memberNumber = memberNumber;
        }
    }
}

