/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.disf.enums.FSADataTypeEnum;
import kd.data.fsa.common.constant.FSAUIConstants;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSAFieldTypeEnum;
import kd.data.fsa.common.enums.FSAParamTemplateCatelogEnum;
import kd.data.fsa.formplugin.FSAF7Util;
import kd.data.fsa.formplugin.FSAMemberSelectF7Plugin;
import kd.data.fsa.formplugin.util.EntryUtil;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.model.gdt.CombFiledModel;
import kd.data.fsa.model.gdt.MemberModel;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSAParamTemplateHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FSADataCollectionFormPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
TabSelectListener {
    private static final String CACHE_DEFAULT_NUMBER_ = "defaultNumber_";
    private static final String CACHE_DEFAULT_NAME_ = "defaultName_";
    private static final String CACHE_DIM_ID_ = "id_";
    private static final String CACHE_DIM_NAME_ = "name_";
    private static final String CACHE_DIM_ENTITY_ = "entity_";
    private static final String CACHE_DIM_TYPE_ = "dimType_";
    private static final String CACHE_DIM_DATA_TYPE_ = "dimDataType_";
    private static final String CUSTOMMEASURE = "custommeasure";
    boolean beyy = false;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection paramDyn = FSAParamTemplateHelper.getParamDynamicByGroupId((Long)FSAUIConstants.FID_DATA_COLLECTION);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(paramDyn.size());
        for (DynamicObject dyn : paramDyn) {
            ComboItem item = new ComboItem();
            item.setValue(dyn.getString("number"));
            item.setCaption(new LocaleString(dyn.getString("name")));
            comboItemList.add(item);
        }
        if (!comboItemList.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("datasrctype");
            comboEdit.setComboItems(comboItemList);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap4"});
        this.editDatacolsrcfilterInit();
        this.editDataEntryEntityInit();
        this.initDimType();
        model.setDataChanged(false);
        String dataSrcType = (String)model.getValue("datasrctype");
        this.setVisibleAndEnableStatus(dataSrcType);
        this.openOffLineDataPreview(view, dataSrcType);
    }

    public void createNewData(BizDataEventArgs e) {
        IFormView view = this.getView();
        view.setEnable(Boolean.TRUE, new String[]{"name", "number"});
        view.setVisible(Boolean.FALSE, new String[]{"offlinedata_preview"});
    }

    private void setDisVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap4"});
    }

    private void setEditDisable(boolean isQuote) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setEnable(Boolean.FALSE, new String[]{"name", "number"});
        if (isQuote) {
            view.setEnable(Boolean.FALSE, new String[]{"paramsrcname", "description", "superlongdata", "datasrctype"});
            view.setEnable(Boolean.FALSE, new String[]{"addfield", "createcombfield", "customaddfield", CUSTOMMEASURE, "deletefield", "bar_save", "saveandadd", "updatemeasure"});
            DynamicObjectCollection datacolsrcfilter = model.getEntryEntity("datacolsrcfilter");
            for (int i = 0; i < datacolsrcfilter.size(); ++i) {
                view.setEnable(Boolean.FALSE, i, new String[]{"srcdimdefault"});
            }
            DynamicObjectCollection dataentryentity = model.getEntryEntity("dataentryentity");
            for (int i = 0; i < dataentryentity.size(); ++i) {
                view.setEnable(Boolean.FALSE, i, new String[]{"dimname", "dimnumber", "dimtype", "dimdatatype", "dimsetup"});
            }
        }
    }

    private void initDimType() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimtype");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString("\u7ef4\u5ea6"), "1"));
        IDataModel model = this.getModel();
        String dataSrcType = (String)model.getValue("datasrctype");
        boolean itemVisible = false;
        if ("fileParamSource".equals(dataSrcType)) {
            itemVisible = true;
        }
        data.add(new ComboItem(null, new LocaleString("\u5ea6\u91cf"), "2", itemVisible));
        data.add(new ComboItem(new LocaleString("\u65e5\u671f"), "0"));
        comboEdit.setComboItems(data);
    }

    public void afterLoadData(EventObject e) {
        this.setDisVisible();
        this.beyy = this.checkQuote();
        this.setEditDisable(this.beyy);
        this.editDatacolsrcfilterInit();
        this.editDataEntryEntityInit();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (name) {
            case "paramsrc_tag": {
                this.paramsrcChange(e);
                break;
            }
            case "dimnumber": 
            case "dimname": {
                this.changeCombFieldNameAndNumber(e);
                break;
            }
            case "dimtype": {
                this.changeDimType(e);
                break;
            }
            case "datasrctype": {
                String dataSrcType = (String)e.getChangeSet()[0].getNewValue();
                this.setCreateCombFieldEnable(this.getView(), dataSrcType);
                this.setVisibleAndEnableStatus(dataSrcType);
                IPageCache pageCache = view.getPageCache();
                String srcMark = pageCache.get("pageCacheDataSrcTypeMark");
                String paramSrc = (String)model.getValue("paramsrc_tag");
                if (StringUtils.isEmpty((CharSequence)srcMark) && StringUtils.isNotEmpty((CharSequence)paramSrc)) {
                    pageCache.put("paramsrc_tag", paramSrc);
                    pageCache.put("paramsrcname", (String)model.getValue("paramsrcname"));
                    pageCache.put("datasrctype", (String)oldValue);
                    pageCache.put("pageCacheDataSrcTypeMark", "dataSrcTypeMark");
                    model.setValue("paramsrcname", null);
                    model.setValue("paramsrc_tag", null);
                }
                this.initDimType();
                break;
            }
            case "paramsrcname": {
                if (newValue == null || !StringUtils.isBlank((CharSequence)newValue.toString())) break;
                model.setValue("paramsrcname", oldValue);
                break;
            }
        }
    }

    private void setVisibleAndEnableStatus(String dataSrcType) {
        IFormView view = this.getView();
        Tab tab = (Tab)view.getControl("tabap");
        if ("fileParamSource".equals(dataSrcType)) {
            view.setVisible(Boolean.TRUE, new String[]{"offlinedata_preview"});
            this.openOffLineDataPreview(view, dataSrcType);
            view.setVisible(Boolean.FALSE, new String[]{"updatemeasure"});
            tab.activeTab("offlinedata_preview");
        } else if ("bcmParamSource".equals(dataSrcType)) {
            view.setVisible(Boolean.FALSE, new String[]{"offlinedata_preview"});
            view.setVisible(Boolean.TRUE, new String[]{"updatemeasure"});
            tab.activeTab("datacollection_setcolumn");
        }
    }

    private void openOffLineDataPreview(IFormView view, String dataSrcType) {
        Tab tab = (Tab)view.getControl("tabap");
        if ("fileParamSource".equals(dataSrcType)) {
            tab.activeTab("offlinedata_preview");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("fsa_offlinedata_preview");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("offlinedata_preview");
            formShowParameter.setParentFormId(view.getFormShowParameter().getFormId());
            this.getPageCache().put("offlinedata_pageid", formShowParameter.getPageId());
            view.showForm(formShowParameter);
        } else {
            tab.activeTab("datacollection_setcolumn");
        }
    }

    private boolean checkHasMeasure(boolean excludeSelect) {
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("dataentryentity");
        int[] select = EntryUtil.select((AbstractFormPlugin)this, "dataentryentity");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            if (ArrayUtils.contains((int[])select, (int)i) && excludeSelect) continue;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            String dimType = dynamicObject.getString("dimtype");
            String fieldcreatetype = dynamicObject.getString("fieldcreatetype");
            if (!FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString().equals(fieldcreatetype) || !FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType)) continue;
            return true;
        }
        return false;
    }

    private void changeDimType(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String oldValue = (String)changeData.getOldValue();
        String newValue = (String)changeData.getNewValue();
        int row = changeData.getRowIndex();
        if (oldValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        if (FSADimensionTypeEnum.DATE_DIM.getCodeString().equals(newValue)) {
            model.setValue("dimdatatype", (Object)FSADataTypeEnum.DATE_TYPE.getCodeString(), row);
        } else if (FSADimensionTypeEnum.DATA_DIM.getCodeString().equals(newValue)) {
            model.setValue("dimdatatype", (Object)FSADataTypeEnum.STRING_TYPE.getCodeString(), row);
        } else if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(newValue)) {
            model.setValue("dimdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), row);
        }
    }

    private void changeCombFieldNameAndNumber(PropertyChangedArgs e) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("dataentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("dataentryentity", entryCurrentRowIndex);
        String createType = entryRowEntity.getString("fieldcreatetype");
        if (FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString().equals(createType)) {
            long dimId = entryRowEntity.getLong("dimid");
            String combNumber = entryRowEntity.getString("dimnumber");
            String combName = entryRowEntity.getString("dimname");
            DynamicObjectCollection combDynamicObjectCollection = this.getModel().getEntryEntity("datacolcombfields");
            for (int i = 0; i < combDynamicObjectCollection.size(); ++i) {
                long combId = ((DynamicObject)combDynamicObjectCollection.get(i)).getLong("COMBINATIONID");
                if (dimId != combId) continue;
                this.getModel().setValue("combofieldfname", (Object)combName, i);
                this.getModel().setValue("combofieldnumber", (Object)combNumber, i);
                return;
            }
        }
    }

    private void paramsrcChange(PropertyChangedArgs e) {
        String oldValue = (String)e.getChangeSet()[0].getOldValue();
        IFormView view = this.getView();
        if (StringUtils.isEmpty((CharSequence)view.getPageCache().get("datasrctype"))) {
            view.getPageCache().put("datasrctype", (String)this.getModel().getValue("datasrctype"));
        }
        String tabMark = view.getPageCache().get("pageCacheTabValueGetMark");
        view.getPageCache().put("pageCacheTabValueGetMark", null);
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isNotEmpty((CharSequence)tabMark) && StringUtils.isNotEmpty((CharSequence)newValue)) {
            JSONObject jsonObject = JSONObject.parseObject((String)newValue);
            FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)jsonObject.getString("fileUpload"), FSAFileInfoModel.class);
            this.showDimFromFile(fileInfoModel);
        } else if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
            view.showConfirm(ResManager.loadKDString((String)"\u5c06\u91cd\u65b0\u52a0\u8f7d\u6e90\u5b57\u6bb5\u5217\u8868\u548c\u6e05\u7a7a\u96c6\u5408\u5b57\u6bb5\u5217\u8868\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"FSADataCollectionFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("changeParamConfirm", (IFormPlugin)this));
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        if ("datacollection_setcolumn".equalsIgnoreCase(subTabKey)) {
            // empty if block
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        if ("changeParamConfirm".equalsIgnoreCase(actionId)) {
            IPageCache pageCache = view.getPageCache();
            String paramsrc = pageCache.get("paramsrc_tag");
            String paramsrcname = pageCache.get("paramsrcname");
            String dataSrcType = pageCache.get("datasrctype");
            pageCache.remove("paramsrc_tag");
            pageCache.remove("paramsrcname");
            pageCache.remove("datasrctype");
            pageCache.remove("pageCacheDataSrcTypeMark");
            if (MessageBoxResult.Yes == messageBoxResult) {
                String paramSrc = (String)model.getValue("paramsrc_tag");
                model.deleteEntryData("datacolcombfields");
                model.deleteEntryData("dataentryentity");
                model.deleteEntryData("datacolsrcfilter");
                view.updateView("datacolcombfields");
                view.updateView("dataentryentity");
                view.updateView("datacolsrcfilter");
                dataSrcType = (String)model.getValue("datasrctype");
                if (StringUtils.isNotEmpty((CharSequence)paramSrc)) {
                    if ("bcmParamSource".equals(dataSrcType)) {
                        this.showDim(paramSrc);
                    } else if ("fileParamSource".equals(dataSrcType)) {
                        paramSrc = (String)model.getValue("paramsrc_tag");
                        JSONObject jsonObject = JSONObject.parseObject((String)paramSrc);
                        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)jsonObject.getString("fileUpload"), FSAFileInfoModel.class);
                        this.showDimFromFile(fileInfoModel);
                    }
                }
                this.setCreateCombFieldEnable(view, dataSrcType);
            } else {
                model.setValue("datasrctype", (Object)dataSrcType);
                model.setValue("paramsrcname", (Object)paramsrcname);
                model.setValue("paramsrc_tag", (Object)paramsrc);
                view.updateView("datasrctype");
                view.updateView("paramsrcname");
                view.updateView("paramsrc_tag");
                this.setVisibleAndEnableStatus(dataSrcType);
                this.initDimType();
            }
        }
        if ("CHANGE_ENABLE".equals(actionId)) {
            String operaValue;
            Long mutex_obj_id = null;
            mutex_obj_id = this.getModel().getDataEntity().getLong("id");
            DynamicObject dataEntity = BusinessDataReader.loadSingle((Object)mutex_obj_id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_data_collection"));
            if (MessageBoxResult.Yes.equals((Object)messageBoxResult)) {
                dataEntity.set("enable", (Object)"1");
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                DynamicObject dynamicObject = (DynamicObject)save[0];
                model.setValue("enable", (Object)dynamicObject.getString("enable"));
                this.getModel().setDataChanged(false);
            }
            if (StringUtils.isNotEmpty((CharSequence)(operaValue = messageBoxClosedEvent.getCustomVaule()))) {
                this.getView().getPageCache().remove("SaveAndNew");
                this.getView().invokeOperation(operaValue);
            }
        }
        if ("dimTypeChange".equals(actionId)) {
            String oldValue = messageBoxClosedEvent.getCustomVaule();
            int curIdx = model.getEntryCurrentRowIndex("dataentryentity");
            model.setValue("dimtype", (Object)oldValue, curIdx);
            view.updateView("dataentryentity");
        }
        model.endInit();
    }

    private void setCreateCombFieldEnable(IFormView view, String dataSrcType) {
        if ("bcmParamSource".equals(dataSrcType)) {
            view.setEnable(Boolean.TRUE, new String[]{"createcombfield"});
            view.setVisible(Boolean.TRUE, new String[]{"updatemeasure"});
        } else if ("fileParamSource".equals(dataSrcType)) {
            view.setEnable(Boolean.FALSE, new String[]{"createcombfield"});
            view.setVisible(Boolean.FALSE, new String[]{"updatemeasure"});
        }
    }

    private boolean checkQuote() {
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        return QueryServiceHelper.exists((String)"fsa_syncparam", (QFilter[])new QFilter[]{new QFilter("datacollection", "=", (Object)id)}) || QueryServiceHelper.exists((String)"fsa_data_scheme", (QFilter[])new QFilter[]{new QFilter("data_collection", "=", (Object)id)});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addfield", "createcombfield"});
        this.addItemClickListeners(new String[]{"itemclick"});
        IFormView view = this.getView();
        TextEdit combofield = (TextEdit)view.getControl("paramsrcname");
        combofield.addButtonClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)view.getControl("dataentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit selectMemberF7 = (TextEdit)view.getControl("srcdimdefault");
        selectMemberF7.addButtonClickListener((ClickListener)this);
        Tab tab = (Tab)view.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "addfield": {
                this.addField(model);
                break;
            }
            case "createcombfield": {
                String dataSrcType = (String)model.getValue("datasrctype");
                if (!"bcmParamSource".equals(dataSrcType)) break;
                this.openCreateCombfield(model, false);
                break;
            }
            case "paramsrcname": {
                this.openParamsrc(model);
                break;
            }
            case "srcdimdefault": {
                String dataSrcType = (String)model.getValue("datasrctype");
                if (!"bcmParamSource".equals(dataSrcType)) break;
                this.openSelectMemberF7();
                break;
            }
        }
    }

    private void openSelectMemberF7() {
        IDataModel model = this.getModel();
        DynamicObject entryCurrentRow = ((BillModel)model).getEntryCurrentRow("datacolsrcfilter");
        JSONObject jsonObject = (JSONObject)JSONObject.parse((String)((String)model.getValue("paramsrc_tag")));
        String title = entryCurrentRow.getString("srcdimname");
        Long moduleId = jsonObject.getLong("moduleId");
        Long viewId = jsonObject.getLong("OrgView");
        String number = entryCurrentRow.getString("srcdimnumber");
        FSAMemberSelectF7Plugin.openF7((AbstractFormPlugin)this, title, moduleId, viewId, number, "selectMember");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "deletefield": {
                this.deletefield();
                break;
            }
            case "customaddfield": {
                this.customaddfield(evt);
                break;
            }
            case "custommeasure": {
                this.customMeasure(evt);
                break;
            }
            case "updatemeasure": {
                IFormView view = this.getView();
                if (!this.checkHasMeasure(false)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u5b57\u6bb5\u4e2d\u8fd8\u6ca1\u6709\u7ec4\u5408\u5ea6\u91cf\u5c5e\u6027\u3002", (String)"FSADataCollectionFormPlugin_11", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openCreateCombfield(this.getModel(), true);
                break;
            }
        }
    }

    private void customaddfield(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        int newEntryRow = model.createNewEntryRow("dataentryentity");
        model.setValue("fieldcreatetype", (Object)FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString(), newEntryRow);
        model.setValue("dimtype", (Object)FSADimensionTypeEnum.DATA_DIM.getCodeString(), newEntryRow);
        model.setValue("dimdatatype", (Object)FSADataTypeEnum.STRING_TYPE.getCodeString(), newEntryRow);
        model.setValue("dimsetup", (Object)"\u8bbe\u7f6e", newEntryRow);
    }

    private void customMeasure(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        int newEntryRow = model.createNewEntryRow("dataentryentity");
        model.setValue("fieldcreatetype", (Object)FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString(), newEntryRow);
        model.setValue("dimtype", (Object)FSADimensionTypeEnum.MEASURE_DIM.getCodeString(), newEntryRow);
        model.setValue("dimdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), newEntryRow);
        model.setValue("dimsetup", (Object)"\u8bbe\u7f6e", newEntryRow);
        this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"dimtype", "dimdatatype"});
    }

    private void deletefield() {
        int[] dataentryentities = EntryUtil.selectToBatchDo((AbstractFormPlugin)this, "dataentryentity", p -> this.deleteField((List<DynamicObject>)p));
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryRows("dataentryentity", dataentryentities);
        String dataSrcType = (String)model.getValue("datasrctype");
        if ("bcmParamSource".equals(dataSrcType)) {
            if (this.checkHasMeasure(false)) {
                view.setEnable(Boolean.FALSE, new String[]{"createcombfield"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"createcombfield"});
            }
        }
        EntryUtil.clearSelect((AbstractFormPlugin)this, "dataentryentity");
    }

    private void openParamsrc(IDataModel model) {
        String dataSrcType = (String)model.getValue("datasrctype");
        if (StringUtils.isEmpty((CharSequence)dataSrcType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u7c7b\u578b\u3002", (String)"FSADataCollectionFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageType", FSAParamTemplateCatelogEnum.DATASOURCE_FIELD);
        params.put("paramsrc_tag", model.getValue("paramsrc_tag"));
        params.put("paramNumber", dataSrcType);
        DynamicObject entityLoad = FSAParamTemplateHelper.getParamDynamic((String)dataSrcType);
        String dataSrcTypeName = entityLoad.getString("name");
        FSAF7Util f7 = new FSAF7Util((AbstractFormPlugin)this, dataSrcTypeName + "\u7684\u53c2\u6570\u8bbe\u7f6e", "paramsrcselected", params);
        f7.open("fsa_srcparam_setting");
    }

    /*
     * WARNING - void declaration
     */
    private void openCreateCombfield(IDataModel model, boolean isUpdate) {
        Object[] datacolsrcfilters;
        IFormView view = this.getView();
        if (isUpdate) {
            DynamicObjectCollection colCombMappings = model.getEntryEntity("datacolcombmappings");
            datacolsrcfilters = (DynamicObject[])colCombMappings.toArray((Object[])new DynamicObject[0]);
        } else {
            datacolsrcfilters = EntryUtil.selectGrid((AbstractFormPlugin)this, "datacolsrcfilter");
            StringBuilder tipNoteInfo = new StringBuilder();
            for (Object object : datacolsrcfilters) {
                String dimNumber = object.getString("srcdimnumber");
                if (!"Year".equalsIgnoreCase(dimNumber) && !"Period".equalsIgnoreCase(dimNumber)) continue;
                tipNoteInfo.append('\u3001').append(object.getString("srcdimname"));
            }
            if (StringUtils.isNotEmpty((CharSequence)tipNoteInfo)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s \u4e0d\u53ef\u4f5c\u4e3a\u5ea6\u91cf\u7ef4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FSADataCollectionFormPlugin_12", (String)"data-fsa-formplugin", (Object[])new Object[0]), tipNoteInfo.substring(1)));
                return;
            }
        }
        if (ArrayUtils.isEmpty((Object[])datacolsrcfilters)) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5b57\u6bb5\u3002", (String)"FSADataCollectionFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        FSAF7Util f7 = new FSAF7Util((AbstractFormPlugin)this, "\u6dfb\u52a0\u5ea6\u91cf\u5c5e\u6027", "combfieldSelectCallback", datacolsrcfilters);
        String params = (String)model.getValue("paramsrc_tag");
        f7.setCustomParam("paramsrc_tag", params);
        if (isUpdate) {
            void var9_13;
            int rowCnt = model.getEntryRowCount("datacolcombfields");
            HashMap echoMap = new HashMap(datacolsrcfilters.length);
            for (Object dyo : datacolsrcfilters) {
                echoMap.put(dyo.getString("srcfieldnumber"), new LinkedHashMap());
            }
            boolean bl = false;
            while (var9_13 < rowCnt) {
                model.setEntryCurrentRowIndex("datacolcombfields", (int)var9_13);
                DynamicObjectCollection entryEntity = model.getEntryEntity("datacolcombmappings");
                for (Object dyo : entryEntity) {
                    String srcFieldNumber = dyo.getString("srcfieldnumber");
                    String srcFieldMemNumber = dyo.getString("srcfieldmemnumber");
                    Map stringMapMap = (Map)echoMap.get(srcFieldNumber);
                    if (stringMapMap.containsKey(srcFieldMemNumber)) continue;
                    String srcFieldName = dyo.getString("srcfieldname");
                    String srcFieldMemName = dyo.getString("srcfieldmemname");
                    HashMap<Integer, String> map = new HashMap<Integer, String>();
                    map.put(1, srcFieldName);
                    map.put(2, srcFieldMemName);
                    stringMapMap.put(srcFieldMemNumber, map);
                }
                ++var9_13;
            }
            f7.setCustomParam("customEchoMap", echoMap);
        }
        f7.open("fsa_combfield_setting");
    }

    private void combfieldSelectCallback(Object returnData) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        List list = (List)returnData;
        int[] selected = EntryUtil.selectToDo((AbstractFormPlugin)this, "datacolsrcfilter", null);
        HashSet<Integer> deleted = new HashSet<Integer>();
        IPageCache pageCache = view.getPageCache();
        DynamicObjectCollection entryEntity = model.getEntryEntity("dataentryentity");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            LinkedList idxList = new LinkedList();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                if (!FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString().equals(dynamicObject.getString("fieldcreatetype")) || !FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dynamicObject.getString("dimtype"))) continue;
                idxList.add(i);
            }
            if (idxList.size() > 0) {
                model.deleteEntryRows("dataentryentity", idxList.stream().mapToInt(Integer::intValue).toArray());
            }
        }
        for (CombFiledModel returnModel : list) {
            this.addCompoundField(returnModel);
            if (selected.length <= 0) continue;
            for (int lineNo : selected) {
                DynamicObject line = (DynamicObject)model.getEntryEntity("datacolsrcfilter").get(lineNo);
                boolean in = false;
                for (MemberModel membermodel : returnModel.getMemberModels()) {
                    if (in || !membermodel.getSrcFiledNumber().equals(line.getString("srcdimnumber"))) continue;
                    deleted.add(lineNo);
                    in = true;
                }
            }
        }
        model.deleteEntryData("datacolcombfields");
        int[] datacolcombfieldRows = model.batchCreateNewEntryRow("datacolcombfields", list.size());
        int index = 0;
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>(16);
        for (int datacolcombfieldRow : datacolcombfieldRows) {
            model.setValue("COMBINATIONID", (Object)((CombFiledModel)list.get(index)).getCombinationId(), datacolcombfieldRow);
            model.setValue("combofieldfname", (Object)((CombFiledModel)list.get(index)).getCombFiledName(), datacolcombfieldRow);
            model.setValue("combofieldnumber", (Object)((CombFiledModel)list.get(index)).getCombFiledNumber(), datacolcombfieldRow);
            model.setValue("comdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), datacolcombfieldRow);
            List memberModels = ((CombFiledModel)list.get(index)).getMemberModels();
            hashMap.put(datacolcombfieldRow, memberModels);
            ++index;
        }
        Object object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry next = (Map.Entry)object.next();
            int rows = (Integer)next.getKey();
            List data = (List)next.getValue();
            model.setEntryCurrentRowIndex("datacolcombfields", rows);
            int[] datacolcombmappingsRows = model.batchCreateNewEntryRow("datacolcombmappings", data.size());
            int index1 = 0;
            for (int datacolcombmappingsRow : datacolcombmappingsRows) {
                model.setValue("srcfieldname", (Object)((MemberModel)data.get(index1)).getSrcFiledName(), datacolcombmappingsRow);
                model.setValue("srcfieldnumber", (Object)((MemberModel)data.get(index1)).getSrcFiledNumber(), datacolcombmappingsRow);
                model.setValue("srcfieldmemname", (Object)((MemberModel)data.get(index1)).getMemberName(), datacolcombmappingsRow);
                model.setValue("srcfieldmemnumber", (Object)((MemberModel)data.get(index1)).getMemberNumber(), datacolcombmappingsRow);
                model.setValue("comsrcdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), datacolcombmappingsRow);
                ++index1;
            }
        }
        for (Integer next : deleted) {
            DynamicObject entryRowEntity = model.getEntryRowEntity("datacolsrcfilter", next.intValue());
            String number = entryRowEntity.getString("srcdimnumber");
            String srcdimfault = entryRowEntity.getString("srcdimdefault");
            String srcdimfaultName = entryRowEntity.getString("srcdimnamedefault");
            pageCache.put(CACHE_DEFAULT_NUMBER_ + number, srcdimfault);
            pageCache.put(CACHE_DEFAULT_NAME_ + number, srcdimfaultName);
        }
        if (!deleted.isEmpty()) {
            model.deleteEntryRows("datacolsrcfilter", deleted.stream().mapToInt(Integer::intValue).toArray());
            view.updateView("datacolsrcfilter");
            view.setEnable(Boolean.FALSE, new String[]{"createcombfield"});
        }
    }

    private void addField(IDataModel model) {
        int[] selected = EntryUtil.selectToDo((AbstractFormPlugin)this, "datacolsrcfilter", p -> this.addField((DynamicObject)p));
        if (selected.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u7ef4\u5ea6\u3002", (String)"FSADataCollectionFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        model.deleteEntryRows("datacolsrcfilter", selected);
        this.getView().updateView("datacolsrcfilter");
    }

    private void addCompoundField(CombFiledModel returnModel) {
        int newIndex = this.getModel().createNewEntryRow("dataentryentity");
        this.getModel().setValue("dimname", (Object)returnModel.getCombFiledName(), newIndex);
        this.getModel().setValue("dimnumber", (Object)returnModel.getCombFiledNumber(), newIndex);
        this.getModel().setValue("srcnumber", (Object)returnModel.getCombFiledNumber(), newIndex);
        this.getModel().setValue("fieldcreatetype", (Object)FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString(), newIndex);
        this.getModel().setValue("dimtype", (Object)FSADimensionTypeEnum.MEASURE_DIM.getCodeString(), newIndex);
        this.getModel().setValue("dimdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), newIndex);
        this.getModel().setValue("dimid", (Object)returnModel.getCombinationId(), newIndex);
        this.getView().setEnable(Boolean.FALSE, newIndex, new String[]{"dimtype", "dimdatatype"});
    }

    private int addField(DynamicObject datacolsrcfilter) {
        IDataModel model = this.getModel();
        int newIndex = model.createNewEntryRow("dataentryentity");
        IPageCache pageCache = this.getView().getPageCache();
        String srcName = datacolsrcfilter.getString("srcdimname");
        String srcnumber = datacolsrcfilter.getString("srcdimnumber");
        model.setValue("dimname", (Object)srcName, newIndex);
        model.setValue("srcname", (Object)srcName, newIndex);
        model.setValue("dimnumber", (Object)srcnumber, newIndex);
        model.setValue("srcnumber", (Object)srcnumber, newIndex);
        model.setValue("fieldcreatetype", (Object)FSAFieldTypeEnum.SOURCE_FIELD.getCodeString(), newIndex);
        String dimType = datacolsrcfilter.getString("srcdimtype");
        String dimDataType = datacolsrcfilter.getString("srcdimdatatype");
        model.setValue("dimtype", (Object)dimType, newIndex);
        if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType)) {
            model.setValue("dimdatatype", (Object)FSADataTypeEnum.FLOAT_TYPE.getCodeString(), newIndex);
        } else {
            model.setValue("dimdatatype", (Object)dimDataType, newIndex);
        }
        pageCache.put(CACHE_DEFAULT_NUMBER_ + srcnumber, datacolsrcfilter.getString("srcdimdefault"));
        pageCache.put(CACHE_DEFAULT_NAME_ + srcnumber, datacolsrcfilter.getString("srcdimnamedefault"));
        pageCache.put(CACHE_DIM_TYPE_ + srcnumber, dimType);
        pageCache.put(CACHE_DIM_DATA_TYPE_ + srcnumber, dimDataType);
        model.setValue("dimid", (Object)pageCache.get(CACHE_DIM_ID_ + srcnumber), newIndex);
        this.getView().setEnable(Boolean.FALSE, newIndex, new String[]{"dimdatatype"});
        return newIndex;
    }

    private void deleteField(List<DynamicObject> dynamicObjects) {
        ArrayList<Long> willRemoveCombIds = new ArrayList<Long>(16);
        IDataModel model = this.getModel();
        JSONObject jsonObject = (JSONObject)JSONObject.parse((String)((String)model.getValue("paramsrc_tag")));
        if (jsonObject == null) {
            return;
        }
        Long moduleId = jsonObject.getLong("moduleId");
        Long viewId = jsonObject.getLong("OrgView");
        IPageCache pageCache = this.getView().getPageCache();
        String dataSrcType = (String)model.getValue("datasrctype");
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fieldcreatetype = dynamicObject.getString("fieldcreatetype");
            if (fieldcreatetype != null && FSAFieldTypeEnum.getEnum((String)fieldcreatetype) == FSAFieldTypeEnum.SOURCE_FIELD) {
                int newIndex = model.createNewEntryRow("datacolsrcfilter");
                String srcnumber = dynamicObject.getString("srcnumber");
                model.setValue("srcdimnumber", (Object)srcnumber, newIndex);
                if ("bcmParamSource".equals(dataSrcType)) {
                    model.setValue("srcdimname", (Object)pageCache.get(CACHE_DIM_NAME_ + srcnumber), newIndex);
                    Tuple2<String, String> membersTopOne = this.getMembersTopOne(moduleId, viewId, pageCache.get(CACHE_DIM_ENTITY_ + srcnumber), Long.parseLong(pageCache.get(CACHE_DIM_ID_ + srcnumber)), srcnumber);
                    String cacheDefaultName = (String)membersTopOne.t1;
                    String cacheDefaultNumber = (String)membersTopOne.t2;
                    model.setValue("srcdimdatatype", (Object)FSADataTypeEnum.STRING_TYPE.getCodeString(), newIndex);
                    model.setValue("srcdimtype", (Object)FSADimensionTypeEnum.DATA_DIM.getCodeString(), newIndex);
                    model.setValue("srcdimdefault", (Object)cacheDefaultNumber, newIndex);
                    model.setValue("srcdimnamedefault", (Object)cacheDefaultName, newIndex);
                } else if ("fileParamSource".equals(dataSrcType)) {
                    model.setValue("srcdimname", (Object)dynamicObject.getString("srcname"), newIndex);
                    String dimDataType = pageCache.get(CACHE_DIM_DATA_TYPE_ + srcnumber);
                    String dimType = pageCache.get(CACHE_DIM_TYPE_ + srcnumber);
                    model.setValue("srcdimdatatype", (Object)(StringUtils.isEmpty((CharSequence)dimDataType) ? dynamicObject.getString("dimdatatype") : dimDataType), newIndex);
                    model.setValue("srcdimtype", (Object)(StringUtils.isEmpty((CharSequence)dimType) ? dynamicObject.getString("dimtype") : dimType), newIndex);
                    model.setValue("srcdimdefault", (Object)ResManager.loadKDString((String)"\u65e0", (String)"FSADataCollectionFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]), newIndex);
                    model.setValue("srcdimnamedefault", (Object)ResManager.loadKDString((String)"\u65e0", (String)"FSADataCollectionFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]), newIndex);
                }
            }
            if (fieldcreatetype == null || FSAFieldTypeEnum.getEnum((String)fieldcreatetype) != FSAFieldTypeEnum.COMBINATION_FIELD) continue;
            Long dimid = (Long)dynamicObject.get("dimid");
            willRemoveCombIds.add(dimid);
        }
        DynamicObjectCollection datacolcombfields = model.getEntryEntity("datacolcombfields");
        if (willRemoveCombIds.size() > 0) {
            ArrayList<Integer> willRemoveRows = new ArrayList<Integer>(16);
            ArrayList<CombFiledModel> combFiledModels = new ArrayList<CombFiledModel>(16);
            for (int i = 0; i < datacolcombfields.size(); ++i) {
                CombFiledModel combFiledModel = new CombFiledModel();
                DynamicObject dynamicObject = (DynamicObject)datacolcombfields.get(i);
                combFiledModel.loadFromDynamicObject(dynamicObject);
                combFiledModels.add(combFiledModel);
                if (!willRemoveCombIds.contains(combFiledModel.getCombinationId())) continue;
                willRemoveRows.add(i);
            }
            int[] rowsArray = new int[willRemoveRows.size()];
            for (int i = 0; i < willRemoveRows.size(); ++i) {
                rowsArray[i] = (Integer)willRemoveRows.get(i);
            }
            DynamicObjectCollection dataentryentity = this.getModel().getEntryEntity("dataentryentity");
            List<Long> notRemoveIds = this.getNotRemoveIds(dataentryentity, willRemoveCombIds);
            Set<String> notRemoveSrcNumber = this.getNotRemoveSrcNumber(combFiledModels, notRemoveIds);
            this.getNotExitAndWriteBackSrc(combFiledModels, willRemoveCombIds, notRemoveSrcNumber);
            model.deleteEntryRows("datacolcombfields", rowsArray);
            this.getView().updateView("datacolcombfields");
        }
    }

    public Tuple2<Long, Long> getFromSrcParam() {
        JSONObject jsonObject = (JSONObject)JSONObject.parse((String)((String)this.getModel().getValue("paramsrc_tag")));
        Long moduleId = jsonObject.getLong("moduleId");
        Long viewId = jsonObject.getLong("OrgView");
        return new Tuple2((Object)moduleId, (Object)viewId);
    }

    private void getNotExitAndWriteBackSrc(List<CombFiledModel> combFiledModels, List<Long> willRemoveCombIds, Set<String> notRemoveSrcNumber) {
        int[] addRows;
        List list = combFiledModels.stream().filter(p -> willRemoveCombIds.contains(p.getCombinationId())).flatMap(p -> p.getMemberModels().stream()).filter(p -> !notRemoveSrcNumber.contains(p.getSrcFiledNumber())).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (list.size() > 0) {
            for (MemberModel memberModel : list) {
                if (map.containsKey(memberModel.getSrcFiledNumber())) continue;
                map.put(memberModel.getSrcFiledNumber(), memberModel.getSrcFiledName());
            }
        }
        if (map.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getView().getPageCache();
        Tuple2<Long, Long> fromSrcParam = this.getFromSrcParam();
        Iterator iterator = map.entrySet().iterator();
        for (int addRow : addRows = model.batchCreateNewEntryRow("datacolsrcfilter", map.size())) {
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            model.setValue("srcdimnumber", (Object)key, addRow);
            model.setValue("srcdimname", next.getValue(), addRow);
            model.setValue("srcdimdatatype", (Object)FSADataTypeEnum.STRING_TYPE.getCodeString(), addRow);
            model.setValue("srcdimtype", (Object)FSADimensionTypeEnum.DATA_DIM.getCodeString(), addRow);
            Tuple2<String, String> membersTopOne = this.getMembersTopOne((Long)fromSrcParam.t1, (Long)fromSrcParam.t2, pageCache.get(CACHE_DIM_ENTITY_ + key), Long.parseLong(pageCache.get(CACHE_DIM_ID_ + key)), key);
            model.setValue("srcdimdefault", membersTopOne.t2, addRow);
            model.setValue("srcdimnamedefault", membersTopOne.t1, addRow);
        }
    }

    private List<Long> getNotRemoveIds(DynamicObjectCollection dataentryentity, List<Long> willRemoveIds) {
        return dataentryentity.stream().filter(p -> p.getString("fieldcreatetype").equals(FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString())).map(p -> p.getLong("dimid")).filter(p -> !willRemoveIds.contains(p)).collect(Collectors.toList());
    }

    private Set<String> getNotRemoveSrcNumber(List<CombFiledModel> combFiledModels, List<Long> notRemoveIds) {
        return combFiledModels.stream().filter(p -> notRemoveIds.contains(p.getCombinationId())).flatMap(p -> p.getMemberModels().stream().map(q -> q.getSrcFiledNumber())).collect(Collectors.toSet());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object returnData1 = e.getReturnData();
        if (returnData1 == null) {
            return;
        }
        switch (actionId) {
            case "paramsrcselected": {
                DynamicObjectCollection entryEntity;
                Map returnData = (Map)returnData1;
                String oldParamSrcValue = (String)model.getValue("paramsrc_tag");
                String oldParamSrcNameValue = (String)model.getValue("paramsrcname");
                String paramSrc = SerializationUtils.toJsonString((Object)returnData);
                model.setValue("paramsrc_tag", (Object)paramSrc);
                String dataSrcType = (String)model.getValue("datasrctype");
                StringBuilder strB = new StringBuilder();
                DynamicObject entityLoad = FSAParamTemplateHelper.getParamDynamic((String)dataSrcType);
                if (entityLoad != null && (entryEntity = entityLoad.getDynamicObjectCollection("entryentity")) != null && !entryEntity.isEmpty()) {
                    for (DynamicObject entry : entryEntity) {
                        String paramNumber = entry.getString("paramNumber");
                        String name = (String)returnData.get(paramNumber + "name");
                        if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                        if (strB.length() == 0) {
                            strB.append(name);
                            continue;
                        }
                        strB.append(',').append(name);
                    }
                }
                model.setValue("paramsrcname", (Object)strB);
                if (StringUtils.isEmpty((CharSequence)oldParamSrcValue)) {
                    if ("bcmParamSource".equals(dataSrcType)) {
                        this.showDim(paramSrc);
                        break;
                    }
                    this.openOffLineDataPreview(view, dataSrcType);
                    break;
                }
                view.getPageCache().put("paramsrc_tag", oldParamSrcValue);
                view.getPageCache().put("paramsrcname", oldParamSrcNameValue);
                if (!"fileParamSource".equals(dataSrcType)) break;
                IFormView configView = view.getView(this.getPageCache().get("offlinedata_pageid"));
                if (configView != null) {
                    configView.close();
                }
                this.openOffLineDataPreview(view, dataSrcType);
                break;
            }
            case "setparam": {
                Map returnData = (Map)returnData1;
                this.getModel().deleteEntryData("subentryentity");
                for (Map.Entry entry : returnData.entrySet()) {
                    int row = model.createNewEntryRow("subentryentity");
                    model.setValue("paramnumber", entry.getKey(), row);
                    model.setValue("paramvalue", entry.getValue(), row);
                }
                break;
            }
            case "combfieldSelectCallback": {
                this.combfieldSelectCallback(returnData1);
                break;
            }
            case "selectMember": {
                this.selectMemberCallback(returnData1);
                break;
            }
        }
    }

    private void selectMemberCallback(Object returnData) {
        FSAMemberSelectF7Plugin.MemberModel memberModel = (FSAMemberSelectF7Plugin.MemberModel)returnData;
        IDataModel model = this.getModel();
        int writeIndex = model.getEntryCurrentRowIndex("datacolsrcfilter");
        model.setValue("srcdimdefault", (Object)memberModel.getNumber(), writeIndex);
        model.setValue("srcdimnamedefault", (Object)memberModel.getName(), writeIndex);
    }

    private void showDim(String paramSrc) {
        Long moduleId = JSONObject.parseObject((String)paramSrc).getLong("moduleId");
        Map olapServerDimemsionMetaInfoMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        JSONObject json = JSONObject.parseObject((String)((String)model.getValue("paramsrc_tag")));
        Long viewId = json.getLong("OrgView");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("srcdimnumber", new Object[0]);
        vs.addField("srcdimname", new Object[0]);
        vs.addField("srcdimtype", new Object[0]);
        vs.addField("srcdimdatatype", new Object[0]);
        vs.addField("srcdimdefault", new Object[0]);
        vs.addField("srcdimnamedefault", new Object[0]);
        for (Map.Entry entry : olapServerDimemsionMetaInfoMap.entrySet()) {
            OlapServerDimemsionMetaInfo value = (OlapServerDimemsionMetaInfo)entry.getValue();
            Tuple2<String, String> membersTopOne = this.getMembersTopOne(moduleId, viewId, value.getDimEntityName(), value.getId(), value.getNumber());
            vs.addRow(new Object[]{entry.getKey(), value.getName(), FSADimensionTypeEnum.DATA_DIM.getCodeString(), FSADataTypeEnum.STRING_TYPE.getCodeString(), membersTopOne.t2, membersTopOne.t1});
            this.cache(value.getNumber(), value.getId(), value.getName(), value.getDimEntityName());
        }
        model.batchCreateNewEntryRow("datacolsrcfilter", vs);
        model.endInit();
        this.getView().updateView("datacolsrcfilter");
    }

    private void showDimFromFile(FSAFileInfoModel fileInfoModel) {
        List columnList = fileInfoModel.getColumnList();
        List classList = fileInfoModel.getClassList();
        if (columnList == null || columnList.isEmpty() || classList == null || classList.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("datacolsrcfilter");
        dataModel.deleteEntryData("dataentryentity");
        dataModel.deleteEntryData("datacolcombfields");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("srcdimnumber", new Object[0]);
        vs.addField("srcdimname", new Object[0]);
        vs.addField("srcdimdatatype", new Object[0]);
        vs.addField("srcdimtype", new Object[0]);
        vs.addField("srcdimdefault", new Object[0]);
        vs.addField("srcdimnamedefault", new Object[0]);
        int columnIdx = 0;
        for (String column : columnList) {
            String columnNum = column.matches("^\\w+$") && column.length() <= 50 ? column : "field" + (columnIdx + 1);
            String columnName = column.length() <= 50 ? column : columnNum;
            String[] typeArr = this.getSrcType(columnIdx, classList);
            vs.addRow(new Object[]{columnNum, columnName, typeArr[0], typeArr[1], ResManager.loadKDString((String)"\u65e0", (String)"FSADataCollectionFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e0", (String)"FSADataCollectionFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0])});
            ++columnIdx;
        }
        model.batchCreateNewEntryRow("datacolsrcfilter", vs);
        model.endInit();
        this.getView().updateView("datacolsrcfilter");
    }

    private String[] getSrcType(int columnIdx, List<Class> classList) {
        String[] strArr = new String[2];
        if (classList.size() > columnIdx) {
            Class clazz = classList.get(columnIdx);
            if (Date.class.equals((Object)clazz)) {
                strArr[0] = FSADataTypeEnum.DATE_TYPE.getCodeString();
                strArr[1] = FSADimensionTypeEnum.DATE_DIM.getCodeString();
            } else if (Object.class.equals((Object)clazz)) {
                strArr[0] = FSADataTypeEnum.BASICDATA_TYPE.getCodeString();
                strArr[1] = FSADimensionTypeEnum.DATA_DIM.getCodeString();
            } else if (Long.class.equals((Object)clazz) || Double.class.equals((Object)clazz) || BigInteger.class.equals((Object)clazz) || BigDecimal.class.equals((Object)clazz)) {
                strArr[0] = FSADataTypeEnum.FLOAT_TYPE.getCodeString();
                strArr[1] = FSADimensionTypeEnum.MEASURE_DIM.getCodeString();
            } else if (Integer.class.equals((Object)clazz)) {
                strArr[0] = FSADataTypeEnum.INTEGER_TYPE.getCodeString();
                strArr[1] = FSADimensionTypeEnum.MEASURE_DIM.getCodeString();
            } else {
                strArr[0] = FSADataTypeEnum.STRING_TYPE.getCodeString();
                strArr[1] = FSADimensionTypeEnum.DATA_DIM.getCodeString();
            }
        }
        return strArr;
    }

    private Tuple2<String, String> getMembersTopOne(Long moduleId, Long viewId, String entity, Long dimid, String dimnumber) {
        IPageCache pageCache = this.getView().getPageCache();
        String filterNumber = pageCache.get(CACHE_DEFAULT_NUMBER_ + moduleId + dimnumber);
        String filterName = pageCache.get(CACHE_DEFAULT_NAME_ + moduleId + dimnumber);
        if (StringUtils.isNotEmpty((CharSequence)filterNumber) && StringUtils.isNotEmpty((CharSequence)filterName)) {
            return new Tuple2((Object)filterName, (Object)filterNumber);
        }
        OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = FSABcmDataProvider.loadDimensionMembersTopOne((Long)moduleId, (Long)viewId, (String)entity, (Long)dimid, (String)dimnumber);
        if (olapServerDimMemberMetaInfo != null) {
            filterName = olapServerDimMemberMetaInfo.getName();
            filterNumber = olapServerDimMemberMetaInfo.getNumber();
        }
        pageCache.put(CACHE_DEFAULT_NAME_ + moduleId + dimnumber, filterName);
        pageCache.put(CACHE_DEFAULT_NUMBER_ + moduleId + dimnumber, filterNumber);
        return new Tuple2((Object)filterName, (Object)filterNumber);
    }

    private void showDimEdit(Long moduleId) {
        IDataModel model = this.getModel();
        Map olapServerDimemsionMetaInfoMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
        Iterator iterator = olapServerDimemsionMetaInfoMap.entrySet().iterator();
        DynamicObjectCollection datacolsrcfilter = model.getEntryEntity("datacolsrcfilter");
        HashMap<String, Integer> numberRowMap = new HashMap<String, Integer>(10);
        for (int i = 0; i < datacolsrcfilter.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)datacolsrcfilter.get(i);
            String srcdimnumber = dynamicObject.getString("srcdimnumber");
            numberRowMap.put(srcdimnumber, i);
        }
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String number = (String)next.getKey();
            OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo = (OlapServerDimemsionMetaInfo)next.getValue();
            Integer rowIndex = (Integer)numberRowMap.get(number);
            if (rowIndex != null) {
                model.setValue("srcdimname", (Object)olapServerDimemsionMetaInfo.getName(), rowIndex.intValue());
                model.setValue("srcdimtype", (Object)FSADimensionTypeEnum.DATA_DIM.getCodeString(), rowIndex.intValue());
                model.setValue("srcdimdatatype", (Object)FSADataTypeEnum.STRING_TYPE.getCodeString(), rowIndex.intValue());
            }
            this.cache(number, olapServerDimemsionMetaInfo.getId(), olapServerDimemsionMetaInfo.getName(), olapServerDimemsionMetaInfo.getDimEntityName());
        }
    }

    private void cache(String key, Long id, String name, String entityName) {
        this.getPageCache().put(CACHE_DIM_ID_ + key, String.valueOf(id));
        this.getPageCache().put(CACHE_DIM_NAME_ + key, name);
        this.getPageCache().put(CACHE_DIM_ENTITY_ + key, entityName);
    }

    private void editDataEntryEntityInit() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection dataentryentity = model.getEntryEntity("dataentryentity");
        for (int i = 0; i < dataentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dataentryentity.get(i);
            String fieldcreatetype = dynamicObject.getString("fieldcreatetype");
            if (FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString().equals(fieldcreatetype)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"dimtype", "dimdatatype"});
            }
            this.getModel().setValue("dimsetup", (Object)"\u8bbe\u7f6e", i);
        }
        if (this.beyy || this.checkHasMeasure(false)) {
            view.setEnable(Boolean.FALSE, new String[]{"createcombfield"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"createcombfield"});
        }
        String dataSrcType = (String)model.getValue("datasrctype");
        if ("bcmParamSource".equals(dataSrcType)) {
            view.setVisible(Boolean.TRUE, new String[]{"updatemeasure"});
        } else if ("fileParamSource".equals(dataSrcType)) {
            view.setVisible(Boolean.FALSE, new String[]{"updatemeasure"});
        }
    }

    private void editDatacolsrcfilterInit() {
        IDataModel model = this.getModel();
        String dataSrcType = (String)model.getValue("datasrctype");
        if ("fileParamSource".equals(dataSrcType)) {
            return;
        }
        String paramsrc = (String)model.getValue("paramsrc_tag");
        if (StringUtils.isNotEmpty((CharSequence)paramsrc)) {
            JSONObject parser = (JSONObject)JSONObject.parse((String)paramsrc);
            Long moudleId = (Long)parser.get((Object)"moduleId");
            this.showDimEdit(moudleId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (hyperLinkClickEvent.getFieldName().equals("dimsetup")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            DynamicObjectCollection subentryentity = this.getModel().getEntryEntity("subentryentity");
            for (DynamicObject row : subentryentity) {
                params.put(row.getString("paramnumber"), row.getString("paramvalue"));
            }
            params.put("pageType", FSAParamTemplateCatelogEnum.COMBINATION_PARAM);
            params.put("isQuote", this.checkQuote());
            params.put("createtype", this.getModel().getValue("fieldcreatetype"));
            FSAF7Util f7 = new FSAF7Util((AbstractFormPlugin)this, "\u5b57\u6bb5\u53c2\u6570\u8bbe\u7f6e", "setparam", params);
            f7.open("fsa_srcparam_setting");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String saveAndNewCache = this.getView().getPageCache().get("SaveAndNew");
        if (operate instanceof New && StringUtils.isNotEmpty((CharSequence)saveAndNewCache)) {
            args.setCancel(true);
        } else if (operate instanceof SaveAndNew) {
            this.getPageCache().put("SaveAndNew", "1");
        }
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "saveandnew".equals(operateKey)) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object source = afterDoOperationEventArgs.getSource();
        IFormView view = this.getView();
        if (source instanceof SaveAndNew) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                SaveAndNew save = (SaveAndNew)source;
                String enable = (String)save.getView().getModel().getValue("enable");
                if ("0".equals(enable)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"FSADataCollectionFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CHANGE_ENABLE", (IFormPlugin)this), null, "new");
                } else {
                    this.getPageCache().remove("SaveAndNew");
                }
            }
        } else if (source instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Save save = (Save)source;
            String enable = (String)save.getView().getModel().getValue("enable");
            if ("0".equals(enable)) {
                view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"FSADataCollectionFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CHANGE_ENABLE", (IFormPlugin)this));
            } else {
                this.getPageCache().remove("SaveAndNew");
            }
        }
    }
}

