/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.data.fsa.common.constant.FSAUIConstants;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSAParamTemplateHelper;

public class FSADataCollectionListPlugin
extends AbstractListPlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        DynamicObjectCollection paramCol = FSAParamTemplateHelper.getParamDynamicByGroupId((Long)FSAUIConstants.FID_DATA_COLLECTION);
        if (paramCol != null && paramCol.size() > 0) {
            HashMap<String, String> nameMap = new HashMap<String, String>(paramCol.size());
            for (DynamicObject param : paramCol) {
                nameMap.put(param.getString("number"), param.getString("name"));
            }
            for (DynamicObject data : pageData) {
                String dataSrcType = data.getString("datasrctype");
                data.set("datasrctype", nameMap.get(dataSrcType));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btnclose"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        IFormView view = this.getView();
        String entityId = view.getParentView().getEntityId();
        if ("fsa_syncparam".equals(entityId)) {
            Button btn;
            Object source = evt.getSource();
            if (source instanceof Button && !"btnok".equals((btn = (Button)source).getKey())) {
                return;
            }
            Object focusRowPkId = this.getFocusRowPkId();
            String tips = FSADataCollectionHelper.preJudgeDataCollection((Long)Long.valueOf(String.valueOf(focusRowPkId)));
            if (tips != null) {
                view.showTipNotification(tips);
                evt.setCancel(true);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object focusRowPkId;
        String tips;
        IFormView view = this.getView();
        String entityId = view.getParentView().getEntityId();
        if ("fsa_syncparam".equals(entityId) && (tips = FSADataCollectionHelper.preJudgeDataCollection((Long)Long.valueOf(String.valueOf(focusRowPkId = this.getFocusRowPkId())))) != null) {
            view.showTipNotification(tips);
            args.setCancel(true);
        }
    }
}

