/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillPlugin;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.formplugin.FSABaseFormPlugin;
import kd.data.fsa.formplugin.util.FSACorrectFieldUtil;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;
import kd.data.fsa.model.version.FSADataVersionQueryFilterModel;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSADataSchemeFormPlugin
extends FSABaseFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
IBillPlugin,
ProgresssListener {
    public static final String RETURN_LEVEL_ADJUSTMENT = "RETURN_LEVEL_ADJUSTMENT";
    public static final String RETURN_DATAVERSION = "RETURN_DATAVERSION";
    public static final String RETURN_FETCH_DATA = "RETURN_FETCH_DATA";
    public static final String CHANGE_ENABLE = "changeEnable";
    public static final String OUTPUTFIELD_INDEX = "outputField_index";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid eg = (EntryGrid)this.getControl("data_entry");
        eg.addRowClickListener((RowClickEventListener)this);
        eg = (EntryGrid)this.getControl("output_fields_entry");
        eg.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbar", "data_entry_toolbarap"});
        this.addClickListeners(new String[]{"data_version"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        IFormView view = this.getView();
        view.setEnable(Boolean.TRUE, new String[]{"number", "data_collection"});
        view.setVisible(Boolean.FALSE, new String[]{"progressbarap"});
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", "data_collection"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object dataCollection = model.getValue("data_collection");
        String enable = (String)model.getValue("enable");
        if ("1".equals(enable)) {
            view.setEnable(Boolean.FALSE, new String[]{"data_collection"});
        }
        if (dataCollection != null) {
            Long dataCollectionId = ((DynamicObject)dataCollection).getLong("id");
            String selectField = "id, number, name, tablenumber, tablename";
            QFilter dateFilter = new QFilter("datacollection", "=", (Object)dataCollectionId);
            dateFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection syncParamDynCollection = QueryServiceHelper.query((String)"fsa_syncparam", (String)selectField, (QFilter[])new QFilter[]{dateFilter});
            if (syncParamDynCollection.isEmpty()) {
                model.getEntryEntity("data_entry").clear();
                return;
            }
            LinkedHashSet<Long> newQueryParamIDs = new LinkedHashSet<Long>(10);
            for (DynamicObject dyn : syncParamDynCollection) {
                newQueryParamIDs.add(dyn.getLong("id"));
            }
            ArrayList<Integer> deleteList = new ArrayList<Integer>(10);
            HashSet<Long> exsitingParamIds = new HashSet<Long>(10);
            int idx = 0;
            for (Object dyn : model.getEntryEntity("data_entry")) {
                Long paramId = dyn.getDynamicObject("data_sync_param").getLong("id");
                if (!newQueryParamIDs.contains(paramId)) {
                    deleteList.add(idx);
                } else {
                    exsitingParamIds.add(paramId);
                }
                ++idx;
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            if (!deleteList.isEmpty()) {
                Object dyn;
                Collections.reverse(deleteList);
                dyn = deleteList.iterator();
                while (dyn.hasNext()) {
                    int i = (Integer)dyn.next();
                    model.getEntryEntity("data_entry").remove(i);
                }
            }
            newQueryParamIDs.removeAll(exsitingParamIds);
            LinkedHashMap<Integer, Long> rowParamIdMap = new LinkedHashMap<Integer, Long>(newQueryParamIDs.size());
            for (Long newParamId : newQueryParamIDs) {
                int newEntryRow = model.createNewEntryRow("data_entry");
                model.setValue("data_sync_param", (Object)newParamId, newEntryRow);
                rowParamIdMap.put(newEntryRow, newParamId);
            }
            if (!rowParamIdMap.isEmpty()) {
                this.getPageCache().put("dyn_load_param", FSAJSONUtils.toJsonString(rowParamIdMap));
            }
            abstractModel.endInit();
            view.updateView("data_entry");
            String dataSrcType = ((DynamicObject)dataCollection).getString("datasrctype");
            if ("fileParamSource".equals(dataSrcType)) {
                view.setEnable(Boolean.FALSE, new String[]{"alldata"});
            }
        }
        this.setDataVersion(null);
        model.setEntryCurrentRowIndex("data_entry", 0);
        this.linkageIfHierarchy();
        DynamicObjectCollection entryEntity = model.getEntryEntity("output_fields_entry");
        if (entryEntity != null && entryEntity.isEmpty()) {
            this.refreshOutputFieldList(0);
        }
        model.setDataChanged(false);
    }

    private void setDataVersion(Integer row) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (row == null) {
            int entryRowCount = model.getEntryRowCount("data_entry");
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            block0: for (int i = 0; i < entryRowCount; ++i) {
                FSADataVersionQueryFilterModel versionQueryFilterModel;
                DynamicObject dyn = model.getEntryRowEntity("data_entry", i);
                long syncParamId = dyn.getDynamicObject("data_sync_param").getLong("id");
                List versionList = FSADataversionUtils.getEnableVersion((long)syncParamId, null, (boolean)false);
                String disableVersions = (String)dyn.get("disable_versions_tag");
                if (versionList == null || versionList.size() <= 0) continue;
                if (StringUtils.isNotEmpty((String)disableVersions) && (versionQueryFilterModel = (FSADataVersionQueryFilterModel)FSAJSONUtils.cast((String)disableVersions, FSADataVersionQueryFilterModel.class)) != null) {
                    Set disableVersionSet = versionQueryFilterModel.getBanVersionSet();
                    if (disableVersionSet != null && disableVersionSet.size() > 0) {
                        for (int j = 0; j < versionList.size(); ++j) {
                            Long version = (Long)versionList.get(j);
                            if (disableVersionSet.contains(version)) continue;
                            dyn.set("data_version", versionList.get(j));
                            continue block0;
                        }
                        continue;
                    }
                    dyn.set("data_version", versionList.get(0));
                    continue;
                }
                dyn.set("data_version", versionList.get(0));
            }
            abstractModel.endInit();
        } else {
            DynamicObject entryRowEntity = model.getEntryRowEntity("data_entry", row.intValue());
            entryRowEntity.set("data_version", (Object)"");
            long syncParamId = entryRowEntity.getDynamicObject("data_sync_param").getLong("id");
            List versionList = FSADataversionUtils.getEnableVersion((long)syncParamId, null, (boolean)false);
            String disableVersions = (String)entryRowEntity.get("disable_versions_tag");
            Set disableVersionSet = null;
            if (StringUtils.isNotEmpty((String)disableVersions)) {
                FSADataVersionQueryFilterModel versionQueryFilterModel = (FSADataVersionQueryFilterModel)FSAJSONUtils.cast((String)disableVersions, FSADataVersionQueryFilterModel.class);
                disableVersionSet = versionQueryFilterModel.getBanVersionSet();
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            if (versionList != null && versionList.size() > 0) {
                if (disableVersionSet != null && disableVersionSet.size() > 0) {
                    for (int i = 0; i < versionList.size(); ++i) {
                        Long version = (Long)versionList.get(i);
                        if (disableVersionSet.contains(version)) continue;
                        entryRowEntity.set("data_version", versionList.get(i));
                        break;
                    }
                } else {
                    entryRowEntity.set("data_version", versionList.get(0));
                }
            }
            abstractModel.endInit();
        }
        view.updateView("data_entry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propName = e.getProperty().getName()) {
            case "data_collection": {
                if (!"1".equals(this.getPageCache().get("restoreBySystem"))) {
                    Object oldValue = e.getChangeSet()[0].getOldValue();
                    if (oldValue != null) {
                        Long dataCollectionId = ((DynamicObject)oldValue).getLong("id");
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6570\u636e\u96c6\u5408\uff0c\u5c06\u6e05\u7a7a\u6570\u636e\u96c6\u5408\u5c55\u793a\u8f93\u51fa\u8bbe\u7f6e\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"FSADataSchemeFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("data_collection", (IFormPlugin)this), null, dataCollectionId.toString());
                    } else {
                        this.showData();
                    }
                }
                this.getPageCache().remove("restoreBySystem");
                this.getPageCache().remove("dyn_load_param");
                Object dataCollection = model.getValue("data_collection");
                String dataSrcType = ((DynamicObject)dataCollection).getString("datasrctype");
                if (!"fileParamSource".equals(dataSrcType)) break;
                view.setEnable(Boolean.FALSE, new String[]{"alldata"});
                break;
            }
            case "if_output_hierarchy": {
                String ifHierarchy = (Boolean)model.getValue("if_output_hierarchy") != false ? "1" : "0";
                int entryRowCount = model.getEntryRowCount("output_fields_entry");
                for (int i = 0; i < entryRowCount; ++i) {
                    String dimNumber = (String)model.getValue("dim_type", i);
                    if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimNumber) || FSADimensionTypeEnum.DATE_DIM.getCodeString().equals(dimNumber)) continue;
                    model.setValue("if_hierarchy", (Object)ifHierarchy, i);
                }
                if ("1".equals(ifHierarchy)) {
                    this.getPageCache().put("page_cache_if_hierarchy" + this.getModel().getEntryCurrentRowIndex("data_entry"), "true");
                    break;
                }
                this.getPageCache().remove("page_cache_if_hierarchy" + this.getModel().getEntryCurrentRowIndex("data_entry"));
                break;
            }
            case "alldata": {
                int entryRowCount = model.getEntryRowCount("data_entry");
                if (entryRowCount == 0) break;
                int entryCurrentRowIndex = model.getEntryCurrentRowIndex("data_entry");
                EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
                if (entryGrid.getSelectRows().length == 0) break;
                model.setValue("export_alldata", model.getValue("alldata"), entryCurrentRowIndex);
                break;
            }
        }
    }

    private void showData() {
        IDataModel model = this.getModel();
        DynamicObject dataCollection = (DynamicObject)model.getValue("data_collection");
        long dataCollectionId = dataCollection.getLong("id");
        String selectField = "id, number, name, tablename, tablenumber";
        QFilter dateFilter = new QFilter("datacollection", "=", (Object)dataCollectionId);
        dateFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection syncParamDynCollection = QueryServiceHelper.query((String)"fsa_syncparam", (String)selectField, (QFilter[])new QFilter[]{dateFilter}, (String)"createtime desc");
        model.deleteEntryData("data_entry");
        for (DynamicObject syncDynObj : syncParamDynCollection) {
            int dataEntryRow = model.createNewEntryRow("data_entry");
            model.setValue("data_sync_param", (Object)syncDynObj.getString("id"), dataEntryRow);
        }
        this.setDataVersion(null);
        model.setEntryCurrentRowIndex("data_entry", 0);
        this.refreshOutputFieldList(0);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (evt.getActionId()) {
            case "RETURN_FETCH_DATA": {
                if (returnData == null) break;
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                StringBuilder dataVersionBuilder = new StringBuilder();
                EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
                for (DynamicObject dataEntity : entryGrid.getEntryData().getDataEntitys()) {
                    String dataVersion = dataEntity.getString("data_version");
                    dataVersionBuilder.append(dataVersion).append('|');
                }
                this.getPageCache().put("page_cache_all_dataversion", dataVersionBuilder.toString());
                bar.start();
                break;
            }
            case "RETURN_DATAVERSION": {
                if (returnData == null) {
                    int currentRow = model.getEntryCurrentRowIndex("data_entry");
                    this.setDataVersion(currentRow);
                    return;
                }
                String dataVersionFilters = this.getPageCache().get("cache_data_version_filter");
                HashMap<Long, String> dataVersionFilterMap = StringUtils.isNotEmpty((String)dataVersionFilters) ? (HashMap<Long, String>)FSAJSONUtils.cast((String)dataVersionFilters, Map.class) : new HashMap<Long, String>(10);
                int entryCurrentRowIndex = model.getEntryCurrentRowIndex("data_entry");
                String dataVersionModel = (String)returnData;
                if (StringUtils.isNotEmpty((String)dataVersionModel)) {
                    FSADataVersionQueryFilterModel dataVersionSetModel = (FSADataVersionQueryFilterModel)FSAJSONUtils.cast((String)dataVersionModel, FSADataVersionQueryFilterModel.class);
                    if (dataVersionSetModel != null && dataVersionSetModel.getUseLatestVersion().booleanValue()) {
                        model.setValue("use_latest_version", (Object)1, entryCurrentRowIndex);
                    } else {
                        model.setValue("use_latest_version", (Object)0, entryCurrentRowIndex);
                    }
                }
                model.setValue("disable_versions_tag", (Object)dataVersionModel, entryCurrentRowIndex);
                String row = this.getPageCache().get("data_version_row");
                int selectRow = Integer.parseInt(row);
                this.setDataVersion(selectRow);
                model.setEntryCurrentRowIndex("data_entry", selectRow);
                Long syncParamId = ((DynamicObject)model.getValue("data_sync_param", selectRow)).getLong("id");
                dataVersionFilterMap.put(syncParamId, dataVersionModel);
                this.getPageCache().put("cache_data_version_filter", FSAJSONUtils.toJsonString(dataVersionFilterMap));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String saveAndNewCache = this.getPageCache().get("SaveAndNew");
        if (source instanceof Save && "saveandqing".equals(((Save)source).getOperateKey())) {
            if (StringUtils.isNotEmpty((String)FSADataCollectionHelper.preJudgeDataCollection((Long)((Long)this.getModel().getValue("data_collection_id"))))) {
                args.setCancel(true);
                return;
            }
            Long schemeId = (Long)model.getValue("id");
            if (schemeId.equals(0L)) {
                args.setCancel(true);
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntry = (DynamicObject)model.getEntryEntity("data_entry").get(selectRows[0]);
            String tableNumber = dataEntry.getDynamicObject("data_sync_param").getString("tablenumber");
            String dataVersion = dataEntry.getString("data_version");
            if (StringUtils.isEmpty((String)tableNumber) || StringUtils.isEmpty((String)dataVersion)) {
                args.setCancel(true);
                return;
            }
            String enable = (String)model.getValue("enable");
            if ("0".equals(enable)) {
                args.setCancel(true);
                return;
            }
        }
        if (source instanceof New && StringUtils.isNotEmpty((String)saveAndNewCache)) {
            args.setCancel(true);
            return;
        }
        if (source instanceof SaveAndNew) {
            this.getPageCache().put("SaveAndNew", "1");
        }
        if (source instanceof Save) {
            String dynLoadParamString;
            Map dataVersionFilterMap;
            Long shcemeId = (Long)model.getValue("id");
            String dataVersionFilter = this.getPageCache().get("cache_data_version_filter");
            if (StringUtils.isNotEmpty((String)dataVersionFilter) && (dataVersionFilterMap = (Map)FSAJSONUtils.cast((String)dataVersionFilter, Map.class)) != null && dataVersionFilterMap.size() > 0) {
                for (Map.Entry dataVersions : dataVersionFilterMap.entrySet()) {
                    FSADataCacheMgr.instance.getFSADataVersionQueryFilterCacheService().updataFSADataVersionQueryFilterCacheService(shcemeId, (Long)dataVersions.getKey(), (String)dataVersions.getValue());
                }
            }
            if (StringUtils.isNotEmpty((String)(dynLoadParamString = this.getPageCache().get("dyn_load_param")))) {
                int entryCurrentRowIndex = model.getEntryCurrentRowIndex("data_entry");
                HashMap rowParamMap = (HashMap)FSAJSONUtils.cast((String)dynLoadParamString, HashMap.class);
                AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                abstractModel.beginInit();
                if (rowParamMap != null && rowParamMap.size() > 0) {
                    int entryRowCnt = model.getEntryRowCount("data_entry");
                    for (int i = 1; i <= rowParamMap.size(); ++i) {
                        model.deleteEntryRow("data_entry", entryRowCnt - i);
                    }
                    int rowSize = rowParamMap.size();
                    for (int i = 0; i < rowSize; ++i) {
                        int newEntryRow = model.createNewEntryRow("data_entry");
                        model.setValue("data_sync_param", rowParamMap.get(newEntryRow), newEntryRow);
                    }
                    this.getPageCache().remove("dyn_load_param");
                }
                abstractModel.endInit();
                view.updateView("data_entry");
                this.setDataVersion(null);
                model.setEntryCurrentRowIndex("data_entry", entryCurrentRowIndex);
                this.refreshOutputFieldList(0);
                view.updateView("output_fields_entry");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String enable = (String)model.getValue("enable");
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (afterDoOperationEventArgs.getSource() instanceof SaveAndNew && "0".equals(enable)) {
                view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"FSADataSchemeFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CHANGE_ENABLE, (IFormPlugin)this), null, "new");
            } else if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && "0".equals(enable)) {
                view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"FSADataSchemeFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CHANGE_ENABLE, (IFormPlugin)this));
            } else {
                this.getPageCache().remove("SaveAndNew");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String actionId = mbce.getCallBackId();
        if (CHANGE_ENABLE.equals(actionId)) {
            String operaValue;
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                DynamicObject analySchemeDynObj = BusinessDataReader.loadSingle((Object)this.getModel().getValue("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_data_scheme"));
                model.setValue("enable", (Object)"1");
                analySchemeDynObj.set("enable", (Object)"1");
                Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{analySchemeDynObj});
                if (result != null && "1".equalsIgnoreCase(((DynamicObject)result[0]).getString("enable"))) {
                    model.setValue("enable", (Object)"1");
                    model.setDataChanged(false);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f", (String)"FSADataSchemeFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.isNotEmpty((String)(operaValue = mbce.getCustomVaule()))) {
                this.getPageCache().remove("SaveAndNew");
                view.invokeOperation(operaValue);
            }
        } else if ("data_collection".equalsIgnoreCase(actionId)) {
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                this.getPageCache().remove("restoreBySystem");
                this.showData();
            } else {
                this.getPageCache().put("restoreBySystem", "1");
                model.setValue("data_collection", (Object)mbce.getCustomVaule());
            }
        } else if ("callbackSaveSchema".equalsIgnoreCase(actionId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            view.invokeOperation("save");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.refreshOutputFieldList(this.getModel().getEntryRowCount("output_fields_entry"));
    }

    protected void refreshOutputFieldList(int outputFieldsRow) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (model.getEntryEntity("output_fields_entry") == null) {
            return;
        }
        if (outputFieldsRow == 0) {
            model.getEntryEntity("output_fields_entry").clear();
            String ifHierarchy = StringUtils.isEmpty((String)this.getPageCache().get("page_cache_if_hierarchy" + model.getEntryCurrentRowIndex("data_entry"))) ? "0" : "1";
            model.setValue("if_output_hierarchy", (Object)"1".equals(ifHierarchy));
            DynamicObject dataCollection = (DynamicObject)model.getValue("data_collection");
            DynamicObjectCollection dataentryDynCol = dataCollection.getDynamicObjectCollection("dataentryentity");
            for (DynamicObject dataEntry : dataentryDynCol) {
                String dimType = dataEntry.getString("dimtype");
                String srcNumber = dataEntry.getString("srcnumber");
                int outputFieldRow = model.createNewEntryRow("output_fields_entry");
                model.setValue("dim_name", (Object)dataEntry.getString("dimname"), outputFieldRow);
                model.setValue("dim_number", (Object)dataEntry.getString("dimnumber"), outputFieldRow);
                model.setValue("dim_type", (Object)dimType, outputFieldRow);
                model.setValue("src_number", (Object)srcNumber, outputFieldRow);
                if ("2".equals(dimType) || StringUtils.isEmpty((String)srcNumber)) {
                    view.setEnable(Boolean.FALSE, outputFieldRow, new String[]{"if_hierarchy"});
                }
                if (!"1".equals(dimType)) continue;
                model.setValue("if_hierarchy", (Object)ifHierarchy, outputFieldRow);
            }
        } else {
            this.linkageIfHierarchy();
            for (int i = 0; i < outputFieldsRow; ++i) {
                String dimType = (String)model.getValue("dim_type", i);
                String srcNumber = (String)model.getValue("src_number", i);
                if (!dimType.equals("2") && !StringUtils.isEmpty((String)srcNumber)) continue;
                view.setEnable(Boolean.FALSE, i, new String[]{"if_hierarchy"});
            }
        }
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("data_entry");
        model.setValue("alldata", model.getValue("export_alldata", entryCurrentRowIndex));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy = evt.getItemKey();
        if (operationKy.equalsIgnoreCase("bar_close")) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object sourceFlag = view.getFormShowParameter().getCustomParam("easyModeSource");
        boolean easyModeSource = sourceFlag != null && (Boolean)sourceFlag != false;
        boolean easySourceAndHasPermission = easyModeSource && this.hasEasyModePermission();
        DynamicObject dataCollection = (DynamicObject)model.getValue("data_collection");
        Long schemeId = (Long)model.getValue("id");
        if (schemeId.equals(0L) && !operationKy.equalsIgnoreCase("saveandnew") && !operationKy.equalsIgnoreCase("bar_save")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u65b9\u6848\u4fe1\u606f\u3002", (String)"FSADataSchemeFormPlugin_12", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
        switch (operationKy) {
            case "check_data": {
                if (!(!easyModeSource && FSAPermissionUtil.hasSpecificPerm(view, "fsa_data_scheme", "2/F14J2MUC/+").booleanValue() || easySourceAndHasPermission)) {
                    return;
                }
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u53ef\u7528\u6570\u636e\u3002", (String)"FSADataSchemeFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                int selectRow = selectRows[0];
                DynamicObject syncParam = (DynamicObject)model.getValue("data_sync_param", selectRow);
                Long syncParamId = syncParam.getLong("id");
                String tableNumber = syncParam.getString("tablenumber");
                String tableName = syncParam.getString("tablename");
                if (StringUtils.isNotEmpty((String)tableNumber)) {
                    String disableVersions = (String)model.getValue("disable_versions_tag", selectRow);
                    this.checkData(FSACommonConstant.buildEntityName((String)tableNumber), tableName, syncParamId, disableVersions);
                    break;
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u53c2\u6570\u6ca1\u6709\u7ed1\u5b9a\u5bf9\u5e94\u7684\u6570\u636e\u8868\u3002", (String)"FSADataSchemeFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                view.updateView("data_entry");
                break;
            }
            case "qing_provider": {
                if (!(!easyModeSource && FSAPermissionUtil.hasSpecificPerm(view, "fsa_data_scheme", "2/F17MFH+I8Q").booleanValue() || easySourceAndHasPermission)) {
                    return;
                }
                String enable = (String)model.getValue("enable");
                if ("0".equals(enable)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u65b9\u6848\u3002", (String)"FSADataSchemeFormPlugin_17", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                String tips = FSADataCollectionHelper.preJudgeDataCollection((Long)((Long)this.getModel().getValue("data_collection_id")));
                if (StringUtils.isNotEmpty((String)tips)) {
                    view.showTipNotification(tips);
                    return;
                }
                String dataSrcType = dataCollection.getString("datasrctype");
                if (!"bcmParamSource".equalsIgnoreCase(dataSrcType)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u79bb\u7ebf\u6570\u636e\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u8f7b\u5206\u6790\u770b\u677f\u3002", (String)"FSADataSchemeFormPlugin_19", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.redirectToQing();
                break;
            }
            case "fetch_data": {
                String tips = FSADataCollectionHelper.preJudgeDataCollection((Long)((Long)this.getModel().getValue("data_collection_id")));
                if (StringUtils.isNotEmpty((String)tips)) {
                    view.showTipNotification(tips);
                    return;
                }
                if (!(!easyModeSource && FSAPermissionUtil.hasSpecificPerm(view, "fsa_data_scheme", "2/F11GP8ZICX").booleanValue() || easySourceAndHasPermission)) {
                    return;
                }
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u53ef\u7528\u6570\u636e\u3002", (String)"FSADataSchemeFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                int selectRow = selectRows[0];
                DynamicObject syncParam = (DynamicObject)model.getValue("data_sync_param", selectRow);
                Long syncParamId = syncParam.getLong("id");
                FormShowParameter formShow = new FormShowParameter();
                formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RETURN_FETCH_DATA));
                formShow.setFormId("fsa_syncparamtask");
                formShow.getOpenStyle().setShowType(ShowType.Modal);
                formShow.getCustomParams().put("syncparam_id", syncParamId);
                view.showForm(formShow);
                break;
            }
            case "refresh_entry": {
                this.timerRefresh();
                break;
            }
        }
    }

    private void checkData(String number, String tableName, Long syncParamId, String disableVersions) {
        FSACorrectFieldUtil.correctFieldIfMissed(number, tableName);
        IFormView view = this.getView();
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId("fsa_dynamicdatapreview");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        rsp.setCustomParam("number", (Object)number);
        rsp.setCustomParam("rptdatasyncparam", (Object)syncParamId);
        rsp.setCustomParam("alldata", this.getModel().getValue("alldata"));
        if (StringUtils.isEmpty((String)disableVersions)) {
            rsp.setCustomParam("disable_versions", null);
            rsp.setCustomParam("use_latest_version", (Object)Boolean.TRUE);
        } else {
            FSADataVersionQueryFilterModel versionQueryFilterModel = (FSADataVersionQueryFilterModel)FSAJSONUtils.cast((String)disableVersions, FSADataVersionQueryFilterModel.class);
            Set disableVersionSet = versionQueryFilterModel.getBanVersionSet();
            Boolean useLastVersion = versionQueryFilterModel.getUseLatestVersion();
            rsp.setCustomParam("disable_versions", (Object)disableVersionSet);
            rsp.setCustomParam("use_latest_version", (Object)useLastVersion);
        }
        ArrayList<String> taskType = new ArrayList<String>(3);
        taskType.add(String.valueOf(FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task.getValue()));
        taskType.add(String.valueOf(FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task.getValue()));
        taskType.add(String.valueOf(FSAWorkTaskTypeEnum.File_Upload_Data_Task.getValue()));
        QFilter filter = new QFilter("rptdatasyncparam", "=", (Object)syncParamId).and("tasktype", "in", taskType).and("status", "=", (Object)FSAStatusEnum.PROCESSING.getCodeString());
        DynamicObjectCollection col = QueryServiceHelper.query((String)"fsa_rptdata_synctask", (String)"id,version", (QFilter[])filter.toArray(), (String)"createtime desc", (int)1);
        if (col != null && !col.isEmpty()) {
            DynamicObject dyObj = (DynamicObject)col.get(0);
            rsp.setCustomParam("datasynctask", (Object)dyObj.getLong("id"));
            rsp.setCustomParam("version", (Object)dyObj.getString("version"));
        }
        rsp.setParentFormId(view.getFormShowParameter().getFormId());
        view.showForm((FormShowParameter)rsp);
    }

    private void redirectToQing() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long schemeId = (Long)model.getValue("id");
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u53ef\u7528\u6570\u636e\u3002", (String)"FSADataSchemeFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject syncParam = ((DynamicObject)model.getEntryEntity("data_entry").get(selectRows[0])).getDynamicObject("data_sync_param");
        long syncParamId = syncParam.getLong("id");
        DynamicObject dataEntry = (DynamicObject)model.getEntryEntity("data_entry").get(selectRows[0]);
        String tableNumber = dataEntry.getDynamicObject("data_sync_param").getString("tablenumber");
        String dataVersion = dataEntry.getString("data_version");
        if (StringUtils.isEmpty((String)tableNumber)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u53ef\u7528\u540c\u6b65\u53c2\u6570\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e\u8868\u3002", (String)"FSADataSchemeFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            view.updateView("data_entry");
            return;
        }
        if (StringUtils.isEmpty((String)dataVersion)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u540c\u6b65\u53c2\u6570\u672a\u53d6\u6570\u6216\u6570\u636e\u7248\u672c\u90fd\u5df2\u88ab\u7981\u7528\u3002", (String)"FSADataSchemeFormPlugin_18", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            view.updateView("data_entry");
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        String paramStr = schemeId + "&&" + syncParamId;
        fsp.setFormId("fsa_rptfacts_qing");
        fsp.setCustomParam("cacheParam.", (Object)paramStr);
        fsp.setCaption(tableNumber);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setHasRight(FSAPermissionUtil.hasSpecificPerm("fsa_easy_mode", "23TJUJAFMP3U").booleanValue());
        view.showForm(fsp);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "data_version": {
                int entryCurrIndex = model.getEntryCurrentRowIndex("data_entry");
                this.getPageCache().put("data_version_row", String.valueOf(entryCurrIndex));
                Object disableVersions = model.getValue("disable_versions_tag", entryCurrIndex);
                DynamicObject syncParam = (DynamicObject)model.getValue("data_sync_param", entryCurrIndex);
                Long syncParamId = syncParam.getLong("id");
                String tableNumber = syncParam.getString("tablenumber");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("FSA_HISTORY_DATA_SYNCTASK");
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RETURN_DATAVERSION));
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("disable_versions", disableVersions);
                fsp.setCustomParam("data_sync_param", (Object)syncParamId);
                fsp.setCustomParam("tablenumber", (Object)tableNumber);
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        this.timerRefresh();
    }

    private void timerRefresh() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_entry");
        int[] entryRows = entryGrid.getSelectRows();
        this.setDataVersion(null);
        StringBuilder dataVersionBuilder = new StringBuilder();
        for (DynamicObject dataEntity : entryGrid.getEntryData().getDataEntitys()) {
            String dataVersion = dataEntity.getString("data_version");
            dataVersionBuilder.append(dataVersion).append('|');
        }
        String pageCacheAllDataVersion = this.getPageCache().get("page_cache_all_dataversion");
        if (!dataVersionBuilder.toString().equals(pageCacheAllDataVersion)) {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.stop();
            this.getPageCache().remove("page_cache_all_dataversion");
        }
        if (entryRows.length > 0) {
            this.getModel().setEntryCurrentRowIndex("data_entry", entryRows[0]);
        }
    }

    private void linkageIfHierarchy() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("output_fields_entry");
        if (entryEntity != null && entryEntity.isEmpty()) {
            model.setValue("if_output_hierarchy", (Object)Boolean.FALSE);
        } else {
            int entryRowCount = model.getEntryRowCount("output_fields_entry");
            for (int i = 0; i < entryRowCount; ++i) {
                if (!FSADimensionTypeEnum.DATA_DIM.getCodeString().equals(model.getValue("dim_type", i))) continue;
                String ifHierarchy = (String)model.getValue("if_hierarchy", i);
                model.setValue("if_output_hierarchy", (Object)"1".equals(ifHierarchy));
                break;
            }
        }
    }

    private boolean hasEasyModePermission() {
        return FSAPermissionUtil.hasSpecificPerm("fsa_easy_mode", "23TJUJAFMP3U");
    }
}

