/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.RawDataToDataSetWrapper;

public class FSADynamicDataPreviewPlugin
extends AbstractReportListDataPlugin {
    private LinkedHashMap<String, String[]> columnMap;

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        this.columnMap = (LinkedHashMap)JSONObject.parseObject((String)queryParam.getSortInfo(), (TypeReference)new TypeReference<LinkedHashMap<String, String[]>>(){}, (Feature[])new Feature[0]);
        Map paramMap = (Map)JSONObject.parseObject((String)queryParam.getSortSource(), (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
        String entityName = (String)paramMap.get("entityName");
        String selectFields = (String)paramMap.get("selectFields");
        int pageIndex = Integer.parseInt((String)paramMap.get("pageindex"));
        int pageRows = Integer.parseInt((String)paramMap.get("pagerows"));
        boolean removeDuplicateData = Boolean.parseBoolean((String)paramMap.get("removeDuplicateData"));
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            String dimMembersMapJson = (String)paramMap.get("dimMembersMap");
            Map dimMembersMap = StringUtils.isEmpty((String)dimMembersMapJson) ? null : (Map)JSONObject.parseObject((String)dimMembersMapJson, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){}, (Feature[])new Feature[0]);
            String dimensionSourceNumberMapJson = (String)paramMap.get("dimensionSourceNumberMap");
            Map dimensionSourceNumberMap = (Map)JSONObject.parseObject((String)dimensionSourceNumberMapJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            List rowKeyFieldNames = (List)JSONObject.parseObject((String)((String)paramMap.get("rowKeyFieldNames")), (TypeReference)new TypeReference<ArrayList<String>>(){}, (Feature[])new Feature[0]);
            String[] selectFieldsArr = selectFields.split(",");
            int selectFiledLength = selectFieldsArr.length;
            int startRow = (pageIndex - 1) * pageRows;
            QFilter[] filtersArr = filterInfo.getQFilters().toArray(new QFilter[0]);
            if (!removeDuplicateData) {
                AbstractDataSet ds = (AbstractDataSet)ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), entityName, selectFields, filtersArr, null, startRow, pageRows);
                if (dimMembersMap == null || dimMembersMap.isEmpty()) {
                    return ds;
                }
                LinkedList<Object[]> dimensionDataToNameList = new LinkedList<Object[]>();
                while (ds.hasNext()) {
                    Row row = ds.next();
                    dimensionDataToNameList.add(this.convertNumberToNameOfRowData(selectFiledLength, selectFieldsArr, rowKeyFieldNames, dimMembersMap, dimensionSourceNumberMap, row));
                }
                return new RawDataToDataSetWrapper(entityName, ds, dimensionDataToNameList);
            }
            AbstractDataSet ds = (AbstractDataSet)QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])filtersArr, (String)"version desc");
            if (ds != null) {
                HashSet<String> rowKeyValueSet = new HashSet<String>(pageRows);
                LinkedList<Object[]> srcDataList = new LinkedList<Object[]>();
                while (ds.hasNext() && srcDataList.size() < pageRows) {
                    Row row = ds.next();
                    StringBuilder rowKeyValueBuilder = new StringBuilder();
                    for (String dimensionName : rowKeyFieldNames) {
                        Object dimensionObj = row.get(dimensionName);
                        if (dimensionObj == null) continue;
                        rowKeyValueBuilder.append(',').append(dimensionObj);
                    }
                    if (!rowKeyValueSet.add(rowKeyValueBuilder.substring(1)) || rowKeyValueSet.size() <= startRow) continue;
                    if (dimMembersMap == null || dimMembersMap.isEmpty()) {
                        Object[] objArr = new Object[selectFiledLength];
                        for (int i = 0; i < selectFiledLength; ++i) {
                            objArr[i] = row.get(i);
                        }
                        srcDataList.add(objArr);
                        continue;
                    }
                    srcDataList.add(this.convertNumberToNameOfRowData(selectFiledLength, selectFieldsArr, rowKeyFieldNames, dimMembersMap, dimensionSourceNumberMap, row));
                }
                return new RawDataToDataSetWrapper(entityName, ds, srcDataList);
            }
        }
        return null;
    }

    public Object[] convertNumberToNameOfRowData(int selectFiledLength, String[] selectFieldsArr, List<String> rowKeyFieldNames, Map<String, Map<String, String>> dimMembersMap, Map<String, String> dimensionSourceNumberMap, Row row) {
        Object[] objArr = new Object[selectFiledLength];
        for (int i = 0; i < selectFiledLength; ++i) {
            String key = String.valueOf(row.get(i));
            String field = selectFieldsArr[i];
            if (key != null && rowKeyFieldNames.contains(field)) {
                String membersName;
                String sourceDimensionNumber = dimensionSourceNumberMap.get(field);
                Map<String, String> membersNumberAndNameMap = dimMembersMap.get(sourceDimensionNumber);
                if (membersNumberAndNameMap != null && StringUtils.isNotEmpty((String)(membersName = membersNumberAndNameMap.get(key)))) {
                    objArr[i] = membersName;
                    continue;
                }
                objArr[i] = row.get(i);
                continue;
            }
            objArr[i] = row.get(i);
        }
        return objArr;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if (columns == null) {
            columns = new LinkedList<AbstractReportColumn>();
        }
        if (this.columnMap != null && !this.columnMap.isEmpty()) {
            for (Map.Entry<String, String[]> en : this.columnMap.entrySet()) {
                String columnKey = en.getKey();
                String[] nameAndType = en.getValue();
                ReportColumn column = new ReportColumn();
                column.setCaption(new LocaleString(nameAndType[0]));
                column.setFieldKey(columnKey);
                column.setZeroShow(true);
                if ("version".equalsIgnoreCase(columnKey)) {
                    column.setFieldType("text");
                } else {
                    column.setFieldType(this.getReportDataType(nameAndType[1]));
                }
                columns.add((AbstractReportColumn)column);
            }
        }
        return columns;
    }

    private String getReportDataType(String dataType) {
        switch (dataType) {
            case "0": {
                return "date";
            }
            case "2": {
                return "decimal";
            }
            case "3": {
                return "integer";
            }
            case "4": {
                return "boolean";
            }
            case "5": {
                return "text";
            }
        }
        return "text";
    }
}

