/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.fsa.file.FSAFileReaderFactory;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSADynamicEntryFormPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"refresh"});
    }

    public void beforeBindData(EventObject e) {
        this.updateModelAndGetFileInfo(false);
    }

    public void afterBindData(EventObject e) {
        this.showEntry();
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("refresh".equalsIgnoreCase(key)) {
            this.updateModelAndGetFileInfo(true);
            this.showEntry();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        int preViewRows;
        int preViewStart;
        IDataModel model;
        String sheetName;
        String stepConfig;
        FSAFileInfoModel fileInfoModel;
        FSAFileInfoModel fileDetail;
        super.beforeClosed(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        String modelName = parentModel.getDataEntityType().getName();
        if ("fsa_data_import_wizard".equalsIgnoreCase(modelName) && (fileDetail = this.getFileInfoDetail(fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)(stepConfig = (String)parentModel.getValue("stepconfig", 0)), FSAFileInfoModel.class), sheetName = (String)(model = this.getModel()).getValue("choosesheet"), preViewStart = ((Integer)model.getValue("previewstart")).intValue(), preViewRows = Integer.parseInt((String)model.getValue("previewrows")))) != null) {
            parentModel.setValue("stepconfig", (Object)FSAJSONUtils.toJsonString((Object)fileDetail), 0);
            view.sendFormAction(parentView);
        }
    }

    private void initComboItem(List<String> nameList) {
        if (!CollectionUtils.isEmpty(nameList)) {
            LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
            ComboEdit cb = (ComboEdit)this.getControl("choosesheet");
            for (String name : nameList) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(name));
                item.setValue(name);
                item.setItemVisible(true);
                comboItems.add(item);
            }
            cb.setComboItems(comboItems);
        }
    }

    private FSAFileInfoModel getFileInfoDetail(FSAFileInfoModel fileInfoModel, String chooseSheetName, int previewStart, int previewRows) {
        FSAFileInfoModel detailInfo = FSAFileReaderFactory.getFileReader((String)fileInfoModel.getFileName()).getFileInfoOnSheet(fileInfoModel, chooseSheetName, previewStart, previewRows);
        return detailInfo;
    }

    private void initEntryData(FSAFileInfoModel fileDetailModel) {
        List dataList;
        this.getModel().deleteEntryData("entryentity");
        List headerList = fileDetailModel.getColumnList();
        if (!CollectionUtils.isEmpty((Collection)headerList)) {
            this.createGrid(headerList, "entryentity");
        }
        if (!CollectionUtils.isEmpty((Collection)(dataList = fileDetailModel.getDataList()))) {
            List<List<Object>> dataRowList = this.dataProcess(dataList);
            this.setGridData(headerList, dataRowList, "entryentity");
        }
    }

    private void updateModelAndGetFileInfo(boolean refresh) {
        int preViewRows;
        int preViewStart;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        String modelName = parentModel.getDataEntityType().getName();
        FSAFileInfoModel fileInfoModel = null;
        String sheetName = null;
        if ("fsa_data_collection".equalsIgnoreCase(modelName)) {
            parentView.getPageCache().put("pageCacheTabPageId", view.getPageId());
            String paramJson = (String)parentModel.getValue("paramsrc_tag");
            Map configMap = (Map)FSAJSONUtils.cast((String)paramJson, Map.class);
            if (!CollectionUtils.isEmpty((Map)configMap)) {
                fileInfoModel = (FSAFileInfoModel)JSON.parseObject((String)((String)configMap.get("fileUpload")), (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0]);
                sheetName = (String)configMap.get("selectSheet");
            }
            view.setVisible(Boolean.FALSE, new String[]{"choosesheet"});
        } else if ("fsa_data_import_wizard".equalsIgnoreCase(modelName)) {
            String stepConfig = (String)parentModel.getValue("stepconfig", 0);
            fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)stepConfig, FSAFileInfoModel.class);
        }
        if (fileInfoModel == null) {
            return;
        }
        List nameList = fileInfoModel.getSheetNameList();
        this.initComboItem(nameList);
        if (StringUtils.isEmpty(sheetName)) {
            String string = sheetName = fileInfoModel.getSheetName() == null ? (String)nameList.get(0) : fileInfoModel.getSheetName();
        }
        if (refresh) {
            sheetName = (String)model.getValue("choosesheet");
            preViewStart = (Integer)model.getValue("previewstart");
            preViewRows = Integer.parseInt((String)model.getValue("previewrows"));
        } else {
            preViewStart = fileInfoModel.getTitleRow() == null ? 1 : fileInfoModel.getTitleRow();
            preViewRows = fileInfoModel.getPreviewRow() == null ? 10 : fileInfoModel.getPreviewRow();
            model.setValue("choosesheet", (Object)sheetName);
            model.setValue("previewstart", (Object)preViewStart);
            model.setValue("previewrows", (Object)preViewRows);
        }
        FSAFileInfoModel fileDetail = this.getFileInfoDetail(fileInfoModel, sheetName, preViewStart, preViewRows);
        if (fileDetail != null) {
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            int totalCounts = fileDetail.getDataCount();
            model.setValue("totalrows", (Object)totalCounts);
            model.setValue("pagerows", (Object)Math.min(preViewRows, totalCounts));
            if ("fsa_data_collection".equalsIgnoreCase(modelName)) {
                this.updateFileModelValue(view, parentView, parentModel, preViewStart, preViewRows, fileDetail);
            } else {
                parentModel.setValue("stepconfig", (Object)FSAJSONUtils.toJsonString((Object)fileDetail), 0);
                view.sendFormAction(parentView);
            }
            this.getPageCache().put("fsa_offlinedata_preview", FSAJSONUtils.toJsonString((Object)fileDetail));
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u4e0d\u518d\u5c55\u793a\u9884\u89c8\u5185\u5bb9\u3002", (String)"FSADynamicEntryFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
    }

    private void showEntry() {
        FSAFileInfoModel fileInfoModel;
        String fileModelInfo = this.getPageCache().get("fsa_offlinedata_preview");
        if (StringUtils.isNotEmpty((String)fileModelInfo) && (fileInfoModel = (FSAFileInfoModel)JSON.parseObject((String)fileModelInfo, (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0])) != null) {
            this.initEntryData(fileInfoModel);
        }
    }

    private void updateFileModelValue(IFormView view, IFormView parentView, IDataModel parentModel, int preStart, int preRows, FSAFileInfoModel fileDetail) {
        String paramSrcJson = (String)parentModel.getValue("paramsrc_tag");
        JSONObject jsonObject = JSONObject.parseObject((String)paramSrcJson);
        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)jsonObject.getString("fileUpload"), FSAFileInfoModel.class);
        fileInfoModel.setTitleRow(Integer.valueOf(preStart));
        fileInfoModel.setPreviewRow(Integer.valueOf(preRows));
        fileInfoModel.setSheetName(fileDetail.getSheetName());
        fileInfoModel.setColumnList(fileDetail.getColumnList());
        fileInfoModel.setClassList(fileDetail.getClassList());
        fileInfoModel.setDataCount(fileDetail.getDataCount());
        parentView.getPageCache().put("pageCacheTabValueGetMark", "tabMark");
        HashMap<String, String> paramSrcMap = new HashMap<String, String>(2);
        paramSrcMap.put("fileUpload", FSAJSONUtils.toJsonString((Object)fileInfoModel));
        paramSrcMap.put("fileUploadname", fileInfoModel.getFileName());
        paramSrcMap.put("selectSheet", jsonObject.getString("selectSheet"));
        paramSrcMap.put("selectSheetname", jsonObject.getString("selectSheet"));
        parentModel.setValue("paramsrc_tag", (Object)FSAJSONUtils.toJsonString(paramSrcMap));
        view.sendFormAction(parentView);
    }

    private void createGrid(Collection<String> headersList, String gridKey) {
        HashMap<String, Object> meta = new HashMap<String, Object>(3);
        meta.put("key", gridKey);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>(3);
        args.put("rk", "rk");
        args.put("seq", "fseq");
        args.put("columns", this.createColumns(headersList));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    public List<Map<String, Object>> createColumns(Collection<String> headersList) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(headersList.size() + 2);
        cols.add(FSADynamicEntryFormPlugin.genRKColumn());
        cols.add(FSADynamicEntryFormPlugin.genSeqColumn());
        Iterator<String> colIt = headersList.iterator();
        while (colIt.hasNext()) {
            cols.add(this.createColumn(colIt.next()));
        }
        return cols;
    }

    public Map<String, Object> createColumn(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("header", new LocaleString(key));
        map.put("visible", Boolean.TRUE);
        map.put("dataIndex", key);
        return map;
    }

    private void setGridData(Collection<String> headersList, List<List<Object>> dataRowList, String gridKey) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataindex", this.getDataIndex(headersList));
        data.put("rows", dataRowList);
        data.put("datacount", dataRowList.size());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(gridKey, "data", data);
    }

    private Map<String, Integer> getDataIndex(Collection<String> headersList) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(headersList.size() + 2);
        dataIndex.put("rk", 0);
        dataIndex.put("fseq", 1);
        int i = 0;
        for (String colName : headersList) {
            dataIndex.put(colName, i + 2);
            ++i;
        }
        return dataIndex;
    }

    public static Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("dataIndex", "fseq");
        map.put("header", new LocaleString("seq"));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    public static Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("dataIndex", "rk");
        map.put("header", new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    private List<List<Object>> dataProcess(List<String[]> originData) {
        LinkedList<List<Object>> afterProcess = new LinkedList<List<Object>>();
        for (int i = 0; i < originData.size(); ++i) {
            String[] originRow;
            LinkedList<Object> rowDataProcess = new LinkedList<Object>();
            rowDataProcess.add(i + 1);
            rowDataProcess.add(i + 1);
            for (String val : originRow = originData.get(i)) {
                rowDataProcess.add(val);
            }
            afterProcess.add(rowDataProcess);
        }
        return afterProcess;
    }
}

