/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSAFilterModeEnum;
import kd.data.fsa.formplugin.FSAEasyModelBusFormPlugin;
import kd.data.fsa.formplugin.FSAMemberSelectF7Plugin;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.Template;
import kd.data.fsa.olap.TmplDimPosition;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSAJSONUtils;
import org.apache.commons.lang.StringUtils;

public class FSAEasyModeDimConfigFormPlugin
extends AbstractFormPlugin
implements FSAEasyModelBusFormPlugin.TabStep,
RowClickEventListener {
    @Override
    public void init(FSAEasyModelBusFormPlugin.EasyModelMessage object) {
        if (object instanceof FSAEasyModelBusFormPlugin.EasyModel) {
            FSAEasyModelBusFormPlugin.EasyModel easyModel = (FSAEasyModelBusFormPlugin.EasyModel)object;
            this.initDimensionEntry(easyModel);
        }
    }

    @Override
    public void clear(FSAEasyModelBusFormPlugin.EasyModelMessage easyModelMessage) {
        this.getPageCache().remove("modeDimConfigChange");
        if (easyModelMessage instanceof FSAEasyModelBusFormPlugin.EasyModel) {
            FSAEasyModelBusFormPlugin.EasyModel easyModel = (FSAEasyModelBusFormPlugin.EasyModel)easyModelMessage;
            easyModel.setDimFilters(null);
        }
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage previousStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        String modeDimConfigChange = this.getPageCache().get("modeDimConfigChange");
        if (Boolean.parseBoolean(modeDimConfigChange)) {
            easyModel.setExitData(true);
        }
        easyModel.setDimFilters(this.getDimFilters(easyModel));
        return easyModel;
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage nextStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        IDataModel model = this.getModel();
        String currencyNumber = (String)model.getValue("currency_number");
        String processNumber = (String)model.getValue("process_number");
        if (StringUtils.isEmpty((String)currencyNumber) || StringUtils.isEmpty((String)processNumber)) {
            return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(ResManager.loadKDString((String)"\u201c\u62a5\u544a\u5e01\u5e01\u522b\u201d\u548c\u201c\u5305\u62ec\u7684\u6570\u636e\u8303\u56f4\u201d\u662f\u5fc5\u586b\u9879", (String)"FSAEasyModeFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        String errorString = this.validateDimensionMember();
        if (errorString != null) {
            return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(String.format(ResManager.loadKDString((String)"%s \u4e3a\u6bcf\u6b21\u5fc5\u586b\u9879\uff0c\u8bf7\u65b0\u589e\u7ef4\u5ea6\u6210\u5458\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"FSAEasyModeFormPlugin_11", (String)"data-fsa-formplugin", (Object[])new Object[0]), errorString));
        }
        easyModel.setDimFilters(this.getDimFilters(easyModel));
        String modeDimConfigChange = this.getPageCache().get("modeDimConfigChange");
        if (Boolean.parseBoolean(modeDimConfigChange)) {
            easyModel.setClear(true);
        }
        return easyModel;
    }

    private String validateDimensionMember() {
        IDataModel model = this.getModel();
        StringBuilder errorStringBuilder = new StringBuilder();
        for (int i = 0; i < model.getEntryRowCount("dimension_entry"); ++i) {
            if (!FSAFilterModeEnum.REQUIRED.getCodeString().equals(model.getValue("filtermode", i))) continue;
            DynamicObject entryRowEntity = model.getEntryRowEntity("dimension_entry", i);
            model.setEntryCurrentRowIndex("dimension_entry", i);
            int memberEntryCount = model.getEntryRowCount("member_filter_entry");
            if (memberEntryCount != 0) continue;
            errorStringBuilder.append('\u3001').append(entryRowEntity.getString("dimname"));
        }
        return errorStringBuilder.length() == 0 ? null : errorStringBuilder.substring(1);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"currency_name", "process_name"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimension_entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        if ("add".equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("dimension_entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"FSASyncParamFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                return;
            }
            int selectRowIndex = selectRows[0];
            String dimName = (String)model.getValue("dimname", selectRowIndex);
            String dimNumber = (String)model.getValue("dimnumber", selectRowIndex);
            this.showDimMembers(dimName, dimNumber);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "currency_name": {
                this.showDimMember("Currency", "currency_name");
                break;
            }
            case "process_name": {
                this.showDimMember("Process", "process_name");
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = model.getEntryCurrentRowIndex("dimension_entry");
        String dimNumber = (String)model.getValue("dimnumber", rowIndex);
        String scenarioId = this.getPageCache().get("scenarioMemberId");
        view.setEnable(Boolean.valueOf(!StringUtils.isNotEmpty((String)scenarioId) || !"Scenario".equals(dimNumber)), new String[]{"add", "del"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "currency_name": {
                if (StringUtils.isEmpty((String)((String)newValue))) {
                    this.removeCurrency(model);
                }
                this.setChangeFlag();
                break;
            }
            case "process_name": {
                if (StringUtils.isEmpty((String)((String)newValue))) {
                    this.removeProcess(model);
                }
                this.setChangeFlag();
                break;
            }
            case "filtermode": {
                this.setChangeFlag();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.setChangeFlag();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        IDataModel model = this.getModel();
        switch (e.getActionId()) {
            case "currency_name": {
                FSAMemberSelectF7Plugin.MemberModel memberModel = (FSAMemberSelectF7Plugin.MemberModel)returnData;
                model.setValue("currency_name", (Object)memberModel.getName());
                model.setValue("currency_number", (Object)memberModel.getNumber());
                model.setValue("currencyid", (Object)memberModel.getId());
                model.setValue("currency_longnumber", (Object)memberModel.getLongNumber());
                break;
            }
            case "process_name": {
                FSAMemberSelectF7Plugin.MemberModel memberModel = (FSAMemberSelectF7Plugin.MemberModel)returnData;
                model.setValue("process_name", (Object)memberModel.getName());
                model.setValue("process_number", (Object)memberModel.getNumber());
                model.setValue("processid", (Object)memberModel.getId());
                model.setValue("process_longnumber", (Object)memberModel.getLongNumber());
                break;
            }
            case "member_filter_entry": {
                HashSet dimMemberSet = (HashSet)returnData;
                int filterEntryCount = model.getEntryRowCount("member_filter_entry");
                for (OlapServerDimMemberMetaInfo memberMetaInfo : dimMemberSet) {
                    boolean memberNumberHasExist = false;
                    Long memberId = memberMetaInfo.getId();
                    for (int i = 0; i < filterEntryCount; ++i) {
                        Long memberIdOfRow = (Long)model.getValue("memberid", i);
                        if (memberId.longValue() != memberIdOfRow.longValue()) continue;
                        memberNumberHasExist = true;
                        break;
                    }
                    if (memberNumberHasExist) continue;
                    int rowIndex = model.createNewEntryRow("member_filter_entry");
                    model.setValue("membername", (Object)memberMetaInfo.getName(), rowIndex);
                    model.setValue("membernumber", (Object)memberMetaInfo.getNumber(), rowIndex);
                    model.setValue("memberid", (Object)memberId, rowIndex);
                    model.setValue("memberlongnumber", (Object)memberMetaInfo.getLongNumber(), rowIndex);
                }
                this.setChangeFlag();
                break;
            }
        }
    }

    private void setChangeFlag() {
        this.getPageCache().put("modeDimConfigChange", "true");
    }

    private void showDimMember(String dimNumber, String closedCallBackFlag) {
        OlapServerDimemsionMetaInfo metaInfo;
        IPageCache pageCache = this.getPageCache();
        Long moduleId = IDataValueUtil.getLong((Object)pageCache.get("moduleId"));
        Long viewId = IDataValueUtil.getLong((Object)pageCache.get("viewId"));
        Map dimMetaMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
        if (dimMetaMap.isEmpty() || (metaInfo = (OlapServerDimemsionMetaInfo)dimMetaMap.get(dimNumber)) == null) {
            return;
        }
        String dimName = metaInfo.getName();
        List filterMemberIds = null;
        Template template = (Template)FSAJSONUtils.cast((String)pageCache.get("templateCache"), Template.class);
        if (template != null) {
            List tdpList;
            Map viewpoint;
            Map pageDim = template.getPageDim();
            if (pageDim != null && pageDim.get(dimNumber) != null) {
                filterMemberIds = (List)pageDim.get(dimNumber);
            }
            if (filterMemberIds == null && (viewpoint = template.getViewpoint()) != null && viewpoint.get(dimNumber) != null) {
                filterMemberIds = Collections.singletonList(viewpoint.get(dimNumber));
            }
            if (filterMemberIds == null && (tdpList = template.getTmplDimPositions()) != null && !tdpList.isEmpty()) {
                Map colDim;
                TmplDimPosition position = (TmplDimPosition)tdpList.get(0);
                Map rowDim = position.getRowDim();
                if (rowDim != null && rowDim.get(dimNumber) != null) {
                    filterMemberIds = (List)rowDim.get(dimNumber);
                }
                if (filterMemberIds == null && (colDim = position.getColDim()) != null && colDim.get(dimNumber) != null) {
                    filterMemberIds = (List)colDim.get(dimNumber);
                }
            }
        }
        FSAMemberSelectF7Plugin.openF7(this, dimName, moduleId, viewId, dimNumber, closedCallBackFlag, filterMemberIds);
    }

    private void showDimMembers(String dimName, String dimNumber) {
        IDataModel model;
        int memberFilterRow;
        List dimMembersIdList;
        Map pageDim;
        IPageCache pageCache = this.getPageCache();
        Long moduleId = IDataValueUtil.getLong((Object)pageCache.get("moduleId"));
        Long viewId = IDataValueUtil.getLong((Object)pageCache.get("viewId"));
        String columnFilter = null;
        List filterColumnParam = null;
        HashSet<Long> initIds = null;
        Template template = (Template)FSAJSONUtils.cast((String)pageCache.get("templateCache"), Template.class);
        if (template != null && (pageDim = template.getPageDim()) != null && !pageDim.isEmpty() && (dimMembersIdList = (List)pageDim.get(dimNumber)) != null && !dimMembersIdList.isEmpty()) {
            Object obj = dimMembersIdList.get(0);
            if (!"Entity".equals(dimNumber) || !"0".equals(obj.toString())) {
                columnFilter = "id";
                filterColumnParam = dimMembersIdList;
            }
        }
        if ((memberFilterRow = (model = this.getModel()).getEntryRowCount("member_filter_entry")) > 0) {
            initIds = new HashSet<Long>(memberFilterRow);
            for (int i = 0; i < memberFilterRow; ++i) {
                Long id = (Long)model.getValue("memberid", i);
                initIds.add(id);
            }
        }
        FSAMultipleMemberF7BasePlugin.openF7(this, dimName, moduleId, dimNumber, viewId, "member_filter_entry", Boolean.TRUE, Boolean.TRUE, columnFilter, filterColumnParam, initIds);
    }

    private void initDimensionEntry(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        Long moduleId = easyModel.getModuleId();
        Long viewId = easyModel.getCslScheme();
        Long scenarioId = easyModel.getScenarioMemberId();
        pageCache.put("moduleId", moduleId.toString());
        pageCache.put("viewId", viewId.toString());
        pageCache.put("scenarioMemberId", scenarioId != null ? scenarioId.toString() : null);
        Template template = FSABcmDataProvider.loadDimMemberFromTemplate((Long)easyModel.getTemplateId());
        pageCache.put("templateCache", FSAJSONUtils.toJsonString((Object)template));
        this.removeCurrency(model);
        this.removeProcess(model);
        model.deleteEntryData("dimension_entry");
        model.deleteEntryData("member_filter_entry");
        List<FSAEasyModelBusFormPlugin.DimFilter> dimFilterList = easyModel.getDimFilters();
        if (dimFilterList != null && !dimFilterList.isEmpty()) {
            Map dimTypeIndex = template.getDimTypeIndex();
            for (FSAEasyModelBusFormPlugin.DimFilter dimension : dimFilterList) {
                List<FSAEasyModelBusFormPlugin.MemberFilter> memberFilterList = dimension.getMemberFilters();
                String dimensionNumber = dimension.getNumber();
                String filterMode = dimension.getFilterMode();
                if ("Currency".equals(dimensionNumber)) {
                    if (memberFilterList == null || memberFilterList.isEmpty()) continue;
                    FSAEasyModelBusFormPlugin.MemberFilter currencyMember = memberFilterList.get(0);
                    model.setValue("currency_name", (Object)currencyMember.getName());
                    model.setValue("currency_number", (Object)currencyMember.getNumber());
                    model.setValue("currencyid", (Object)currencyMember.getId());
                    model.setValue("currency_longnumber", (Object)currencyMember.getLongNumber());
                    if (dimTypeIndex == null || 1 != (Integer)dimTypeIndex.get(dimensionNumber)) continue;
                    view.setEnable(Boolean.FALSE, new String[]{"currency_name"});
                    continue;
                }
                if ("Process".equals(dimensionNumber)) {
                    if (memberFilterList == null || memberFilterList.isEmpty()) continue;
                    FSAEasyModelBusFormPlugin.MemberFilter processMember = memberFilterList.get(0);
                    model.setValue("processid", (Object)processMember.getId());
                    model.setValue("process_name", (Object)processMember.getName());
                    model.setValue("process_number", (Object)processMember.getNumber());
                    model.setValue("process_longnumber", (Object)processMember.getLongNumber());
                    if (dimTypeIndex == null || 1 != (Integer)dimTypeIndex.get(dimensionNumber)) continue;
                    view.setEnable(Boolean.FALSE, new String[]{"process_name"});
                    continue;
                }
                if (!FSAFilterModeEnum.PRESET.getCodeString().equals(filterMode) && !FSAFilterModeEnum.REQUIRED.getCodeString().equals(filterMode)) continue;
                int dimensionEntryIndex = model.createNewEntryRow("dimension_entry");
                model.setValue("dimname", (Object)dimension.getName(), dimensionEntryIndex);
                model.setValue("dimnumber", (Object)dimension.getNumber(), dimensionEntryIndex);
                model.setValue("filtermode", (Object)filterMode, dimensionEntryIndex);
                if (memberFilterList == null || memberFilterList.isEmpty()) continue;
                model.setEntryCurrentRowIndex("dimension_entry", dimensionEntryIndex);
                for (FSAEasyModelBusFormPlugin.MemberFilter member : memberFilterList) {
                    this.createNewMemberEntryRow(member.getName(), member.getNumber(), member.getId(), member.getLongNumber(), model);
                }
            }
        } else {
            Map pageDim;
            this.initViewPointDimension(model, view, template, moduleId, viewId);
            Map dimMetaMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
            if (!dimMetaMap.isEmpty() && (pageDim = template.getPageDim()) != null && !pageDim.isEmpty()) {
                for (Map.Entry en : pageDim.entrySet()) {
                    String dimNumber = (String)en.getKey();
                    if ("Currency".equals(dimNumber) || "Process".equals(dimNumber)) continue;
                    int dimensionEntryIndex = model.createNewEntryRow("dimension_entry");
                    model.setValue("dimname", (Object)((OlapServerDimemsionMetaInfo)dimMetaMap.get(dimNumber)).getName(), dimensionEntryIndex);
                    model.setValue("dimnumber", (Object)dimNumber, dimensionEntryIndex);
                    model.setValue("filtermode", (Object)FSAFilterModeEnum.REQUIRED.getCodeString(), dimensionEntryIndex);
                    if (scenarioId == null || !"Scenario".equals(dimNumber)) continue;
                    model.setEntryCurrentRowIndex("dimension_entry", dimensionEntryIndex);
                    Map infoMap = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)dimNumber, (String)"id", (Collection)((Collection)en.getValue()), (boolean)true);
                    if (infoMap.isEmpty()) continue;
                    for (Map.Entry dimMetaEn : infoMap.entrySet()) {
                        OlapServerDimMemberMetaInfo member = (OlapServerDimMemberMetaInfo)dimMetaEn.getValue();
                        if (member == null) continue;
                        this.createNewMemberEntryRow(member.getName(), member.getNumber(), member.getId(), member.getLongNumber(), model);
                    }
                }
            }
        }
        view.updateView("currency_data_range");
        view.updateView("dimension_entry");
        view.updateView("member_filter_entry");
    }

    private List<FSAEasyModelBusFormPlugin.DimFilter> getDimFilters(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        Map viewpoint;
        OlapServerDimemsionMetaInfo processInfo;
        OlapServerDimemsionMetaInfo currencyInfo;
        Long moduleId = easyModel.getModuleId();
        Long viewId = easyModel.getCslScheme();
        Map dimMetaMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
        if (dimMetaMap.isEmpty()) {
            return null;
        }
        Template template = FSABcmDataProvider.loadDimMemberFromTemplate((Long)easyModel.getTemplateId());
        Map dimTypeIndex = template.getDimTypeIndex();
        IDataModel model = this.getModel();
        LinkedList<FSAEasyModelBusFormPlugin.DimFilter> dimFilters = new LinkedList<FSAEasyModelBusFormPlugin.DimFilter>();
        if (dimTypeIndex != null && 1 != (Integer)dimTypeIndex.get("Currency") && (currencyInfo = (OlapServerDimemsionMetaInfo)dimMetaMap.get("Currency")) != null) {
            FSAEasyModelBusFormPlugin.MemberFilter currencyMemberFilter = this.getMember((Long)model.getValue("currencyid"), (String)model.getValue("currency_name"), (String)model.getValue("currency_number"), (String)model.getValue("currency_longnumber"));
            dimFilters.add(this.getDimension(currencyInfo.getName(), "Currency", "1", Collections.singletonList(currencyMemberFilter)));
        }
        if (dimTypeIndex != null && 1 != (Integer)dimTypeIndex.get("Process") && (processInfo = (OlapServerDimemsionMetaInfo)dimMetaMap.get("Process")) != null) {
            FSAEasyModelBusFormPlugin.MemberFilter processMemberFilter = this.getMember((Long)model.getValue("processid"), (String)model.getValue("process_name"), (String)model.getValue("process_number"), (String)model.getValue("process_longnumber"));
            dimFilters.add(this.getDimension(processInfo.getName(), "Process", "1", Collections.singletonList(processMemberFilter)));
        }
        int dimensionEntryCount = model.getEntryRowCount("dimension_entry");
        for (int i = 0; i < dimensionEntryCount; ++i) {
            model.setEntryCurrentRowIndex("dimension_entry", i);
            String dimensionName = (String)model.getValue("dimname", i);
            String dimensionNumber = (String)model.getValue("dimnumber", i);
            String dimFilterMode = (String)model.getValue("filtermode", i);
            LinkedList<FSAEasyModelBusFormPlugin.MemberFilter> linkedList = new LinkedList<FSAEasyModelBusFormPlugin.MemberFilter>();
            int n = model.getEntryRowCount("member_filter_entry");
            for (int j = 0; j < n; ++j) {
                FSAEasyModelBusFormPlugin.MemberFilter memberFilter = this.getMember((Long)model.getValue("memberid", j), (String)model.getValue("membername", j), (String)model.getValue("membernumber", j), (String)model.getValue("memberlongnumber", j));
                linkedList.add(memberFilter);
            }
            dimFilters.add(this.getDimension(dimensionName, dimensionNumber, dimFilterMode, linkedList));
        }
        List tdpList = template.getTmplDimPositions();
        if (tdpList != null && !tdpList.isEmpty()) {
            Map colDim;
            TmplDimPosition position = (TmplDimPosition)tdpList.get(0);
            Map rowDim = position.getRowDim();
            if (rowDim != null && !rowDim.isEmpty()) {
                for (Map.Entry entry : rowDim.entrySet()) {
                    String string = (String)entry.getKey();
                    String dimensionName = ((OlapServerDimemsionMetaInfo)dimMetaMap.get(string)).getName();
                    dimFilters.add(this.getDimensionFromMeta(moduleId, viewId, dimensionName, string, (Collection)entry.getValue(), "4"));
                }
            }
            if ((colDim = position.getColDim()) != null && !colDim.isEmpty()) {
                for (Map.Entry entry : colDim.entrySet()) {
                    String dimensionNumber = (String)entry.getKey();
                    String dimensionName = ((OlapServerDimemsionMetaInfo)dimMetaMap.get(dimensionNumber)).getName();
                    dimFilters.add(this.getDimensionFromMeta(moduleId, viewId, dimensionName, dimensionNumber, (Collection)entry.getValue(), "5"));
                }
            }
        }
        if ((viewpoint = template.getViewpoint()) != null && !viewpoint.isEmpty()) {
            for (Map.Entry en : viewpoint.entrySet()) {
                String string = (String)en.getKey();
                String string2 = ((OlapServerDimemsionMetaInfo)dimMetaMap.get(string)).getName();
                dimFilters.add(this.getDimensionFromMeta(moduleId, viewId, string2, string, Collections.singletonList(en.getValue()), "3"));
            }
        }
        return dimFilters;
    }

    private FSAEasyModelBusFormPlugin.DimFilter getDimension(String name, String number, String filterMode, List<FSAEasyModelBusFormPlugin.MemberFilter> memberFilters) {
        FSAEasyModelBusFormPlugin.DimFilter dimension = new FSAEasyModelBusFormPlugin.DimFilter();
        dimension.setName(name);
        dimension.setNumber(number);
        dimension.setFilterMode(filterMode);
        dimension.setMemberFilters(memberFilters);
        return dimension;
    }

    private FSAEasyModelBusFormPlugin.MemberFilter getMember(Long id, String name, String number, String longNumber) {
        FSAEasyModelBusFormPlugin.MemberFilter memberFilter = new FSAEasyModelBusFormPlugin.MemberFilter();
        memberFilter.setId(id);
        memberFilter.setName(name);
        memberFilter.setNumber(number);
        memberFilter.setLongNumber(longNumber);
        return memberFilter;
    }

    private FSAEasyModelBusFormPlugin.DimFilter getDimensionFromMeta(Long moduleId, Long viewId, String dimensionName, String dimensionNumber, Collection<?> filterParam, String filterMode) {
        Map infoMap = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)dimensionNumber, (String)"id", filterParam, (boolean)true);
        if (infoMap.isEmpty()) {
            return this.getDimension(dimensionName, dimensionNumber, filterMode, Collections.emptyList());
        }
        LinkedList<FSAEasyModelBusFormPlugin.MemberFilter> memberFilterList = new LinkedList<FSAEasyModelBusFormPlugin.MemberFilter>();
        for (Map.Entry en : infoMap.entrySet()) {
            OlapServerDimMemberMetaInfo meta = (OlapServerDimMemberMetaInfo)en.getValue();
            if (meta == null) continue;
            FSAEasyModelBusFormPlugin.MemberFilter memberFilter = this.getMember(meta.getId(), meta.getName(), meta.getNumber(), meta.getLongNumber());
            memberFilterList.add(memberFilter);
        }
        return this.getDimension(dimensionName, dimensionNumber, filterMode, memberFilterList);
    }

    private void removeCurrency(IDataModel model) {
        model.setValue("currencyid", null);
        model.setValue("currency_name", null);
        model.setValue("currency_number", null);
        model.setValue("currency_longnumber", null);
    }

    private void removeProcess(IDataModel model) {
        model.setValue("processid", null);
        model.setValue("process_name", null);
        model.setValue("process_number", null);
        model.setValue("process_longnumber", null);
    }

    private void createNewMemberEntryRow(String memberName, String memberNumber, Long memberId, String memberLongNumber, IDataModel model) {
        int memberEntryIndex = model.createNewEntryRow("member_filter_entry");
        model.setValue("membername", (Object)memberName, memberEntryIndex);
        model.setValue("membernumber", (Object)memberNumber, memberEntryIndex);
        model.setValue("memberid", (Object)memberId, memberEntryIndex);
        model.setValue("memberlongnumber", (Object)memberLongNumber, memberEntryIndex);
    }

    private void initViewPointDimension(IDataModel model, IFormView view, Template template, Long moduleId, Long viewId) {
        OlapServerDimMemberMetaInfo processMetaInfo;
        Map infoMap;
        Long processMemberId;
        OlapServerDimMemberMetaInfo currencyMetaInfo;
        Map infoMap2;
        Map dimTypeIndex = template.getDimTypeIndex();
        if (dimTypeIndex == null || dimTypeIndex.isEmpty()) {
            return;
        }
        Map viewpoint = template.getViewpoint();
        if (viewpoint == null || viewpoint.isEmpty()) {
            return;
        }
        Long currencyMemberId = (Long)viewpoint.get("Currency");
        if (currencyMemberId != null && 1 == (Integer)dimTypeIndex.get("Currency") && !(infoMap2 = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)"Currency", (String)"id", Collections.singletonList(currencyMemberId), (boolean)true)).isEmpty() && (currencyMetaInfo = (OlapServerDimMemberMetaInfo)infoMap2.values().iterator().next()) != null) {
            model.setValue("currencyid", (Object)currencyMetaInfo.getId());
            model.setValue("currency_name", (Object)currencyMetaInfo.getName());
            model.setValue("currency_number", (Object)currencyMetaInfo.getNumber());
            model.setValue("currency_longnumber", (Object)currencyMetaInfo.getLongNumber());
            view.setEnable(Boolean.FALSE, new String[]{"currency_name"});
        }
        if ((processMemberId = (Long)viewpoint.get("Process")) != null && 1 == (Integer)dimTypeIndex.get("Process") && !(infoMap = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)"Process", (String)"id", Collections.singletonList(processMemberId), (boolean)true)).isEmpty() && (processMetaInfo = (OlapServerDimMemberMetaInfo)infoMap.values().iterator().next()) != null) {
            model.setValue("processid", (Object)processMetaInfo.getId());
            model.setValue("process_name", (Object)processMetaInfo.getName());
            model.setValue("process_number", (Object)processMetaInfo.getNumber());
            model.setValue("process_longnumber", (Object)processMetaInfo.getLongNumber());
            view.setEnable(Boolean.FALSE, new String[]{"process_name"});
        }
    }
}

