/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;
import kd.data.fsa.formplugin.FSAEasyModelBusFormPlugin;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;
import kd.data.fsa.formplugin.util.FSAWriteBackQueryInfoWorkService;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSASyncTaskLogHelper;
import org.apache.commons.lang.StringUtils;

public class FSAEasyModeQueryDataFormPlugin
extends AbstractFormPlugin
implements FSAEasyModelBusFormPlugin.TabStep,
ProgresssListener {
    FSAEasyModelBusFormPlugin fSAEasyModelBusFormPlugin;
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    @Override
    public void init(FSAEasyModelBusFormPlugin.EasyModelMessage easyModelMessage) {
        this.getModel().setValue("common_info", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u51c6\u5907\u6570\u636e....", (String)"FSAEasyModeFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        if (easyModelMessage instanceof FSAEasyModelBusFormPlugin.EasyModel) {
            FSAEasyModelBusFormPlugin.EasyModel easyModel = (FSAEasyModelBusFormPlugin.EasyModel)easyModelMessage;
            this.getPageCache().put("easymodel_querydata_page", JSON.toJSONString((Object)easyModel));
            this.getPageCache().put("cache_scheme_id", easyModel.getDataSchemeId().toString());
            this.createBcmSyncTask(easyModel.getSyncParamId(), easyModel.getDataCollectionId(), easyModel.getIgnoreDimNull(), easyModel.getTableNumber(), easyModel.getTemplateId());
        }
    }

    @Override
    public void clear(FSAEasyModelBusFormPlugin.EasyModelMessage easyModelMessage) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"cancel"});
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage previousStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        return easyModel;
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage nextStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        return easyModel;
    }

    @Override
    public void setFSAEasyModelBusFormPlugin(FSAEasyModelBusFormPlugin e) {
        this.fSAEasyModelBusFormPlugin = e;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "cancel_query": 
            case "cancelConfirm": {
                if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                    IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
                    int[] taskStatisticsPoints = staticStatus.getTaskStatisticsPoints();
                    if (taskStatisticsPoints[0] == taskStatisticsPoints[1] && taskStatisticsPoints[0] != 0 || staticStatus.isTaskEnd()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"FSAEasyModeFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String taskId = this.getPageCache().get("pageCacheTaskId");
                    FSAWorkTaskStatusConsumer.getInstance().markTaskCancel((Object)taskId);
                    this.deleteQueryInfoData();
                    if ("cancel_query".equals(callBackId)) {
                        Control source = new Control();
                        source.setKey("btn_previous");
                        this.fSAEasyModelBusFormPlugin.click(new EventObject(source));
                        break;
                    }
                    this.fSAEasyModelBusFormPlugin.getPageCache().put("forceClose", Boolean.TRUE.toString());
                    this.getView().close();
                    break;
                }
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.start();
                break;
            }
            case "redirect_scheme_callback": {
                if (!"redirect_scheme".equals(e.getCustomVaule())) break;
                IFormView view = this.getView();
                Long schemeId = Long.parseLong(this.getPageCache().get("cache_scheme_id"));
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setPkId((Object)schemeId);
                baseShowParameter.setFormId("fsa_data_scheme");
                baseShowParameter.setCustomParam("easyModeSource", (Object)Boolean.TRUE);
                baseShowParameter.setHasRight(FSAPermissionUtil.hasSpecificPerm("fsa_easy_mode", "23TJUJAFMP3U").booleanValue());
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)baseShowParameter);
                view.close();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("cancel".equals(key)) {
            this.cancelQueryTask();
        }
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage cancelOrRunBackstage() {
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        int[] taskStatisticsPoints = staticStatus.getTaskStatisticsPoints();
        if (taskStatisticsPoints[0] == taskStatisticsPoints[1] && taskStatisticsPoints[0] != 0 || staticStatus.isTaskEnd()) {
            this.fSAEasyModelBusFormPlugin.getPageCache().put("forceClose", Boolean.TRUE.toString());
            this.getView().close();
            return new FSAEasyModelBusFormPlugin.EasyModelMessage();
        }
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.stop();
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u5f53\u524d\u53d6\u6570\uff1f\u5982\u53d6\u6d88\uff0c\u5df2\u53d6\u7684\u6570\u636e\u5c06\u88ab\u5e9f\u5f03\u3002", (String)"FSAEasyModeFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]);
        return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(msg);
    }

    public void cancelQueryTask() {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.stop();
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u5f53\u524d\u53d6\u6570\uff1f\u5982\u53d6\u6d88\uff0c\u5df2\u53d6\u7684\u6570\u636e\u5c06\u88ab\u5e9f\u5f03\u3002", (String)"FSAEasyModeFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("cancel_query", (IFormPlugin)this));
    }

    public IDataSimpleWorkTaskStatisticStatus getStaticStatus() {
        String taskId = this.getPageCache().get("pageCacheTaskId");
        String cacheStatusStr = this.cache.get("FSA|" + taskId);
        IDataSimpleWorkTaskStatisticStatus statisticStatus = null;
        if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
            statisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.getCachedWorkTaskStatusEvent(cacheStatusStr);
        } else {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fsa_rptdata_synctask", (String)"staticstatus_info_tag", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(taskId)).toArray());
            cacheStatusStr = dynamicObject.getString("staticstatus_info_tag");
            if (kd.bos.util.StringUtils.isNotEmpty((String)cacheStatusStr)) {
                statisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.getCachedWorkTaskStatusEvent(cacheStatusStr);
            }
        }
        return statisticStatus;
    }

    public IWorkTaskStatusEvent getCachedWorkTaskStatusEvent(String cacheStatusStr) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray((Object)cacheStatusStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IWorkTaskStatusEvent)IDataBeanUtil.getClassNewInstance((Class)IDataBeanUtil.getClassByName((String)String.valueOf(jsonArray.get(0))), (Object[])new Object[]{jsonArray});
    }

    private void createBcmSyncTask(Long syncParamId, Long collectionId, Boolean ignoreDimNull, String tableNumber, Long templateId) {
        Long version = FSADataversionUtils.getVersionToDateLong();
        FSAWorkTaskTypeEnum taskType = FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task;
        Long taskId = FSASyncTaskLogHelper.createSyncTask((Long)syncParamId, (String)String.valueOf(version), (FSAWorkTaskTypeEnum)taskType);
        this.getPageCache().put("pageCacheTaskId", taskId.toString());
        FSADataSyncTaskParamModel taskParamModel = new FSADataSyncTaskParamModel("syncParamTask", Collections.emptyList());
        Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((Long)collectionId);
        Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
        taskParamModel.setModelNumber(FSABcmDataProvider.getModelNumber((Long)moduleId));
        String paramDetail = JSON.toJSONString((Object)taskParamModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        FSAWorkTaskMeta meta = new FSAWorkTaskMeta(Long.valueOf(0L), Long.valueOf(0L), syncParamId.toString(), taskId, syncParamId, FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task, paramDetail, true, tableNumber, Boolean.TRUE, ignoreDimNull, version, templateId);
        meta.setNeedDelete(true);
        IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)true);
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        if (0.0 > percent) {
            bar.stop();
        } else if (percent == 100.0) {
            progressEvent.setProgress(99);
        }
        if (staticStatus != null && staticStatus.isTaskEnd()) {
            progressEvent.setProgress((int)percent);
            bar.stop();
        }
    }

    public double getPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (statisticStatus != null) {
            int[] taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints();
            long[] totalTaskTimeCost = statisticStatus.getTotalTaskTimeCost();
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            double percent = (double)taskStatisticsPoints[0] / (double)taskStatisticsPoints[1] * 100.0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            boolean withError = statisticStatus.isWithError();
            if (withError) {
                Long taskId = Long.parseLong(this.getPageCache().get("pageCacheTaskId"));
                QFilter qFilter = new QFilter("datasynctask", "=", (Object)taskId);
                qFilter.and(new QFilter("status", "=", (Object)"9"));
                model.setValue("statustext", (Object)statisticStatus.getStatusMessage());
                ArrayList<MessageBoxLink> msgLinkList = new ArrayList<MessageBoxLink>();
                MessageBoxLink msgLink = new MessageBoxLink();
                msgLink.setText(ResManager.loadKDString((String)"\u70b9\u51fb\u6b64\u5904", (String)"FSAEasyModeFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                msgLink.setValue("redirect_scheme");
                msgLinkList.add(msgLink);
                String msg = ResManager.loadKDString((String)"\u53d6\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"FSAEasyModeFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]) + "#{0}" + ResManager.loadKDString((String)"\u8df3\u8f6c\u5230\u5f53\u524d\u6570\u636e\u65b9\u6848", (String)"FSAEasyModeFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, msgLinkList, MessageBoxOptions.None, ConfirmTypes.Wait, new ConfirmCallBackListener("redirect_scheme_callback", (IFormPlugin)this));
            } else if (Double.doubleToLongBits(taskProcRecStatistics[0]) == Double.doubleToLongBits(0.0) && !taskEnd) {
                model.setValue("statustext", (Object)(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FSARptDataSyncTaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]) + (statisticStatus.getStatusMessage() == null ? "" : ": " + statisticStatus.getStatusMessage())));
            } else if (0.0 < percent && percent <= 100.0 && !taskEnd) {
                long time = totalTaskTimeCost[1] - totalTaskTimeCost[0];
                double predictTime = (double)time / (double)taskStatisticsPoints[0] * (double)(taskStatisticsPoints[1] - taskStatisticsPoints[0]);
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
                String predictdateTime = sdf.format(predictTime);
                if (percent == 100.0) {
                    model.setValue("statustext", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u7ec4\u7ec7\u5c42\u7ea7\u8865\u9f50", (String)"FSAEasyModeFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
                } else {
                    model.setValue("statustext", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u53d6\u6570\u4e2d......", (String)"FSAEasyModeFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                }
                model.setValue("execution_info", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u53d6 %s\u6761/%s\u6761 \u9884\u8ba1\u9700\u8981\u65f6\u95f4 %s", (String)"FSAEasyModeFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskProcRecStatistics[0], taskStatisticsPoints[1], predictdateTime));
            } else if (taskEnd) {
                model.setValue("statustext", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u5df2\u5b8c\u6210\u3002", (String)"FSAEasyModeFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                model.setValue("common_info", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"cancel"});
                model.setValue("execution_info", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8bfb\u53d6\uff1a%s\u6761\uff0c\u6210\u529f\u5408\u5e76\u5199\u5165\uff1a%s\u6761\uff0c\u5df2\u5ffd\u7565\uff1a%s\u6761\uff0c\u5c42\u7ea7\u8865\u9f50\uff1a%s\u6761\uff0c\u5171\u5b58\u5165\u6570\u636e\u8868\uff1a%s\u6761", (String)"FSAEasyModeQueryDataFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskProcRecStatistics[0], taskProcRecStatistics[1], taskProcRecStatistics[2], taskProcRecStatistics[4], taskProcRecStatistics[1] + taskProcRecStatistics[4]));
                view.setVisible(Boolean.TRUE, new String[]{"btn_next"});
                percent = 100.0;
            }
            return percent;
        }
        return 0.0;
    }

    private void deleteQueryInfoData() {
        FSAEasyModelBusFormPlugin.EasyModel easyModel;
        String easyModelJson = this.getPageCache().get("easymodel_querydata_page");
        FSAEasyModelBusFormPlugin.EasyModel easyModel2 = easyModel = easyModelJson == null ? null : (FSAEasyModelBusFormPlugin.EasyModel)FSAJSONUtils.cast((String)easyModelJson, FSAEasyModelBusFormPlugin.EasyModel.class);
        if (easyModel != null) {
            FSAWriteBackQueryInfoWorkService.getInstance().deleteQueryInfoData(easyModel);
        }
    }
}

