/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAFilterModeEnum;
import kd.data.fsa.formplugin.FSAEasyModelBusFormPlugin;
import kd.data.fsa.formplugin.FSAMemberSelectF7Plugin;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.formplugin.util.BaseDataUtil;
import kd.data.fsa.formplugin.util.FSAWriteBackQueryInfoWorkService;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.Template;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSAJSONUtils;
import org.apache.commons.lang.StringUtils;

public class FSAEasyModeTableConfirmFormPlugin
extends AbstractFormPlugin
implements FSAEasyModelBusFormPlugin.TabStep {
    @Override
    public void init(FSAEasyModelBusFormPlugin.EasyModelMessage easyModelMessage) {
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isEmpty((String)pageCache.get(FSACommonConstant.buildCacheKey((String)"table_confirm")))) {
            pageCache.put(FSACommonConstant.buildCacheKey((String)"table_confirm"), "true");
            if (easyModelMessage instanceof FSAEasyModelBusFormPlugin.EasyModel) {
                this.constructTableComfiemPage((FSAEasyModelBusFormPlugin.EasyModel)easyModelMessage);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"pagedim_member"});
    }

    private void constructTableComfiemPage(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        SimpleDateFormat sbf = new SimpleDateFormat("yyMMddHHmmss");
        String timeFormat = sbf.format(new Date());
        this.getPageCache().put("cache_current_time", timeFormat);
        String templateName = easyModel.getTemplateName().length() > 7 ? easyModel.getTemplateName().substring(0, 7) : easyModel.getTemplateName();
        String templateNumber = easyModel.getTemplateNumber().length() > 7 ? easyModel.getTemplateNumber().substring(0, 7).toLowerCase() : easyModel.getTemplateNumber().toLowerCase();
        model.setValue("tablename", (Object)(easyModel.getTableName() == null ? templateName + timeFormat : easyModel.getTableName()));
        model.setValue("tablenumber", (Object)(easyModel.getTableNumber() == null ? templateNumber + timeFormat : easyModel.getTableNumber()));
        model.beginInit();
        List<FSAEasyModelBusFormPlugin.DimFilter> dimFilters = easyModel.getDimFilters();
        ArrayList<String> headerList = new ArrayList<String>(dimFilters.size());
        ArrayList<List<String>> columnDimensionList = new ArrayList<List<String>>(5);
        ArrayList<List<String>> descartesResultList = new ArrayList<List<String>>(5);
        ArrayList<String> disPlayNameList = new ArrayList<String>();
        model.deleteEntryData("tmpldim_entry");
        model.deleteEntryData("pagedim_entry");
        for (FSAEasyModelBusFormPlugin.DimFilter dimFilter : dimFilters) {
            if (dimFilter == null) continue;
            FSAFilterModeEnum anEnum = FSAFilterModeEnum.getEnum((String)dimFilter.getFilterMode());
            switch (anEnum) {
                case PRESET: 
                case REQUIRED: {
                    headerList.add(dimFilter.getName());
                    StringBuilder disPlayName = null;
                    List<FSAEasyModelBusFormPlugin.MemberFilter> list = dimFilter.getMemberFilters();
                    HashSet<Long> memberIds = new HashSet<Long>(list.size());
                    for (FSAEasyModelBusFormPlugin.MemberFilter memberFilter : list) {
                        if (disPlayName == null) {
                            disPlayName = new StringBuilder();
                        }
                        disPlayName.append(memberFilter.getName()).append(';');
                        memberIds.add(memberFilter.getId());
                    }
                    int dataEntryRow = model.createNewEntryRow("pagedim_entry");
                    model.setValue("pagedim_dimname", (Object)dimFilter.getName(), dataEntryRow);
                    model.setValue("pagedim_dimnumber", (Object)dimFilter.getNumber(), dataEntryRow);
                    model.setValue("pagedim_member", disPlayName == null ? null : disPlayName.substring(0, disPlayName.length() - 1), dataEntryRow);
                    model.setValue("member_id_set", (Object)JSON.toJSONString(memberIds), dataEntryRow);
                    break;
                }
                case FIXED_CONDITION: {
                    StringBuilder disPlayName = new StringBuilder();
                    disPlayName.append(dimFilter.getName()).append(" : ");
                    List<FSAEasyModelBusFormPlugin.MemberFilter> list = dimFilter.getMemberFilters();
                    if (!list.isEmpty()) {
                        disPlayName.append(list.get(0).getName());
                    }
                    disPlayNameList.add(disPlayName.toString());
                    break;
                }
                case ROW_DIMENSION: {
                    headerList.add(dimFilter.getName());
                }
                case COLUMN_DIMENSION: {
                    StringBuilder disPlayName = new StringBuilder();
                    List<FSAEasyModelBusFormPlugin.MemberFilter> list = dimFilter.getMemberFilters();
                    if (list.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5217\u7ef4\u6210\u5458\u503c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FSAEasyModeTableConfirmFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    }
                    ArrayList<String> columnMembers = new ArrayList<String>(10);
                    for (FSAEasyModelBusFormPlugin.MemberFilter memberFilter : list) {
                        String memberName = memberFilter.getName();
                        columnMembers.add(memberName);
                        disPlayName.append(memberName).append('\u3001');
                    }
                    int dataEntryRow = model.createNewEntryRow("tmpldim_entry");
                    model.setValue("tmpldim_dimname", (Object)dimFilter.getName(), dataEntryRow);
                    model.setValue("tmpldim_dimnumber", (Object)dimFilter.getNumber(), dataEntryRow);
                    model.setValue("tmpldim_member", (Object)(StringUtils.isEmpty((String)disPlayName.toString()) ? "" : disPlayName.substring(0, disPlayName.length() - 1)), dataEntryRow);
                    columnDimensionList.add(columnMembers);
                    break;
                }
            }
        }
        model.endInit();
        this.getView().updateView("tmpldim_entry");
        this.getView().updateView("pagedim_entry");
        Container container = (Container)this.getView().getControl("hidedim_flex");
        container.deleteControls(new String[]{"hidedim_panel"});
        FlexPanelAp cardPanel = this.createCardPanel(disPlayNameList);
        cardPanel.setCollapsible(false);
        container.setDroppable(false);
        ArrayList<Map> items = new ArrayList<Map>();
        List controlList = ((Container)cardPanel.buildRuntimeControl()).getItems();
        items.add(cardPanel.createControl());
        container.addControls(items);
        this.getView().createControlIndex(controlList);
        this.getModel().deleteEntryData("table_preview_entry");
        BaseDataUtil.descartes(columnDimensionList, descartesResultList, 0, new ArrayList<String>(0));
        for (List list : descartesResultList) {
            headerList.add(StringUtils.join((Collection)list, (char)'_'));
        }
        if (!CollectionUtils.isEmpty(headerList)) {
            this.createGrid(headerList, "table_preview_entry");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        switch (propertyName) {
            case "pagedim_member": {
                ChangeData changeData = e.getChangeSet()[0];
                if (changeData.getNewValue().toString().isEmpty()) {
                    int rowIndex = e.getChangeSet()[0].getRowIndex();
                    ArrayList memberFilters = new ArrayList(0);
                    String dimNumber = model.getValue("pagedim_dimnumber", rowIndex).toString();
                    model.setValue("member_id_set", (Object)"[]", rowIndex);
                    String cacheTableConfirmMap = pageCache.get("cache_table_confirm_map");
                    HashMap tableConfirmMap = StringUtils.isEmpty((String)cacheTableConfirmMap) ? new HashMap() : (Map)JSON.parseObject((String)cacheTableConfirmMap, (TypeReference)new TypeReference<HashMap<String, List<FSAEasyModelBusFormPlugin.MemberFilter>>>(){}, (Feature[])new Feature[0]);
                    tableConfirmMap.put(dimNumber, memberFilters);
                    pageCache.put("cache_table_confirm_map", JSON.toJSONString(tableConfirmMap));
                }
            }
            case "tablename": 
            case "tablenumber": 
            case "ignoredimnull": 
            case "superlongdata": {
                this.getPageCache().put(FSACommonConstant.buildCacheKey((String)"table_confirm_change"), "true");
                break;
            }
        }
    }

    @Override
    public void clear(FSAEasyModelBusFormPlugin.EasyModelMessage easyModelMessage) {
        this.getPageCache().remove(FSACommonConstant.buildCacheKey((String)"table_confirm"));
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage previousStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        this.updateEasyModelData(easyModel);
        return easyModel;
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage nextStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        try {
            this.updateEasyModelData(easyModel);
            String errorMessage = this.validate(easyModel.getTableNumber(), easyModel.getTableName());
            if (errorMessage != null) {
                FSAEasyModelBusFormPlugin.TabStepFalseMessage failMessage = new FSAEasyModelBusFormPlugin.TabStepFalseMessage(errorMessage);
                return failMessage;
            }
            FSAWriteBackQueryInfoWorkService.getInstance().reWriteDataInfo(easyModel);
        }
        catch (Exception e) {
            FSAEasyModelBusFormPlugin.TabStepFalseMessage failMessage = new FSAEasyModelBusFormPlugin.TabStepFalseMessage(e.getMessage());
            return failMessage;
        }
        return easyModel;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        switch (e.getActionId()) {
            case "Currency": 
            case "Process": {
                HashSet<Long> memberIds = new HashSet<Long>();
                FSAMemberSelectF7Plugin.MemberModel memberModel = (FSAMemberSelectF7Plugin.MemberModel)returnData;
                ArrayList<FSAEasyModelBusFormPlugin.MemberFilter> memberFilters = new ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>(1);
                FSAEasyModelBusFormPlugin.MemberFilter memberFilter = new FSAEasyModelBusFormPlugin.MemberFilter();
                memberFilter.setId(memberModel.getId());
                memberFilter.setName(memberModel.getName());
                memberFilter.setNumber(memberModel.getNumber());
                memberFilter.setLongNumber(memberModel.getLongNumber());
                memberIds.add(memberModel.getId());
                memberFilters.add(memberFilter);
                model.setValue("pagedim_member", (Object)memberModel.getName());
                model.setValue("member_id_set", (Object)JSON.toJSONString(memberIds));
                String cacheTableConfirmMap = pageCache.get("cache_table_confirm_map");
                HashMap<String, ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>> tableConfirmMap = StringUtils.isEmpty((String)cacheTableConfirmMap) ? new HashMap<String, ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>>() : (Map)JSON.parseObject((String)cacheTableConfirmMap, (TypeReference)new TypeReference<HashMap<String, List<FSAEasyModelBusFormPlugin.MemberFilter>>>(){}, (Feature[])new Feature[0]);
                tableConfirmMap.put(e.getActionId(), memberFilters);
                pageCache.put("cache_table_confirm_map", JSON.toJSONString(tableConfirmMap));
                break;
            }
            default: {
                HashSet dimMemberSet = (HashSet)returnData;
                ArrayList<FSAEasyModelBusFormPlugin.MemberFilter> memberFilters = new ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>(dimMemberSet.size());
                HashSet<Long> memberIds = new HashSet<Long>();
                StringBuilder memberNameSb = new StringBuilder();
                for (OlapServerDimMemberMetaInfo dimMemberMetaInfo : dimMemberSet) {
                    FSAEasyModelBusFormPlugin.MemberFilter memberFilter = new FSAEasyModelBusFormPlugin.MemberFilter();
                    memberFilter.setId(dimMemberMetaInfo.getId());
                    memberFilter.setName(dimMemberMetaInfo.getName());
                    memberFilter.setNumber(dimMemberMetaInfo.getNumber());
                    memberFilter.setLongNumber(dimMemberMetaInfo.getLongNumber());
                    memberFilters.add(memberFilter);
                    memberNameSb.append(dimMemberMetaInfo.getName()).append(',');
                    memberIds.add(dimMemberMetaInfo.getId());
                }
                model.setValue("pagedim_member", (Object)memberNameSb.subSequence(0, memberNameSb.length() - 1));
                model.setValue("member_id_set", (Object)JSON.toJSONString(memberIds));
                String cacheTableConfirmMap = this.getPageCache().get("cache_table_confirm_map");
                HashMap<String, ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>> tableConfirmMap = StringUtils.isEmpty((String)cacheTableConfirmMap) ? new HashMap<String, ArrayList<FSAEasyModelBusFormPlugin.MemberFilter>>() : (Map)JSON.parseObject((String)cacheTableConfirmMap, (TypeReference)new TypeReference<HashMap<String, List<FSAEasyModelBusFormPlugin.MemberFilter>>>(){}, (Feature[])new Feature[0]);
                tableConfirmMap.put(e.getActionId(), memberFilters);
                pageCache.put("cache_table_confirm_map", JSON.toJSONString(tableConfirmMap));
            }
        }
    }

    private void updateEasyModelData(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (!StringUtils.isEmpty((String)pageCache.get(FSACommonConstant.buildCacheKey((String)"table_confirm_change")))) {
            easyModel.setExitData(true);
            easyModel.setTimeFormatString(pageCache.get("cache_current_time"));
            easyModel.setTableName(model.getValue("tablename").toString());
            easyModel.setTableNumber(model.getValue("tablenumber").toString());
            easyModel.setIgnoreDimNull((Boolean)model.getValue("ignoredimnull"));
            easyModel.setSuperLongData((Boolean)model.getValue("superlongdata"));
            String cacheTableConfirmMap = pageCache.get("cache_table_confirm_map");
            if (StringUtils.isNotEmpty((String)cacheTableConfirmMap)) {
                Map tableConfirmMap = (Map)JSON.parseObject((String)cacheTableConfirmMap, (TypeReference)new TypeReference<HashMap<String, List<FSAEasyModelBusFormPlugin.MemberFilter>>>(){}, (Feature[])new Feature[0]);
                Set tableConfirmSet = tableConfirmMap.keySet();
                List<FSAEasyModelBusFormPlugin.DimFilter> dimFilters = easyModel.getDimFilters();
                for (FSAEasyModelBusFormPlugin.DimFilter dimFilter : dimFilters) {
                    if (dimFilter == null || !FSAFilterModeEnum.PRESET.getCodeString().equals(dimFilter.getFilterMode()) && !FSAFilterModeEnum.REQUIRED.getCodeString().equals(dimFilter.getFilterMode()) || !tableConfirmSet.contains(dimFilter.getNumber())) continue;
                    dimFilter.setMemberFilters((List)tableConfirmMap.get(dimFilter.getNumber()));
                }
                pageCache.remove("cache_table_confirm_map");
            }
        }
    }

    private void showDimMembers(String dimName, String dimNumber, Collection<Long> filterParamCollection, Set<Long> memberIdSet) {
        IDataModel model = this.getModel();
        Long moduleId = (Long)model.getValue("module_id");
        Long viewId = (Long)model.getValue("cslscheme_id");
        FSAMultipleMemberF7BasePlugin.openF7(this, dimName, moduleId, dimNumber, viewId, dimNumber, Boolean.TRUE, Boolean.TRUE, "id", filterParamCollection, memberIdSet);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("pagedim_member".equals(key)) {
            Map pageDim;
            IDataModel model = this.getModel();
            int entryCurrentRowIndex = model.getEntryCurrentRowIndex("pagedim_entry");
            String dimName = (String)model.getValue("pagedim_dimname", entryCurrentRowIndex);
            String dimNumber = (String)model.getValue("pagedim_dimnumber", entryCurrentRowIndex);
            List filterParamCollection = null;
            String templateCache = this.getPageCache().get("templateCache");
            if (StringUtils.isNotEmpty((String)templateCache) && (pageDim = ((Template)FSAJSONUtils.cast((String)templateCache, Template.class)).getPageDim()) != null) {
                filterParamCollection = (List)pageDim.get(dimNumber);
            }
            if ("Currency".equals(dimNumber) || "Process".equals(dimNumber)) {
                this.showDimMember(dimNumber, dimNumber, filterParamCollection);
            } else {
                Object entityId;
                HashSet memberIdSet = (HashSet)JSON.parseObject((String)model.getValue("member_id_set").toString(), (TypeReference)new TypeReference<HashSet<Long>>(){}, (Feature[])new Feature[0]);
                if ("Entity".equalsIgnoreCase(dimNumber) && filterParamCollection != null && filterParamCollection.size() == 1 && (entityId = filterParamCollection.get(0)).equals(0)) {
                    filterParamCollection = null;
                }
                this.showDimMembers(dimName, dimNumber, filterParamCollection, memberIdSet);
            }
        }
    }

    private String validate(String tableNumber, String tableName) {
        StringBuilder errorString = new StringBuilder();
        IDataModel model = this.getModel();
        if (StringUtils.isEmpty((String)tableName)) {
            errorString.append('\u3001').append(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u624b\u52a8\u4fee\u6539", (String)"FSAEasyModeTableConfirmFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        } else if (tableName.length() > 19) {
            errorString.append('\u3001').append(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8868\u540d\u79f0\u957f\u5ea6\u8d85\u8fc719\u4e2a\u5b57\u7b26\uff0c\u8bf7\u624b\u52a8\u4fee\u6539", (String)"FSANumberNameConfigFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)tableNumber)) {
            errorString.append('\u3001').append(ResManager.loadKDString((String)"\u6570\u636e\u8868\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u624b\u52a8\u4fee\u6539", (String)"FSAEasyModeTableConfirmFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        } else if (!tableNumber.matches("[0-9a-z_]*") || tableNumber.length() > 19) {
            errorString.append('\u3001').append(ResManager.loadKDString((String)"\u6570\u636e\u8868\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u5b57\u7b26\u6570\u5c0f\u4e8e19\u3002\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSAEasyModeTableConfirmFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        if (MetadataDao.checkNumber((String)tableNumber)) {
            errorString.append('\u3001').append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6570\u636e\u8868\u7f16\u7801\u76f8\u540c\u7684\u6570\u636e\u8868\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSAEasyModeTableConfirmFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        int entryRowCount = model.getEntryRowCount("pagedim_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            Object dimNumber = model.getValue("pagedim_dimnumber", i);
            String dimMember = model.getValue("pagedim_member", i).toString();
            if (!"Currency".equals(dimNumber) && !"Process".equals(dimNumber) || !StringUtils.isEmpty((String)dimMember)) continue;
            errorString.append('\u3001').append(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0\uff1a%s \u4e3a\u5fc5\u5f55\u9879, \u53d6\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"FSAEasyModeTableConfirmFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]), model.getValue("pagedim_dimname", i)));
        }
        return errorString.length() == 0 ? null : errorString.substring(1);
    }

    private void showDimMember(String dimNumber, String closedCallBackFlag, Collection<Long> filterParamCollection) {
        OlapServerDimemsionMetaInfo metaInfo;
        IDataModel model = this.getModel();
        Long moduleId = (Long)model.getValue("module_id");
        Long viewId = (Long)model.getValue("cslscheme_id");
        Map dimMetaMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
        if (dimMetaMap.isEmpty() || (metaInfo = (OlapServerDimemsionMetaInfo)dimMetaMap.get(dimNumber)) == null) {
            return;
        }
        String dimName = metaInfo.getName();
        FSAMemberSelectF7Plugin.openF7(this, dimName, moduleId, viewId, metaInfo.getId(), dimNumber, metaInfo.getDimEntityName(), closedCallBackFlag, filterParamCollection);
    }

    private void createGrid(Collection<String> headersList, String gridKey) {
        HashMap<String, Object> meta = new HashMap<String, Object>(3);
        meta.put("key", gridKey);
        meta.put("methodname", "createGridColumns");
        HashMap<String, List<Map<String, Object>>> args = new HashMap<String, List<Map<String, Object>>>(3);
        args.put("columns", this.createColumns(headersList));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    public List<Map<String, Object>> createColumns(Collection<String> headersList) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(headersList.size() + 2);
        Iterator<String> colIt = headersList.iterator();
        while (colIt.hasNext()) {
            cols.add(this.createColumn(colIt.next()));
        }
        return cols;
    }

    public Map<String, Object> createColumn(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("header", new LocaleString(key));
        map.put("visible", Boolean.TRUE);
        map.put("dataIndex", key);
        return map;
    }

    private FlexPanelAp createCardPanel(List<String> disPlayNameList) {
        FlexPanelAp resultPanel = new FlexPanelAp();
        resultPanel.setKey("hidedim_panel");
        resultPanel.setId("hidedim_panel");
        resultPanel.setDirection("row");
        resultPanel.setWidth(new LocaleString("100%"));
        resultPanel.setShadow(false);
        resultPanel.setCollapsible(true);
        resultPanel.setDefaultcollapse(true);
        resultPanel.setBackColor("white");
        resultPanel.setName(new LocaleString(""));
        resultPanel.setJustifyContent("default");
        resultPanel.setAlignItems("default");
        resultPanel.setAlignContent("default");
        for (String disPlayName : disPlayNameList) {
            FlexPanelAp details = new FlexPanelAp();
            details.setKey("dimension_detail");
            details.setBackColor("white");
            Style style = new Style();
            Padding padding = new Padding();
            padding.setTop("12px");
            padding.setRight("18px");
            style.setPadding(padding);
            details.setStyle(style);
            details.setAutoTextWrap(true);
            details.setDirection("row");
            details.setJustifyContent("flex-start");
            details.setAlignItems("center");
            details.setGrow(0);
            details.setWidth(new LocaleString("25%"));
            String[] splitString = disPlayName.split(":");
            for (int i = 0; i < splitString.length; ++i) {
                String displayNameSplit = splitString[i];
                if (i == 0) {
                    displayNameSplit = displayNameSplit + ":";
                }
                LabelAp fontTitle = new LabelAp();
                fontTitle.setName(new LocaleString(displayNameSplit));
                fontTitle.setKey("_font");
                fontTitle.setFontSize(12);
                fontTitle.setWidth(new LocaleString("100%"));
                fontTitle.setForeColor("#000000");
                details.getItems().add(fontTitle);
            }
            resultPanel.getItems().add(details);
        }
        return resultPanel;
    }
}

