/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.data.fsa.formplugin.FSAEasyModeReportFormPlugin;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;
import kd.data.fsa.olap.Template;
import kd.data.fsa.utils.FSAJSONUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FSAEasyModelBusFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    Map<String, TabStep> plugInMap;
    private static final String[] STEP_FORM_ID = new String[]{"choose_data_source", "data_dimension_config", "table_confirm", "data_fetch", "table_preview"};

    public void afterCreateNewData(EventObject e) {
        this.showStepPage(0, null);
        EasyModel easyModel = new EasyModel();
        this.getPageCache().put("easyModel", FSAJSONUtils.toJsonString((Object)easyModel));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String forceClose = this.getPageCache().get("forceClose");
        if (StringUtils.isEmpty((CharSequence)forceClose)) {
            e.setCancel(true);
            Control control = new Control();
            control.setKey("btncancel");
            this.click(new EventObject(control));
        }
    }

    public void initialize() {
        FormViewPluginProxy service = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        FSAEasyModelBusFormPlugin fsaEasyModelBusFormPlugin = (FSAEasyModelBusFormPlugin)service.getPlugin(((Object)((Object)this)).getClass().getName());
        List plugIns = service.getPlugIns().stream().filter(p -> p instanceof TabStep).map(p -> (TabStep)p).collect(Collectors.toList());
        this.plugInMap = new HashMap<String, TabStep>(plugIns.size());
        for (TabStep plugIn : plugIns) {
            TabNameEnum[] values;
            String pluginName = plugIn.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
            plugIn.setFSAEasyModelBusFormPlugin(fsaEasyModelBusFormPlugin);
            for (TabNameEnum value : values = TabNameEnum.values()) {
                if (!pluginName.equals(value.pluginName.toLowerCase(Locale.ENGLISH))) continue;
                this.plugInMap.put(value.tabName, plugIn);
            }
        }
        this.plugInMap.put("table_preview", new FSAEasyModeReportFormPlugin());
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl("wizard_tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"btncancel", "btn_previous", "btn_next", "btnok", "enter_scheme"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if ("busCancelConfirm".equals(actionId) && MessageBoxResult.Yes == messageBoxResult) {
            this.getView().getPageCache().put("forceClose", "1");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        String key;
        int currentStep = this.getCurrentStep();
        IFormView view = this.getView();
        TabStep tabStep = this.plugInMap.get(STEP_FORM_ID[currentStep]);
        if (tabStep == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5411\u5bfc\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FSAEasyModelBusFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        String easyModelJson = this.getPageCache().get("easyModel");
        EasyModel easyModel = easyModelJson == null ? null : (EasyModel)FSAJSONUtils.cast((String)easyModelJson, EasyModel.class);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_previous": {
                if (easyModel == null) {
                    return;
                }
                EasyModelMessage data = tabStep.previousStep(easyModel);
                if (data instanceof TabStepFalseMessage) {
                    this.showFalseMessage((TabStepFalseMessage)data);
                    break;
                }
                this.previousStep(currentStep, (EasyModel)data);
                break;
            }
            case "btnok": 
            case "btn_next": {
                if (easyModel == null) {
                    return;
                }
                EasyModelMessage data = tabStep.nextStep(easyModel);
                if (data instanceof TabStepFalseMessage) {
                    this.showFalseMessage((TabStepFalseMessage)data);
                    break;
                }
                this.nextStep(currentStep, (EasyModel)data);
                break;
            }
            case "btncancel": {
                EasyModelMessage data = tabStep.cancelOrRunBackstage();
                if (data instanceof TabStepFalseMessage) {
                    TabStepFalseMessage message = (TabStepFalseMessage)data;
                    view.showConfirm(message.getMessage(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("cancelConfirm", (IFormPlugin)tabStep));
                    break;
                }
                if (currentStep > 0 && data == null) {
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff0c\u82e5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FSAEasyModelBusFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                    view.showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("busCancelConfirm", (IFormPlugin)this));
                    break;
                }
                view.getPageCache().put("forceClose", "1");
                view.close();
                break;
            }
            case "enter_scheme": {
                if (easyModel == null) {
                    return;
                }
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setPkId((Object)easyModel.getDataSchemeId());
                baseShowParameter.setFormId("fsa_data_scheme");
                baseShowParameter.setCustomParam("easyModeSource", (Object)Boolean.TRUE);
                baseShowParameter.setHasRight(FSAPermissionUtil.hasSpecificPerm("fsa_easy_mode", "23TJUJAFMP3U").booleanValue());
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)baseShowParameter);
                break;
            }
        }
    }

    private void nextStep(int currentStep, EasyModel easyModel) {
        int thsLastIndex;
        if (easyModel.isClear()) {
            String[] tabNames;
            for (String tabName : tabNames = this.followUpProcess()) {
                TabStep tabStep = this.plugInMap.get(tabName);
                if (tabStep == null) continue;
                tabStep.clear(easyModel);
            }
            easyModel.setExitData(false);
            easyModel.setClear(false);
        }
        int step = currentStep < (thsLastIndex = STEP_FORM_ID.length - 1) ? currentStep + 1 : thsLastIndex;
        this.getPageCache().put("easyModel", JSON.toJSONString((Object)easyModel));
        this.showStepPage(step, easyModel);
    }

    private void previousStep(int currentStep, EasyModel easyModel) {
        if (easyModel.isExitData()) {
            this.getPageCache().put("easyModel", JSON.toJSONString((Object)easyModel));
        }
        int step = currentStep > 0 ? currentStep - 1 : 0;
        this.showStepPage(step, easyModel);
    }

    private void showFalseMessage(TabStepFalseMessage tabStepFalseMessage) {
        this.getView().showTipNotification(tabStepFalseMessage.getMessage());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        IFormView view = this.getView();
        String subTabKey = tabSelectEvent.getTabKey();
        view.setVisible(Boolean.FALSE, new String[]{"btn_next", "btncancel", "btn_previous", "btnok", "enter_scheme"});
        List<String> showButtonList = TabNameEnum.getList(subTabKey);
        showButtonList.forEach(p -> view.setVisible(Boolean.TRUE, new String[]{p}));
    }

    private int getCurrentStep() {
        Tab tab = (Tab)this.getControl("wizard_tabap");
        String currentTab = tab.getCurrentTab();
        return ArrayUtils.indexOf((Object[])STEP_FORM_ID, (Object)currentTab);
    }

    private String[] followUpProcess() {
        int currentStep = this.getCurrentStep();
        if (currentStep == STEP_FORM_ID.length - 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(STEP_FORM_ID, currentStep + 1, STEP_FORM_ID.length);
    }

    private void showStepPage(int stepIndex, EasyModel data) {
        String stepName = STEP_FORM_ID[stepIndex];
        Tab tab = (Tab)this.getControl("wizard_tabap");
        tab.selectTab(stepName);
        tab.activeTab(stepName);
        TabStep tabStep = this.plugInMap.get(stepName);
        if (tabStep != null) {
            if (stepIndex == 4) {
                tabStep.init(data, this.getView());
            } else {
                tabStep.init(data);
            }
        }
    }

    public static class MemberFilter {
        Long id;
        String name;
        String number;
        String longNumber;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }
    }

    public static class DimFilter {
        Long id;
        String name;
        String number;
        String filterMode;
        List<MemberFilter> memberFilters;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getFilterMode() {
            return this.filterMode;
        }

        public void setFilterMode(String filterMode) {
            this.filterMode = filterMode;
        }

        public List<MemberFilter> getMemberFilters() {
            return this.memberFilters;
        }

        public void setMemberFilters(List<MemberFilter> memberFilters) {
            this.memberFilters = memberFilters;
        }
    }

    public static class EasyModel
    extends EasyModelMessage {
        Long moduleId;
        String moduleName;
        Long scenarioMemberId;
        Long cslScheme;
        String cslSchemeName;
        Long templateId;
        String templateName;
        String templateNumber;
        List<DimFilter> dimFilters;
        Long dataCollectionId;
        Long syncParamId;
        Long dataSchemeId;
        String tableName;
        String tableNumber;
        Boolean ignoreDimNull;
        Boolean superLongData;
        String timeFormatString;
        Template template;

        public Template getTemplate() {
            return this.template;
        }

        public void setTemplate(Template template) {
            this.template = template;
        }

        public Long getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(Long moduleId) {
            this.moduleId = moduleId;
        }

        public Long getScenarioMemberId() {
            return this.scenarioMemberId;
        }

        public void setScenarioMemberId(Long scenarioMemberId) {
            this.scenarioMemberId = scenarioMemberId;
        }

        public Long getCslScheme() {
            return this.cslScheme;
        }

        public void setCslScheme(Long cslScheme) {
            this.cslScheme = cslScheme;
        }

        public Long getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(Long templateId) {
            this.templateId = templateId;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getTemplateNumber() {
            return this.templateNumber;
        }

        public void setTemplateNumber(String templateNumber) {
            this.templateNumber = templateNumber;
        }

        public List<DimFilter> getDimFilters() {
            return this.dimFilters;
        }

        public void setDimFilters(List<DimFilter> dimFilters) {
            this.dimFilters = dimFilters;
        }

        public Long getDataCollectionId() {
            return this.dataCollectionId;
        }

        public void setDataCollectionId(Long dataCollectionId) {
            this.dataCollectionId = dataCollectionId;
        }

        public Long getSyncParamId() {
            return this.syncParamId;
        }

        public void setSyncParamId(Long syncParamId) {
            this.syncParamId = syncParamId;
        }

        public Long getDataSchemeId() {
            return this.dataSchemeId;
        }

        public void setDataSchemeId(Long dataSchemeId) {
            this.dataSchemeId = dataSchemeId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getTableNumber() {
            return this.tableNumber;
        }

        public void setTableNumber(String tableNumber) {
            this.tableNumber = tableNumber;
        }

        public Boolean getIgnoreDimNull() {
            return this.ignoreDimNull;
        }

        public void setIgnoreDimNull(Boolean ignoreDimNull) {
            this.ignoreDimNull = ignoreDimNull;
        }

        public Boolean getSuperLongData() {
            return this.superLongData;
        }

        public void setSuperLongData(Boolean superLongData) {
            this.superLongData = superLongData;
        }

        public String getTimeFormatString() {
            return this.timeFormatString;
        }

        public void setTimeFormatString(String timeFormatString) {
            this.timeFormatString = timeFormatString;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getCslSchemeName() {
            return this.cslSchemeName;
        }

        public void setCslSchemeName(String cslSchemeName) {
            this.cslSchemeName = cslSchemeName;
        }
    }

    public static class TabStepFalseMessage
    extends EasyModelMessage {
        String message;

        public TabStepFalseMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class EasyModelMessage {
        boolean exitData;
        boolean clear;

        public boolean isExitData() {
            return this.exitData;
        }

        public void setExitData(boolean exitData) {
            this.exitData = exitData;
        }

        public boolean isClear() {
            return this.clear;
        }

        public void setClear(boolean clear) {
            this.clear = clear;
        }
    }

    public static interface TabStep
    extends BusOpera {
        default public EasyModelMessage previousStep(EasyModel easyModel) {
            return null;
        }

        default public EasyModelMessage nextStep(EasyModel easyModel) {
            return null;
        }

        default public EasyModelMessage cancelOrRunBackstage() {
            return null;
        }

        @Override
        default public void init(EasyModelMessage object) {
        }

        default public void init(EasyModelMessage object, IFormView view) {
        }

        @Override
        default public void clear(EasyModelMessage easyModelMessage) {
        }
    }

    public static interface BusOpera {
        public void init(EasyModelMessage var1);

        default public void setFSAEasyModelBusFormPlugin(FSAEasyModelBusFormPlugin e) {
        }

        default public void clear(EasyModelMessage easyModelMessage) {
        }
    }

    public static enum TabNameEnum {
        KEY_CHOOSE_DATA_SOURCE("FSAEasyModelDataSource", "choose_data_source", Arrays.asList("btncancel", "btn_next")),
        KEY_DATA_DIMENSION_CONFIG("FSAEasyModeDimConfigFormPlugin", "data_dimension_config", Arrays.asList("btn_previous", "btn_next")),
        KEY_TABLE_CONFIRM("FSAEasyModeTableConfirmFormPlugin", "table_confirm", Arrays.asList("btn_previous", "btnok")),
        KEY_DATA_FETCH("FSAEasyModeQueryDataFormPlugin", "data_fetch", Collections.singletonList("enter_scheme")),
        KEY_TABLE_PREVIEW("FSAEasyModeReportFormPlugin", "table_preview", Collections.singletonList("btncancel"));

        String pluginName;
        String tabName;
        List<String> showButtonName;

        private TabNameEnum(String pluginName, String tabName, List<String> showButtonName) {
            this.pluginName = pluginName;
            this.tabName = tabName;
            this.showButtonName = showButtonName;
        }

        static List<String> getList(String tabName) {
            switch (tabName) {
                case "choose_data_source": {
                    return TabNameEnum.KEY_CHOOSE_DATA_SOURCE.showButtonName;
                }
                case "data_dimension_config": {
                    return TabNameEnum.KEY_DATA_DIMENSION_CONFIG.showButtonName;
                }
                case "table_confirm": {
                    return TabNameEnum.KEY_TABLE_CONFIRM.showButtonName;
                }
                case "data_fetch": {
                    return TabNameEnum.KEY_DATA_FETCH.showButtonName;
                }
                case "table_preview": {
                    return TabNameEnum.KEY_TABLE_PREVIEW.showButtonName;
                }
            }
            return Collections.emptyList();
        }
    }
}

