/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.fsa.formplugin.FSAEasyModelBusFormPlugin;
import kd.data.fsa.olap.OlapCslSchemeInfo;
import kd.data.fsa.olap.OlapServerBaseMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.TemplateCatalog;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAEasyModelDataSource
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
SearchEnterListener,
FSAEasyModelBusFormPlugin.TabStep,
ListRowClickListener {
    private static final String HISTORY_PAGECACHE_KEY = "historyOperator";
    private static final String COLOR = "#fc8055";
    private static final String IMAGEUP = "imageup";
    private static final String IMAGEDOWN = "imagedown";
    private static final String FORMPLUGIN = "data-fsa-formplugin";
    private static final String CSLSCHEME = "cslscheme";
    private static final String SCENARIO = "scenario";
    private static final String MODULE = "module";
    private static final String SEARCHAP = "searchap";
    private static final String SEARCHTEXT = "searchText";
    private static final String TREENODELIST = "treeNodeList";
    private static final String HASNOCHANGE = "hasnochange";
    private static final String ISEXITDATE = "isExitDate";
    private static final String LASTSELECTTREE = "lastSelectTree";
    private static final String FOCUSNODE = "focusNode";
    private static final String ISCLEAR = "isClear";
    private static final String NEWMODELID = "newModelId";
    private static final String NOREFSHBILLLIST = "noRefshBilllist";
    private static final String EXITTREE = "exitTree";
    private static final String SEARCHLIST = "searchList";

    public void initialize() {
        super.initialize();
        BillList billList = this.getBillList();
        billList.setBillFormId("bcm_templateentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.equals(IMAGEUP) || key.equals(IMAGEDOWN)) {
            String searchText = this.getPageCache().get(SEARCHTEXT);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchText)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u641c\u7d22\u5185\u5bb9\u6309\u56de\u8f66\u952e\u540e\u8fdb\u884c\u641c\u7d22\u3002", (String)"FSAEasyModelDataSource_5", (String)FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String searchList = this.getPageCache().get(SEARCHLIST);
            List searchTreeNodeList = FSAJSONUtils.jsonCastToList((String)searchList, TreeNode.class);
            if (CollectionUtils.isEmpty((Collection)searchTreeNodeList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5173\u952e\u8bcd\u6ca1\u6709\u68c0\u7d22\u5230\u76f8\u5173\u7684\u6a21\u677f\u5206\u7c7b\u3002", (String)"FSAEasyModelDataSource_6", (String)FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String focusNodeId = this.getTreeView().getTreeState().getFocusNodeId();
            String treeNodeListJson = this.getPageCache().get(TREENODELIST);
            List treeNodeList = FSAJSONUtils.jsonCastToList((String)treeNodeListJson, TreeNode.class);
            switch (key) {
                case "imageup": {
                    this.preClick(treeNodeList, searchTreeNodeList, focusNodeId);
                    break;
                }
                case "imagedown": {
                    this.nextClick(treeNodeList, searchTreeNodeList, focusNodeId);
                    break;
                }
            }
        }
    }

    private void nextClick(List<TreeNode> treeNodeList, List<TreeNode> searchTreeNodeList, String currentId) {
        List allId = treeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        List searchId = searchTreeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        int index = allId.indexOf(currentId);
        int loop = 0;
        block0: do {
            if (index == treeNodeList.size() - 1) {
                index = 0;
            }
            for (int i = index + 1; i < treeNodeList.size(); ++i) {
                TreeNode treeNode = treeNodeList.get(i);
                String id = treeNode.getId();
                if (searchId.contains(id)) {
                    this.getTreeView().treeNodeClick(treeNode.getParentid(), treeNode.getId());
                    this.getTreeView().focusNode(treeNode);
                    loop = 1;
                    continue block0;
                }
                ++index;
            }
        } while (loop++ < 1);
    }

    private void preClick(List<TreeNode> treeNodeList, List<TreeNode> searchTreeNodeList, String currentId) {
        List allId = treeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        List searchId = searchTreeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        int index = allId.indexOf(currentId);
        int loop = 0;
        block0: do {
            if (index - 1 < 0) {
                index = treeNodeList.size() - 1;
            }
            for (int i = index - 1; i >= 0; --i) {
                TreeNode treeNode = treeNodeList.get(i);
                String id = treeNode.getId();
                if (searchId.contains(id)) {
                    this.getTreeView().treeNodeClick(treeNode.getParentid(), treeNode.getId());
                    this.getTreeView().focusNode(treeNode);
                    loop = 1;
                    continue block0;
                }
                --index;
            }
        } while (loop++ < 1);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminorgEdit = (BasedataEdit)this.getView().getControl(CSLSCHEME);
        adminorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView treeView = this.getTreeView();
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        BillList billList = this.getBillList();
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(new String[]{IMAGEUP, IMAGEDOWN});
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        HistoryOperator historyOperator = this.getHistory();
        if (currentListSelectedRow == null) {
            return;
        }
        Long primaryKeyValue = (Long)currentListSelectedRow.getPrimaryKeyValue();
        String hasNoChange = this.getPageCache().get(HASNOCHANGE);
        String isExitDate = this.getPageCache().get(ISEXITDATE);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isExitDate) && !primaryKeyValue.equals(historyOperator.getSelectRowId()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)hasNoChange)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u9009\u62e9\u6539\u53d8\u5c06\u6e05\u7a7a\u4e0b\u4e00\u9875\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSAEasyModelDataSource_4", (String)FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("changeRow", (IFormPlugin)this));
        }
    }

    private HistoryOperator getHistory() {
        String history = this.getPageCache().get(HISTORY_PAGECACHE_KEY);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)history)) {
            HistoryOperator historyOperator = new HistoryOperator();
            this.getPageCache().put(HISTORY_PAGECACHE_KEY, JSON.toJSONString((Object)historyOperator));
            return historyOperator;
        }
        return (HistoryOperator)JSON.parseObject((String)history, HistoryOperator.class);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String lastSelectTreeNodeId = this.getPageCache().get(LASTSELECTTREE);
        String scenario = (String)this.getModel().getValue(SCENARIO);
        String oldScenario = this.getHistory().getScenarioId();
        if (!nodeId.equals(lastSelectTreeNodeId) || !oldScenario.equals(scenario)) {
            this.refshTemplates(nodeId);
            this.getPageCache().put(LASTSELECTTREE, nodeId);
            TreeNode treeNode = new TreeNode((String)evt.getParentNodeId(), nodeId, "");
            this.getPageCache().put(FOCUSNODE, JSON.toJSONString((Object)treeNode));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        switch (actionId) {
            case "cancelConfirm": {
                if (MessageBoxResult.Yes != messageBoxResult) break;
                this.getView().getPageCache().put("forceClose", "1");
                this.getView().close();
                break;
            }
            case "changeModule": {
                if (MessageBoxResult.Yes == messageBoxResult) {
                    this.getPageCache().put(ISCLEAR, ISCLEAR);
                    long newModelId = Long.parseLong(this.getPageCache().get(NEWMODELID));
                    this.changeModule(newModelId);
                    this.getPageCache().remove(HASNOCHANGE);
                } else {
                    HistoryOperator historyOperator = this.getHistory();
                    this.getModel().beginInit();
                    this.getModel().setValue(MODULE, (Object)historyOperator.getModuleId());
                    this.getModel().endInit();
                    this.getView().updateView(MODULE);
                }
                this.getPageCache().remove(NEWMODELID);
                break;
            }
            case "changeRow": {
                String oldScenarioId;
                if (MessageBoxResult.Yes == messageBoxResult) {
                    this.getPageCache().put(ISCLEAR, ISCLEAR);
                    this.getPageCache().remove(HASNOCHANGE);
                    break;
                }
                HistoryOperator history = this.getHistory();
                TreeView treeView = this.getTreeView();
                String newFocusNodeId = treeView.getTreeState().getFocusNodeId();
                TreeNode treeNode = history.getTreeNode();
                String treeNodeId = treeNode.getId();
                String scenarioId = (String)this.getModel().getValue(SCENARIO);
                boolean newOldScenarioEquals = scenarioId.equals(oldScenarioId = history.getScenarioId());
                if (!newOldScenarioEquals) {
                    this.getPageCache().put(NOREFSHBILLLIST, "1");
                    this.getModel().setValue(SCENARIO, (Object)oldScenarioId);
                }
                if (!newFocusNodeId.equals(treeNodeId) || !newOldScenarioEquals) {
                    this.focus(treeView, treeNode);
                    this.refshTemplates(treeNodeId);
                    this.getPageCache().put(LASTSELECTTREE, treeNodeId);
                }
                this.getPageCache().remove(NOREFSHBILLLIST);
                int selectedOldRowIndex = history.getSelectRowIndex();
                BillList billList = this.getBillList();
                billList.selectRows(selectedOldRowIndex);
                break;
            }
        }
    }

    private void focus(TreeView treeView, TreeNode treeNode) {
        treeView.focusNode(treeNode);
        this.getPageCache().put(FOCUSNODE, JSON.toJSONString((Object)treeNode));
    }

    private void changeModule(Long newModelId) {
        this.getModel().setValue(CSLSCHEME, null);
        OlapCslSchemeInfo olapCslSchemeInfo = FSABcmDataProvider.loadDefaultCslSchemeInfo((long)newModelId);
        if (olapCslSchemeInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u6ca1\u6709\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"FSAEasyModelDataSource_8", (String)FORMPLUGIN, (Object[])new Object[0]));
        }
        this.getModel().setValue(CSLSCHEME, (Object)olapCslSchemeInfo.getId());
        this.getModel().beginInit();
        this.getModel().setValue(SCENARIO, (Object)"");
        this.getModel().endInit();
        this.changeScenario(newModelId);
        List templateCatalogs = FSABcmDataProvider.loadTemplateCatalog((long)newModelId, null, (Object[][])null);
        this.refshCatalog(templateCatalogs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "module": {
                DynamicObject newModel = (DynamicObject)newValue;
                if (newModel == null) {
                    return;
                }
                Long modelId = (Long)newModel.getPkValue();
                String isExitDate = this.getPageCache().get(ISEXITDATE);
                String hasNoChange = this.getPageCache().get(HASNOCHANGE);
                HistoryOperator history = this.getHistory();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isExitDate) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)hasNoChange) && history != null && history.getModuleId() != null && newModel.getLong("id") != history.getModuleId().longValue()) {
                    this.getPageCache().put(NEWMODELID, modelId.toString());
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4f53\u7cfb\u6539\u53d8\u5c06\u6e05\u7a7a\u5df2\u64cd\u4f5c\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSAEasyModelDataSource_2", (String)FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("changeModule", (IFormPlugin)this));
                    break;
                }
                if (history != null && history.getModuleId() != null && newModel.getLong("id") == history.getModuleId().longValue()) break;
                this.changeModule(modelId);
                break;
            }
            case "scenario": {
                DynamicObject modelDyna = (DynamicObject)this.getModel().getValue(MODULE);
                if (modelDyna == null) {
                    return;
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((String)newValue))) {
                    Long scenarioId = Long.parseLong((String)newValue);
                    Long modelId = (Long)modelDyna.getPkValue();
                    int[] filters = new int[]{1};
                    Long dimId = null;
                    String scenarioIdCache = this.getPageCache().get(modelId + SCENARIO);
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)scenarioIdCache)) {
                        Map dimemsionMetaInfoMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)modelId);
                        dimId = ((OlapServerDimemsionMetaInfo)dimemsionMetaInfoMap.get("Scenario")).getId();
                        if (dimId == null) {
                            throw new KDBizException("bcm Scenario id is null error");
                        }
                        this.getPageCache().put(modelId + SCENARIO, dimId.toString());
                    } else {
                        dimId = Long.parseLong(scenarioIdCache);
                    }
                    Object[][] filterParams = new Object[][]{{dimId, scenarioId}};
                    List templateCatalogs = FSABcmDataProvider.loadTemplateCatalog((long)modelId, (int[])filters, (Object[][])filterParams);
                    this.refshCatalog(templateCatalogs);
                    break;
                }
                Long modelId = (Long)modelDyna.getPkValue();
                List templateCatalogs = FSABcmDataProvider.loadTemplateCatalog((long)modelId, null, (Object[][])null);
                this.refshCatalog(templateCatalogs);
            }
        }
    }

    private void initTemplate(BillList billList) {
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("id", "=", null);
        fp.setFilter(filter);
        billList.setMulti(false);
        billList.setFilterParameter(fp);
    }

    private void refshTemplates(String nodeId) {
        if (nodeId == null) {
            throw new KDBizException("An exception occurred with node ID null");
        }
        Long nodeid = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nodeId) ? 0L : Long.parseLong(nodeId);
        IDataModel model = this.getModel();
        DynamicObject modelDyna = (DynamicObject)model.getValue(MODULE);
        String scenarioId = (String)model.getValue(SCENARIO);
        BillList billList = this.getBillList();
        billList.setBillFormId("bcm_templateentity");
        if (modelDyna == null || StringUtils.isEmpty((String)modelDyna.getPkValue().toString()) || "0".equals(modelDyna.getPkValue().toString())) {
            billList.clearData();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FSAEasyModelDataSource_0", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FilterParameter fp = new FilterParameter();
        Long modelId = (Long)modelDyna.getPkValue();
        List<String> select = Arrays.asList("number", "name", "status", "versionnumber", "templatecatalog.name", "effectivedate", "expiringdate", "usage", "creator.name", "createtime", "modifier.naodifytme", "modifytime");
        fp.setSelectFields(select);
        fp.setOrderBy("sequence asc,number asc");
        String cache = this.getPageCache().get("templateCatalogChildren");
        Map templateCatalogChildren = (Map)JSON.parseObject((String)cache, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
        Set<Long> childrenIds = (Set<Long>)templateCatalogChildren.get(nodeid);
        if (childrenIds != null) {
            childrenIds.add(nodeid);
        } else {
            childrenIds = Collections.singleton(nodeid);
        }
        List templates = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)scenarioId)) {
            int[] intFilter = new int[]{1};
            String scenarioDimIdCache = this.getPageCache().get(modelId + SCENARIO);
            Object[][] filterParams = new Object[][]{{Long.parseLong(scenarioDimIdCache), Long.parseLong(scenarioId)}};
            templates = FSABcmDataProvider.loadTemplate((long)modelId, childrenIds, (int[])intFilter, (Object[][])filterParams);
        } else {
            templates = FSABcmDataProvider.loadTemplate((long)modelId, childrenIds, null, (Object[][])null);
        }
        Set templateIds = templates.stream().map(OlapServerBaseMetaInfo::getId).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", templateIds);
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.setClearSelection(true);
        billList.setMulti(false);
        billList.refresh();
    }

    private void refshCatalog(List<TemplateCatalog> templateCatalogs) {
        TreeView treeView = this.getTreeView();
        treeView.deleteAllNodes();
        this.getPageCache().remove(EXITTREE);
        this.initTree(treeView, templateCatalogs);
    }

    private void initTree(TreeView tree, List<TemplateCatalog> templateCatalogs) {
        String searchText;
        if (CollectionUtils.isEmpty(templateCatalogs)) {
            return;
        }
        Map<Long, List<TemplateCatalog>> collect = templateCatalogs.stream().collect(Collectors.groupingBy(TemplateCatalog::getParentId));
        Map parentChildrenIds = templateCatalogs.stream().collect(Collectors.groupingBy(TemplateCatalog::getParentId, Collectors.mapping(p -> p.getId(), Collectors.toSet())));
        this.getPageCache().put("templateCatalogChildren", FSAJSONUtils.toJsonString(parentChildrenIds));
        List<TemplateCatalog> rootCatalogs = collect.get(0L);
        if (CollectionUtils.isEmpty(templateCatalogs)) {
            throw new KDBizException("TemplateCatalog has not root Node");
        }
        TemplateCatalog templateCatalog = rootCatalogs.get(0);
        TreeNode rootNode = new TreeNode("", templateCatalog.getId().toString(), templateCatalog.getName());
        this.setChildNode(rootNode, collect);
        tree.addNode(rootNode);
        List<TreeNode> listFromTreeNode = this.getListFromTreeNode(rootNode, new ArrayList<TreeNode>(16));
        this.getPageCache().put(TREENODELIST, JSON.toJSONString(listFromTreeNode));
        tree.setRootVisible(true);
        this.getPageCache().put(EXITTREE, "1");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getPageCache().get(NOREFSHBILLLIST))) {
            this.focus(tree, rootNode);
            this.refshTemplates(rootNode.getId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(searchText = this.getPageCache().get(SEARCHTEXT)))) {
            this.search(new SearchEnterEvent((Object)this.getView().getControl(SEARCHAP), searchText));
        }
    }

    private List<TreeNode> getListFromTreeNode(TreeNode treeNode, List<TreeNode> treeNodes) {
        List children;
        if (treeNodes != null) {
            treeNodes.add(treeNode);
        }
        if ((children = treeNode.getChildren()) != null) {
            children.forEach(p -> this.getListFromTreeNode((TreeNode)p, treeNodes));
        }
        return treeNodes;
    }

    private void setChildNode(TreeNode rootNode, Map<Long, List<TemplateCatalog>> collect) {
        List<TemplateCatalog> templateCatalogs = collect.get(Long.parseLong(rootNode.getId()));
        if (templateCatalogs == null) {
            return;
        }
        templateCatalogs.forEach(p -> {
            TreeNode treeNode = new TreeNode(String.valueOf(p.getParentId()), p.getId().toString(), p.getName());
            rootNode.addChild(treeNode);
            this.setChildNode(treeNode, collect);
        });
        rootNode.setIsOpened(true);
        rootNode.setExpend(true);
    }

    private void changeScenario(Long modelId) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(SCENARIO);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        if (modelId == null) {
            data.clear();
        } else {
            Map olapServerDimMemberMetaInfoMap = FSABcmDataProvider.loadScenaio((Long)modelId);
            HashMap<String, OlapServerDimMemberMetaInfo> idMemberMapCache = new HashMap<String, OlapServerDimMemberMetaInfo>(olapServerDimMemberMetaInfoMap.size());
            for (Map.Entry next : olapServerDimMemberMetaInfoMap.entrySet()) {
                OlapServerDimMemberMetaInfo value = (OlapServerDimMemberMetaInfo)next.getValue();
                String idstr = value.getId().toString();
                idMemberMapCache.put(idstr, value);
                data.add(new ComboItem(new LocaleString(value.getName()), idstr));
            }
            this.getPageCache().put("scenarioMembers", JSON.toJSONString(idMemberMapCache));
        }
        comboEdit.setComboItems(data);
    }

    private void selectCslscheme(BeforeF7SelectEvent evt) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODULE);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FSAEasyModelDataSource_0", (String)FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            long id = model.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCustomParam("custom", (Object)"fsa");
            showParameter.getListFilterParameter().setFilter(new QFilter("model", "=", (Object)id));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "cslscheme": {
                this.selectCslscheme(evt);
                break;
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        String exitTree = this.getPageCache().get(EXITTREE);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)exitTree)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FSAEasyModelDataSource_0", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"FSAEasyModelDataSource_3", (String)FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.getPageCache().put(SEARCHTEXT, text);
            TreeView treeView = this.getTreeView();
            String treeNodeListJson = this.getPageCache().get(TREENODELIST);
            List treeNodeList = FSAJSONUtils.jsonCastToList((String)treeNodeListJson, TreeNode.class);
            treeNodeList.forEach(p -> p.setColor(""));
            treeView.updateNodes(treeNodeList);
            List<TreeNode> treeNodeListByText = treeNodeList.stream().filter(p -> p.getText().toLowerCase().contains(text.toLowerCase())).collect(Collectors.toList());
            this.getPageCache().put(SEARCHLIST, JSON.toJSONString(treeNodeListByText));
            treeNodeListByText.forEach(p -> p.setColor(COLOR));
            treeView.updateNodes(treeNodeListByText);
            treeView.focusNode((TreeNode)JSON.parseObject((String)this.getPageCache().get(FOCUSNODE), TreeNode.class));
        }
    }

    @Override
    public void init(FSAEasyModelBusFormPlugin.EasyModelMessage object) {
        if (object == null) {
            BillList billList = this.getBillList();
            this.initTemplate(billList);
        } else if (object instanceof FSAEasyModelBusFormPlugin.EasyModel) {
            FSAEasyModelBusFormPlugin.EasyModel easyModel = (FSAEasyModelBusFormPlugin.EasyModel)object;
            if (easyModel.isExitData()) {
                this.getPageCache().put(ISEXITDATE, ISEXITDATE);
                this.getPageCache().put(HASNOCHANGE, HASNOCHANGE);
            } else {
                this.getPageCache().remove(ISEXITDATE);
            }
        }
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage nextStep(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        String exitTree = this.getPageCache().get(EXITTREE);
        DynamicObject module = (DynamicObject)this.getModel().getValue(MODULE);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)exitTree) || module == null) {
            return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"FSAEasyModelDataSource_0", (String)FORMPLUGIN, (Object[])new Object[0]));
        }
        DynamicObject cslscheme = (DynamicObject)this.getModel().getValue(CSLSCHEME);
        if (cslscheme == null) {
            return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"FSAEasyModelDataSource_7", (String)FORMPLUGIN, (Object[])new Object[0]));
        }
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return new FSAEasyModelBusFormPlugin.TabStepFalseMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u677f\u3002", (String)"FSAEasyModelDataSource_1", (String)FORMPLUGIN, (Object[])new Object[0]));
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        String isExitDate = this.getPageCache().get(ISEXITDATE);
        String isClear = this.getPageCache().get(ISCLEAR);
        easyModel = this.packageData(easyModel, listSelectedRow);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isExitDate)) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isClear)) {
                easyModel.setClear(true);
            } else if (!this.getModel().getValue("cslscheme_id").equals(this.getHistory().getCslschemeId()) && !CollectionUtils.isEmpty(easyModel.getDimFilters())) {
                List<FSAEasyModelBusFormPlugin.DimFilter> dimFilters = easyModel.getDimFilters();
                for (int i = 0; i < dimFilters.size(); ++i) {
                    FSAEasyModelBusFormPlugin.DimFilter dimFilter = dimFilters.get(i);
                    if (!dimFilter.getNumber().equals("Entity")) continue;
                    dimFilter.setMemberFilters(null);
                    break;
                }
            }
        }
        this.nextStepSetHisory(listSelectedRow);
        return easyModel;
    }

    @Override
    public FSAEasyModelBusFormPlugin.EasyModelMessage cancelOrRunBackstage() {
        String exitTree = this.getPageCache().get(EXITTREE);
        DynamicObject module = (DynamicObject)this.getModel().getValue(MODULE);
        DynamicObject cslscheme = (DynamicObject)this.getModel().getValue(CSLSCHEME);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exitTree) || module != null || cslscheme != null) {
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff0c\u82e5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FSAEasyModelBusFormPlugin_1", (String)FORMPLUGIN, (Object[])new Object[0]);
            FSAEasyModelBusFormPlugin.TabStepFalseMessage tabStepFalseMessage = new FSAEasyModelBusFormPlugin.TabStepFalseMessage(msg);
            return tabStepFalseMessage;
        }
        return null;
    }

    FSAEasyModelBusFormPlugin.EasyModel packageData(FSAEasyModelBusFormPlugin.EasyModel easyModel, ListSelectedRow listSelectedRow) {
        Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
        String name = listSelectedRow.getName();
        String number = listSelectedRow.getNumber();
        String scenarioId = (String)this.getModel().getValue(SCENARIO);
        Long module = (Long)this.getModel().getValue("module_id");
        if (easyModel == null) {
            easyModel = new FSAEasyModelBusFormPlugin.EasyModel();
        }
        easyModel.setModuleId(module);
        easyModel.setScenarioMemberId(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)scenarioId) ? null : Long.valueOf(Long.parseLong(scenarioId)));
        easyModel.setTemplateId(primaryKeyValue);
        easyModel.setTemplateName(name);
        easyModel.setTemplateNumber(number);
        DynamicObject moduleDynamicObject = (DynamicObject)this.getModel().getValue(MODULE);
        easyModel.setModuleName(moduleDynamicObject.getString("name"));
        this.setCslscheme(easyModel);
        return easyModel;
    }

    private void nextStepSetHisory(ListSelectedRow listSelectedRow) {
        HistoryOperator historyOperator = this.getHistory();
        Long module = (Long)this.getModel().getValue("module_id");
        String scenarioId = (String)this.getModel().getValue(SCENARIO);
        Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
        historyOperator.setModuleId(module);
        historyOperator.setScenarioId(scenarioId);
        Long cslschemeId = (Long)this.getModel().getValue("cslscheme_id");
        historyOperator.setCslschemeId(cslschemeId);
        historyOperator.setSearchapText(this.getPageCache().get(SEARCHTEXT));
        historyOperator.setSelectRowIndex(listSelectedRow.getRowKey());
        historyOperator.setSelectRowId(primaryKeyValue);
        TreeView treeView = this.getTreeView();
        Map focusNode = treeView.getTreeState().getFocusNode();
        TreeNode treeNode = new TreeNode((String)focusNode.get("parentid"), (String)focusNode.get("id"), (String)focusNode.get("text"));
        historyOperator.setTreeNode(treeNode);
        this.getPageCache().put(HISTORY_PAGECACHE_KEY, JSON.toJSONString((Object)historyOperator));
    }

    private void setCslscheme(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        DynamicObject cslschemeDynamicObject = (DynamicObject)this.getModel().getValue(CSLSCHEME);
        easyModel.setCslSchemeName(cslschemeDynamicObject.getString("name"));
        Long cslschemeId = (Long)this.getModel().getValue("cslscheme_id");
        easyModel.setCslScheme(cslschemeId);
    }

    private TreeView getTreeView() {
        return (TreeView)this.getControl("templatecatalog");
    }

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    private static class HistoryOperator {
        private Long moduleId;
        private Long cslschemeId;
        private String scenarioId;
        private String searchapText;
        private TreeNode treeNode;
        private Integer selectRowIndex;
        private Long selectRowId;

        private HistoryOperator() {
        }

        public Long getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(Long moduleId) {
            this.moduleId = moduleId;
        }

        public Long getCslschemeId() {
            return this.cslschemeId;
        }

        public void setCslschemeId(Long cslschemeId) {
            this.cslschemeId = cslschemeId;
        }

        public String getScenarioId() {
            return this.scenarioId == null ? "" : this.scenarioId;
        }

        public void setScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
        }

        public String getSearchapText() {
            return this.searchapText;
        }

        public void setSearchapText(String searchapText) {
            this.searchapText = searchapText;
        }

        public TreeNode getTreeNode() {
            return this.treeNode;
        }

        public void setTreeNode(TreeNode treeNode) {
            this.treeNode = treeNode;
        }

        public Integer getSelectRowIndex() {
            return this.selectRowIndex;
        }

        public void setSelectRowIndex(Integer selectRowIndex) {
            this.selectRowIndex = selectRowIndex;
        }

        public Long getSelectRowId() {
            return this.selectRowId;
        }

        public void setSelectRowId(Long selectRowId) {
            this.selectRowId = selectRowId;
        }
    }
}

