/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAFieldMappingFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Long collectionId = (Long)view.getFormShowParameter().getCustomParam("datacollection");
        DynamicObject dataCol = BusinessDataServiceHelper.loadSingle((Object)collectionId, (String)"fsa_data_collection");
        if (dataCol != null) {
            FSAFieldMappingWithTimePatternModel fieldMappingWithTimePatternModel;
            IDataModel model = this.getModel();
            IFormView parentView = view.getParentView();
            IDataModel parentModel = parentView.getModel();
            String fileStepConfig = (String)parentModel.getValue("stepconfig", 0);
            FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileStepConfig, FSAFileInfoModel.class);
            List nameList = null;
            if (fileInfoModel != null) {
                nameList = fileInfoModel.getColumnList();
                LinkedList<ComboItem> comboItems = new LinkedList<ComboItem>();
                for (String name : nameList) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(name));
                    item.setValue(name);
                    item.setItemVisible(true);
                    comboItems.add(item);
                }
                ComboEdit cb = (ComboEdit)this.getControl("file_srcfield");
                cb.setComboItems(comboItems);
            }
            String fieldMappingWithTimePatternConfig = (String)parentModel.getValue("stepconfig", 1);
            List modelList = null;
            if (StringUtils.isNotEmpty((String)fieldMappingWithTimePatternConfig) && (fieldMappingWithTimePatternModel = (FSAFieldMappingWithTimePatternModel)JSON.parseObject((String)fieldMappingWithTimePatternConfig, (TypeReference)new TypeReference<FSAFieldMappingWithTimePatternModel>(){}, (Feature[])new Feature[0])) != null) {
                model.setValue("timeformat", (Object)fieldMappingWithTimePatternModel.getTimePattern());
                modelList = fieldMappingWithTimePatternModel.getFieldMappingModelList();
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField("paramfield_name", new Object[0]);
            tvs.addField("paramfield_number", new Object[0]);
            tvs.addField("dimension_type", new Object[0]);
            tvs.addField("data_type", new Object[0]);
            tvs.addField("file_srcfield", new Object[0]);
            tvs.addField("default_value", new Object[0]);
            DynamicObjectCollection dataEntryEntity = dataCol.getDynamicObjectCollection("dataentryentity");
            for (DynamicObject entity : dataEntryEntity) {
                String dimName = entity.getString("dimname");
                String dimNumber = entity.getString("dimnumber");
                String dimType = entity.getString("dimtype");
                String dataType = entity.getString("dimdatatype");
                String fileSrcField = null;
                String defaultValue = null;
                if (!CollectionUtils.isEmpty((Collection)modelList)) {
                    for (FSAFieldMappingModel fmm : modelList) {
                        Object[] objArr = fmm.getV();
                        if (!dimNumber.equalsIgnoreCase((String)objArr[0])) continue;
                        fileSrcField = (String)objArr[1];
                        defaultValue = (String)objArr[2];
                    }
                } else if (nameList != null && !nameList.isEmpty()) {
                    for (String srcField : nameList) {
                        if (!dimName.equalsIgnoreCase(srcField) && !dimNumber.equalsIgnoreCase(srcField)) continue;
                        fileSrcField = srcField;
                    }
                }
                tvs.addRow(new Object[]{dimName, dimNumber, dimType, dataType, fileSrcField, defaultValue});
            }
            abstractModel.batchCreateNewEntryRow("mapping_entry", tvs);
            abstractModel.endInit();
            view.updateView("mapping_entry");
        }
    }
}

