/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.util.StringUtils;
import kd.data.fsa.file.FSACSVFileReader;
import kd.data.fsa.file.FSAFileReaderFactory;
import kd.data.fsa.file.FSASupFileReader;
import kd.data.fsa.formplugin.FSABaseFormPlugin;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAFileUploadFormPlugin
extends FSABaseFormPlugin
implements UploadListener,
AttachmentMarkListener {
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{"fileinfo"});
        view.setEnable(Boolean.FALSE, new String[]{"btnok"});
        Boolean hiddenOperate = (Boolean)view.getFormShowParameter().getCustomParam("customHiddenOperatePanel");
        if (hiddenOperate == null) {
            view.setEnable(Boolean.FALSE, new String[]{"contentpanel", "operatepanel"});
        } else {
            view.setVisible(hiddenOperate, new String[]{"operatepanel"});
        }
        String fileInfo = (String)view.getFormShowParameter().getCustomParam("customEcho");
        if (StringUtils.isNotEmpty((String)fileInfo)) {
            view.setVisible(Boolean.TRUE, new String[]{"oldfileflex"});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfo, FSAFileInfoModel.class);
            String urlMapJson = fileInfoModel.getUrlMapJson();
            List urlMaps = (List)JSON.parseObject((String)urlMapJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            Map urlMap = (Map)urlMaps.get(0);
            Date createDate = new Date((Long)urlMap.get("createdate"));
            String fileName = String.valueOf(urlMap.get("name"));
            Map creator = (Map)urlMap.get("creator");
            String creatorName = new LocaleString((String)creator.values().iterator().next()).getLocaleValue();
            model.setValue("oldfilename", (Object)fileName, 0);
            model.setValue("creator", (Object)creatorName, 0);
            model.setValue("createtime", (Object)sdf.format(createDate), 0);
            model.setValue("mark", (Object)String.valueOf(urlMap.get("mark") == null ? "" : urlMap.get("mark")), 0);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"oldfileflex"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addMarkListener((AttachmentMarkListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterUpload(UploadEvent evt) {
        Control source = (Control)evt.getSource();
        if ("attachmentpanelap".equals(source.getKey())) {
            IFormView view = this.getView();
            Object[] urls = evt.getUrls();
            if (urls.length == 1) {
                Map url = (Map)urls[0];
                String name = String.valueOf(url.get("name"));
                String fileUrl = String.valueOf(url.get("url"));
                FSASupFileReader fileReader = FSAFileReaderFactory.getFileReader((String)name);
                FSAFileInfoModel fileInfoModel = fileReader.getFileInfoNoSheetSelect(name, fileUrl, name);
                fileInfoModel.setUrlMapJson(FSAJSONUtils.toJsonString((Object)urls));
                Boolean hiddenOperate = (Boolean)view.getFormShowParameter().getCustomParam("customHiddenOperatePanel");
                if (!hiddenOperate.booleanValue()) {
                    IDataModel model = this.getModel();
                    model.setValue("fileinfo", (Object)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u5f20sheet\uff0c\u5171%2$s\u884c\u6570\u636e", (String)"FSAFileUploadFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), fileInfoModel.getSheetNameList().size(), fileInfoModel.getDataCount()));
                    view.setVisible(Boolean.TRUE, new String[]{"fileinfo"});
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u3002", (String)"FSAFileUploadFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                view.setEnable(Boolean.TRUE, new String[]{"btnok"});
                view.setVisible(Boolean.FALSE, new String[]{"oldfileflex"});
                view.getPageCache().put("pageCacheFileInfoModel", FSAJSONUtils.toJsonString((Object)fileInfoModel));
                view.getPageCache().put("pageCacheFileUrlMap", FSAJSONUtils.toJsonString((Object)url));
            } else {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"FSAFileUploadFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        Control source = (Control)evt.getSource();
        if ("attachmentpanelap".equals(source.getKey())) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            model.setValue("fileinfo", (Object)"");
            view.setVisible(Boolean.FALSE, new String[]{"fileinfo"});
            view.setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String fileInfoModeJson = view.getPageCache().get("pageCacheFileInfoModel");
            Boolean hiddenOperate = (Boolean)view.getFormShowParameter().getCustomParam("customHiddenOperatePanel");
            MainEntityType entityType = model.getDataEntityType();
            FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            List attachmentData = attachmentPanel.getAttachmentData();
            String fileName = String.valueOf(((Map)attachmentData.get(0)).get("name"));
            fileInfoModel.setFileName(fileName);
            FSASupFileReader fileReader = FSAFileReaderFactory.getFileReader((String)fileName);
            if (fileReader instanceof FSACSVFileReader) {
                fileInfoModel.setSheetNameList(fileReader.getSheetNames(fileName));
                fileInfoModel.setSheetName(fileName);
            }
            String urlMapJson = fileInfoModel.getUrlMapJson();
            List urlMaps = (List)JSON.parseObject((String)urlMapJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            ((Map)urlMaps.get(0)).put("name", fileName);
            fileInfoModel.setUrlMapJson(JSON.toJSONString((Object)urlMaps));
            if (hiddenOperate.booleanValue()) {
                String path = FSAFileReaderFactory.getFileReader((String)fileInfoModel.getFileName()).upload(entityType, fileInfoModel.getFileName(), fileInfoModel.getFileUrl());
                fileInfoModel.setFileUrl(path);
            }
            view.returnDataToParent((Object)FSAJSONUtils.toJsonString((Object)fileInfoModel));
            view.close();
        }
    }

    public void mark(AttachmentMarkEvent evt) {
        IFormView view = this.getView();
        String fileInfoModeJson = view.getPageCache().get("pageCacheFileInfoModel");
        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
        String urlMapJson = fileInfoModel.getUrlMapJson();
        List urlMaps = (List)JSON.parseObject((String)urlMapJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        ((Map)urlMaps.get(0)).put("mark", evt.getDescription());
        fileInfoModel.setUrlMapJson(JSON.toJSONString((Object)urlMaps));
        view.getPageCache().put("pageCacheFileInfoModel", FSAJSONUtils.toJsonString((Object)fileInfoModel));
    }
}

