/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.file.FSAFileReaderFactory;
import kd.data.fsa.formplugin.util.FSACorrectFieldUtil;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSASyncTaskLogHelper;

public class FSAGuideFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
ProgresssListener {
    private static final String[] STEP_FORM_ID = new String[]{"fsa_fileupload", "fsa_offlinedata_preview", "fsa_fieldmapping", "fsa_choose_import_version", "fsa_importdata"};
    private static final String[] FIRST_STEP_SHOW = new String[]{"btn_cancel", "btn_next"};
    private static final String[] FIRST_STEP_HIDE = new String[]{"btn_previous", "btn_ok", "btncancel", "btnok", "btnstartimport", "check_data"};
    private static final String[] END_STEP_SHOW = new String[]{"btn_previous", "btncancel", "btnstartimport"};
    private static final String[] END_STEP_HIDE = new String[]{"btn_next", "btn_cancel", "btn_ok", "btnok", "check_data"};
    private static final String[] MIDDLE_STEP_SHOW = new String[]{"btn_previous", "btn_next"};
    private static final String[] MIDDLE_STEP_HIDE = new String[]{"btn_cancel", "btn_ok", "btncancel", "btnok", "btnstartimport", "check_data"};
    DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("wizard_tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btn_next", "btn_previous", "btn_cancel", "btn_ok", "btnstartimport", "btncancel", "btnok", "check_data"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setStepNumber(0);
        this.showStepPage(0);
        this.buttonVisible(this.buttonControl());
        this.getModel().batchCreateNewEntryRow("stepconfigentry", 4);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object obj = closedCallBackEvent.getReturnData();
        switch (key) {
            case "fsa_number_name_config": {
                this.setTableFromReturnData(obj);
                break;
            }
            case "fsa_importdata": {
                if ("btn_previous".equalsIgnoreCase((String)obj)) {
                    int previousStep = this.getCurrentStep() - 1;
                    this.setStepNumber(previousStep);
                    this.showStepPage(previousStep);
                    this.buttonVisible(this.buttonControl());
                    this.getView().setVisible(Boolean.TRUE, new String[]{"operatepanel"});
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    private void setTableFromReturnData(Object obj) {
        Map result;
        boolean success;
        if (obj instanceof Map && (success = Boolean.parseBoolean((String)(result = (Map)obj).get("res")))) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%s]\u521b\u5efa\u6210\u529f", (String)"FSASyncParamFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), result.get("tablename")));
        }
    }

    private void showStepPage(int stepIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String stepName = STEP_FORM_ID[stepIndex];
        Tab tab = (Tab)this.getControl("wizard_tabap");
        tab.activeTab(stepName);
        if ("fsa_importdata".equals(stepName)) {
            IFormView configView = view.getView(this.getConfigPageId());
            IDataModel configDataModel = configView.getModel();
            Boolean createNewVersion = (Boolean)configDataModel.getValue("create_version");
            this.getPageCache().put("create_version", createNewVersion.toString());
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(stepName);
        OpenStyle openStyle = fsp.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(stepName);
        StyleCss css = new StyleCss();
        css.setWidth("700");
        css.setHeight("550");
        openStyle.setInlineStyleCss(css);
        fsp.setStatus(OperationStatus.ADDNEW);
        if (0 == stepIndex) {
            fsp.setCustomParam("customHiddenOperatePanel", (Object)Boolean.FALSE);
            fsp.setCustomParam("customEcho", model.getValue("stepconfig", 0));
        }
        FormShowParameter originFsp = view.getFormShowParameter();
        fsp.setCustomParam("datacollection", originFsp.getCustomParam("datacollection"));
        fsp.setCustomParam("syncparam_id", originFsp.getCustomParam("syncparam_id"));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, stepName));
        this.setConfigPageId(fsp.getPageId());
        view.showForm(fsp);
    }

    private void buttonVisible(Map<String, String[]> btnMap) {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, btnMap.get("show"));
        view.setVisible(Boolean.FALSE, btnMap.get("hide"));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (control.getKey()) {
            case "btn_previous": {
                this.previousStep();
                break;
            }
            case "btn_next": {
                this.nextStep();
                break;
            }
            case "btnstartimport": {
                view.setVisible(Boolean.FALSE, new String[]{"btn_previous"});
                this.startImport(view);
                break;
            }
            case "btnok": {
                view.getPageCache().put("pageCacheCloseFlag", "true");
                view.getPageCache().put("pageCacheRunBackground", "backMark");
                view.close();
                break;
            }
            case "check_data": {
                String entityNumber = FSACommonConstant.buildEntityName((String)((String)model.getValue("tablenumber")));
                String tableName = (String)model.getValue("tablename");
                FSACorrectFieldUtil.correctFieldIfMissed(entityNumber, tableName);
                FormShowParameter fsp = view.getFormShowParameter();
                Long syncParamId = (Long)fsp.getCustomParam("syncparam_id");
                ReportShowParameter rsp = new ReportShowParameter();
                rsp.setFormId("fsa_dynamicdatapreview");
                rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                rsp.setCustomParam("number", (Object)entityNumber);
                rsp.setCustomParam("rptdatasyncparam", (Object)syncParamId);
                rsp.setCustomParam("disable_versions", null);
                rsp.setCustomParam("use_latest_version", (Object)Boolean.FALSE);
                rsp.setCustomParam("onlyViewAppointVersion", model.getValue("version"));
                rsp.setCustomParam("datasourcetype", (Object)"1");
                rsp.setParentFormId(fsp.getFormId());
                view.showForm((FormShowParameter)rsp);
                break;
            }
        }
    }

    private void previousStep() {
        int currentStep = this.getCurrentStep();
        if (this.sendStepConfigToEntry(currentStep)) {
            int previousStep = currentStep - 1;
            this.setStepNumber(previousStep);
            this.showStepPage(previousStep);
            this.buttonVisible(this.buttonControl());
        }
    }

    private void nextStep() {
        int currentStep = this.getCurrentStep();
        if (this.sendStepConfigToEntry(currentStep)) {
            int nextStep = currentStep + 1;
            this.setStepNumber(nextStep);
            this.showStepPage(nextStep);
            this.buttonVisible(this.buttonControl());
        }
    }

    private void setStepNumber(int currentStep) {
        IDataModel model = this.getModel();
        int number = currentStep + 1;
        model.setValue("stepnumber", (Object)number);
    }

    private boolean sendStepConfigToEntry(int currentStep) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (STEP_FORM_ID.length - 1 == currentStep) {
            return true;
        }
        IFormView configView = view.getView(this.getConfigPageId());
        IDataModel configDataModel = configView.getModel();
        boolean checkResult = this.setDataToEntry(currentStep, configDataModel, configView, model, view);
        if (checkResult) {
            configView.close();
            view.sendFormAction(configView);
        }
        return checkResult;
    }

    private boolean setDataToEntry(int currentStep, IDataModel configDataModel, IFormView configView, IDataModel model, IFormView view) {
        switch (currentStep) {
            case 0: {
                String fileInfoModelJson = configView.getPageCache().get("pageCacheFileInfoModel");
                if (StringUtils.isNotEmpty((String)fileInfoModelJson)) {
                    model.setValue("stepconfig", (Object)fileInfoModelJson, 0);
                    break;
                }
                String fileStepConfig = (String)model.getValue("stepconfig", 0);
                if (StringUtils.isNotEmpty((String)fileStepConfig)) {
                    model.setValue("stepconfig", (Object)fileStepConfig, 0);
                    break;
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"FSAGuideFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                return false;
            }
            case 2: {
                LinkedList<FSAFieldMappingModel> mappingList = new LinkedList<FSAFieldMappingModel>();
                int totalRow = configDataModel.getEntryRowCount("mapping_entry");
                HashSet<String> fileSrcFieldSet = new HashSet<String>(totalRow);
                for (int i = 0; i < totalRow; ++i) {
                    String dimType = (String)configDataModel.getValue("dimension_type", i);
                    String paramFieldNumber = (String)configDataModel.getValue("paramfield_number", i);
                    String fileSrcField = (String)configDataModel.getValue("file_srcfield", i);
                    String defaultValue = (String)configDataModel.getValue("default_value", i);
                    if (!FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType) && StringUtils.isEmpty((String)fileSrcField) && StringUtils.isEmpty((String)defaultValue)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b2c%d\u884c\u9700\u8981\u7684\u5b57\u6bb5\u6216\u586b\u5199\u5bf9\u5e94\u7684\u9ed8\u8ba4\u503c", (String)"FSAGuideFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), i + 1));
                        return false;
                    }
                    if (StringUtils.isNotEmpty((String)fileSrcField) && !fileSrcFieldSet.add(fileSrcField)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u8868\u6e90\u5b57\u6bb5\u91cd\u590d\u6620\u5c04", (String)"FSAGuideFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), i + 1));
                        return false;
                    }
                    FSAFieldMappingModel idbModel = new FSAFieldMappingModel(dimType, paramFieldNumber, fileSrcField, defaultValue);
                    mappingList.add(idbModel);
                }
                FSAFieldMappingWithTimePatternModel mappingWithTimePatternModel = new FSAFieldMappingWithTimePatternModel((String)configDataModel.getValue("timeformat"), mappingList);
                model.setValue("stepconfig", (Object)FSAJSONUtils.toJsonString((Object)mappingWithTimePatternModel), 1);
                break;
            }
            case 3: {
                FormShowParameter originFsp = view.getFormShowParameter();
                Long syncParamId = (Long)originFsp.getCustomParam("syncparam_id");
                QFilter idFilter = new QFilter("id", "=", (Object)syncParamId);
                DynamicObject syncParamDyn = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"tablenumber,number,name", (QFilter[])idFilter.toArray());
                String tableNumber = syncParamDyn.getString("tablenumber");
                if (StringUtils.isEmpty((String)tableNumber) || StringUtils.isNotEmpty((String)tableNumber) && !MetadataDao.checkNumber((String)FSACommonConstant.buildEntityName((String)tableNumber))) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId("fsa_number_name_config");
                    fsp.setStatus(OperationStatus.ADDNEW);
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    fsp.setCustomParam("syncparam_id", (Object)syncParamId);
                    fsp.setCustomParam("synParamName", (Object)syncParamDyn.getString("name"));
                    fsp.setCustomParam("synParamNum", (Object)syncParamDyn.getString("number"));
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fsa_number_name_config"));
                    Long collectionId = (Long)originFsp.getCustomParam("datacollection");
                    QFilter colIdFilter = new QFilter("id", "=", (Object)collectionId);
                    DynamicObject collectionDyn = QueryServiceHelper.queryOne((String)"fsa_data_collection", (String)"number,name", (QFilter[])colIdFilter.toArray());
                    if (collectionDyn != null) {
                        fsp.setCustomParam("collectionName", (Object)collectionDyn.getString("name"));
                        fsp.setCustomParam("collectionNum", (Object)collectionDyn.getString("number"));
                    }
                    view.showForm(fsp);
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868", (String)"FSAGuideFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return false;
                }
                String version = (String)configDataModel.getValue("current_version");
                model.setValue("stepconfig", (Object)(StringUtils.isEmpty((String)version) ? String.valueOf(FSADataversionUtils.getVersionToDateLong()) : version), 2);
                break;
            }
        }
        return true;
    }

    private int getCurrentStep() {
        int step = Integer.parseInt((String)this.getModel().getValue("stepnumber"));
        return step > 0 ? step - 1 : 0;
    }

    private boolean isFirstStep() {
        int currentStep = this.getCurrentStep();
        return currentStep == 0;
    }

    private boolean isEndStep() {
        int currentStep = this.getCurrentStep();
        return currentStep >= STEP_FORM_ID.length - 1;
    }

    private Map<String, String[]> buttonControl() {
        String[] hideBtn;
        String[] showBtn;
        HashMap<String, String[]> result = new HashMap<String, String[]>(2);
        if (this.isFirstStep()) {
            showBtn = FIRST_STEP_SHOW;
            hideBtn = FIRST_STEP_HIDE;
        } else if (this.isEndStep()) {
            showBtn = END_STEP_SHOW;
            hideBtn = END_STEP_HIDE;
        } else {
            showBtn = MIDDLE_STEP_SHOW;
            hideBtn = MIDDLE_STEP_HIDE;
        }
        result.put("show", showBtn);
        result.put("hide", hideBtn);
        return result;
    }

    private void setConfigPageId(String pageId) {
        this.getPageCache().put("configPageId", pageId);
    }

    private String getConfigPageId() {
        return this.getPageCache().get("configPageId");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        if ("fsa_importdata".equals(subTabKey)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            FormShowParameter originFsp = view.getFormShowParameter();
            Long syncParamId = (Long)originFsp.getCustomParam("syncparam_id");
            String version = model.getValue("stepconfig", 2).toString();
            DynamicObject syncParmaDo = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam", (String)"number,name,tablenumber,tablename");
            if (syncParmaDo != null) {
                model.setValue("number", (Object)syncParmaDo.getString("number"));
                model.setValue("name", (Object)syncParmaDo.getString("name"));
                model.setValue("tablenumber", (Object)syncParmaDo.getString("tablenumber"));
                model.setValue("tablename", (Object)syncParmaDo.getString("tablename"));
            }
            model.setValue("version", (Object)version);
            view.setVisible(Boolean.FALSE, new String[]{"flexprogressbar", "fleximporttag"});
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        Object[] infoArr = this.getCompleteInfo();
        if (infoArr != null && infoArr.length == 2) {
            String importValueTag = (String)infoArr[0];
            Integer completePercent = (Integer)infoArr[1];
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            if (-1 == completePercent) {
                view.setVisible(Boolean.FALSE, new String[]{"fleximporttag"});
                bar.stop();
                view.showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u5df2\u4e2d\u6b62\u3002", (String)"FSAImportDataFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                view.setEnable(Boolean.FALSE, new String[]{"btnok"});
            } else if (completePercent >= 100) {
                progressEvent.setProgress(100);
                model.setValue("importtagvalue", (Object)importValueTag);
                model.setValue("importtag", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u5b8c\u6210", (String)"FSAImportDataFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                view.setEnable(Boolean.FALSE, new String[]{"btnok", "ignoreerr", "ignorenull"});
                view.setVisible(Boolean.TRUE, new String[]{"check_data"});
                bar.stop();
            } else {
                progressEvent.setProgress(completePercent.intValue());
                model.setValue("importtagvalue", (Object)importValueTag);
            }
        }
    }

    private void startImport(IFormView view) {
        IDataModel model = this.getModel();
        FormShowParameter parameter = view.getFormShowParameter();
        String fileInfoModeJson = model.getValue("stepconfig", 0).toString();
        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
        if (fileInfoModel.getDataCount() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\u3002", (String)"FSAImportDataFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long syncParamId = (Long)parameter.getCustomParam("syncparam_id");
        String version = model.getValue("stepconfig", 2).toString();
        Boolean createVersion = Boolean.parseBoolean(this.getPageCache().get("create_version"));
        Long taskId = FSASyncTaskLogHelper.createSyncTask((Long)syncParamId, (String)version, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.File_Upload_Data_Task);
        String fieldMappingJson = model.getValue("stepconfig", 1).toString();
        FSAFieldMappingWithTimePatternModel fieldMappingWithTimePatternModel = (FSAFieldMappingWithTimePatternModel)JSON.parseObject((String)fieldMappingJson, (TypeReference)new TypeReference<FSAFieldMappingWithTimePatternModel>(){}, (Feature[])new Feature[0]);
        FSAWorkTaskMeta meta = new FSAWorkTaskMeta(syncParamId.toString(), taskId, syncParamId, FSAWorkTaskTypeEnum.File_Upload_Data_Task, Long.valueOf(Long.parseLong(version)), fileInfoModel, (Boolean)model.getValue("ignoreerr"), (Boolean)model.getValue("ignorenull"), fieldMappingWithTimePatternModel, (String)model.getValue("tablenumber"), createVersion);
        IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.File_Upload_Data_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)true);
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
        view.getPageCache().put("pageCacheTaskId", String.valueOf(taskId));
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.setPercent(0);
        bar.start();
        view.setEnable(Boolean.TRUE, new String[]{"btnok"});
        view.setVisible(Boolean.FALSE, new String[]{"btnstartimport"});
        view.setVisible(Boolean.TRUE, new String[]{"flexprogressbar", "fleximporttag", "btnok"});
    }

    private Object[] getCompleteInfo() {
        IFormView view = this.getView();
        String fileInfoModeJson = this.getModel().getValue("stepconfig", 0).toString();
        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
        if (fileInfoModel == null) {
            return null;
        }
        String cacheKey = "fsa_" + view.getPageCache().get("pageCacheTaskId");
        String cacheValue = this.cache.get(cacheKey);
        Object[] infoArr = new Object[2];
        if (StringUtils.isEmpty((String)cacheValue)) {
            infoArr[0] = "0/" + fileInfoModel.getDataCount();
            infoArr[1] = 0;
        } else {
            infoArr[0] = cacheValue;
            String[] cacheArr = cacheValue.split("/");
            if ("0".equals(cacheArr[0])) {
                infoArr[1] = -1;
            } else {
                int percent = Integer.parseInt(cacheArr[0]) * 100 / Integer.parseInt(cacheArr[1]);
                infoArr[1] = percent;
            }
        }
        return infoArr;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView view = this.getView();
        String closeFlag = view.getPageCache().get("pageCacheCloseFlag");
        String backMark = view.getPageCache().get("pageCacheRunBackground");
        Object[] infoArr = this.getCompleteInfo();
        if (infoArr == null || infoArr.length <= 0) {
            return;
        }
        Integer completePercent = (Integer)infoArr[1];
        if (!Boolean.parseBoolean(closeFlag) && completePercent < 100 && completePercent > 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4efb\u52a1\u5c1a\u672a\u5b8c\u6210\uff0c\u73b0\u5728\u9000\u51fa\u5c06\u4e0d\u4f1a\u4fdd\u5b58\u5df2\u5bfc\u5165\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSAImportDataFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackClose", (IFormPlugin)this));
            view.getPageCache().put("pageCacheCloseFlag", "true");
            e.setCancel(true);
        } else if (StringUtils.isEmpty((String)backMark)) {
            this.removeFile();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ent) {
        super.confirmCallBack(ent);
        String callBackId = ent.getCallBackId();
        MessageBoxResult boxResult = ent.getResult();
        if ("callbackClose".equalsIgnoreCase(callBackId)) {
            IFormView view = this.getView();
            if (MessageBoxResult.Yes == boxResult) {
                String fileInfoModeJson = this.getModel().getValue("stepconfig", 0).toString();
                FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
                this.cache.put("fsa_stop_" + fileInfoModel.getFileUrl(), (Object)"stop", 1800);
                view.close();
            } else {
                view.getPageCache().remove("pageCacheCloseFlag");
            }
        }
    }

    private void removeFile() {
        String fileInfoModeJson = this.getModel().getValue("stepconfig", 0).toString();
        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileInfoModeJson, FSAFileInfoModel.class);
        FSAFileReaderFactory.getFileReader((String)".csv").removeFile(fileInfoModel.getFileUrl());
    }
}

