/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.fsa.formplugin.FSABaseFormPlugin;
import kd.data.fsa.model.version.FSADataVersionQueryFilterModel;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAHistoryDataSynctaskFormPlugin
extends FSABaseFormPlugin
implements RowClickEventListener {
    private static final String BUTTON_BARAP = "button_barap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"use_latest_version", "btnok"});
        this.addItemClickListeners(new String[]{BUTTON_BARAP});
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String dataVersionModelString = (String)fsp.getCustomParam("disable_versions");
        Long syncParamId = (Long)fsp.getCustomParam("data_sync_param");
        FSADataVersionQueryFilterModel dataVersionModel = null;
        Set disableVersionSet = null;
        boolean useLatestVersion = true;
        if (StringUtils.isNotEmpty((String)dataVersionModelString)) {
            dataVersionModel = (FSADataVersionQueryFilterModel)FSAJSONUtils.cast((String)dataVersionModelString, FSADataVersionQueryFilterModel.class);
        }
        if (dataVersionModel != null) {
            disableVersionSet = dataVersionModel.getBanVersionSet();
            useLatestVersion = dataVersionModel.getUseLatestVersion();
        }
        if (!useLatestVersion) {
            model.setValue("use_latest_version", (Object)Boolean.FALSE);
        }
        model.setValue("data_sync_param", (Object)syncParamId);
        QFilter qFilter = new QFilter("refparam", "=", (Object)syncParamId).and("status", "=", (Object)FSAStatusEnum.ENABLE.getCodeString());
        DataSet versionDataSet = QueryServiceHelper.queryDataSet((String)"kd.data.fsa.formplugin.FSAHistoryDataSynctaskFormPlugin", (String)"fsa_dataversion", (String)"version,createtime", (QFilter[])new QFilter[]{qFilter}, (String)"createtime DESC");
        model.deleteEntryData("data_version_entity");
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        abstractModel.beginInit();
        TableValueSetter columnEntryTvs = new TableValueSetter(new String[0]);
        columnEntryTvs.addField("version", new Object[0]);
        columnEntryTvs.addField("status", new Object[0]);
        columnEntryTvs.addField("createtime", new Object[0]);
        TableValueSetter disableColumnEntryTvs = new TableValueSetter(new String[0]);
        disableColumnEntryTvs.addField("version", new Object[0]);
        disableColumnEntryTvs.addField("status", new Object[0]);
        disableColumnEntryTvs.addField("createtime", new Object[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (versionDataSet.hasNext()) {
            Row next = versionDataSet.next();
            String createTime = sdf.format(next.getDate("createtime"));
            Long version = next.getLong("version");
            if (disableVersionSet != null && disableVersionSet.contains(version)) {
                disableColumnEntryTvs.addRow(new Object[]{version, "0", createTime});
                continue;
            }
            columnEntryTvs.addRow(new Object[]{version, "1", createTime});
        }
        abstractModel.batchCreateNewEntryRow("data_version_entity", columnEntryTvs);
        abstractModel.batchCreateNewEntryRow("data_version_entity", disableColumnEntryTvs);
        abstractModel.endInit();
        this.getView().updateView("data_version_entity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "btnok": {
                DynamicObject[] dataEntitys;
                HashSet<Long> banDataVersionSet = new HashSet<Long>(10);
                boolean useLatestVersion = (Boolean)model.getValue("use_latest_version");
                EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
                EntryData entryData = entryGrid.getEntryData();
                for (DynamicObject dataEntity : dataEntitys = entryData.getDataEntitys()) {
                    if (!dataEntity.get("status").equals("0")) continue;
                    banDataVersionSet.add(dataEntity.getLong("version"));
                }
                FSADataVersionQueryFilterModel dataVersionSetModel = new FSADataVersionQueryFilterModel(Boolean.valueOf(useLatestVersion), banDataVersionSet, null);
                model.setDataChanged(false);
                view.returnDataToParent((Object)FSAJSONUtils.toJsonString((Object)dataVersionSetModel));
                view.close();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        FormOperate fo;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "deleteentry".equalsIgnoreCase((fo = (FormOperate)source).getOperateKey()) && (selectRows = (entryGrid = (EntryGrid)this.getControl("data_version_entity")).getSelectRows()) != null && selectRows.length > 0) {
            HashSet<Long> versionSet = new HashSet<Long>(10);
            for (int selectRow : selectRows) {
                String versionStr = (String)this.getModel().getValue("version", selectRow);
                versionSet.add(Long.parseLong(versionStr));
            }
            IFormView view = this.getView();
            FormShowParameter fsp = view.getFormShowParameter();
            String tableNumber = (String)fsp.getCustomParam("tablenumber");
            Long syncParamId = (Long)fsp.getCustomParam("data_sync_param");
            FSADataversionUtils.deleteVersionAndData((String)tableNumber, (Long)syncParamId, versionSet);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate fo;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "deleteentry".equalsIgnoreCase((fo = (FormOperate)source).getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
            entryGrid.clearEntryState();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ArrayList<String> errorList = new ArrayList<String>(10);
        ArrayList<Integer> successList = new ArrayList<Integer>(10);
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_version_entity");
        int[] selectRows = entryGrid.getSelectRows();
        switch (itemKey) {
            case "enable": {
                if (selectRows == null || selectRows.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u7248\u672c\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (int selectRow : selectRows) {
                    if ("1".equals(model.getValue("status", selectRow))) {
                        errorList.add((String)model.getValue("version", selectRow));
                        continue;
                    }
                    model.setValue("status", (Object)"1", selectRow);
                    successList.add(selectRow);
                }
                if (errorList.size() == 0) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (successList.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    break;
                }
                view.showMessage(String.format(ResManager.loadKDString((String)"\u5171[%s]\u4e2a\u7248\u672c\uff0c\u542f\u7528\u6210\u529f[%s]\u4e2a\uff0c\u5931\u8d25[%s]\u4e2a", (String)"FSAHistoryDataSynctaskFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), successList.size() + errorList.size(), successList.size(), errorList.size()), String.format(ResManager.loadKDString((String)"\u7248\u672c:[%s] \u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorList)), MessageTypes.Default);
                break;
            }
            case "forbidden": {
                if (selectRows == null || selectRows.length == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u7248\u672c\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean useLastVersion = (Boolean)model.getValue("use_latest_version");
                for (int selectRow : selectRows) {
                    if ("0".equals(model.getValue("status", selectRow))) {
                        errorList.add((String)model.getValue("version", selectRow));
                        continue;
                    }
                    if (useLastVersion && selectRow == 0) {
                        errorList.add((String)model.getValue("version", selectRow));
                        continue;
                    }
                    model.setValue("status", (Object)"0", selectRow);
                    successList.add(selectRow);
                }
                if (errorList.size() == 0) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (errorList.size() == 1 && successList.size() == 0 && useLastVersion && selectRows[0] == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6700\u65b0\u7248\u672c\u201d\u5f00\u542f\u65f6\uff0c\u4e0d\u53ef\u7981\u7528\u6700\u65b0\u7248\u672c\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (successList.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (useLastVersion && selectRows[0] == 0) {
                    String errorString = "";
                    if (errorList.size() > 1) {
                        errorList.remove(0);
                        errorString = String.join((CharSequence)",", errorList);
                        view.showMessage(String.format(ResManager.loadKDString((String)"\u5171[%s]\u4e2a\u7248\u672c\uff0c\u542f\u7528\u6210\u529f[%s]\u4e2a\uff0c\u5931\u8d25[%s]\u4e2a", (String)"FSAHistoryDataSynctaskFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), successList.size() + errorList.size() + 1, successList.size(), errorList.size() + 1), String.format(ResManager.loadKDString((String)"\u7248\u672c:[%s] \u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), errorString) + "\n" + ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6700\u65b0\u7248\u672c\u201d\u5f00\u542f\u65f6\uff0c\u4e0d\u53ef\u7981\u7528\u6700\u65b0\u7248\u672c\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                        break;
                    }
                    view.showMessage(String.format(ResManager.loadKDString((String)"\u5171[%s]\u4e2a\u7248\u672c\uff0c\u542f\u7528\u6210\u529f[%s]\u4e2a\uff0c\u5931\u8d25[%s]\u4e2a", (String)"FSAHistoryDataSynctaskFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), successList.size() + errorList.size(), successList.size(), errorList.size()), ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6700\u65b0\u7248\u672c\u201d\u5f00\u542f\u65f6\uff0c\u4e0d\u53ef\u7981\u7528\u6700\u65b0\u7248\u672c\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                    break;
                }
                view.showMessage(String.format(ResManager.loadKDString((String)"\u5171[%s]\u4e2a\u7248\u672c\uff0c\u542f\u7528\u6210\u529f[%s]\u4e2a\uff0c\u5931\u8d25[%s]\u4e2a", (String)"FSAHistoryDataSynctaskFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), successList.size() + errorList.size(), successList.size(), errorList.size()), String.format(ResManager.loadKDString((String)"\u7248\u672c:[%s] \u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"FSAHistoryDataSynctaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorList)), MessageTypes.Default);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int versionIdx = model.getEntryCurrentRowIndex("data_version_entity");
        String version = (String)model.getValue("version", versionIdx);
        if (version == null || StringUtils.isEmpty((String)version)) {
            return;
        }
        DynamicObject versionField = FSADataversionUtils.getVersionEntryInfo((Long)Long.parseLong(version));
        if (versionField != null) {
            model.deleteEntryData("required_param_entity");
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            DynamicObjectCollection entryEntity = versionField.getDynamicObjectCollection("entryentity");
            TableValueSetter columnEntryTvs = new TableValueSetter(new String[0]);
            columnEntryTvs.addField("dim_name", new Object[0]);
            columnEntryTvs.addField("param_set_value", new Object[0]);
            for (DynamicObject row : entryEntity) {
                StringBuilder paramSetValueSb = new StringBuilder();
                DynamicObjectCollection subEntryEntity = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subRow : subEntryEntity) {
                    paramSetValueSb.append(',').append(subRow.getString("membername"));
                }
                columnEntryTvs.addRow(new Object[]{row.getString("dimname"), paramSetValueSb.substring(1)});
            }
            abstractModel.batchCreateNewEntryRow("required_param_entity", columnEntryTvs);
            abstractModel.endInit();
            view.updateView("required_param_entity");
        }
    }
}

