/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.data.fsa.formplugin.util.EntryUtil;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import org.apache.commons.lang3.StringUtils;

public class FSAMemberSelectF7Plugin
extends AbstractFormPlugin {
    private static final String MODULE_ID = "moudleId";
    private static final String VIEW_ID = "viewId";
    private static final String ENTITY = "entity";
    private static final String DIM_ID = "dimId";
    private static final String DIM_NUMBER = "dimNumber";
    private static final String FILTER_ID = "filterIds";

    public void registerListener(EventObject e) {
        this.addListeners();
    }

    protected void addListeners() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btnok".equals(key)) {
            EntryUtil.selectToDo(this, "treeentryentity", this::returnData);
        }
    }

    private void returnData(DynamicObject dynamicObject) {
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        Long id = dynamicObject.getLong("id");
        Long pid = dynamicObject.getLong("pid");
        String longNumber = dynamicObject.getString("longnumber");
        MemberModel memberModel = new MemberModel(id, number, name, pid, longNumber);
        IFormView view = this.getView();
        view.returnDataToParent((Object)memberModel);
        view.close();
    }

    public void afterBindData(EventObject e) {
        this.init();
    }

    public void init() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long moduleId = (Long)formShowParameter.getCustomParam(MODULE_ID);
        Long viewId = (Long)formShowParameter.getCustomParam(VIEW_ID);
        String entity = (String)formShowParameter.getCustomParam(ENTITY);
        Long dimId = (Long)formShowParameter.getCustomParam(DIM_ID);
        String dimNumber = (String)formShowParameter.getCustomParam(DIM_NUMBER);
        Collection filterIds = (Collection)formShowParameter.getCustomParam(FILTER_ID);
        Map dimemsionMetaInfoMap = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)entity, (Long)dimId, (String)"id", (Collection)filterIds, (boolean)true, null);
        List collect = dimemsionMetaInfoMap.values().stream().filter(p -> !p.getLongNumber().equals(dimNumber)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        model.batchCreateNewEntryRow("treeentryentity", collect.size());
        Iterator iterator = collect.iterator();
        int i = 0;
        long pid = 0L;
        while (iterator.hasNext()) {
            OlapServerDimMemberMetaInfo value = (OlapServerDimMemberMetaInfo)iterator.next();
            if (filterIds == null) {
                pid = value.getParent();
            }
            DynamicObject rowObj = model.getEntryRowEntity("treeentryentity", i++);
            rowObj.set("pid", (Object)pid);
            rowObj.set("id", (Object)value.getId());
            rowObj.set("number", (Object)value.getNumber());
            rowObj.set("name", (Object)value.getName());
            rowObj.set("longnumber", (Object)value.getLongNumber());
        }
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl("treeentryentity");
        grid.setCollapse(false);
        view.updateView("treeentryentity");
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, Long viewId, Long dimId, String dimNumber, String entity, String closeCallBackName) {
        FSAMemberSelectF7Plugin.openF7(that, title, moduleId, viewId, dimId, dimNumber, entity, closeCallBackName, null);
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, Long viewId, Long dimId, String dimNumber, String entity, String closeCallBackName, Collection<Long> filterIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (entity == null || dimId == null) {
            String entitykey = moduleId.toString() + dimNumber + "_number_entity";
            String idkey = moduleId.toString() + dimNumber + "_number_id";
            entity = that.getView().getPageCache().get(entitykey);
            String idcache = that.getView().getPageCache().get(idkey);
            Long l = dimId = StringUtils.isNumeric((CharSequence)idcache) ? Long.valueOf(Long.parseLong(idcache)) : null;
            if (entity == null || dimId == null) {
                OlapServerDimemsionMetaInfo dimMeta = FSABcmDataProvider.loadModuleDimensionMeta((Long)moduleId, (String)dimNumber);
                entity = dimMeta.getDimEntityName();
                dimId = dimMeta.getId();
                that.getView().getPageCache().put(entitykey, entity);
                that.getView().getPageCache().put(idkey, dimId.toString());
            }
        }
        formShowParameter.setFormId("fsa_memberselectf7");
        formShowParameter.setCustomParam(ENTITY, (Object)entity);
        formShowParameter.setCustomParam(VIEW_ID, (Object)viewId);
        formShowParameter.setCustomParam(DIM_ID, (Object)dimId);
        formShowParameter.setCustomParam(MODULE_ID, (Object)moduleId);
        formShowParameter.setCustomParam(DIM_NUMBER, (Object)dimNumber);
        formShowParameter.setCustomParam(FILTER_ID, filterIds);
        if (title != null) {
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"FSAGdtQuerySettingFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), title));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)that, closeCallBackName);
        formShowParameter.setCloseCallBack(closeCallBack);
        that.getView().showForm(formShowParameter);
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, Long viewId, String dimNumber, String closeCallBackName) {
        FSAMemberSelectF7Plugin.openF7(that, title, moduleId, viewId, null, dimNumber, null, closeCallBackName, null);
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, Long viewId, String dimNumber, String closeCallBackName, Collection<Long> filterIds) {
        FSAMemberSelectF7Plugin.openF7(that, title, moduleId, viewId, null, dimNumber, null, closeCallBackName, filterIds);
    }

    public static class MemberModel {
        Long id;
        String number;
        String name;
        Long pid;
        String longNumber;

        public Long getId() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public Long getPid() {
            return this.pid;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public MemberModel(Long id, String number, String name, Long pid, String longNumber) {
            this.id = id;
            this.number = number;
            this.name = name;
            this.pid = pid;
            this.longNumber = longNumber;
        }
    }
}

