/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.data.fsa.olap.OlapCslSchemeInfo;
import kd.data.fsa.olap.OlapServerBaseMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;

public class FSAMultipleMemberF7BasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String ENTITY = "ENTITY";
    public static final String DIMENSION_ID = "DIMENSION_ID";
    public static final String MODULE_ID = "MODULEID";
    public static final String ORANIZATION_VIEW_ID = "ORANIZATION_VIEW_ID";
    public static final String DIMENSION_NUMBER = "DIMENSION_NUMBER";
    public static final String DIMENSION_NAME = "DIMENSION_NAME";
    public static final String IS_OUTUPT_COMPLETE_MEMBER = "IS_OUTUPT_COMPLETE_MEMBER";
    public static final String INIT_MEMBER_IDS = "INIT_MEMBER_IDS";
    private static final String DIMENTITYTYPE = "DIMENTITYTYPE";
    private static final String KEY_DISPLAYBYLEVEL = "displayByLevel";
    private static final String KEY_COLUMNFILTERNAME = "columnFilterName";
    private static final String KEY_FILTERPARAMCOLLECTION = "filterParamCollection";
    private static final String MENBERF7VIEW_TREEID = "membertreeap";
    private static final String MEMBERLIST = "FSAMultipleMemberF7BasePlugin_MEMBERLIST_CACHE";
    private static final String MEMRANGDECOMBO = "memrangdecombo";
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";
    private static final String TREEROOT = "treeroot";
    private static final String COLOR = "#fc8055";
    private static final String MEMBER_ROOT_ID = "memberRootId";
    private static final String MEMBER_ROOT_NAME = "memberRootName";
    protected String entryentity;
    protected String mnum;
    protected String mname;
    protected String mid;
    protected String longnumber;
    protected String filltypevalue;
    protected String pid;
    protected Boolean displayByLevel;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
        BasedataEdit cslscheme = (BasedataEdit)this.getControl("cslscheme");
        cslscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("cslscheme".equals(name)) {
            this.cslSchemeChange(e);
        }
    }

    private void cslSchemeChange(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        long viewId = newValue.getLong("id");
        this.initView(viewId);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Object orgViewId = fsp.getCustomParam(ORANIZATION_VIEW_ID);
        Long organization_view_id = orgViewId == null ? null : Long.valueOf(Long.parseLong(orgViewId.toString()));
        Object customParam = fsp.getCustomParam(KEY_DISPLAYBYLEVEL);
        this.displayByLevel = customParam == null ? Boolean.TRUE : (Boolean)customParam;
        this.initView(organization_view_id);
        view.setVisible(this.displayByLevel, new String[]{this.filltypevalue});
    }

    private static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, String entity, Long dimId, String filterColumnName, Collection<?> filterParamCollection) {
        return FSAMultipleMemberF7BasePlugin.loadDimensionMembers(moduleId, viewId, entity, dimId, filterColumnName, filterParamCollection, null);
    }

    private static Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, String entity, Long dimId, String filterColumnName, Collection<?> filterParamCollection, Consumer<Long> consumer) {
        if (entity.equals("bcm_entitymembertree")) {
            if (viewId == null) {
                OlapCslSchemeInfo olapCslSchemeInfo = FSABcmDataProvider.loadDefaultCslSchemeInfo((long)moduleId);
                if (olapCslSchemeInfo == null) {
                    throw new KDBizException(String.format("this moduleId=%s has not DefaultScheme", moduleId));
                }
                viewId = olapCslSchemeInfo.getId();
            }
            if (consumer != null) {
                consumer.accept(viewId);
            }
        }
        return FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)entity, (Long)dimId, (String)filterColumnName, filterParamCollection, (boolean)true, null);
    }

    private void initView(Long organization_view_id) {
        this.setCurrentTabPage();
        this.setDefaultState();
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        IPageCache pageCache = this.getPageCache();
        Long moduleId = (Long)fsp.getCustomParam(MODULE_ID);
        String entity = (String)fsp.getCustomParam(ENTITY);
        Long selectDimensionId = (Long)fsp.getCustomParam(DIMENSION_ID);
        String dimensionNumber = (String)fsp.getCustomParam(DIMENSION_NUMBER);
        String dimensionName = (String)fsp.getCustomParam(DIMENSION_NAME);
        String filterColumnName = (String)fsp.getCustomParam(KEY_COLUMNFILTERNAME);
        Object filterCollection = fsp.getCustomParam(KEY_FILTERPARAMCOLLECTION);
        pageCache.put(DIMENTITYTYPE, "kd.data.fsa.olap.OlapServerDimMemberMetaInfo");
        Map<String, OlapServerDimMemberMetaInfo> treeValue = FSAMultipleMemberF7BasePlugin.loadDimensionMembers(moduleId, organization_view_id, entity, selectDimensionId, filterColumnName, (Collection)filterCollection, viewId -> {
            this.getModel().setValue("cslscheme", viewId);
            view.setVisible(Boolean.TRUE, new String[]{"cslscheme"});
        });
        if (treeValue.size() == 0) {
            this.cleanTree();
            return;
        }
        OlapServerDimMemberMetaInfo root = treeValue.get(dimensionNumber);
        List<OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoList = treeValue.values().stream().filter(p -> !p.getLongNumber().equals(dimensionNumber)).collect(Collectors.toList());
        if (olapServerDimMemberMetaInfoList.size() == 0) {
            this.cleanTree();
            return;
        }
        if (root != null) {
            pageCache.put(MEMBER_ROOT_ID, root.getId().toString());
            pageCache.put(MEMBER_ROOT_NAME, root.getNumber() + " " + root.getName());
        } else {
            OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = (OlapServerDimMemberMetaInfo)olapServerDimMemberMetaInfoList.get(0);
            if (olapServerDimMemberMetaInfo.getLevel() == 2) {
                pageCache.put(MEMBER_ROOT_ID, olapServerDimMemberMetaInfo.getParent().toString());
            } else {
                pageCache.put(MEMBER_ROOT_ID, "noParentId");
            }
            pageCache.put(MEMBER_ROOT_NAME, dimensionNumber + " " + dimensionName);
        }
        pageCache.put(MEMBERLIST, SerializationUtils.toJsonString(olapServerDimMemberMetaInfoList));
        this.setMemberTree(olapServerDimMemberMetaInfoList);
    }

    private void cleanTree() {
        TreeView mTree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
        mTree.deleteAllNodes();
        this.getModel().deleteEntryData(this.entryentity);
    }

    protected void setMemberTree(List<OlapServerDimMemberMetaInfo> dimensionMetaInfoMap) {
        TreeView mTree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
        mTree.deleteAllNodes();
        this.getModel().deleteEntryData(this.entryentity);
        this.initTree(mTree, dimensionMetaInfoMap);
    }

    protected void initTree(TreeView tree, List<OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoList) {
        if (olapServerDimMemberMetaInfoList == null || 0 == olapServerDimMemberMetaInfoList.size()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String rootId = this.displayByLevel != false ? pageCache.get(MEMBER_ROOT_ID) : "0";
        TreeNode treeRoot = new TreeNode("", rootId, pageCache.get(MEMBER_ROOT_NAME));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        HashSet initMemberIds = new HashSet((Collection)fsp.getCustomParam(INIT_MEMBER_IDS));
        tree.addNode(treeRoot);
        tree.expand(treeRoot.getId());
        ArrayList<TreeNode> noParentTreeNode = new ArrayList<TreeNode>();
        ArrayList<TreeNode> checkNodeWithoutChild = new ArrayList<TreeNode>(initMemberIds.size());
        ArrayList<String> needExpandId = new ArrayList<String>(20);
        for (OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo : olapServerDimMemberMetaInfoList) {
            TreeNode treeNode = this.getTreeNode(olapServerDimMemberMetaInfo);
            boolean b = this.setChildNode(treeRoot, treeNode);
            if (b) {
                if (initMemberIds.contains(treeNode.getId())) {
                    checkNodeWithoutChild.add(treeNode);
                }
            } else {
                noParentTreeNode.add(treeNode);
            }
            if (olapServerDimMemberMetaInfo.getLevel() >= 3 || needExpandId.size() >= 20) continue;
            needExpandId.add(treeNode.getId());
        }
        int show = needExpandId.size();
        for (String nodeId : needExpandId) {
            TreeNode treeNode = treeRoot.getTreeNode(nodeId);
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            if (show >= 20) break;
            tree.expand(nodeId);
            show += children.size();
        }
        if (!checkNodeWithoutChild.isEmpty()) {
            tree.checkNodesWithoutChild(checkNodeWithoutChild);
        }
        checkNodeWithoutChild.clear();
        if (!CollectionUtils.isEmpty(noParentTreeNode)) {
            TreeNode treeNode = new TreeNode(rootId, "wzd", "\u672a\u627e\u5230\u4e0a\u7ea7\u7684\u6210\u5458");
            treeRoot.addChild(treeNode);
            for (TreeNode treeNode2 : noParentTreeNode) {
                boolean find = this.setChildNode(treeNode, treeNode2);
                if (find) continue;
                treeNode2.setParentid("wzd");
                treeNode.addChild(treeNode2);
                if (!initMemberIds.contains(treeNode2.getId())) continue;
                checkNodeWithoutChild.add(treeNode2);
            }
            if (!checkNodeWithoutChild.isEmpty()) {
                tree.checkNodesWithoutChild(checkNodeWithoutChild);
            }
        }
        pageCache.put(TREEROOT, SerializationUtils.toJsonString((Object)treeRoot));
        tree.setRootVisible(this.displayByLevel.booleanValue());
    }

    protected boolean setChildNode(TreeNode treeRoot, TreeNode treeNode) {
        String node_id;
        String parentId = treeNode.getParentid();
        if (parentId.equals(node_id = treeRoot.getId())) {
            treeRoot.addChild(treeNode);
            return true;
        }
        List children = treeRoot.getChildren();
        if (children == null) {
            return false;
        }
        for (TreeNode childrenNode : children) {
            boolean b = this.setChildNode(childrenNode, treeNode);
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected TreeNode getTreeNode(OlapServerDimMemberMetaInfo ol) {
        TreeNode memberTree = new TreeNode();
        memberTree.setParentid(this.displayByLevel != false ? ol.getParent().toString() : "0");
        memberTree.setId(ol.getId().toString());
        memberTree.setText(ol.getNumber() + " " + ol.getName());
        return memberTree;
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setCurrentTabPage();
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection doc = model.getEntryEntity(this.entryentity);
        IPageCache pageCache = this.getPageCache();
        switch (key) {
            case "addoneb": 
            case "addallb": {
                String mlist = pageCache.get(MEMBERLIST);
                pageCache.put("key", key);
                TreeView tree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
                List ids = tree.getTreeState().getSelectedNodeId();
                if (mlist == null || ids.size() == 0 && key.equals("addoneb")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6210\u5458\u3002", (String)"MultipleMemberF7BasePlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.moveMember(mlist, key, model, doc);
                break;
            }
            case "deloneb": {
                EntryGrid eg = (EntryGrid)this.getControl(this.entryentity);
                int[] selectRows = eg.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MultipleMemberF7BasePlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                model.deleteEntryRows(this.entryentity, selectRows);
                break;
            }
            case "delallb": {
                model.deleteEntryData(this.entryentity);
                break;
            }
            case "btnok": {
                if (doc.size() == 0) {
                    return;
                }
                this.btnokFunction(doc);
                break;
            }
            case "imageup": 
            case "imagedown": {
                int newfocus;
                String serial = pageCache.get(ROWLIST);
                if (StringUtils.isEmpty((CharSequence)serial)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode[] list = (TreeNode[])SerializationUtils.fromJsonString((String)serial, TreeNode[].class);
                if (list == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                serial = pageCache.get(FOCUS);
                int oldfocus = (Integer)SerializationUtils.fromJsonString((String)serial, Integer.class);
                TreeNode oldnode = list[oldfocus];
                if ("imageup".equals(key)) {
                    if (0 == oldfocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = oldfocus - 1;
                } else {
                    if (list.length - 1 == oldfocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = oldfocus + 1;
                }
                TreeNode newNode = list[newfocus];
                pageCache.put(FOCUS, SerializationUtils.toJsonString((Object)newfocus));
                TreeView mTree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
                newNode.setColor(COLOR);
                oldnode.setColor("");
                List ids1 = mTree.getTreeState().getCheckedNodeIds();
                mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{oldnode, newNode}));
                ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(TREEROOT), TreeNode.class);
                List childPathNodes = root.getChildPathNodes(newNode.getId());
                childPathNodes.forEach(node -> {
                    List children = node.getChildren();
                    if (children != null && children.size() > 0 && !node.isExpend()) {
                        node.setIsOpened(true);
                        mTree.expand(node.getId());
                    }
                });
                for (String l : ids1) {
                    TreeNode node2 = root.getTreeNode(l, Integer.MAX_VALUE);
                    nodes.add(node2);
                }
                mTree.focusNode(newNode);
                mTree.checkNodesWithoutChild(nodes);
                pageCache.put(TREEROOT, SerializationUtils.toJsonString((Object)root));
                break;
            }
        }
    }

    private <T extends OlapServerDimMemberMetaInfo> void btnokFunction(DynamicObjectCollection docs) {
        Set<Object> returnSet = new HashSet<OlapServerDimMemberMetaInfo>(10);
        String mlist = this.getPageCache().get(MEMBERLIST);
        List<T> oldmemberlist = SerializationUtils.fromJsonStringToList((String)mlist, this.getClassT());
        int index = 1;
        for (DynamicObject doc : docs) {
            List<T> getlist = this.getTreeNodes(doc, oldmemberlist);
            if (getlist == null || getlist.isEmpty()) continue;
            returnSet.addAll(getlist);
            if (index++ >= docs.size() || oldmemberlist.size() / getlist.size() >= 3) continue;
            oldmemberlist = this.updataList(returnSet, oldmemberlist);
        }
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        boolean loadAll = (Boolean)fsp.getCustomParam(IS_OUTUPT_COMPLETE_MEMBER);
        String columnFilterName = (String)fsp.getCustomParam(KEY_COLUMNFILTERNAME);
        Collection filterParamCollection = (Collection)fsp.getCustomParam(KEY_FILTERPARAMCOLLECTION);
        if (loadAll) {
            returnSet = FSAMultipleMemberF7BasePlugin.loadCompeteMember(this, returnSet.stream().map(OlapServerDimMemberMetaInfo::getLongNumber).collect(Collectors.toList()), columnFilterName, filterParamCollection);
        }
        view.returnDataToParent(returnSet);
        view.close();
    }

    private static void collectNoSelect(String longNumberStart, String longNumber, Set<String> set) {
        int index;
        set.add(longNumber);
        if (longNumber.equals(longNumberStart)) {
            return;
        }
        while (longNumber.startsWith(longNumberStart) && (index = longNumber.lastIndexOf(33)) != -1) {
            if (((longNumber = longNumber.substring(0, index)) + "!").equals(longNumberStart)) continue;
            set.add(longNumber);
        }
    }

    private static int compareNumberEqual(List<String> longNumberList, int index) {
        String lastNumber = null;
        if (longNumberList.size() <= 1) {
            throw new KDBizException("longNumberList size must be greater than 1");
        }
        for (String longNumber : longNumberList) {
            String[] split = longNumber.split("!");
            if (split.length > index + 1) {
                String number = split[index];
                if (lastNumber == null) {
                    lastNumber = number;
                }
                if (number.equals(lastNumber)) continue;
                return index + 1;
            }
            return index + 1;
        }
        return FSAMultipleMemberF7BasePlugin.compareNumberEqual(longNumberList, index + 1);
    }

    private Class<?> getClassT() {
        Class<?> aClass;
        try {
            aClass = Class.forName(this.getPageCache().get(DIMENTITYTYPE));
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return aClass;
    }

    private <T extends OlapServerDimMemberMetaInfo> List<T> updataList(Set<OlapServerDimMemberMetaInfo> returnSet, List<T> oldmemberlist) {
        Set collect = returnSet.stream().map(OlapServerBaseMetaInfo::getId).collect(Collectors.toSet());
        return oldmemberlist.stream().filter(p -> !collect.contains(p.getId())).collect(Collectors.toList());
    }

    private <T extends OlapServerDimMemberMetaInfo> List<T> getTreeNodes(DynamicObject doc, List<T> oldmemberlist) {
        String filltype = doc.getString(this.filltypevalue);
        String lnum = doc.getString(this.longnumber);
        String id = doc.getString(this.mid);
        String parentid = doc.getString(this.pid);
        switch (filltype) {
            case "10": {
                return oldmemberlist.stream().filter(p -> p.getId().toString().equals(id)).collect(Collectors.toList());
            }
            case "20": {
                return oldmemberlist.stream().filter(p -> p.getParent().toString().equals(id)).collect(Collectors.toList());
            }
            case "30": {
                return oldmemberlist.stream().filter(p -> p.getParent().toString().equals(id) || p.getId().toString().equals(id)).collect(Collectors.toList());
            }
            case "50": {
                return oldmemberlist.stream().filter(p -> p.getLongNumber().startsWith(lnum)).filter(p -> !p.getId().toString().equals(id)).collect(Collectors.toList());
            }
            case "60": {
                return oldmemberlist.stream().filter(p -> p.getLongNumber().startsWith(lnum)).collect(Collectors.toList());
            }
            case "70": {
                return oldmemberlist.stream().filter(p -> p.getParent().toString().equals(parentid)).filter(p -> !p.getId().toString().equals(id)).collect(Collectors.toList());
            }
            case "80": {
                return oldmemberlist.stream().filter(p -> p.getParent().toString().equals(parentid)).collect(Collectors.toList());
            }
            case "90": {
                return oldmemberlist.stream().filter(p -> p.getLongNumber().startsWith(lnum)).filter(OlapServerDimMemberMetaInfo::isLeaf).collect(Collectors.toList());
            }
            case "110": {
                return oldmemberlist.stream().filter(p -> p.getLongNumber().startsWith(lnum)).filter(p -> !p.isLeaf()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    protected void setDefaultState() {
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{"dimensioncombo"});
        view.setVisible(Boolean.FALSE, new String[]{"tabpageap2", "moveup", "movedowm", "cslscheme"});
        TabPage tp = (TabPage)this.getControl("tabpageap1");
        tp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u9009", (String)"MultipleMemberF7BasePlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0])));
    }

    protected void setCurrentTabPage() {
        this.entryentity = "entryentity1";
        this.mnum = "mnum1";
        this.mname = "mname1";
        this.mid = "mid1";
        this.filltypevalue = "filltypevalue1";
        this.pid = "pid1";
        this.longnumber = "longnumber1";
    }

    protected void moveMember(String mlist, String key, IDataModel model, DynamicObjectCollection doc) {
        String filltypenum = (String)this.getModel().getValue(MEMRANGDECOMBO);
        List<Object> selectmemberlist = key.equals("addoneb") ? this.getSelectMembers(mlist, "addoneb") : this.getSelectMembers(mlist, "addallb");
        if (selectmemberlist.size() == 0) {
            return;
        }
        this.move2right(selectmemberlist, doc, model, filltypenum);
    }

    protected void move2right(List<OlapServerDimMemberMetaInfo> oldmemberlist, DynamicObjectCollection hasSelectdoc, IDataModel model, String filltypenum) {
        ArrayList<OlapServerDimMemberMetaInfo> newmemberlist = new ArrayList<OlapServerDimMemberMetaInfo>();
        HashSet<String> idContains = new HashSet<String>(hasSelectdoc.size());
        for (DynamicObject dynamicObject : hasSelectdoc) {
            idContains.add(dynamicObject.getString(this.mid));
        }
        for (OlapServerDimMemberMetaInfo member : oldmemberlist) {
            if (idContains.contains(member.getId().toString())) continue;
            newmemberlist.add(member);
        }
        if (newmemberlist.size() < 1) {
            return;
        }
        int index = 0;
        int[] rows = model.batchCreateNewEntryRow(this.entryentity, newmemberlist.size());
        for (OlapServerDimMemberMetaInfo mem : newmemberlist) {
            model.setValue(this.mid, (Object)mem.getId().toString(), rows[index]);
            model.setValue(this.mnum, (Object)mem.getNumber(), rows[index]);
            model.setValue(this.mname, (Object)mem.getName(), rows[index]);
            model.setValue(this.pid, (Object)mem.getParent().toString(), rows[index]);
            model.setValue(this.longnumber, (Object)mem.getLongNumber(), rows[index]);
            model.setValue(this.filltypevalue, (Object)filltypenum, rows[index++]);
        }
    }

    protected <T extends OlapServerDimMemberMetaInfo> List<T> getSelectMembers(String mlist, String key) {
        List oldmemberlist = SerializationUtils.fromJsonStringToList((String)mlist, this.getClassT());
        List<OlapServerDimMemberMetaInfo> selectmemberlist = new ArrayList();
        if ("addoneb".equals(key)) {
            TreeView tree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
            List ids = tree.getTreeState().getSelectedNodeId();
            HashSet<String> idset = new HashSet<String>(ids);
            for (OlapServerDimMemberMetaInfo map : oldmemberlist) {
                if (idset.add(map.getId().toString())) continue;
                selectmemberlist.add(map);
            }
        } else {
            selectmemberlist = oldmemberlist;
        }
        return selectmemberlist;
    }

    protected void addListeners() {
        TreeView tree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
        tree.addTreeNodeCheckListener(evt -> this.clearColor());
        this.addClickListeners(new String[]{"addoneb", "addallb", "deloneb", "delallb", "btnok", "imageup", "imagedown"});
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                this.searchMember(var1.getText().toLowerCase().trim());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"MultipleMemberF7BasePlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private void searchMember(String text) {
        TreeNode root = this.clearColor();
        TreeView mTree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        this.getTreeNodeListByText(root, treeNodes, text);
        if (treeNodes.size() > 0) {
            HashSet alltreeNodes = new HashSet(root.getChildPathNodes(((TreeNode)treeNodes.get(0)).getId()));
            for (TreeNode treeNode : alltreeNodes) {
                List children = treeNode.getChildren();
                if (children == null || children.size() <= 0) continue;
                treeNode.setIsOpened(true);
                mTree.expand(treeNode.getId());
            }
            this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = (TreeNode)treeNodes.get(0);
            this.getPageCache().put(FOCUS, SerializationUtils.toJsonString((Object)0));
            asd.setColor(COLOR);
            mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{asd}));
            mTree.focusNode(asd);
            this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)root));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"MultipleMemberF7BasePlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        List ids = mTree.getTreeState().getCheckedNodeIds();
        if (ids.size() > 0) {
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(ids.size());
            for (String l : ids) {
                TreeNode node = root.getTreeNode(l, Integer.MAX_VALUE);
                nodes.add(node);
            }
            mTree.checkNodesWithoutChild(nodes);
        }
    }

    private TreeNode clearColor() {
        String serial = this.getPageCache().get(FOCUS);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        if (StringUtils.isEmpty((CharSequence)serial)) {
            return root;
        }
        int oldfocus = (Integer)SerializationUtils.fromJsonString((String)serial, Integer.class);
        TreeNode[] list = (TreeNode[])SerializationUtils.fromJsonString((String)this.getPageCache().get(ROWLIST), TreeNode[].class);
        TreeNode oldnode = list[oldfocus];
        TreeView mTree = (TreeView)this.getControl(MENBERF7VIEW_TREEID);
        oldnode.setColor("");
        List ids = mTree.getTreeState().getCheckedNodeIds();
        mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{oldnode}));
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (String l : ids) {
            TreeNode node = root.getTreeNode(l, Integer.MAX_VALUE);
            nodes.add(node);
        }
        mTree.checkNodesWithoutChild(nodes);
        return root;
    }

    private void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, String dimNumber, Long organizationViewId, String closeCallBackName, Boolean displayByLevel, String columnFilterName, Collection<?> filterParamCollection) {
        FSAMultipleMemberF7BasePlugin.openF7(that, title, moduleId, dimNumber, organizationViewId, closeCallBackName, false, displayByLevel, columnFilterName, filterParamCollection, null);
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, String dimNumber, Long organizationViewId, String closeCallBackName, Boolean displayByLevel, String columnFilterName, Collection<?> filterParamCollection, Set<Long> initIds) {
        FSAMultipleMemberF7BasePlugin.openF7(that, title, moduleId, dimNumber, organizationViewId, closeCallBackName, false, displayByLevel, columnFilterName, filterParamCollection, initIds);
    }

    private static OlapServerDimemsionMetaInfo getOlapServerDimemsionMetaInfo(AbstractFormPlugin that, Long moduleId, String dimNumber) {
        OlapServerDimemsionMetaInfo dimMeta;
        String olapServerDimemsionMetaInfoCache = "olapServerDimemsionMetaInfo_" + moduleId + dimNumber;
        String olapServerDimemsionMetaInfoString = that.getView().getPageCache().get(olapServerDimemsionMetaInfoCache);
        if (olapServerDimemsionMetaInfoString == null) {
            dimMeta = FSABcmDataProvider.loadModuleDimensionMeta((Long)moduleId, (String)dimNumber);
            that.getView().getPageCache().put(olapServerDimemsionMetaInfoCache, SerializationUtils.toJsonString((Object)dimMeta));
        } else {
            dimMeta = (OlapServerDimemsionMetaInfo)SerializationUtils.fromJsonString((String)olapServerDimemsionMetaInfoString, OlapServerDimemsionMetaInfo.class);
        }
        return dimMeta;
    }

    public static void openF7(AbstractFormPlugin that, String title, Long moduleId, String dimNumber, Long organizationViewId, String closeCallBackName, Boolean iSOutputCompleteMember, Boolean displayByLevel, String columnFilterName, Collection<?> filterParamCollection, Set<Long> initIds) {
        OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo = FSAMultipleMemberF7BasePlugin.getOlapServerDimemsionMetaInfo(that, moduleId, dimNumber);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fsa_mulmemberf7base");
        formShowParameter.setCustomParam(ENTITY, (Object)olapServerDimemsionMetaInfo.getDimEntityName());
        formShowParameter.setCustomParam(DIMENSION_ID, (Object)olapServerDimemsionMetaInfo.getId());
        formShowParameter.setCustomParam(DIMENSION_NUMBER, (Object)olapServerDimemsionMetaInfo.getNumber());
        formShowParameter.setCustomParam(DIMENSION_NAME, (Object)olapServerDimemsionMetaInfo.getName());
        formShowParameter.setCustomParam(MODULE_ID, (Object)moduleId);
        formShowParameter.setCustomParam(ORANIZATION_VIEW_ID, (Object)organizationViewId);
        formShowParameter.setCustomParam(IS_OUTUPT_COMPLETE_MEMBER, (Object)iSOutputCompleteMember);
        formShowParameter.setCustomParam(KEY_DISPLAYBYLEVEL, (Object)displayByLevel);
        formShowParameter.setCustomParam(KEY_COLUMNFILTERNAME, (Object)columnFilterName);
        formShowParameter.setCustomParam(KEY_FILTERPARAMCOLLECTION, filterParamCollection);
        Set initIdstrs = initIds == null ? Collections.emptySet() : initIds.stream().map(Object::toString).collect(Collectors.toSet());
        formShowParameter.setCustomParam(INIT_MEMBER_IDS, initIdstrs);
        if (title != null) {
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"FSAGdtQuerySettingFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), title));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)that, closeCallBackName);
        formShowParameter.setCloseCallBack(closeCallBack);
        that.getView().showForm(formShowParameter);
    }

    private static <T extends OlapServerDimMemberMetaInfo> Set<T> loadCompeteMember(AbstractFormPlugin that, Collection<String> longNumberCollection, String filterColumnName, Collection<?> filterParamCollection) {
        return FSAMultipleMemberF7BasePlugin.loadCompeteMember(that, longNumberCollection, null, null, null, filterColumnName, filterParamCollection);
    }

    public static <T extends OlapServerDimMemberMetaInfo> Set<T> loadCompeteMember(AbstractFormPlugin that, Collection<String> longNumberCollection, Long moduleId, String dimNumber, Long viewId, String filterColumnName, Collection<?> filterParamCollection) {
        List memberListCache;
        Class<OlapServerDimMemberMetaInfo> clazz = OlapServerDimMemberMetaInfo.class;
        if (longNumberCollection == null || longNumberCollection.size() == 0) {
            return Collections.emptySet();
        }
        String allMemberCache = that.getView().getPageCache().get(MEMBERLIST);
        if (allMemberCache != null) {
            memberListCache = SerializationUtils.fromJsonStringToList((String)allMemberCache, clazz);
        } else {
            OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo = FSAMultipleMemberF7BasePlugin.getOlapServerDimemsionMetaInfo(that, moduleId, dimNumber);
            allMemberCache = that.getView().getPageCache().get("GET_MEMBER_CACHE_" + olapServerDimemsionMetaInfo.getId());
            if (allMemberCache != null) {
                memberListCache = SerializationUtils.fromJsonStringToList((String)allMemberCache, clazz);
            } else {
                Map<String, OlapServerDimMemberMetaInfo> treeValue = FSAMultipleMemberF7BasePlugin.loadDimensionMembers(moduleId, viewId, olapServerDimemsionMetaInfo.getDimEntityName(), olapServerDimemsionMetaInfo.getId(), filterColumnName, filterParamCollection);
                memberListCache = treeValue.values().stream().map(t -> t).collect(Collectors.toList());
                String cacheStr = SerializationUtils.toJsonString(memberListCache);
                that.getView().getPageCache().put("GET_MEMBER_CACHE_" + olapServerDimemsionMetaInfo.getId(), cacheStr);
            }
        }
        ArrayList<String> longNumberList = new ArrayList<String>(longNumberCollection);
        if (longNumberCollection.size() <= 1) {
            return memberListCache.stream().filter(p -> longNumberCollection.contains(p.getLongNumber())).collect(Collectors.toSet());
        }
        int index = FSAMultipleMemberF7BasePlugin.compareNumberEqual(longNumberList, 0);
        int finishIndex = index - 1;
        List longNumberStartList = longNumberList.stream().map(p -> {
            String[] split = p.split("!");
            if (split.length <= finishIndex + 1) {
                return p;
            }
            String noSameNumber = finishIndex == 0 ? "" : "!" + split[finishIndex] + "!";
            return p.substring(0, p.indexOf(noSameNumber)) + noSameNumber;
        }).collect(Collectors.toList());
        HashSet<String> longNumberSet = new HashSet<String>(16);
        for (int i = 0; i < longNumberList.size(); ++i) {
            String longNumber = (String)longNumberList.get(i);
            String longNumberStart = (String)longNumberStartList.get(i);
            FSAMultipleMemberF7BasePlugin.collectNoSelect(longNumberStart, longNumber, longNumberSet);
        }
        longNumberSet.addAll(longNumberStartList.stream().map(p -> p.endsWith("!") ? p.substring(0, p.length() - 1) : p).collect(Collectors.toSet()));
        return memberListCache.stream().filter(p -> longNumberSet.contains(p.getLongNumber())).collect(Collectors.toSet());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().add(new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam(MODULE_ID)));
    }
}

