/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.utils.FSATableUtil;

public class FSANumberNameConfigFormPlugin
extends AbstractFormPlugin {
    private static final String SAVE_CONFIM = "save confirm";
    private static final String OVERWRITTE_CONFIM = "overwrite confirm";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.createTable();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult) {
            switch (actionId) {
                case "save confirm": {
                    IFormView view = this.getView();
                    Long syncParamId = (Long)view.getFormShowParameter().getCustomParam("syncparam_id");
                    String tableName = (String)view.getFormShowParameter().getCustomParam("tablename");
                    String tableNumber = (String)view.getFormShowParameter().getCustomParam("tablenumber");
                    if (StringUtils.isNotEmpty((String)tableNumber)) {
                        FSATableUtil.createOrDropTable((Long)syncParamId, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.Drop_Table_Task, (String)tableNumber, (String)tableName, (boolean)false);
                    }
                    this.returnData(new HashMap<String, String>());
                    break;
                }
                case "overwrite confirm": {
                    HashMap<String, String> returnValue = new HashMap<String, String>();
                    returnValue.put("overWriteStr", "true");
                    this.returnData(returnValue);
                    break;
                }
            }
        }
    }

    private void createTable() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String inputTableName = (String)model.getValue("name");
        if (StringUtils.isEmpty((String)inputTableName) || inputTableName.length() > 19) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8868\u540d\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e19\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSANumberNameConfigFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        String inputTableNumber = (String)model.getValue("number");
        if (!this.numVerify(inputTableNumber)) {
            return;
        }
        long id = (Long)view.getFormShowParameter().getCustomParam("syncparam_id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fsa_syncparam");
        String originTableNumber = dynamicObject.getString("tablenumber");
        if (MetadataDao.checkNumber((String)this.formatForm(inputTableNumber))) {
            if (inputTableNumber.equalsIgnoreCase(originTableNumber)) {
                view.showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u53c2\u6570\u5df2\u6709\u6570\u636e\u8868[%s]\uff0c\u4fdd\u5b58\u5c06\u4f1a\u8986\u76d6\u5df2\u6709\u6570\u636e\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSANumberNameConfigFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), inputTableNumber), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(OVERWRITTE_CONFIM, (IFormPlugin)this));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u76f8\u540c\u7684\u6570\u636e\u8868\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSANumberNameConfigFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.isNotEmpty((String)originTableNumber) && MetadataDao.checkNumber((String)this.formatForm(originTableNumber))) {
            view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u5c06\u4f1a\u8986\u76d6\u5df2\u6709\u6570\u636e\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSANumberNameConfigFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(SAVE_CONFIM, (IFormPlugin)this));
        } else {
            this.returnData(new HashMap<String, String>());
        }
    }

    private void init() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter originFsp = view.getFormShowParameter();
        String tableName = (String)originFsp.getCustomParam("tablename");
        String tableNumber = (String)originFsp.getCustomParam("tablenumber");
        if (StringUtils.isEmpty((String)tableName) && (tableName = originFsp.getCustomParam("collectionName") + "_" + originFsp.getCustomParam("synParamName")).length() > 19) {
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8868\u540d\u79f0\u957f\u5ea6\u8d85\u8fc719\u4e2a\u5b57\u7b26\uff0c\u8bf7\u624b\u52a8\u4fee\u6539", (String)"FSANumberNameConfigFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("name", (Object)tableName);
        if (StringUtils.isEmpty((String)tableNumber) && (tableNumber = originFsp.getCustomParam("collectionNum") + "_" + originFsp.getCustomParam("synParamNum")).length() > 19) {
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8868\u7f16\u7801\u957f\u5ea6\u8d85\u8fc719\u4e2a\u5b57\u7b26\uff0c\u8bf7\u624b\u52a8\u4fee\u6539", (String)"FSANumberNameConfigFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("number", (Object)tableNumber);
    }

    private void returnData(Map<String, String> returnValue) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String tableNumber = (String)model.getValue("number");
        String tableName = (String)model.getValue("name");
        Long syncParamId = (Long)view.getFormShowParameter().getCustomParam("syncparam_id");
        boolean success = FSATableUtil.createOrDropTable((Long)syncParamId, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (boolean)Boolean.parseBoolean(returnValue.get("overWriteStr")));
        if (!success) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%s]\u521b\u5efa\u5931\u8d25", (String)"FSANumberNameConfigFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), tableName));
        } else {
            DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam");
            syncParam.set("tablename", (Object)tableName);
            syncParam.set("tablenumber", (Object)tableNumber);
            SaveServiceHelper.update((DynamicObject)syncParam);
            returnValue.put("tablename", tableName);
            returnValue.put("tablenumber", tableNumber);
            returnValue.put("res", "true");
            view.returnDataToParent(returnValue);
            view.close();
        }
    }

    private boolean numVerify(String str) {
        if (str.matches("[0-9a-z_]*") && str.length() <= 19) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u4e14\u5b57\u7b26\u6570\u5c0f\u4e8e19\u3002\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSANumberNameConfigFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        return false;
    }

    private String formatForm(String tableName) {
        return FSACommonConstant.buildEntityName((String)tableName.toLowerCase());
    }
}

