/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.formplugin.FSAReportFormPluginHelper;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAReportDataViewPlugin
extends AbstractReportFormPlugin
implements ProgresssListener {
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"firstpage", "previouspage", "nextpage", "lastpage", "pagerows", "membername_filter"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        Long taskId = (Long)view.getFormShowParameter().getCustomParam("datasynctask");
        if (taskId == null) {
            view.setVisible(Boolean.FALSE, new String[]{"process_info_flex"});
        } else {
            this.barProcessConfig(view, model, null);
            IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
            if (staticStatus != null && !staticStatus.isTaskEnd()) {
                view.setEnable(Boolean.FALSE, new String[]{"refresh", "exportexcel"});
            }
        }
        FSAReportFormPluginHelper.afterCreateNewData((IFormView)view, model);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("exportdatatofile".equals(operateKey)) {
            IReportView view = this.getView();
            IDataModel model = this.getModel();
            args.setCancel(true);
            int totalRows = (Integer)model.getValue("totalrows");
            if (totalRows > 500000) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8f83\u5927\uff0c\u8bf7\u60a8\u51cf\u5c0f\u67e5\u8be2\u8303\u56f4", (String)"FSAReportDataViewPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            } else {
                FSAReportFormPluginHelper.execScript((IFormView)view, model);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        FSAReportFormPluginHelper.afterDoOperation((IFormView)view, model, key);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        FSAReportFormPluginHelper.closedCallBack((IFormView)view, model, actionId, returnData);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        return FSAReportFormPluginHelper.verifyQuery((IFormView)view, model, queryParam);
    }

    public void onProgress(ProgressEvent progressEvent) {
        this.barProcessConfig(this.getView(), this.getModel(), progressEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        FSAReportFormPluginHelper.propertyChanged((IFormView)view, model, e.getProperty().getName());
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        FSAReportFormPluginHelper.click((AbstractFormPlugin)this, (IFormView)view, model, key);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("reset".equals(evt.getItemKey())) {
            FSAReportFormPluginHelper.cleanQueryFilter(this.getModel());
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String key = ((ReportColumn)e.getSource()).getFieldKey();
        Object value = e.getRowData().get(key);
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalVal = (BigDecimal)value;
            if (bigDecimalVal.compareTo(BigDecimal.ZERO) == 0 && !bigDecimalVal.toString().startsWith("0E-")) {
                e.setFormatValue((Object)"");
            } else {
                DecimalFormat decimalFormat = new DecimalFormat("#,##0.0000");
                decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                e.setFormatValue((Object)decimalFormat.format(bigDecimalVal));
            }
        }
    }

    private void barProcessConfig(IReportView view, IDataModel model, ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        if (0.0 > percent) {
            view.setVisible(Boolean.TRUE, new String[]{"unfetch"});
            view.setVisible(Boolean.FALSE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            bar.stop();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"unfetch"});
            view.setVisible(Boolean.TRUE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            int percentIntValue = (int)percent;
            if (progressEvent == null) {
                bar.setPercent(percentIntValue);
                if (percent < 100.0) {
                    bar.start();
                }
            } else {
                if (staticStatus != null && !staticStatus.isTaskEnd() && percentIntValue == 100) {
                    percentIntValue = 99;
                }
                progressEvent.setProgress(percentIntValue);
            }
            model.setValue("completepercent", (Object)percentIntValue);
        }
        if (staticStatus != null && (staticStatus.isTaskEnd() || staticStatus.isWithError())) {
            Long taskVersion;
            bar.stop();
            view.setEnable(Boolean.TRUE, new String[]{"refresh", "exportexcel"});
            String taskVersionStr = (String)view.getFormShowParameter().getCustomParam("version");
            Long l = taskVersion = StringUtils.isNotEmpty((String)taskVersionStr) ? Long.valueOf(Long.parseLong(taskVersionStr)) : null;
            if (taskVersion != null && !staticStatus.isWithError() && staticStatus.isTaskEnd()) {
                ArrayList<Long> enableVersionList;
                IPageCache pageCache = this.getPageCache();
                String enableVersionListJson = pageCache.get("enableVersion");
                List<Long> list = enableVersionList = StringUtils.isNotEmpty((String)enableVersionListJson) ? (List)JSONObject.parseObject((String)enableVersionListJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]) : null;
                if (enableVersionList == null) {
                    enableVersionList = new ArrayList<Long>(1);
                }
                if (!enableVersionList.contains(taskVersion)) {
                    enableVersionList.add(0, taskVersion);
                    pageCache.put("enableVersion", FSAJSONUtils.toJsonString(enableVersionList));
                }
            }
        }
    }

    public IDataSimpleWorkTaskStatisticStatus getStaticStatus() {
        DynamicObject prtDataSyncTask;
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("datasynctask");
        if (taskId == null) {
            return null;
        }
        String cacheStatusStr = this.cache.get("FSA|" + taskId);
        IDataSimpleWorkTaskStatisticStatus statisticStatus = null;
        if (StringUtils.isEmpty((String)cacheStatusStr) && (prtDataSyncTask = BusinessDataReader.loadSingle((Object)taskId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_rptdata_synctask"))) != null) {
            cacheStatusStr = prtDataSyncTask.getString("staticstatus_info_tag");
        }
        if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
            statisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.getCachedWorkTaskStatusEvent(cacheStatusStr);
        }
        return statisticStatus;
    }

    public IWorkTaskStatusEvent getCachedWorkTaskStatusEvent(String cacheStatusStr) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray((Object)cacheStatusStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IWorkTaskStatusEvent)IDataBeanUtil.getClassNewInstance((Class)IDataBeanUtil.getClassByName((String)String.valueOf(jsonArray.get(0))), (Object[])new Object[]{jsonArray});
    }

    public double getPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        IDataModel model = this.getModel();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("datasynctask");
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDbj = QueryServiceHelper.queryOne((String)"fsa_rptdata_synctask", (String)"status,version", (QFilter[])idFilter.toArray());
        if (taskDbj == null) {
            return -1.0;
        }
        String taskStatus = taskDbj.getString("status");
        if (statisticStatus != null) {
            int[] taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints();
            if (taskStatisticsPoints.length == 2 && taskStatisticsPoints[1] == 0) {
                if (FSAStatusEnum.SUCCESS.getCodeString().equals(taskStatus)) {
                    return 100.0;
                }
                if (FSAStatusEnum.PROCESSING.getCodeString().equals(taskStatus)) {
                    return 0.0;
                }
                if (FSAStatusEnum.FAILURE.getCodeString().equals(taskStatus)) {
                    return -1.0;
                }
            }
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            double percent = (double)taskStatisticsPoints[0] / (double)taskStatisticsPoints[1] * 100.0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            long taskExecutionTime = statisticStatus.getTaskExecutionTime();
            if (taskEnd || Double.doubleToLongBits(percent) == Double.doubleToLongBits(100.0)) {
                model.setValue("info", (Object)((statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()) + String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%s, \u5df2\u8bfb\u53d6\uff1a%s, \u5b9e\u9645\u603b\u6570\uff1a%s, \u6210\u529f\u5408\u5e76\u5199\u5165\uff1a%s, \u5df2\u5ffd\u7565\uff1a%s, \u5c42\u7ea7\u8865\u9f50\uff1a%s, \u8bfb\u53d6\u901f\u7387\uff1a%s(\u6761/\u79d2), \u5199\u5165\u901f\u7387:%s(\u6761/\u79d2)", (String)"FSARptDataSyncTaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1], taskProcRecStatistics[1], taskProcRecStatistics[2], taskProcRecStatistics[4], taskExecutionTime == 0L ? 0L : (long)taskStatisticsPoints[0] / taskExecutionTime * 1000L, taskExecutionTime == 0L ? 0L : taskProcRecStatistics[1] / taskExecutionTime * 1000L)));
            } else if (Double.doubleToLongBits(percent) == Double.doubleToLongBits(0.0)) {
                model.setValue("info", (Object)(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FSARptDataSyncTaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]) + (statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage())));
            } else if (0.0 < percent && percent < 100.0) {
                model.setValue("info", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%s, \u5df2\u8bfb\u53d6\uff1a%s, \u5b9e\u9645\u603b\u6570\uff1a%s, \u6210\u529f\u5408\u5e76\u5199\u5165\uff1a%s, \u5df2\u5ffd\u7565\uff1a%s, \u5c42\u7ea7\u8865\u9f50\uff1a%s, \u8bfb\u53d6\u901f\u7387\uff1a%s(\u6761/\u79d2), \u5199\u5165\u901f\u7387:%s(\u6761/\u79d2)", (String)"FSARptDataSyncTaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1], taskProcRecStatistics[1], taskProcRecStatistics[2], taskProcRecStatistics[4], taskExecutionTime == 0L ? 0L : (long)taskStatisticsPoints[0] / taskExecutionTime * 1000L, taskExecutionTime == 0L ? 0L : taskProcRecStatistics[1] / taskExecutionTime * 1000L));
            } else {
                model.setValue("info", (Object)(statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()));
            }
            return percent;
        }
        if (StringUtils.isEmpty((String)((String)taskDbj.get("version")))) {
            return -1.0;
        }
        if (FSAStatusEnum.SUCCESS.getCodeString().equals(taskStatus)) {
            return 100.0;
        }
        if (FSAStatusEnum.FAILURE.getCodeString().equals(taskStatus)) {
            return -1.0;
        }
        return 0.0;
    }
}

