/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataFileServiceUtil;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.disf.utils.ZipStreamHelper;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.model.FSAConfigModel;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSAPreviewDataHelper;
import org.apache.commons.io.FilenameUtils;

public class FSAReportFormPluginHelper {
    private static final Log logger = LogFactory.getLog(FSAReportFormPluginHelper.class);

    public static void afterCreateNewData(IFormView view, IDataModel model) {
        FormShowParameter fsp = view.getFormShowParameter();
        Long syncParamId = (Long)fsp.getCustomParam("rptdatasyncparam");
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam");
        if (syncParam == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u53c2\u6570\u8bb0\u5f55\u4e0d\u5b58\u5728", (String)"FSAReportDataViewPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = (String)fsp.getCustomParam("number");
        if (!MetadataDao.checkNumber((String)entityName)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u6570\u636e\u6e90\u5b9e\u4f53\u5bf9\u8c61[%s]", (String)"FSAReportDataViewPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), entityName));
            return;
        }
        DynamicObject dataCol = BusinessDataServiceHelper.loadSingleFromCache((Object)syncParam.getLong("datacollection_id"), (String)"fsa_data_collection");
        if (dataCol == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u8bb0\u5f55\u4e0d\u5b58\u5728", (String)"FSAReportDataViewPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        Set dimensionNumberSet = FSAPreviewDataHelper.getDimensionSetFromDataCol((DynamicObject)dataCol);
        Map dimensionSourceNumberMap = FSAPreviewDataHelper.getDimensionSourceNumberMap((DynamicObject)dataCol);
        LinkedList dimensionSourceNumberList = new LinkedList();
        LinkedHashMap<String, String[]> columnMap = new LinkedHashMap<String, String[]>();
        StringBuilder selectFieldsBuilder = new StringBuilder();
        StringBuilder selectFieldsNameBuilder = new StringBuilder();
        StringBuilder dimensionsBuilder = new StringBuilder();
        String dimensions = null;
        String[] dimensionArr = null;
        DataEntityPropertyCollection entityProperties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        for (IDataEntityProperty prop : entityProperties) {
            String entityCol = prop.getName();
            if ("id".equalsIgnoreCase(entityCol) || "del".equalsIgnoreCase(entityCol) || "datasourcetype".equalsIgnoreCase(entityCol)) continue;
            if (dimensionNumberSet.contains(entityCol.toLowerCase())) {
                dimensionsBuilder.append(',').append(entityCol);
                dimensionSourceNumberList.add(dimensionSourceNumberMap.get(entityCol.toLowerCase()));
            }
            String displayName = prop.getDisplayName().toString();
            String[] nameAndType = new String[]{displayName, IDataValueUtil.getDataType((IDataEntityProperty)prop).getCodeString()};
            columnMap.put(entityCol, nameAndType);
            selectFieldsBuilder.append(',').append(entityCol);
            selectFieldsNameBuilder.append(',').append(displayName);
        }
        IPageCache pageCache = view.getPageCache();
        pageCache.put("dimensionSourceNumberMap", FSAJSONUtils.toJsonString((Object)dimensionSourceNumberMap));
        pageCache.put("columnMap", FSAJSONUtils.toJsonString(columnMap));
        if (selectFieldsBuilder.length() > 0) {
            pageCache.put("selectFields", selectFieldsBuilder.substring(1));
        }
        if (selectFieldsNameBuilder.length() > 0) {
            pageCache.put("selectFieldsName", selectFieldsNameBuilder.substring(1));
        }
        if (dimensionsBuilder.length() > 0) {
            dimensions = dimensionsBuilder.substring(1);
            dimensionArr = dimensions.split(",");
            pageCache.put("dimensions", dimensions);
        }
        List<Long> enableVersionList = new ArrayList<Long>(1);
        Object onlyViewAppointVersion = fsp.getCustomParam("onlyViewAppointVersion");
        if (onlyViewAppointVersion != null) {
            Long version = Long.valueOf(String.valueOf(onlyViewAppointVersion));
            enableVersionList.add(version);
        } else {
            Object disableVersionObj = fsp.getCustomParam("disable_versions");
            Boolean useLastVersion = (Boolean)fsp.getCustomParam("use_latest_version");
            HashSet<Long> disableVersionSet = null;
            if (disableVersionObj instanceof JSONArray) {
                disableVersionSet = new HashSet<Long>(10);
                JSONArray disableVersionArr = (JSONArray)disableVersionObj;
                for (Object obj : disableVersionArr) {
                    disableVersionSet.add((Long)obj);
                }
            }
            enableVersionList = FSADataversionUtils.getEnableVersion((long)syncParamId, disableVersionSet, (boolean)useLastVersion);
        }
        StringBuilder versionsBuilder = new StringBuilder();
        if (!enableVersionList.isEmpty()) {
            enableVersionList.forEach(p -> versionsBuilder.append(',').append(p));
        }
        String versions = versionsBuilder.length() > 0 ? versionsBuilder.substring(1) : null;
        String enableVersionListJson = FSAJSONUtils.toJsonString(enableVersionList);
        pageCache.put("enableVersion", enableVersionListJson);
        String dataSrcType = syncParam.getString("datasrctype");
        if ("bcmParamSource".equalsIgnoreCase(dataSrcType)) {
            String dataVersionSourceType;
            Map<String, String[]> memberFilterMap = FSAReportFormPluginHelper.defaultQueryFilter(view, syncParam);
            if (StringUtils.isNotEmpty((String)dimensions) && dimensionArr != null) {
                model.beginInit();
                int firstRow = model.createNewEntryRow("filterentry");
                pageCache.put("versionIndex", String.valueOf(firstRow));
                model.setValue("dimension_name", (Object)((IDataEntityProperty)entityProperties.get((Object)"version")).getDisplayName(), firstRow);
                model.setValue("dimension_number", (Object)"version", firstRow);
                model.setValue("membername_filter", (Object)versions, firstRow);
                model.setValue("membernumber_filter", (Object)enableVersionListJson, firstRow);
                view.setEnable(Boolean.FALSE, firstRow, new String[]{"dimension_name"});
                for (String dimensionNumber : dimensionArr) {
                    String dimensionSourceNumber;
                    String[] memberInfo;
                    int currentRow = model.createNewEntryRow("filterentry");
                    model.setValue("dimension_name", (Object)((IDataEntityProperty)entityProperties.get((Object)dimensionNumber)).getDisplayName(), currentRow);
                    model.setValue("dimension_number", (Object)dimensionNumber, currentRow);
                    if (!memberFilterMap.isEmpty() && (memberInfo = memberFilterMap.get(dimensionSourceNumber = (String)dimensionSourceNumberMap.get(dimensionNumber.toLowerCase()))) != null && 2 == memberInfo.length) {
                        model.setValue("membername_filter", (Object)memberInfo[0], currentRow);
                        model.setValue("membernumber_filter", (Object)memberInfo[1], currentRow);
                    }
                    view.setEnable(Boolean.FALSE, currentRow, new String[]{"dimension_name"});
                }
                model.endInit();
                view.updateView("filterentry");
                Map paramSrcTagMap = FSADataCollectionHelper.getSrcParamFromCol((DynamicObject)dataCol);
                if (paramSrcTagMap != null && !paramSrcTagMap.isEmpty()) {
                    Object moduleId = paramSrcTagMap.get("moduleId");
                    Object orgViewId = paramSrcTagMap.get("OrgView");
                    pageCache.put("moduleId", String.valueOf(moduleId));
                    pageCache.put("OrgView", String.valueOf(orgViewId));
                    HashMap viewAndModuleMap = new HashMap(2);
                    viewAndModuleMap.put("organizationViewId", orgViewId);
                    viewAndModuleMap.put("moduleId", moduleId);
                    Map numberMappingNameMap = FSAPreviewDataHelper.numberMappingNameMap(viewAndModuleMap, (String[])dimensionSourceNumberList.toArray(new String[0]));
                    pageCache.put("dimMembersMap", FSAJSONUtils.toJsonString((Object)numberMappingNameMap));
                }
            }
            if ("1".equals(dataVersionSourceType = (String)fsp.getCustomParam("datasourcetype"))) {
                view.setEnable(Boolean.FALSE, new String[]{"filterentry"});
            }
        } else if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
            view.setVisible(Boolean.FALSE, new String[]{"filterentry"});
        }
    }

    public static void closedCallBack(IFormView view, IDataModel model, String actionId, Object returnData) {
        switch (actionId) {
            case "fsa_mulmemberf7base": {
                if (!(returnData instanceof HashSet)) break;
                int rowIndex = model.getEntryCurrentRowIndex("filterentry");
                StringBuilder memberNameBuilder = new StringBuilder();
                StringBuilder memberNumberBuilder = new StringBuilder();
                HashSet dimMemberSet = (HashSet)returnData;
                for (OlapServerDimMemberMetaInfo memberMetaInfo : dimMemberSet) {
                    memberNameBuilder.append(',').append(memberMetaInfo.getName());
                    memberNumberBuilder.append(',').append(memberMetaInfo.getNumber());
                }
                model.setValue("membername_filter", (Object)memberNameBuilder.substring(1), rowIndex);
                model.setValue("membernumber_filter", (Object)memberNumberBuilder.substring(1), rowIndex);
                break;
            }
            case "version": {
                String chooseVersionStr = (String)returnData;
                if (!StringUtils.isNotEmpty((String)chooseVersionStr)) break;
                StringBuilder versionBuilder = new StringBuilder();
                List versionList = (List)JSONObject.parseObject((String)chooseVersionStr, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
                for (Object obj : versionList) {
                    versionBuilder.append(',').append(obj);
                }
                int versionIndex = Integer.parseInt(view.getPageCache().get("versionIndex"));
                model.setValue("membername_filter", (Object)(versionBuilder.length() > 0 ? versionBuilder.substring(1) : null), versionIndex);
                model.setValue("membernumber_filter", (Object)chooseVersionStr, versionIndex);
                break;
            }
        }
    }

    public static void propertyChanged(IFormView view, IDataModel model, String key) {
        switch (key) {
            case "pagerows": {
                view.invokeOperation("refresh");
                break;
            }
            case "pageindex": {
                int pageSize;
                int totalRows = (Integer)model.getValue("totalrows");
                int pageIndex = (Integer)model.getValue("pageindex");
                int pageRows = Integer.parseInt((String)model.getValue("pagerows"));
                int n = pageSize = totalRows % pageRows != 0 ? totalRows / pageRows + 1 : totalRows / pageRows;
                if (pageIndex > pageSize) {
                    model.setValue("pageindex", (Object)pageSize);
                } else if (pageIndex < 1) {
                    model.setValue("pageindex", (Object)1);
                }
                view.invokeOperation("refresh");
                break;
            }
            case "membername_filter": {
                IPageCache pageCache = view.getPageCache();
                int rowIndex = model.getEntryCurrentRowIndex("filterentry");
                String nameFilter = (String)model.getValue("membername_filter", rowIndex);
                if (StringUtils.isEmpty((String)nameFilter)) {
                    model.setValue("membernumber_filter", null, rowIndex);
                }
                pageCache.remove("totalrows");
                break;
            }
        }
    }

    public static void click(AbstractFormPlugin formPlugin, IFormView view, IDataModel model, String key) {
        int totalRows = (Integer)model.getValue("totalrows");
        int pageIndex = (Integer)model.getValue("pageindex");
        int pageRows = Integer.parseInt((String)model.getValue("pagerows"));
        int pageSize = totalRows % pageRows != 0 ? totalRows / pageRows + 1 : totalRows / pageRows;
        switch (key) {
            case "firstpage": {
                model.setValue("pageindex", (Object)1);
                view.setEnable(Boolean.FALSE, new String[]{"firstpage", "previouspage"});
                view.setEnable(Boolean.valueOf(pageSize > 1), new String[]{"nextpage", "lastpage"});
                break;
            }
            case "previouspage": {
                int previousPageIndex = pageIndex > 0 ? pageIndex - 1 : 1;
                model.setValue("pageindex", (Object)previousPageIndex);
                view.setEnable(Boolean.valueOf(previousPageIndex != 1), new String[]{"firstpage", "previouspage"});
                view.setEnable(Boolean.valueOf(previousPageIndex < pageSize), new String[]{"nextpage", "lastpage"});
                break;
            }
            case "nextpage": {
                int nextPageIndex = pageIndex > pageSize ? pageSize : pageIndex + 1;
                model.setValue("pageindex", (Object)nextPageIndex);
                view.setEnable(Boolean.valueOf(nextPageIndex > 1), new String[]{"firstpage", "previouspage"});
                view.setEnable(Boolean.valueOf(nextPageIndex < pageSize), new String[]{"nextpage", "lastpage"});
                break;
            }
            case "lastpage": {
                model.setValue("pageindex", (Object)pageSize);
                view.setEnable(Boolean.valueOf(pageSize > 1), new String[]{"firstpage", "previouspage"});
                view.setEnable(Boolean.FALSE, new String[]{"nextpage", "lastpage"});
                break;
            }
            case "membername_filter": {
                String sourceNumber;
                int rowIndex = model.getEntryCurrentRowIndex("filterentry");
                String dimNumber = (String)model.getValue("dimension_number", rowIndex);
                if ("version".equalsIgnoreCase(dimNumber)) {
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("fsa_versionfilter");
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    String enableVersionJson = view.getPageCache().get("enableVersion");
                    parameter.setCustomParam("enableVersion", (Object)enableVersionJson);
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "version"));
                    view.showForm(parameter);
                    break;
                }
                String dimensionSourceNumberMapJson = view.getPageCache().get("dimensionSourceNumberMap");
                Map dimensionSourceNumberMap = (Map)JSONObject.parseObject((String)dimensionSourceNumberMapJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                if (dimensionSourceNumberMap == null || dimensionSourceNumberMap.isEmpty() || !StringUtils.isNotEmpty((String)(sourceNumber = (String)dimensionSourceNumberMap.get(dimNumber)))) break;
                String dimName = (String)model.getValue("dimension_name", rowIndex);
                FSAReportFormPluginHelper.openSelectMemberF7(formPlugin, view, dimName, sourceNumber);
                break;
            }
            case "reset": {
                FSAReportFormPluginHelper.cleanQueryFilter(model);
                break;
            }
            case "query": {
                view.invokeOperation("refresh");
                break;
            }
        }
    }

    public static void openSelectMemberF7(AbstractFormPlugin formPlugin, IFormView view, String dimName, String dimNumber) {
        Map memberIdMap;
        IPageCache pageCache = view.getPageCache();
        String moduleIdStr = pageCache.get("moduleId");
        String viewIdStr = pageCache.get("OrgView");
        Long moduleId = "null".equalsIgnoreCase(moduleIdStr) ? null : IDataValueUtil.getLong((Object)moduleIdStr);
        Long viewId = "null".equalsIgnoreCase(viewIdStr) ? null : IDataValueUtil.getLong((Object)viewIdStr);
        Set memberIdSet = null;
        String memberIdMapCache = pageCache.get("memberIdMap");
        if (StringUtils.isNotEmpty((String)memberIdMapCache) && (memberIdMap = (Map)JSON.parseObject((String)memberIdMapCache, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0])) != null && !memberIdMap.isEmpty()) {
            memberIdSet = (Set)memberIdMap.get(dimNumber.toLowerCase());
        }
        FSAMultipleMemberF7BasePlugin.openF7(formPlugin, dimName, moduleId, dimNumber, viewId, "fsa_mulmemberf7base", Boolean.FALSE, "id", memberIdSet);
    }

    public static Map<String, String[]> defaultQueryFilter(IFormView view, DynamicObject syncParam) {
        HashMap<String, String[]> defaultQueryMap = new HashMap<String, String[]>(16);
        DynamicObjectCollection dimEntryCol = syncParam.getDynamicObjectCollection("dimentry");
        if (dimEntryCol != null && !dimEntryCol.isEmpty()) {
            HashMap memberIdMap = new HashMap(16);
            for (DynamicObject dimObj : dimEntryCol) {
                HashSet<Long> memberIdSet = new HashSet<Long>(16);
                String[] memberFilterInfo = new String[2];
                DynamicObjectCollection dimFilterEntryCol = dimObj.getDynamicObjectCollection("dimfilterentry");
                if (dimFilterEntryCol == null || dimFilterEntryCol.isEmpty()) continue;
                StringBuilder memberNameBuilder = new StringBuilder();
                StringBuilder memberNumberBuilder = new StringBuilder();
                for (DynamicObject dimFilterObj : dimFilterEntryCol) {
                    memberIdSet.add(dimFilterObj.getLong("memberid"));
                    memberNameBuilder.append(',').append(dimFilterObj.getString("membername"));
                    memberNumberBuilder.append(',').append(dimFilterObj.getString("membernumber"));
                }
                memberFilterInfo[0] = memberNameBuilder.substring(1);
                memberFilterInfo[1] = memberNumberBuilder.substring(1);
                String dimNumber = dimObj.getString("olddimnumber");
                defaultQueryMap.put(dimNumber, memberFilterInfo);
                memberIdMap.put(dimNumber.toLowerCase(), memberIdSet);
            }
            view.getPageCache().put("memberIdMap", FSAJSONUtils.toJsonString(memberIdMap));
        }
        return defaultQueryMap;
    }

    public static boolean verifyQuery(IFormView view, IDataModel model, ReportQueryParam queryParam) {
        int dataRows;
        String dataVersionSourceType;
        FormShowParameter fsp = view.getFormShowParameter();
        String entityName = (String)fsp.getCustomParam("number");
        IPageCache pageCache = view.getPageCache();
        String dimensions = pageCache.get("dimensions");
        String selectFields = pageCache.get("selectFields");
        String columnMapJson = pageCache.get("columnMap");
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty((String)dimensions) || StringUtils.isEmpty((String)selectFields) || StringUtils.isEmpty((String)columnMapJson)) {
            return false;
        }
        LinkedHashMap<String, Object> columnMap = (LinkedHashMap<String, Object>)JSONObject.parseObject((String)columnMapJson, (TypeReference)new TypeReference<LinkedHashMap<String, String[]>>(){}, (Feature[])new Feature[0]);
        LinkedHashMap<String, Object> sortColumnMap = null;
        ArrayList<String> dimensionNumberList = new ArrayList<String>();
        if (columnMap != null && !columnMap.isEmpty()) {
            sortColumnMap = new LinkedHashMap<String, Object>(columnMap.size());
            int totalRows = model.getEntryRowCount("filterentry");
            if (totalRows > 0) {
                for (int i = 0; i < totalRows; ++i) {
                    String dimensionNumber = (String)model.getValue("dimension_number", i);
                    sortColumnMap.put(dimensionNumber, columnMap.get(dimensionNumber));
                    if ("version".equalsIgnoreCase(dimensionNumber)) continue;
                    dimensionNumberList.add(dimensionNumber);
                }
            } else {
                String[] dimensionArr = dimensions.split(",");
                dimensionNumberList.addAll(Arrays.asList(dimensionArr));
            }
            if (!sortColumnMap.isEmpty()) {
                for (Map.Entry entry : columnMap.entrySet()) {
                    String key = (String)entry.getKey();
                    sortColumnMap.computeIfAbsent(key, k -> (String[])entry.getValue());
                }
            }
        }
        String chooseVersionStr = null;
        String versionIndexStr = pageCache.get("versionIndex");
        if (StringUtils.isNotEmpty((String)versionIndexStr)) {
            int versionIndex = Integer.parseInt(versionIndexStr);
            chooseVersionStr = (String)model.getValue("membernumber_filter", versionIndex);
        }
        String enableVersionJson = pageCache.get("enableVersion");
        int entryRowCount = model.getEntryRowCount("filterentry");
        List enableVersion = (List)JSONObject.parseObject((String)(entryRowCount > 0 ? chooseVersionStr : enableVersionJson), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        boolean removeDuplicateData = enableVersion != null && 1 < enableVersion.size();
        QFilter filter = new QFilter("del", "in", (Object)new Long[]{0L, 2L}).and(new QFilter("version", "in", (Object)enableVersion));
        QFilter condition = FSAReportFormPluginHelper.queryFilter(model);
        if (condition != null) {
            filter.and(condition);
        }
        if ((dataVersionSourceType = (String)fsp.getCustomParam("datasourcetype")) != null) {
            filter.and(new QFilter("datasourcetype", "=", (Object)dataVersionSourceType));
        } else {
            Boolean checkAllSourceType = (Boolean)fsp.getCustomParam("alldata");
            if (checkAllSourceType == null || !checkAllSourceType.booleanValue()) {
                filter.and(new QFilter("datasourcetype", "in", Arrays.asList(" ", "0")));
            }
        }
        boolean executeQuery = true;
        String dataRowsStr = pageCache.get("totalrows");
        if (StringUtils.isEmpty((String)dataRowsStr)) {
            dataRows = FSAReportFormPluginHelper.getRows(entityName, filter);
            if (removeDuplicateData) {
                if (dataRows > 500000) {
                    executeQuery = false;
                    view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8f83\u5927\uff0c\u8bf7\u60a8\u51cf\u5c0f\u67e5\u8be2\u8303\u56f4", (String)"FSAReportDataViewPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                } else {
                    dataRows = FSAReportFormPluginHelper.getRows(entityName, filter, dimensions);
                }
            }
            pageCache.put("totalrows", String.valueOf(dataRows));
        } else {
            dataRows = Integer.parseInt(dataRowsStr);
        }
        if (executeQuery) {
            int pageIndex = (Integer)model.getValue("pageindex");
            String pageRowsStr = (String)model.getValue("pagerows");
            FSAReportFormPluginHelper.updatePageParam(view, model, pageIndex, Integer.parseInt(pageRowsStr), dataRows);
            pageIndex = (Integer)model.getValue("pageindex");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("entityName", entityName);
            paramMap.put("rowKeyFieldNames", FSAJSONUtils.toJsonString(dimensionNumberList));
            paramMap.put("selectFields", selectFields);
            paramMap.put("pageindex", String.valueOf(pageIndex));
            paramMap.put("pagerows", pageRowsStr);
            paramMap.put("removeDuplicateData", String.valueOf(removeDuplicateData));
            paramMap.put("dimMembersMap", pageCache.get("dimMembersMap"));
            paramMap.put("dimensionSourceNumberMap", pageCache.get("dimensionSourceNumberMap"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.setQFilters(Collections.singletonList(filter));
            queryParam.setFilter(filterInfo);
            queryParam.setSortSource(FSAJSONUtils.toJsonString(paramMap));
            queryParam.setSortInfo(FSAJSONUtils.toJsonString((Object)(sortColumnMap != null && !sortColumnMap.isEmpty() ? sortColumnMap : columnMap)));
        }
        return executeQuery;
    }

    public static QFilter queryFilter(IDataModel model) {
        int totalRows = model.getEntryRowCount("filterentry");
        QFilter queryFilter = null;
        for (int i = 0; i < totalRows; ++i) {
            String dimensionNumber = (String)model.getValue("dimension_number", i);
            String dimMemberNumber = (String)model.getValue("membernumber_filter", i);
            if ("version".equalsIgnoreCase(dimensionNumber) || !StringUtils.isNotEmpty((String)dimMemberNumber)) continue;
            List<String> memberNumberList = Arrays.asList(dimMemberNumber.split(","));
            if (queryFilter == null) {
                queryFilter = new QFilter(dimensionNumber, "in", memberNumberList);
                continue;
            }
            queryFilter.and(dimensionNumber, "in", memberNumberList);
        }
        return queryFilter;
    }

    public static int getRows(String entityName, QFilter filter) {
        DynamicObjectCollection rowCol = QueryServiceHelper.query((String)"FSAReportDataHelper.getRows", (String)entityName, (String)"count(*) as num", (QFilter[])filter.toArray(), null);
        if (rowCol != null && rowCol.size() > 0) {
            return Integer.parseInt(((DynamicObject)rowCol.get(0)).get("num").toString());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRows(String entityName, QFilter filter, String dimensions) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"FSAReportDataHelper.getRows", (String)entityName, (String)dimensions, (QFilter[])filter.toArray(), (String)"version desc");){
            if (ds == null) return 0;
            int dataRows = 0;
            HashSet<String> rowKeyValSet = new HashSet<String>(16);
            while (ds.hasNext()) {
                Row row = ds.next();
                StringBuilder rowKeyValBuilder = new StringBuilder();
                for (int i = 0; i < row.size(); ++i) {
                    Object dimObj = row.get(i);
                    if (dimObj == null) continue;
                    rowKeyValBuilder.append(',').append(dimObj);
                }
                if (!rowKeyValSet.add(rowKeyValBuilder.substring(1))) continue;
                ++dataRows;
            }
            int n = dataRows;
            return n;
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u6570\u8bb0\u5f55\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    public static void updatePageParam(IFormView view, IDataModel model, int pageIndex, int pageRows, int dataRows) {
        int totalPageSize;
        model.setValue("totalrows", (Object)dataRows);
        int n = totalPageSize = dataRows % pageRows != 0 ? dataRows / pageRows + 1 : dataRows / pageRows;
        if (totalPageSize == 0) {
            totalPageSize = 1;
        }
        model.setValue("totalpages", (Object)totalPageSize);
        if (pageIndex > totalPageSize) {
            model.setValue("pageindex", (Object)totalPageSize);
        }
        view.setEnable(Boolean.valueOf(pageIndex != 1), new String[]{"firstpage", "previouspage"});
        view.setEnable(Boolean.valueOf(pageIndex < totalPageSize), new String[]{"nextpage", "lastpage"});
    }

    public static void cleanQueryFilter(IDataModel model) {
        int totalRows = model.getEntryRowCount("filterentry");
        for (int i = 0; i < totalRows; ++i) {
            model.setValue("membername_filter", null, i);
            model.setValue("membernumber_filter", null, i);
        }
    }

    public static void afterDoOperation(IFormView view, IDataModel model, String key) {
        if (key.equalsIgnoreCase("moveentryup") || key.equalsIgnoreCase("moveentrydown")) {
            int totalRows = model.getEntryRowCount("filterentry");
            for (int i = 0; i < totalRows; ++i) {
                String number = (String)model.getValue("dimension_number", i);
                if (!"version".equalsIgnoreCase(number)) continue;
                view.getPageCache().put("versionIndex", String.valueOf(i));
                break;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void execScript(IFormView view, IDataModel model) {
        block50: {
            String dir;
            String dataVersionSourceType;
            int entryRowCount;
            IPageCache pageCache = view.getPageCache();
            String dimensions = pageCache.get("dimensions");
            String selectFields = pageCache.get("selectFields");
            String selectFieldsName = pageCache.get("selectFieldsName");
            String enableVersionJson = pageCache.get("enableVersion");
            if (StringUtils.isEmpty((String)dimensions) || StringUtils.isEmpty((String)selectFields) || StringUtils.isEmpty((String)selectFieldsName) || StringUtils.isEmpty((String)enableVersionJson)) {
                return;
            }
            FormShowParameter fsp = view.getFormShowParameter();
            String entityName = (String)fsp.getCustomParam("number");
            String chooseVersionStr = null;
            String versionIndexStr = pageCache.get("versionIndex");
            if (StringUtils.isNotEmpty((String)versionIndexStr)) {
                int versionIndex = Integer.parseInt(versionIndexStr);
                chooseVersionStr = (String)model.getValue("membernumber_filter", versionIndex);
            }
            List enableVersion = (List)JSONObject.parseObject((String)((entryRowCount = model.getEntryRowCount("filterentry")) > 0 ? chooseVersionStr : enableVersionJson), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
            boolean removeDuplicateData = enableVersion != null && 1 < enableVersion.size();
            QFilter filter = new QFilter("del", "in", (Object)new Long[]{0L, 2L}).and(new QFilter("version", "in", (Object)enableVersion));
            QFilter condition = FSAReportFormPluginHelper.queryFilter(model);
            if (condition != null) {
                filter.and(condition);
            }
            if ((dataVersionSourceType = (String)fsp.getCustomParam("datasourcetype")) != null) {
                filter.and(new QFilter("datasourcetype", "=", (Object)dataVersionSourceType));
            } else {
                Boolean checkAllSourceType = (Boolean)fsp.getCustomParam("alldata");
                if (checkAllSourceType == null || !checkAllSourceType.booleanValue()) {
                    filter.and(new QFilter("datasourcetype", "in", Arrays.asList(" ", "0")));
                }
            }
            int selectFieldSize = selectFields.split(",").length;
            List<String> rowKeyFieldNames = Arrays.asList(dimensions.split(","));
            String fileNameFormat = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String sourceFileName = String.format("%s_%s.csv", entityName, fileNameFormat);
            FSAConfigModel configModel = FSADataCacheMgr.instance.getFSAConfigModel("temp_dir");
            if (configModel == null || "default".equalsIgnoreCase(dir = configModel.getValue())) {
                dir = IDataFileServiceUtil.getLocalTempFolder();
            }
            String sourceFileUrl = dir + (dir.endsWith(File.separator) ? "" : File.separator) + sourceFileName;
            String zipFileName = String.format("%s_%s.zip", entityName, fileNameFormat);
            String zipFileUrl = dir + (dir.endsWith(File.separator) ? "" : File.separator) + zipFileName;
            String checkedSourceFileUrl = FilenameUtils.getName((String)sourceFileUrl);
            File sourceFile = new File(checkedSourceFileUrl);
            File zipFile = null;
            BufferedWriter sourceBw = null;
            FileInputStream sourceFis = null;
            FileInputStream zipFis = null;
            ZipOutputStream zipZos = null;
            if (!sourceFile.exists()) {
                block49: {
                    String encoding;
                    block48: {
                        if (sourceFile.createNewFile() && sourceFile.canWrite()) break block48;
                        view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u7cfb\u7edf\u6ca1\u6709\u670d\u52a1\u5668\u5199\u6587\u4ef6\u6743\u9650\u3002", (String)"FSAReportDataViewPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        FSAReportFormPluginHelper.safeClose(zipZos);
                        String errorMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                        try {
                            if (sourceBw != null) {
                                sourceBw.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error(String.format(errorMsg, e.getMessage()));
                        }
                        try {
                            if (zipFis != null) {
                                zipFis.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error(String.format(errorMsg, e.getMessage()));
                        }
                        try {
                            if (sourceFis != null) {
                                sourceFis.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error(String.format(errorMsg, e.getMessage()));
                        }
                        if (sourceFile.exists() && sourceFile.delete() && logger.isInfoEnabled()) {
                            logger.info("sourceFile delete success!");
                        }
                        if (zipFile != null && zipFile.exists() && zipFile.delete() && logger.isInfoEnabled()) {
                            logger.info("zipFile delete success!");
                        }
                        return;
                    }
                    configModel = FSADataCacheMgr.instance.getFSAConfigModel("file_encoding");
                    if (configModel == null || "default".equalsIgnoreCase(encoding = configModel.getValue())) {
                        encoding = "GBK";
                    }
                    sourceBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(checkedSourceFileUrl), Charset.forName(encoding)));
                    sourceBw.write(selectFieldsName);
                    sourceBw.newLine();
                    FSAReportFormPluginHelper.batchWriteDataToFile(view, entityName, selectFields, filter.toArray(), selectFieldSize, rowKeyFieldNames, removeDuplicateData, sourceBw);
                    sourceFis = new FileInputStream(sourceFile);
                    zipFile = new File(FilenameUtils.getName((String)zipFileUrl));
                    zipZos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
                    byte[] buf = new byte[10240];
                    long readLength = ZipStreamHelper.compressInputStream((InputStream)sourceFis, (ZipOutputStream)zipZos, (String)sourceFile.getName(), (boolean)true, (byte[])buf);
                    zipZos.flush();
                    FSAReportFormPluginHelper.safeClose(zipZos);
                    if (readLength > 0x6400000L) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u7ecf\u8fc7\u538b\u7f29\u540e\u4ecd\u8d85\u8fc7100M\uff0c\u8bf7\u60a8\u51cf\u5c0f\u67e5\u8be2\u8303\u56f4\u540e\u518d\u5c1d\u8bd5\u5bfc\u51fa", (String)"FSAReportDataViewPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        break block49;
                    }
                    zipFis = new FileInputStream(zipFile);
                    String fileServerUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFileName, (InputStream)zipFis, 5000);
                    view.openUrl(fileServerUrl);
                }
                FSAReportFormPluginHelper.safeClose(zipZos);
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                try {
                    if (sourceBw != null) {
                        sourceBw.close();
                    }
                }
                catch (IOException e) {
                    logger.error(String.format(errorMsg, e.getMessage()));
                }
                try {
                    if (zipFis != null) {
                        zipFis.close();
                    }
                }
                catch (IOException e) {
                    logger.error(String.format(errorMsg, e.getMessage()));
                }
                try {
                    if (sourceFis != null) {
                        sourceFis.close();
                    }
                }
                catch (IOException e) {
                    logger.error(String.format(errorMsg, e.getMessage()));
                }
                if (sourceFile.exists() && sourceFile.delete() && logger.isInfoEnabled()) {
                    logger.info("sourceFile delete success!");
                }
                if (zipFile != null && zipFile.exists() && zipFile.delete() && logger.isInfoEnabled()) {
                    logger.info("zipFile delete success!");
                }
                break block50;
                catch (IOException e) {
                    try {
                        throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        FSAReportFormPluginHelper.safeClose(zipZos);
                        String errorMsg2 = ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                        try {
                            if (sourceBw != null) {
                                sourceBw.close();
                            }
                        }
                        catch (IOException e2) {
                            logger.error(String.format(errorMsg2, e2.getMessage()));
                        }
                        try {
                            if (zipFis != null) {
                                zipFis.close();
                            }
                        }
                        catch (IOException e3) {
                            logger.error(String.format(errorMsg2, e3.getMessage()));
                        }
                        try {
                            if (sourceFis != null) {
                                sourceFis.close();
                            }
                        }
                        catch (IOException e4) {
                            logger.error(String.format(errorMsg2, e4.getMessage()));
                        }
                        if (sourceFile.exists() && sourceFile.delete() && logger.isInfoEnabled()) {
                            logger.info("sourceFile delete success!");
                        }
                        if (zipFile != null && zipFile.exists() && zipFile.delete() && logger.isInfoEnabled()) {
                            logger.info("zipFile delete success!");
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public static void safeClose(Closeable zipZos) {
        if (zipZos != null) {
            try {
                zipZos.close();
            }
            catch (IOException e) {
                logger.error(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void batchWriteDataToFile(IFormView view, String entityName, String selectFields, QFilter[] qFilters, int selectFieldSize, List<String> rowKeyFieldNames, boolean removeDuplicateData, BufferedWriter sourceBw) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"batchWriteDataToFile", (String)entityName, (String)selectFields, (QFilter[])qFilters, (String)"version desc");){
            if (ds != null && ds.hasNext()) {
                Map dimensionSourceNumberMap;
                HashSet<String> rowKeySet = removeDuplicateData ? new HashSet<String>(16) : null;
                int cumulativeRow = 0;
                String[] selectFieldsArr = selectFields.split(",");
                String dimMembersMapJson = view.getPageCache().get("dimMembersMap");
                Map dimMembersMap = StringUtils.isEmpty((String)dimMembersMapJson) ? null : (Map)JSONObject.parseObject((String)dimMembersMapJson, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){}, (Feature[])new Feature[0]);
                String dimensionSourceNumberMapJson = view.getPageCache().get("dimensionSourceNumberMap");
                Map map = dimensionSourceNumberMap = StringUtils.isEmpty((String)dimensionSourceNumberMapJson) ? null : (Map)JSONObject.parseObject((String)dimensionSourceNumberMapJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                while (ds.hasNext()) {
                    Object obj;
                    Row row = ds.next();
                    if (rowKeySet != null) {
                        StringBuilder rowKeyValueBuilder = new StringBuilder();
                        for (String dimKey : rowKeyFieldNames) {
                            obj = row.get(dimKey);
                            if (obj == null) continue;
                            rowKeyValueBuilder.append(',').append(obj);
                        }
                        if (!rowKeySet.add(rowKeyValueBuilder.substring(1))) continue;
                    }
                    for (int i = 0; i < selectFieldSize; ++i) {
                        String field = selectFieldsArr[i];
                        boolean isFieldDimension = rowKeyFieldNames.contains(field);
                        obj = row.get(i);
                        if (obj != null) {
                            String sourceNumber;
                            String objVal = String.valueOf(obj);
                            if (isFieldDimension && dimMembersMap != null && dimensionSourceNumberMap != null && StringUtils.isNotEmpty((String)(sourceNumber = (String)dimensionSourceNumberMap.get(field)))) {
                                String membersName;
                                Map membersNumberAndNameMap = (Map)dimMembersMap.get(sourceNumber);
                                if (membersNumberAndNameMap != null && StringUtils.isNotEmpty((String)(membersName = (String)membersNumberAndNameMap.get(objVal)))) {
                                    sourceBw.write(membersName);
                                } else {
                                    sourceBw.write(objVal);
                                }
                            } else {
                                sourceBw.write(objVal);
                            }
                        } else if (!isFieldDimension) {
                            sourceBw.write(48);
                        }
                        if (i == selectFieldSize - 1) {
                            sourceBw.newLine();
                            if (++cumulativeRow < 2000) continue;
                            sourceBw.flush();
                            cumulativeRow = 0;
                            continue;
                        }
                        sourceBw.write(44);
                    }
                }
                if (0 < cumulativeRow) {
                    sourceBw.flush();
                }
            } else {
                sourceBw.flush();
            }
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u65f6\u5199\u5165\u6570\u636e\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"FSAReportDataViewPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }
}

