/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.TimeZone;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;

public class FSARptDataSyncTaskFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
ProgresssListener {
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    public void initialize() {
        this.addBillListFilter();
    }

    private void addBillListFilter() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(setFilterEvent -> {
            Long taskId = (Long)this.getModel().getValue("id");
            QFilter taskIdFilter = new QFilter("datasynctask", "=", (Object)taskId);
            setFilterEvent.addCustomQFilter(taskIdFilter);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            String operateKey;
            Donothing source = (Donothing)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "replay": {
                    this.replayTask();
                    break;
                }
            }
        }
    }

    public void replayTask() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
        this.setVisible();
        Long taskId = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("datasynctask", "=", (Object)taskId);
        qFilter.and("tasktype", "=", (Object)String.valueOf(FSAWorkTaskTypeEnum.Hierarchy_Complete_Task.getValue()));
        qFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fsa_rptdata_synclog", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!dynamicObjects.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5c42\u7ea7\u8865\u9f50\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d\u3002", (String)"FSARptDataSyncTaskFormPlugin_13", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
        Long primaryKeyValue = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject currentDynObj = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"fsa_rptdata_synclog");
        String status = currentDynObj.getString("status");
        String taskType = currentDynObj.getString("tasktype");
        if ("9".equals(status) && String.valueOf(FSAWorkTaskTypeEnum.Hierarchy_Complete_Task.getValue()).equals(taskType)) {
            for (ListSelectedRow listSelectedRow : currentListAllRowCollection) {
                Long pkValue = (Long)listSelectedRow.getPrimaryKeyValue();
                if (primaryKeyValue.equals(pkValue)) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"fsa_rptdata_synclog");
                status = dynamicObject.getString("status");
                taskType = dynamicObject.getString("tasktype");
                if (!"2".equals(status) || !String.valueOf(FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task.getValue()).equals(taskType)) continue;
                Long syncParamId = ((DynamicObject)model.getValue("rptdatasyncparam")).getLong("id");
                DynamicObject syncParamDynObj = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam");
                String tableNumber = syncParamDynObj.getString("tablenumber");
                Long version = Long.parseLong(model.getValue("version").toString());
                FSAWorkTaskMeta newTaskMeta = new FSAWorkTaskMeta(Long.valueOf(0L), pkValue, taskId.toString(), taskId, syncParamId, FSAWorkTaskTypeEnum.Hierarchy_Complete_Task, null, true, tableNumber, null, null, version);
                IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.Hierarchy_Complete_Task.getValue(), (IWorkTaskTransLog)newTaskMeta, (boolean)true);
                IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5c42\u7ea7\u81ea\u52a8\u8865\u9f50\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\u3002", (String)"FSARptDataSyncTaskFormPlugin_11", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                break;
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5931\u8d25\u7684\u5c42\u7ea7\u81ea\u52a8\u8865\u9f50\u4efb\u52a1\u518d\u6b21\u6267\u884c\u3002", (String)"FSARptDataSyncTaskFormPlugin_12", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        BillList billList = (BillList)view.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        hyperLinkClickEvent.getFieldName();
        Object logId = ((BillListHyperLinkClickEvent)hyperLinkClickEvent).getCurrentRow().getPrimaryKeyValue();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(logId);
        billShowParameter.setFormId("fsa_rptdata_synclog");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String version = (String)model.getValue("version");
        if (StringUtils.isEmpty((String)version)) {
            view.setVisible(Boolean.FALSE, new String[]{"version"});
        }
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        if (0.0 > percent) {
            view.setVisible(Boolean.TRUE, new String[]{"unfetch"});
            view.setVisible(Boolean.FALSE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            bar.stop();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"unfetch"});
            view.setVisible(Boolean.TRUE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            if (percent >= 100.0) {
                bar.setPercent(100);
                model.setValue("completepercent", (Object)100);
            } else {
                bar.setPercent((int)percent);
                bar.start();
                model.setValue("completepercent", (Object)percent);
            }
        }
        if (staticStatus != null && staticStatus.isTaskEnd()) {
            bar.stop();
        }
        this.setVisible();
        model.setDataChanged(false);
    }

    private void setVisible() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
        ArrayList<String> operationKeys = new ArrayList<String>();
        operationKeys.add("replay");
        HashSet<Long> unVisibleIdSet = new HashSet<Long>(10);
        Long taskId = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter("datasynctask", "=", (Object)taskId);
        QFilter qFilter2 = new QFilter("tasktype", "!=", (Object)String.valueOf(FSAWorkTaskTypeEnum.Hierarchy_Complete_Task.getValue()));
        qFilter2.or("status", "!=", (Object)"9");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fsa_rptdata_synclog", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject dynamicObject : dynamicObjects) {
            unVisibleIdSet.add(dynamicObject.getLong("id"));
        }
        int i = 0;
        for (ListSelectedRow listSelectedRow : currentListAllRowCollection) {
            Long pkValue = (Long)listSelectedRow.getPrimaryKeyValue();
            if (unVisibleIdSet.contains(pkValue)) {
                billList.hideOperateItems("replay_op", i, operationKeys);
            }
            ++i;
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        IDataSimpleWorkTaskStatisticStatus staticStatus = this.getStaticStatus();
        double percent = this.getPercent(staticStatus);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (0.0 > percent) {
            view.setVisible(Boolean.TRUE, new String[]{"unfetch"});
            view.setVisible(Boolean.FALSE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            bar.stop();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"unfetch"});
            view.setVisible(Boolean.TRUE, new String[]{"synctaskprogress", "progressbarap", "completepercent", "percentchar", "info"});
            if (percent >= 100.0) {
                progressEvent.setProgress(100);
                model.setValue("completepercent", (Object)100);
            } else {
                progressEvent.setProgress((int)percent);
                model.setValue("completepercent", (Object)percent);
            }
        }
        if (staticStatus != null && staticStatus.isTaskEnd()) {
            bar.stop();
            view.invokeOperation("refresh");
        }
    }

    public IDataSimpleWorkTaskStatisticStatus getStaticStatus() {
        int[] taskStatisticsPoints;
        long[] totalTaskTimeCost;
        IDataModel model = this.getModel();
        Long taskId = (Long)model.getValue("id");
        String cacheStatusStr = this.cache.get("FSA|" + taskId);
        IDataSimpleWorkTaskStatisticStatus statisticStatus = null;
        if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
            statisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.getCachedWorkTaskStatusEvent(cacheStatusStr);
        } else {
            cacheStatusStr = (String)model.getValue("staticstatus_info_tag");
            if (StringUtils.isNotEmpty((String)cacheStatusStr)) {
                statisticStatus = (IDataSimpleWorkTaskStatisticStatus)this.getCachedWorkTaskStatusEvent(cacheStatusStr);
            }
        }
        if (statisticStatus != null && !statisticStatus.isTaskEnd() && (totalTaskTimeCost = statisticStatus.getTotalTaskTimeCost()).length == 2 && (taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints()).length == 2) {
            long time = totalTaskTimeCost[1] - totalTaskTimeCost[0];
            double predictTime = (double)time / (double)taskStatisticsPoints[0] * (double)(taskStatisticsPoints[1] - taskStatisticsPoints[0]);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            String dateTime = sdf.format(time);
            String predictdateTime = sdf.format(predictTime);
            model.setValue("executiontime", (Object)String.format(ResManager.loadKDString((String)"%s (\u9884\u8ba1\u5269\u4f59\u65f6\u95f4: %s)", (String)"FSARptDataSyncTaskFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), dateTime, predictdateTime));
        }
        return statisticStatus;
    }

    public double getPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        IDataModel model = this.getModel();
        Long taskId = (Long)model.getValue("id");
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDbj = QueryServiceHelper.queryOne((String)"fsa_rptdata_synctask", (String)"status,version", (QFilter[])idFilter.toArray());
        if (taskDbj == null) {
            return -1.0;
        }
        String taskStatus = taskDbj.getString("status");
        if (statisticStatus != null) {
            int[] taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints();
            if (taskStatisticsPoints.length == 2 && taskStatisticsPoints[1] == 0) {
                if (FSAStatusEnum.SUCCESS.getCodeString().equals(taskStatus)) {
                    return 100.0;
                }
                if (FSAStatusEnum.PROCESSING.getCodeString().equals(taskStatus)) {
                    return 0.0;
                }
                if (FSAStatusEnum.FAILURE.getCodeString().equals(taskStatus)) {
                    return -1.0;
                }
            }
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            long taskExecutionTime = statisticStatus.getTaskExecutionTime();
            double percent = (double)taskStatisticsPoints[0] / (double)taskStatisticsPoints[1] * 100.0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            if (taskEnd || Double.doubleToLongBits(percent) == Double.doubleToLongBits(100.0)) {
                model.setValue("info", (Object)((statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()) + String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%s, \u5df2\u8bfb\u53d6\uff1a%s, \u5b9e\u9645\u603b\u6570\uff1a%s, \u6210\u529f\u5408\u5e76\u5199\u5165\uff1a%s, \u5df2\u5ffd\u7565\uff1a%s, \u5c42\u7ea7\u8865\u9f50\uff1a%s, \u8bfb\u53d6\u901f\u7387\uff1a%s(\u6761/\u79d2), \u5199\u5165\u901f\u7387:%s(\u6761/\u79d2)", (String)"FSARptDataSyncTaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1], taskProcRecStatistics[1], taskProcRecStatistics[2], taskProcRecStatistics[4], taskExecutionTime == 0L ? 0L : (long)taskStatisticsPoints[0] / taskExecutionTime * 1000L, taskExecutionTime == 0L ? 0L : taskProcRecStatistics[1] / taskExecutionTime * 1000L)));
            } else if (Double.doubleToLongBits(percent) == Double.doubleToLongBits(0.0)) {
                model.setValue("info", (Object)(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u521d\u59cb\u5316", (String)"FSARptDataSyncTaskFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]) + (statisticStatus.getStatusMessage() == null ? "" : ": " + statisticStatus.getStatusMessage())));
            } else if (0.0 < percent && percent < 100.0) {
                model.setValue("info", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\uff1a%s, \u5df2\u8bfb\u53d6\uff1a%s, \u5b9e\u9645\u603b\u6570\uff1a%s, \u6210\u529f\u5408\u5e76\u5199\u5165\uff1a%s, \u5df2\u5ffd\u7565\uff1a%s, \u5c42\u7ea7\u8865\u9f50\uff1a%s, \u8bfb\u53d6\u901f\u7387\uff1a%s(\u6761/\u79d2), \u5199\u5165\u901f\u7387:%s(\u6761/\u79d2)", (String)"FSARptDataSyncTaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), taskStatisticsPoints[1] - taskStatisticsPoints[0], taskProcRecStatistics[0], taskStatisticsPoints[1], taskProcRecStatistics[1], taskProcRecStatistics[2], taskProcRecStatistics[4], taskExecutionTime == 0L ? 0L : (long)taskStatisticsPoints[0] / taskExecutionTime * 1000L, taskExecutionTime == 0L ? 0L : taskProcRecStatistics[1] / taskExecutionTime * 1000L));
            } else {
                model.setValue("info", (Object)(statisticStatus.getStatusMessage() == null ? "" : statisticStatus.getStatusMessage()));
            }
            return percent;
        }
        model.setValue("info", null);
        if (StringUtils.isEmpty((String)((String)taskDbj.get("version")))) {
            return -1.0;
        }
        if (FSAStatusEnum.SUCCESS.getCodeString().equals(taskStatus)) {
            return 100.0;
        }
        if (FSAStatusEnum.FAILURE.getCodeString().equals(taskStatus)) {
            return -1.0;
        }
        return 0.0;
    }

    public IWorkTaskStatusEvent getCachedWorkTaskStatusEvent(String cacheStatusStr) {
        JSONArray jsonArray = IDataValueUtil.toJSONArray((Object)cacheStatusStr);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        return (IWorkTaskStatusEvent)IDataBeanUtil.getClassNewInstance((Class)IDataBeanUtil.getClassByName((String)String.valueOf(jsonArray.get(0))), (Object[])new Object[]{jsonArray});
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy;
        super.itemClick(evt);
        switch (operationKy = evt.getItemKey()) {
            case "terminate_task": {
                DynamicObject taskDbj;
                if (!FSAPermissionUtil.hasSpecificPerm(this.getView(), "fsa_rptdata_synctask", "2/F47X/3N+JT").booleanValue()) {
                    return;
                }
                IDataModel model = this.getModel();
                Long taskId = (Long)model.getValue("id");
                FSAWorkTaskStatusConsumer.getInstance().markTaskCancel((Object)taskId);
                String cacheStatusStr = this.cache.get("FSA|" + taskId);
                if (!StringUtils.isEmpty((String)cacheStatusStr)) break;
                DynamicObject[] logCollection = BusinessDataServiceHelper.load((String)"fsa_rptdata_synclog", (String)"id, status", (QFilter[])new QFilter[]{new QFilter("datasynctask", "=", (Object)taskId)});
                if (logCollection != null) {
                    for (DynamicObject log : logCollection) {
                        String originStatus = log.getString("status");
                        if (!FSAStatusEnum.PROCESSING.getCodeString().equals(originStatus)) continue;
                        log.set("status", (Object)FSAStatusEnum.TERMINATE.getCodeString());
                        SaveServiceHelper.update((DynamicObject)log);
                    }
                    this.getView().updateView();
                }
                if ((taskDbj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fsa_rptdata_synctask")) == null) break;
                String originStatus = taskDbj.getString("status");
                if (!FSAStatusEnum.PROCESSING.getCodeString().equals(originStatus)) break;
                taskDbj.set("status", (Object)FSAStatusEnum.TERMINATE.getCodeString());
                SaveServiceHelper.update((DynamicObject)taskDbj);
                break;
            }
        }
    }
}

