/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataJsonUtil;
import kd.data.fsa.model.rpt.config.FSABaseStdRptIndicator;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSARptFormulaEditFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnleft", "btnright", "btnok", "btncancel", "clr", "backspace"});
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String calculateJson = (String)this.getView().getFormShowParameter().getCustomParam("formula_json");
        FSABaseStdRptIndicator rptIndicator = this.deserialize(calculateJson);
        this.setFormulaObj(rptIndicator);
    }

    public void afterBindData(EventObject e) {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (IDataJsonUtil.isJSonFormat((String)json, (String[])new String[0])) {
            this.fillTreeNodes(json);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (ctlSource.getKey()) {
            case "btnok": {
                String calculateJson = (String)this.getView().getFormShowParameter().getCustomParam("formula_json");
                FSABaseStdRptIndicator rptIndicator = this.deserialize(calculateJson);
                this.getFormulaObj(rptIndicator);
                view.returnDataToParent((Object)FSAJSONUtils.toJsonString((Object)rptIndicator));
                view.close();
                break;
            }
            case "btncancel": {
                view.close();
                break;
            }
            case "clr": {
                model.setValue("calcformular", (Object)"");
                model.setValue("displayformular", (Object)"");
                break;
            }
            case "backspace": {
                this.contentBackSpace((String)model.getValue("calcformular"), (String)model.getValue("displayformular"));
                break;
            }
            default: {
                this.clickCompareButton(ctlSource.getKey());
            }
        }
    }

    private void contentBackSpace(String oldCalculate, String oldDisplayFormular) {
        IDataModel model = this.getModel();
        if (StringUtils.isNotEmpty((String)oldCalculate)) {
            if (oldCalculate.indexOf(32) > -1) {
                String newCalculate = oldCalculate.substring(0, oldCalculate.lastIndexOf(32));
                model.setValue("calcformular", (Object)newCalculate);
            } else {
                model.setValue("calcformular", (Object)"");
            }
        }
        if (StringUtils.isNotEmpty((String)oldDisplayFormular)) {
            if (oldDisplayFormular.indexOf(32) > -1) {
                String newDisplayFormular = oldDisplayFormular.substring(0, oldDisplayFormular.lastIndexOf(32));
                model.setValue("displayformular", (Object)newDisplayFormular);
            } else {
                model.setValue("displayformular", (Object)"");
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        String currentNodeText = (String)treeView.getTreeState().getFocusNode().get("text");
        IDataModel model = this.getModel();
        String oldCalculate = (String)model.getValue("calcformular");
        if (StringUtils.isNotEmpty((String)oldCalculate)) {
            model.setValue("calcformular", (Object)(oldCalculate + " [" + e.getNodeId() + ']'));
        } else {
            model.setValue("calcformular", (Object)('[' + e.getNodeId().toString() + ']'));
        }
        String oldDisplayFormular = (String)model.getValue("displayformular");
        if (StringUtils.isNotEmpty((String)oldDisplayFormular)) {
            model.setValue("displayformular", (Object)(oldDisplayFormular + " " + currentNodeText));
        } else {
            model.setValue("displayformular", (Object)currentNodeText);
        }
    }

    private FSABaseStdRptIndicator deserialize(String json) {
        return StringUtils.isEmpty((String)json) ? new FSABaseStdRptIndicator() : (FSABaseStdRptIndicator)FSAJSONUtils.cast((String)json, FSABaseStdRptIndicator.class);
    }

    private void setFormulaObj(FSABaseStdRptIndicator rptIndicator) {
        if (rptIndicator == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("calcformular", (Object)rptIndicator.getCalcFormular());
        model.setValue("description", (Object)rptIndicator.getDescription());
        model.setValue("displayformular", (Object)rptIndicator.getDisplayFormular());
    }

    private void getFormulaObj(FSABaseStdRptIndicator rptIndicator) {
        IDataModel model = this.getModel();
        rptIndicator.setCalcFormular((String)model.getValue("calcformular"));
        rptIndicator.setDescription((String)model.getValue("description"));
        rptIndicator.setDisplayFormular((String)model.getValue("displayformular"));
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(node);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = null;
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)compareValue)) {
            IDataModel model = this.getModel();
            String oldCalculate = (String)model.getValue("calcformular");
            if (StringUtils.isNotEmpty((String)oldCalculate)) {
                model.setValue("calcformular", (Object)(oldCalculate + " " + compareValue));
            } else {
                model.setValue("calcformular", (Object)compareValue);
            }
            String oldDisplayFormular = (String)model.getValue("displayformular");
            if (StringUtils.isNotEmpty((String)oldDisplayFormular)) {
                model.setValue("displayformular", (Object)(oldDisplayFormular + " " + compareValue));
            } else {
                model.setValue("displayformular", (Object)compareValue);
            }
        }
    }
}

